/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.CustomEntityProjectModelInfoProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexableFilesIndex;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.workspaceModel.core.fileIndex.DependencyDescription;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.impl.PlatformInternalWorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexImpl;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleDependencyIndex;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.DependenciesKt;
import com.intellij.workspaceModel.storage.bridgeEntities.ExcludeUrlEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.RootsKt;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

class CustomEntitiesCausingReindexTracker {
    private final boolean useWorkspaceFileIndexContributors = IndexableFilesIndex.isEnabled();
    @NotNull
    private Set<Class<? extends WorkspaceEntity>> customEntitiesToRescan;

    CustomEntitiesCausingReindexTracker() {
        ExtensionPointListener<Object> listener2 = new ExtensionPointListener<Object>(){

            @Override
            public void extensionAdded(Object extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                CustomEntitiesCausingReindexTracker.this.reinit();
            }

            @Override
            public void extensionRemoved(Object extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                CustomEntitiesCausingReindexTracker.this.reinit();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/util/indexing/CustomEntitiesCausingReindexTracker$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        IndexableEntityProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener<IndexableEntityProvider<? extends WorkspaceEntity>>)listener2);
        CustomEntityProjectModelInfoProvider.EP.addExtensionPointListener(listener2);
        WorkspaceFileIndexImpl.Companion.getEP_NAME().addExtensionPointListener(listener2);
        this.customEntitiesToRescan = this.listCustomEntitiesCausingRescan();
    }

    private void reinit() {
        this.customEntitiesToRescan = this.listCustomEntitiesCausingRescan();
    }

    private Set<Class<? extends WorkspaceEntity>> listCustomEntitiesCausingRescan() {
        Stream<Class> allClasses = CustomEntityProjectModelInfoProvider.EP.getExtensionList().stream().map(provider2 -> provider2.getEntityClass());
        allClasses = Stream.concat(allClasses, WorkspaceFileIndexImpl.Companion.getEP_NAME().getExtensionList().stream().filter(contributor -> this.useWorkspaceFileIndexContributors || !(contributor instanceof PlatformInternalWorkspaceFileIndexContributor)).flatMap(contributor -> CustomEntitiesCausingReindexTracker.getEntityClassesToCauseReindexing(contributor)));
        allClasses = Stream.concat(allClasses, IndexableEntityProvider.EP_NAME.getExtensionList().stream().filter(provider2 -> !this.useWorkspaceFileIndexContributors || provider2 instanceof IndexableEntityProvider.Enforced).map(provider2 -> provider2.getEntityClass()));
        return Set.copyOf(allClasses.filter(aClass -> !CustomEntitiesCausingReindexTracker.isEntityReindexingCustomised(aClass)).collect(Collectors.toSet()));
    }

    private static Stream<Class<? extends WorkspaceEntity>> getEntityClassesToCauseReindexing(WorkspaceFileIndexContributor<?> contributor) {
        List<DependencyDescription<?>> dependencies = contributor.getDependenciesOnOtherEntities();
        Stream<Class<? extends WorkspaceEntity>> baseStream = Stream.of(contributor.getEntityClass());
        if (dependencies.isEmpty()) {
            return baseStream;
        }
        Stream<Class> dependenciesStream = dependencies.stream().filter(description -> description instanceof DependencyDescription.OnParent).map(description -> ((DependencyDescription.OnParent)description).getParentClass());
        return Stream.concat(baseStream, dependenciesStream);
    }

    private static boolean isEntityReindexingCustomised(Class<? extends WorkspaceEntity> entityClass) {
        return LibraryEntity.class.isAssignableFrom(entityClass) || LibraryPropertiesEntity.class.isAssignableFrom(entityClass);
    }

    boolean shouldRescan(@NotNull WorkspaceEntity entity, @NotNull Project project2) {
        if (entity == null) {
            CustomEntitiesCausingReindexTracker.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            CustomEntitiesCausingReindexTracker.$$$reportNull$$$0(1);
        }
        if (entity instanceof LibraryEntity) {
            return CustomEntitiesCausingReindexTracker.hasDependencyOn((LibraryEntity)entity, project2);
        }
        if (entity instanceof LibraryPropertiesEntity) {
            return CustomEntitiesCausingReindexTracker.hasDependencyOn(((LibraryPropertiesEntity)entity).getLibrary(), project2);
        }
        if (entity instanceof ExcludeUrlEntity) {
            LibraryEntity library = DependenciesKt.getLibrary((ExcludeUrlEntity)((ExcludeUrlEntity)entity));
            if (library != null) {
                return CustomEntitiesCausingReindexTracker.hasDependencyOn(library, project2);
            }
            ContentRootEntity contentRoot = RootsKt.getContentRoot((ExcludeUrlEntity)((ExcludeUrlEntity)entity));
            if (contentRoot != null) {
                return this.isEntityToRescan((WorkspaceEntity)contentRoot);
            }
            return false;
        }
        return this.isEntityToRescan(entity);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean isEntityToRescan(@NotNull WorkspaceEntity entity) {
        if (entity == null) {
            CustomEntitiesCausingReindexTracker.$$$reportNull$$$0(2);
        }
        Class<@NotNull ?> entityClass = entity.getClass();
        return ContainerUtil.exists(this.customEntitiesToRescan, aClass -> aClass.isAssignableFrom(entityClass));
    }

    private static boolean hasDependencyOn(LibraryEntity library, Project project2) {
        return ModuleDependencyIndex.getInstance(project2).hasDependencyOn(library.getSymbolicId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/CustomEntitiesCausingReindexTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRescan";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEntityToRescan";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

