/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.BuildableRootsChangeRescanningInfo;
import com.intellij.util.indexing.BuildableRootsChangeRescanningInfoImpl;
import com.intellij.util.indexing.CustomEntitiesCausingReindexTracker;
import com.intellij.util.indexing.EntityIndexingServiceEx;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexableFilesIndex;
import com.intellij.util.indexing.RootChangesLogger;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.dependenciesCache.DependenciesIndexedStatusService;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.IndexingRootsCollectionUtil;
import com.intellij.util.indexing.roots.LibraryIndexableEntityProvider;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilders;
import com.intellij.workspaceModel.core.fileIndex.DependencyDescription;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.impl.PlatformInternalWorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexImpl;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kotlin.Pair;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

class EntityIndexingServiceImpl
implements EntityIndexingServiceEx {
    private static final Logger LOG = Logger.getInstance(EntityIndexingServiceImpl.class);
    private static final RootChangesLogger ROOT_CHANGES_LOGGER = new RootChangesLogger();
    @NotNull
    private final CustomEntitiesCausingReindexTracker tracker = new CustomEntitiesCausingReindexTracker();

    EntityIndexingServiceImpl() {
    }

    /*
     * WARNING - void declaration
     */
    public void indexChanges(@NotNull Project project2, @NotNull List<? extends RootsChangeRescanningInfo> changes) {
        List<IndexableFilesIterator> mergedIterators;
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(1);
        }
        if (!(FileBasedIndex.getInstance() instanceof FileBasedIndexImpl)) {
            return;
        }
        if (LightEdit.owns((Project)project2)) {
            return;
        }
        if (changes.isEmpty()) {
            EntityIndexingServiceImpl.runFullRescan(project2, "Project roots have changed");
        }
        boolean fullReindexOnBuildableChanges = Registry.is("indexing.full.rescan.on.buildable.changes");
        boolean indexDependencies = false;
        for (RootsChangeRescanningInfo rootsChangeRescanningInfo : changes) {
            if (rootsChangeRescanningInfo == RootsChangeRescanningInfo.TOTAL_RESCAN) {
                EntityIndexingServiceImpl.runFullRescan(project2, "Reindex requested by project root model changes");
                return;
            }
            if (fullReindexOnBuildableChanges && rootsChangeRescanningInfo instanceof BuildableRootsChangeRescanningInfo) {
                EntityIndexingServiceImpl.runFullRescan(project2, "Reindex requested by buildable changes");
                return;
            }
            if (rootsChangeRescanningInfo != RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED) continue;
            if (!indexDependencies && !DependenciesIndexedStatusService.shouldBeUsed()) {
                EntityIndexingServiceImpl.runFullRescan(project2, "Reindex of changed dependencies requested, but not enabled");
                return;
            }
            indexDependencies = true;
        }
        SmartList<IndexableEntityProvider.IndexableIteratorBuilder> builders = new SmartList<IndexableEntityProvider.IndexableIteratorBuilder>();
        Object var6_7 = null;
        if (indexDependencies) {
            Pair<Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder>, DependenciesIndexedStatusService.StatusMark> dependencyBuildersPair = DependenciesIndexedStatusService.getInstance(project2).getDeltaWithLastIndexedStatus();
            if (dependencyBuildersPair == null) {
                EntityIndexingServiceImpl.runFullRescan(project2, "Reindex of changed dependencies requested, but status is not initialized");
                return;
            }
            builders.addAll((Collection)dependencyBuildersPair.getFirst());
            DependenciesIndexedStatusService.StatusMark statusMark = (DependenciesIndexedStatusService.StatusMark)dependencyBuildersPair.getSecond();
        }
        EntityStorageSnapshot entityStorage = WorkspaceModel.getInstance(project2).getCurrentSnapshot();
        for (RootsChangeRescanningInfo rootsChangeRescanningInfo : changes) {
            if (rootsChangeRescanningInfo == RootsChangeRescanningInfo.NO_RESCAN_NEEDED || rootsChangeRescanningInfo == RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED) continue;
            if (rootsChangeRescanningInfo instanceof WorkspaceEventRescanningInfo) {
                builders.addAll(EntityIndexingServiceImpl.getBuildersOnWorkspaceChange(project2, ((WorkspaceEventRescanningInfo)rootsChangeRescanningInfo).events, (EntityStorage)entityStorage));
                continue;
            }
            if (rootsChangeRescanningInfo instanceof WorkspaceEntitiesRootsChangedRescanningInfo) {
                List<EntityReference<WorkspaceEntity>> references = ((WorkspaceEntitiesRootsChangedRescanningInfo)rootsChangeRescanningInfo).references;
                List<@NotNull WorkspaceEntity> entities2 = ContainerUtil.mapNotNull(references, arg_0 -> EntityIndexingServiceImpl.lambda$indexChanges$0((EntityStorage)entityStorage, arg_0));
                builders.addAll(EntityIndexingServiceImpl.getBuildersOnWorkspaceEntitiesRootsChange(project2, entities2, (EntityStorage)entityStorage));
                continue;
            }
            if (rootsChangeRescanningInfo instanceof BuildableRootsChangeRescanningInfo) {
                builders.addAll(EntityIndexingServiceImpl.getBuildersOnBuildableChangeInfo((BuildableRootsChangeRescanningInfo)rootsChangeRescanningInfo));
                continue;
            }
            LOG.warn("Unexpected change " + rootsChangeRescanningInfo.getClass() + " " + rootsChangeRescanningInfo + ", full reindex requested");
            EntityIndexingServiceImpl.runFullRescan(project2, "Reindex on unexpected change in EntityIndexingServiceImpl");
            return;
        }
        if (!builders.isEmpty() && !(mergedIterators = IndexableIteratorBuilders.INSTANCE.instantiateBuilders(builders, project2, (EntityStorage)entityStorage)).isEmpty()) {
            void var6_9;
            List<String> list2 = ContainerUtil.map(mergedIterators, IndexableFilesIterator::getDebugName);
            LOG.debug("Accumulated iterators: " + list2);
            int maxNamesToLog = 10;
            String reasonMessage = "changes in: " + list2.stream().limit(maxNamesToLog).map(StringUtil::wrapWithDoubleQuote).collect(Collectors.joining(", "));
            if (list2.size() > maxNamesToLog) {
                reasonMessage = reasonMessage + " and " + (list2.size() - maxNamesToLog) + " iterators more";
            }
            EntityIndexingServiceImpl.logRootChanges(project2, false);
            new UnindexedFilesUpdater(project2, mergedIterators, (DependenciesIndexedStatusService.StatusMark)var6_9, reasonMessage).queue();
        }
    }

    private static void runFullRescan(@NotNull Project project2, @NotNull @NonNls String reason) {
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(2);
        }
        if (reason == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(3);
        }
        EntityIndexingServiceImpl.logRootChanges(project2, true);
        new UnindexedFilesUpdater(project2, reason).queue();
    }

    private static void logRootChanges(@NotNull Project project2, boolean isFullReindex) {
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (LOG.isDebugEnabled()) {
                String message = isFullReindex ? "Project roots of " + project2.getName() + " have changed" : "Project roots of " + project2.getName() + " will be partially reindexed";
                LOG.debug(message, new Throwable());
            }
        } else {
            ROOT_CHANGES_LOGGER.info(project2, isFullReindex);
        }
    }

    @TestOnly
    @NotNull
    static List<IndexableFilesIterator> getIterators(@NotNull Project project2, @NotNull Collection<? extends EntityChange<?>> events) {
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(5);
        }
        if (events == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(6);
        }
        EntityStorageSnapshot entityStorage = WorkspaceModel.getInstance(project2).getCurrentSnapshot();
        List<IndexableEntityProvider.IndexableIteratorBuilder> result2 = EntityIndexingServiceImpl.getBuildersOnWorkspaceChange(project2, events, (EntityStorage)entityStorage);
        List<IndexableFilesIterator> list2 = IndexableIteratorBuilders.INSTANCE.instantiateBuilders(result2, project2, (EntityStorage)entityStorage);
        if (list2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    private static List<IndexableEntityProvider.IndexableIteratorBuilder> getBuildersOnWorkspaceChange(@NotNull Project project2, @NotNull Collection<? extends EntityChange<?>> event, @NotNull EntityStorage entityStorage) {
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(8);
        }
        if (event == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(9);
        }
        if (entityStorage == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(10);
        }
        SmartList<IndexableEntityProvider.IndexableIteratorBuilder> builders = new SmartList<IndexableEntityProvider.IndexableIteratorBuilder>();
        for (EntityChange<?> change2 : event) {
            EntityIndexingServiceImpl.collectIteratorBuildersOnChange(Change.fromEntityChange(change2), change2.getOldEntity(), change2.getNewEntity(), project2, builders, entityStorage);
        }
        SmartList<IndexableEntityProvider.IndexableIteratorBuilder> smartList = builders;
        if (smartList == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    private static <E extends WorkspaceEntity> void collectIteratorBuildersOnChange(@NotNull Change change2, @Nullable E oldEntity, @Nullable E newEntity2, @NotNull Project project2, @NotNull Collection<? super IndexableEntityProvider.IndexableIteratorBuilder> builders, @NotNull EntityStorage entityStorage) {
        if (change2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(12);
        }
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(13);
        }
        if (builders == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(14);
        }
        if (entityStorage == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(15);
        }
        LOG.assertTrue(newEntity2 != null || change2 == Change.Removed, "New entity " + newEntity2 + ", change " + change2);
        LOG.assertTrue(oldEntity != null || change2 == Change.Added, "Old entity " + oldEntity + ", change " + change2);
        Class entityClass = Objects.requireNonNull(newEntity2 == null ? oldEntity : newEntity2).getEntityInterface();
        IndexingRootsCollectionUtil.RootsCollector collector2 = new IndexingRootsCollectionUtil.RootsCollector(null);
        if (IndexableFilesIndex.isEnabled()) {
            ArrayList newBuilders = new ArrayList();
            EntityIndexingServiceImpl.collectWFICIteratorsOnChange(change2, oldEntity, newEntity2, project2, newBuilders, collector2, entityClass, false, entityStorage);
            builders.addAll(newBuilders);
        } else {
            ArrayList oldBuilders = new ArrayList();
            EntityIndexingServiceImpl.collectIEPIteratorsOnChange(change2, oldEntity, newEntity2, project2, oldBuilders, collector2, entityClass, false, entityStorage);
            builders.addAll(oldBuilders);
        }
    }

    private static <E extends WorkspaceEntity> void collectIEPIteratorsOnChange(@NotNull Change change2, @Nullable E oldEntity, @Nullable E newEntity2, @NotNull Project project2, @NotNull Collection<? super IndexableEntityProvider.IndexableIteratorBuilder> builders, @NotNull IndexingRootsCollectionUtil.RootsCollector collector2, @NotNull Class<? super E> entityClass, boolean enforcedOnly, @NotNull EntityStorage entityStorage) {
        if (change2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(16);
        }
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(17);
        }
        if (builders == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(18);
        }
        if (collector2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(19);
        }
        if (entityClass == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(20);
        }
        if (entityStorage == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(21);
        }
        LOG.assertTrue(newEntity2 != null || change2 == Change.Removed, "New entity " + newEntity2 + ", change " + change2);
        LOG.assertTrue(oldEntity != null || change2 == Change.Added, "Old entity " + oldEntity + ", change " + change2);
        for (IndexableEntityProvider<? extends WorkspaceEntity> uncheckedProvider : IndexableEntityProvider.EP_NAME.getExtensionList()) {
            if (entityClass == uncheckedProvider.getEntityClass() && (!enforcedOnly || uncheckedProvider instanceof IndexableEntityProvider.Enforced)) {
                IndexableEntityProvider<? extends WorkspaceEntity> provider2 = uncheckedProvider;
                Collection<IndexableEntityProvider.IndexableIteratorBuilder> generated = switch (change2) {
                    default -> throw new IncompatibleClassChangeError();
                    case Change.Added -> provider2.getAddedEntityIteratorBuilders(newEntity2, project2);
                    case Change.Replaced -> provider2.getReplacedEntityIteratorBuilders(oldEntity, newEntity2, project2);
                    case Change.Removed -> provider2.getRemovedEntityIteratorBuilders(oldEntity, project2);
                };
                builders.addAll(generated);
            }
            if (change2 != Change.Replaced || enforcedOnly && !(uncheckedProvider instanceof IndexableEntityProvider.Enforced)) continue;
            for (IndexableEntityProvider.DependencyOnParent<WorkspaceEntity> dependency : uncheckedProvider.getDependencies()) {
                if (entityClass != dependency.getParentClass()) continue;
                builders.addAll(dependency.getReplacedEntityIteratorBuilders(oldEntity, newEntity2));
            }
        }
        if (!enforcedOnly) {
            EntityIndexingServiceImpl.collectWFICIteratorsOnChange(change2, oldEntity, newEntity2, project2, builders, collector2, entityClass, true, entityStorage);
        }
    }

    private static <E extends WorkspaceEntity> void collectWFICIteratorsOnChange(@NotNull Change change2, @Nullable E oldEntity, @Nullable E newEntity2, @NotNull Project project2, @NotNull Collection<? super IndexableEntityProvider.IndexableIteratorBuilder> builders, @NotNull IndexingRootsCollectionUtil.RootsCollector collector2, @NotNull Class<? super E> entityClass, boolean customOnly, @NotNull EntityStorage entityStorage) {
        if (change2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(22);
        }
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(23);
        }
        if (builders == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(24);
        }
        if (collector2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(25);
        }
        if (entityClass == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(26);
        }
        if (entityStorage == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(27);
        }
        LOG.assertTrue(newEntity2 != null || change2 == Change.Removed, "New entity " + newEntity2 + ", change " + change2);
        LOG.assertTrue(oldEntity != null || change2 == Change.Added, "Old entity " + oldEntity + ", change " + change2);
        if (change2 != Change.Removed) {
            List<WorkspaceFileIndexContributor<?>> contributors = ((WorkspaceFileIndexImpl)WorkspaceFileIndex.getInstance(project2)).getContributors();
            for (WorkspaceFileIndexContributor<?> uncheckedContributor : contributors) {
                if (customOnly && uncheckedContributor instanceof PlatformInternalWorkspaceFileIndexContributor) continue;
                if (entityClass == uncheckedContributor.getEntityClass()) {
                    WorkspaceFileIndexContributor<?> contributor = uncheckedContributor;
                    builders.addAll(EntityIndexingServiceImpl.createBuilders(contributor, newEntity2, entityStorage, collector2));
                }
                if (change2 != Change.Replaced) continue;
                EntityIndexingServiceImpl.handleDependencies(oldEntity, newEntity2, builders, collector2, entityClass, uncheckedContributor, entityStorage);
            }
        }
        if (!customOnly) {
            EntityIndexingServiceImpl.collectIEPIteratorsOnChange(change2, oldEntity, newEntity2, project2, builders, new IndexingRootsCollectionUtil.RootsCollector(null), entityClass, true, entityStorage);
        }
        if (!customOnly && change2 != Change.Removed && EntityIndexingServiceImpl.isLibraryIgnoredByLibraryRootFileIndexContributor(newEntity2)) {
            LibraryIndexableEntityProvider provider2 = IndexableEntityProvider.EP_NAME.findExtensionOrFail(LibraryIndexableEntityProvider.class);
            if (change2 == Change.Added) {
                builders.addAll(provider2.getAddedEntityIteratorBuilders((LibraryEntity)newEntity2, project2));
            } else {
                builders.addAll(provider2.getReplacedEntityIteratorBuilders((LibraryEntity)oldEntity, (LibraryEntity)newEntity2, project2));
            }
        }
    }

    @NotNull
    private static <E extends WorkspaceEntity> Collection<IndexableEntityProvider.IndexableIteratorBuilder> createBuilders(@NotNull WorkspaceFileIndexContributor<E> contributor, @NotNull E entity, @NotNull EntityStorage entityStorage, @NotNull IndexingRootsCollectionUtil.RootsCollector collector2) {
        if (contributor == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(28);
        }
        if (entity == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(29);
        }
        if (entityStorage == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(30);
        }
        if (collector2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(31);
        }
        if (contributor.getStorageKind() != EntityStorageKind.MAIN) {
            List<IndexableEntityProvider.IndexableIteratorBuilder> list2 = Collections.emptyList();
            if (list2 == null) {
                EntityIndexingServiceImpl.$$$reportNull$$$0(32);
            }
            return list2;
        }
        IndexingRootsCollectionUtil.IndexingRootsDescriptions roots2 = new IndexingRootsCollectionUtil.IndexingRootsDescriptions();
        collector2.registerAndCollectAllRoots(roots2, contributor, SequencesKt.sequenceOf((Object[])new WorkspaceEntity[]{entity}), entityStorage);
        Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = IndexingRootsCollectionUtil.createBuildersFromRootsDescriptions(roots2);
        if (collection == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(33);
        }
        return collection;
    }

    private static <E extends WorkspaceEntity> boolean isLibraryIgnoredByLibraryRootFileIndexContributor(@NotNull E newEntity2) {
        if (newEntity2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(34);
        }
        return newEntity2 instanceof LibraryEntity && ((LibraryEntity)newEntity2).getSymbolicId().getTableId() instanceof LibraryTableId.GlobalLibraryTableId;
    }

    private static <E extends WorkspaceEntity, C extends WorkspaceEntity> void handleDependencies(@NotNull E oldEntity, @NotNull E newEntity2, @NotNull Collection<? super IndexableEntityProvider.IndexableIteratorBuilder> builders, @NotNull IndexingRootsCollectionUtil.RootsCollector collector2, @NotNull Class<? super E> entityClass, @NotNull WorkspaceFileIndexContributor<C> contributor, @NotNull EntityStorage entityStorage) {
        if (oldEntity == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(35);
        }
        if (newEntity2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(36);
        }
        if (builders == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(37);
        }
        if (collector2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(38);
        }
        if (entityClass == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(39);
        }
        if (contributor == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(40);
        }
        if (entityStorage == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(41);
        }
        for (DependencyDescription<C> dependency : contributor.getDependenciesOnOtherEntities()) {
            EntityIndexingServiceImpl.handleChildEntities(entityClass, oldEntity, newEntity2, builders, collector2, contributor, dependency, entityStorage);
        }
    }

    private static <E extends WorkspaceEntity, C extends WorkspaceEntity> void handleChildEntities(@NotNull Class<? super E> entityClass, @NotNull E oldEntity, @NotNull E newEntity2, @NotNull Collection<? super IndexableEntityProvider.IndexableIteratorBuilder> builders, @NotNull IndexingRootsCollectionUtil.RootsCollector collector2, @NotNull WorkspaceFileIndexContributor<C> contributor, @NotNull DependencyDescription<C> dependency, @NotNull EntityStorage entityStorage) {
        if (entityClass == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(42);
        }
        if (oldEntity == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(43);
        }
        if (newEntity2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(44);
        }
        if (builders == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(45);
        }
        if (collector2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(46);
        }
        if (contributor == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(47);
        }
        if (dependency == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(48);
        }
        if (entityStorage == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(49);
        }
        if (!(dependency instanceof DependencyDescription.OnParent) || entityClass != ((DependencyDescription.OnParent)dependency).getParentClass()) {
            return;
        }
        List oldElements = SequencesKt.toList((Sequence)((Sequence)((DependencyDescription.OnParent)dependency).getChildrenGetter().invoke(oldEntity)));
        List newElements = SequencesKt.toMutableList((Sequence)((Sequence)((DependencyDescription.OnParent)dependency).getChildrenGetter().invoke(newEntity2)));
        newElements.removeAll(oldElements);
        for (WorkspaceEntity element : newElements) {
            builders.addAll(EntityIndexingServiceImpl.createBuilders(contributor, element, entityStorage, collector2));
        }
    }

    private static Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getBuildersOnWorkspaceEntitiesRootsChange(@NotNull Project project2, @NotNull List<? extends WorkspaceEntity> entities2, @NotNull EntityStorage entityStorage) {
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(50);
        }
        if (entities2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(51);
        }
        if (entityStorage == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(52);
        }
        SmartList builders = new SmartList();
        for (WorkspaceEntity workspaceEntity : entities2) {
            EntityIndexingServiceImpl.collectIteratorBuildersOnChange(Change.Added, null, workspaceEntity, project2, builders, entityStorage);
        }
        return builders;
    }

    @NotNull
    private static Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getBuildersOnBuildableChangeInfo(@NotNull BuildableRootsChangeRescanningInfo buildableInfo) {
        if (buildableInfo == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(53);
        }
        BuildableRootsChangeRescanningInfoImpl info2 = (BuildableRootsChangeRescanningInfoImpl)buildableInfo;
        SmartList<IndexableEntityProvider.IndexableIteratorBuilder> builders = new SmartList<IndexableEntityProvider.IndexableIteratorBuilder>();
        IndexableIteratorBuilders instance2 = IndexableIteratorBuilders.INSTANCE;
        for (ModuleId moduleId : info2.getModules()) {
            builders.addAll(instance2.forModuleContent(moduleId));
        }
        if (info2.hasInheritedSdk()) {
            builders.addAll(instance2.forInheritedSdk());
        }
        for (Pair pair : info2.getSdks()) {
            builders.addAll(instance2.forSdk((String)pair.getFirst(), (String)pair.getSecond()));
        }
        for (LibraryId libraryId : info2.getLibraries()) {
            builders.addAll(instance2.forLibraryEntity(libraryId, true));
        }
        SmartList<IndexableEntityProvider.IndexableIteratorBuilder> smartList = builders;
        if (smartList == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(54);
        }
        return smartList;
    }

    @NotNull
    public BuildableRootsChangeRescanningInfo createBuildableInfo() {
        return new BuildableRootsChangeRescanningInfoImpl();
    }

    @Override
    @NotNull
    public RootsChangeRescanningInfo createWorkspaceChangedEventInfo(@NotNull List<EntityChange<?>> changes) {
        if (changes == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(55);
        }
        return new WorkspaceEventRescanningInfo(changes);
    }

    @Override
    @NotNull
    public RootsChangeRescanningInfo createWorkspaceEntitiesRootsChangedInfo(@NotNull List<EntityReference<WorkspaceEntity>> references) {
        if (references == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(56);
        }
        return new WorkspaceEntitiesRootsChangedRescanningInfo(references);
    }

    public boolean isFromWorkspaceOnly(@NotNull List<? extends RootsChangeRescanningInfo> indexingInfos) {
        if (indexingInfos == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(57);
        }
        if (indexingInfos.isEmpty()) {
            return false;
        }
        for (RootsChangeRescanningInfo rootsChangeRescanningInfo : indexingInfos) {
            if (rootsChangeRescanningInfo instanceof WorkspaceEventRescanningInfo) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldCauseRescan(@NotNull WorkspaceEntity entity, @NotNull Project project2) {
        if (entity == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(58);
        }
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(59);
        }
        return this.tracker.shouldRescan(entity, project2);
    }

    private static /* synthetic */ WorkspaceEntity lambda$indexChanges$0(EntityStorage entityStorage, EntityReference ref) {
        return ref.resolve(entityStorage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11, 32, 33, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 7: 
            case 11: 
            case 32: 
            case 33: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/EntityIndexingServiceImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 10: 
            case 15: 
            case 21: 
            case 27: 
            case 30: 
            case 41: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityStorage";
                break;
            }
            case 12: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 14: 
            case 18: 
            case 24: 
            case 37: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builders";
                break;
            }
            case 19: 
            case 25: 
            case 31: 
            case 38: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 20: 
            case 26: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityClass";
                break;
            }
            case 28: 
            case 40: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 29: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 34: 
            case 36: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEntity";
                break;
            }
            case 35: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldEntity";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entities";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildableInfo";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/EntityIndexingServiceImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIterators";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildersOnWorkspaceChange";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilders";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildersOnBuildableChangeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "indexChanges";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runFullRescan";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logRootChanges";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIterators";
                break;
            }
            case 7: 
            case 11: 
            case 32: 
            case 33: 
            case 54: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBuildersOnWorkspaceChange";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectIteratorBuildersOnChange";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectIEPIteratorsOnChange";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectWFICIteratorsOnChange";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createBuilders";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryIgnoredByLibraryRootFileIndexContributor";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "handleDependencies";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "handleChildEntities";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getBuildersOnWorkspaceEntitiesRootsChange";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getBuildersOnBuildableChangeInfo";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createWorkspaceChangedEventInfo";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createWorkspaceEntitiesRootsChangedInfo";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isFromWorkspaceOnly";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "shouldCauseRescan";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 11, 32, 33, 54 -> new IllegalStateException(string2);
        };
    }

    private static class WorkspaceEventRescanningInfo
    implements RootsChangeRescanningInfo {
        @NotNull
        private final List<EntityChange<?>> events;

        private WorkspaceEventRescanningInfo(@NotNull List<EntityChange<?>> events) {
            if (events == null) {
                WorkspaceEventRescanningInfo.$$$reportNull$$$0(0);
            }
            this.events = events;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/util/indexing/EntityIndexingServiceImpl$WorkspaceEventRescanningInfo", "<init>"));
        }
    }

    private static class WorkspaceEntitiesRootsChangedRescanningInfo
    implements RootsChangeRescanningInfo {
        @NotNull
        private final List<EntityReference<WorkspaceEntity>> references;

        private WorkspaceEntitiesRootsChangedRescanningInfo(@NotNull List<EntityReference<WorkspaceEntity>> entities2) {
            if (entities2 == null) {
                WorkspaceEntitiesRootsChangedRescanningInfo.$$$reportNull$$$0(0);
            }
            this.references = entities2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entities", "com/intellij/util/indexing/EntityIndexingServiceImpl$WorkspaceEntitiesRootsChangedRescanningInfo", "<init>"));
        }
    }

    private static enum Change {
        Added,
        Replaced,
        Removed;


        static Change fromEntityChange(EntityChange<?> change2) {
            if (change2 instanceof EntityChange.Added) {
                return Added;
            }
            if (change2 instanceof EntityChange.Replaced) {
                return Replaced;
            }
            if (change2 instanceof EntityChange.Removed) {
                return Removed;
            }
            throw new IllegalStateException("Unexpected change " + change2);
        }
    }
}

