/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.UnindexedFilesIndexer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class FileBasedIndexProjectHandler {
    @ApiStatus.Internal
    public static final int ourMinFilesToStartDumbMode = Registry.intValue("ide.dumb.mode.minFilesToStart", 20);
    private static final int ourMinFilesSizeToStartDumbMode = Registry.intValue("ide.dumb.mode.minFilesSizeToStart", 0x100000);

    public static void scheduleReindexingInDumbMode(@NotNull Project project2) {
        FileBasedIndex i2;
        if (project2 == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(0);
        }
        if ((i2 = FileBasedIndex.getInstance()) instanceof FileBasedIndexImpl && IndexInfrastructure.hasIndices() && !project2.isDisposed() && FileBasedIndexProjectHandler.mightHaveManyChangedFilesInProject(project2)) {
            String indexingReason = "On refresh of files in " + project2.getName();
            new UnindexedFilesIndexer(project2, indexingReason).queue(project2);
        }
    }

    @ApiStatus.Internal
    public static boolean mightHaveManyChangedFilesInProject(Project project2) {
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (!(fileBasedIndex instanceof FileBasedIndexImpl)) {
            return false;
        }
        final long start = System.currentTimeMillis();
        return !((FileBasedIndexImpl)fileBasedIndex).processChangedFiles(project2, (Processor<? super VirtualFile>)new Processor<VirtualFile>(){
            int filesInProjectToBeIndexed;
            long sizeOfFilesToBeIndexed;

            @Override
            public boolean process(VirtualFile file2) {
                ++this.filesInProjectToBeIndexed;
                if (file2.isValid() && !file2.isDirectory()) {
                    this.sizeOfFilesToBeIndexed += file2.getLength();
                }
                return this.filesInProjectToBeIndexed < ourMinFilesToStartDumbMode && this.sizeOfFilesToBeIndexed < (long)ourMinFilesSizeToStartDumbMode && System.currentTimeMillis() < start + 100L;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/FileBasedIndexProjectHandler", "scheduleReindexingInDumbMode"));
    }
}

