/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.indexing.CorruptionMarker;
import com.intellij.util.indexing.FbiSnapshot;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileTypeTracker;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.IndexingFlag;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.PerProjectIndexingQueue;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.UnindexedFilesScannerExecutor;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0012\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\u00020\u00112\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/indexing/FileBasedIndexTumbler;", "", "reason", "", "Lorg/jetbrains/annotations/NonNls;", "(Ljava/lang/String;)V", "dumbModeSemaphore", "Lcom/intellij/util/concurrency/Semaphore;", "fileBasedIndex", "Lcom/intellij/util/indexing/FileBasedIndexImpl;", "fileTypeTracker", "Lcom/intellij/util/indexing/FileTypeTracker;", "nestedLevelCount", "", "snapshot", "Lcom/intellij/util/indexing/FbiSnapshot;", "turnOff", "", "turnOn", "beforeIndexTasksStarted", "Ljava/lang/Runnable;", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nFileBasedIndexTumbler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileBasedIndexTumbler.kt\ncom/intellij/util/indexing/FileBasedIndexTumbler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,244:1\n1#2:245\n10#3:246\n*S KotlinDebug\n*F\n+ 1 FileBasedIndexTumbler.kt\ncom/intellij/util/indexing/FileBasedIndexTumbler\n*L\n123#1:246\n*E\n"})
public final class FileBasedIndexTumbler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String reason;
    @NotNull
    private final FileBasedIndexImpl fileBasedIndex;
    @NotNull
    private final Semaphore dumbModeSemaphore;
    private int nestedLevelCount;
    @Nullable
    private FbiSnapshot snapshot;
    @Nullable
    private FileTypeTracker fileTypeTracker;
    @NotNull
    private static final Logger LOG;

    public FileBasedIndexTumbler(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.reason = reason;
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        this.fileBasedIndex = (FileBasedIndexImpl)fileBasedIndex;
        this.dumbModeSemaphore = new Semaphore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void turnOff() {
        Application app = ApplicationManager.getApplication();
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(!app.isWriteAccessAllowed());
        try {
            if (this.nestedLevelCount == 0) {
                boolean headless = app.isHeadlessEnvironment();
                if (!headless) {
                    boolean wasUp = this.dumbModeSemaphore.isUp();
                    this.dumbModeSemaphore.down();
                    if (wasUp) {
                        for (Project project2 : ProjectUtil.getOpenProjects()) {
                            UnindexedFilesScannerExecutor scannerExecutor = project2.getService(UnindexedFilesScannerExecutor.class);
                            scannerExecutor.suspendQueue();
                            scannerExecutor.cancelAllTasksAndWait();
                            PerProjectIndexingQueue perProjectIndexingQueue = project2.getService(PerProjectIndexingQueue.class);
                            perProjectIndexingQueue.cancelAllTasksAndWait();
                            perProjectIndexingQueue.clear();
                            DumbService dumbService = DumbService.getInstance(project2);
                            dumbService.cancelAllTasksAndWait();
                            new Companion.MyDumbModeTask(this.dumbModeSemaphore).queue(project2);
                        }
                    }
                }
                LOG.assertTrue(this.fileTypeTracker == null);
                this.fileTypeTracker = new FileTypeTracker();
                this.fileBasedIndex.waitUntilIndicesAreInitialized();
                this.fileBasedIndex.performShutdown(true, this.reason);
                this.fileBasedIndex.dropRegisteredIndexes();
                boolean indexesAreOk = RebuildStatus.isOk();
                RebuildStatus.reset();
                IndexingStamp.dropTimestampMemoryCaches();
                LOG.assertTrue(this.snapshot == null);
                this.snapshot = indexesAreOk ? (FbiSnapshot)FbiSnapshot.Impl.Companion.capture() : (FbiSnapshot)FbiSnapshot.RebuildRequired.INSTANCE;
            }
        }
        finally {
            int n = this.nestedLevelCount;
            this.nestedLevelCount = n + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @JvmOverloads
    public final void turnOn(@Nullable Runnable beforeIndexTasksStarted) {
        block13: {
            FileBasedIndexTumbler.LOG.assertTrue(ApplicationManager.getApplication().isWriteIntentLockAcquired());
            var2_2 = this.nestedLevelCount;
            this.nestedLevelCount = var2_2 + -1;
            if (this.nestedLevelCount != 0) break block13;
            try {
                this.fileBasedIndex.loadIndexes();
                headless = ApplicationManager.getApplication().isHeadlessEnvironment();
                if (headless) {
                    this.fileBasedIndex.waitUntilIndicesAreInitialized();
                }
                if (!headless) {
                    var3_4 = ProjectUtil.getOpenProjects();
                    var5_9 = var3_4.length;
                    for (var4_6 = 0; var4_6 < var5_9; ++var4_6) {
                        project = var3_4[var4_6];
                        project.getService(UnindexedFilesScannerExecutor.class).resumeQueue();
                        project.getService(PerProjectIndexingQueue.class).resumeQueue();
                    }
                    this.dumbModeSemaphore.up();
                }
                if (CorruptionMarker.requireInvalidation() || Registry.is("run.index.rescanning.on.plugin.load.unload") || this.snapshot instanceof FbiSnapshot.RebuildRequired) ** GOTO lbl-1000
                v0 = this.snapshot;
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FbiSnapshot.Impl");
                if (FbiSnapshot.Impl.Companion.isRescanningRequired((FbiSnapshot.Impl)v0, FbiSnapshot.Impl.Companion.capture())) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = runRescanning = false;
                }
                if (runRescanning) {
                    v2 = beforeIndexTasksStarted;
                    if (v2 != null) {
                        v2.run();
                    }
                    IndexingFlag.cleanupProcessedFlag();
                    for (Project project : ProjectUtil.getOpenProjects()) {
                        new UnindexedFilesUpdater(project, this.reason).queue();
                    }
                    FileBasedIndexTumbler.LOG.info("Index rescanning has been started after `" + this.reason + "`");
                } else {
                    FileBasedIndexTumbler.LOG.info("Index rescanning has been skipped after `" + this.reason + "`");
                }
            }
            finally {
                v3 = this.fileTypeTracker;
                if (v3 != null) {
                    it = v3;
                    $i$a$-let-FileBasedIndexTumbler$turnOn$1 = false;
                    Disposer.dispose(it);
                }
                this.fileTypeTracker = null;
                this.snapshot = null;
            }
        }
    }

    public static /* synthetic */ void turnOn$default(FileBasedIndexTumbler fileBasedIndexTumbler, Runnable runnable, int n, Object object) {
        if ((n & 1) != 0) {
            runnable = null;
        }
        fileBasedIndexTumbler.turnOn(runnable);
    }

    @JvmOverloads
    public final void turnOn() {
        FileBasedIndexTumbler.turnOn$default(this, null, 1, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FileBasedIndexTumbler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/util/indexing/FileBasedIndexTumbler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MyDumbModeTask", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/indexing/FileBasedIndexTumbler$Companion$MyDumbModeTask;", "Lcom/intellij/openapi/project/DumbModeTask;", "semaphore", "Lcom/intellij/util/concurrency/Semaphore;", "(Lcom/intellij/util/concurrency/Semaphore;)V", "getSemaphore", "()Lcom/intellij/util/concurrency/Semaphore;", "performInDumbMode", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "toString", "", "tryMergeWith", "taskFromQueue", "intellij.platform.lang.impl"})
        private static final class MyDumbModeTask
        extends DumbModeTask {
            @NotNull
            private final Semaphore semaphore;

            public MyDumbModeTask(@NotNull Semaphore semaphore) {
                Intrinsics.checkNotNullParameter((Object)semaphore, (String)"semaphore");
                this.semaphore = semaphore;
            }

            @NotNull
            public final Semaphore getSemaphore() {
                return this.semaphore;
            }

            @Override
            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText(IndexingBundle.message((String)"indexes.reloading", (Object[])new Object[0]));
                this.semaphore.waitFor();
            }

            @NotNull
            public String toString() {
                return "Plugin loading/unloading";
            }

            @Override
            @Nullable
            public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
                Intrinsics.checkNotNullParameter((Object)taskFromQueue, (String)"taskFromQueue");
                return taskFromQueue instanceof MyDumbModeTask && ((MyDumbModeTask)taskFromQueue).semaphore == this.semaphore ? (DumbModeTask)this : null;
            }
        }
    }
}

