/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000e*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000f\u0010\u0004\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0005J\r\u0010\u0006\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fH$\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/indexing/IndexDataInitializer;", "T", "Ljava/util/concurrent/Callable;", "()V", "call", "()Ljava/lang/Object;", "finish", "getInitializationFinishedMessage", "", "initializationResult", "(Ljava/lang/Object;)Ljava/lang/String;", "prepareTasks", "", "Lcom/intellij/util/ThrowableRunnable;", "Companion", "intellij.platform.lang.impl"})
public abstract class IndexDataInitializer<T>
implements Callable<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final CoroutineScope scope;

    @Override
    @Nullable
    public T call() {
        T t;
        Logger logger = Logger.getInstance(this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(javaClass.name)");
        Logger log = logger;
        Instant started = Instant.now();
        try {
            Collection<ThrowableRunnable<?>> tasks = this.prepareTasks();
            Companion.runParallelTasks(tasks, true);
            T result2 = this.finish();
            String message = this.getInitializationFinishedMessage(result2);
            log.info("Index data initialization done: " + Duration.between(started, Instant.now()).toMillis() + " ms. " + message);
            t = result2;
        }
        catch (Throwable t2) {
            log.error("Index data initialization failed", t2);
            throw t2;
        }
        return t;
    }

    @NotNull
    protected abstract String getInitializationFinishedMessage(T var1);

    protected abstract T finish();

    @NotNull
    protected abstract Collection<ThrowableRunnable<?>> prepareTasks();

    @JvmStatic
    @NotNull
    public static final <T> Future<T> submitGenesisTask(@NotNull Callable<T> action2) {
        return Companion.submitGenesisTask(action2);
    }

    @JvmStatic
    public static final void runParallelTasks(@NotNull Collection<? extends ThrowableRunnable<?>> tasks, boolean checkAppDisposed) {
        Companion.runParallelTasks(tasks, checkAppDisposed);
    }

    static {
        Logger logger = Logger.getInstance(IndexDataInitializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(IndexDataInitializer::class.java)");
        LOG = logger;
        scope = CoroutineScopeKt.CoroutineScope(SupervisorKt.SupervisorJob$default(null, 1, null).plus((CoroutineContext)Dispatchers.getIO().limitedParallelism(1)));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u000f\u001a\u00020\n2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0007J\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\u0004\b\u0001\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/util/indexing/IndexDataInitializer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope$annotations", "executeTask", "", "callable", "Lcom/intellij/util/ThrowableRunnable;", "checkAppDisposed", "", "runParallelTasks", "tasks", "", "submitGenesisTask", "Ljava/util/concurrent/Future;", "T", "action", "Ljava/util/concurrent/Callable;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getScope$annotations() {
        }

        @JvmStatic
        @NotNull
        public final <T> Future<T> submitGenesisTask(@NotNull Callable<T> action2) {
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            return FutureKt.asCompletableFuture(BuildersKt.async$default(scope, null, null, new Function2<CoroutineScope, Continuation<? super T>, Object>(action2, null){
                int label;
                final /* synthetic */ Callable<T> $action;
                {
                    this.$action = $action;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            return this.$action.call();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super T> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null));
        }

        @JvmStatic
        public final void runParallelTasks(@NotNull Collection<? extends ThrowableRunnable<?>> tasks, boolean checkAppDisposed) {
            Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
            if (tasks.isEmpty()) {
                return;
            }
            BuildersKt.runBlocking(Dispatchers.getIO().limitedParallelism(UnindexedFilesUpdater.getNumberOfIndexingThreads()).plus((CoroutineContext)new CoroutineName("Index Storage Lifecycle")), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(tasks, checkAppDisposed, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Collection<ThrowableRunnable<?>> $tasks;
                final /* synthetic */ boolean $checkAppDisposed;
                {
                    this.$tasks = $tasks;
                    this.$checkAppDisposed = $checkAppDisposed;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                            for (ThrowableRunnable<?> task2 : this.$tasks) {
                                BuildersKt.launch$default($this$runBlocking, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(task2, this.$checkAppDisposed, null){
                                    int label;
                                    final /* synthetic */ ThrowableRunnable<?> $task;
                                    final /* synthetic */ boolean $checkAppDisposed;
                                    {
                                        this.$task = $task;
                                        this.$checkAppDisposed = $checkAppDisposed;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                com.intellij.util.indexing.IndexDataInitializer$Companion.access$executeTask(IndexDataInitializer.Companion, this.$task, this.$checkAppDisposed);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, 3, null);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        private final void executeTask(ThrowableRunnable<?> callable, boolean checkAppDisposed) {
            Application app = ApplicationManager.getApplication();
            try {
                if (checkAppDisposed && app.isDisposed()) {
                    return;
                }
                callable.run();
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }

        public static final /* synthetic */ void access$executeTask(Companion $this, ThrowableRunnable callable, boolean checkAppDisposed) {
            $this.executeTask(callable, checkAppDisposed);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

