/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexVersion;
import com.intellij.util.indexing.StripedLock;
import com.intellij.util.io.DataInputOutputUtil;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class IndexingStamp {
    private static final boolean IS_UNIT_TEST = ApplicationManager.getApplication().isUnitTestMode();
    private static final long INDEX_DATA_OUTDATED_STAMP = -2L;
    private static final long HAS_NO_INDEXED_DATA_STAMP = 0L;
    private static final int INDEXING_STAMP_CACHE_CAPACITY = SystemProperties.getIntProperty("index.timestamp.cache.size", 100);
    private static final ConcurrentIntObjectMap<Timestamps> ourTimestampsCache = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
    private static final BlockingQueue<Integer> ourFinishedFiles = new ArrayBlockingQueue<Integer>(INDEXING_STAMP_CACHE_CAPACITY);
    private static final StripedLock ourLock = new StripedLock();

    private IndexingStamp() {
    }

    @NotNull
    public static FileIndexingState isFileIndexedStateCurrent(int fileId, @NotNull ID<?, ?> indexName) {
        long stamp;
        block8: {
            FileIndexingState fileIndexingState;
            if (indexName == null) {
                IndexingStamp.$$$reportNull$$$0(0);
            }
            try {
                stamp = IndexingStamp.getIndexStamp(fileId, indexName);
                if (stamp != 0L) break block8;
                fileIndexingState = FileIndexingState.NOT_INDEXED;
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof IOException)) {
                    throw e;
                }
                FileIndexingState fileIndexingState2 = FileIndexingState.OUT_DATED;
                if (fileIndexingState2 == null) {
                    IndexingStamp.$$$reportNull$$$0(3);
                }
                return fileIndexingState2;
            }
            if (fileIndexingState == null) {
                IndexingStamp.$$$reportNull$$$0(1);
            }
            return fileIndexingState;
        }
        FileIndexingState fileIndexingState = stamp == IndexVersion.getIndexCreationStamp(indexName) ? FileIndexingState.UP_TO_DATE : FileIndexingState.OUT_DATED;
        if (fileIndexingState == null) {
            IndexingStamp.$$$reportNull$$$0(2);
        }
        return fileIndexingState;
    }

    public static void setFileIndexedStateCurrent(int fileId, @NotNull ID<?, ?> id) {
        if (id == null) {
            IndexingStamp.$$$reportNull$$$0(4);
        }
        IndexingStamp.update(fileId, id, IndexVersion.getIndexCreationStamp(id));
    }

    public static void setFileIndexedStateOutdated(int fileId, @NotNull ID<?, ?> id) {
        if (id == null) {
            IndexingStamp.$$$reportNull$$$0(5);
        }
        IndexingStamp.update(fileId, id, -2L);
    }

    public static void setFileIndexedStateUnindexed(int fileId, @NotNull ID<?, ?> id) {
        if (id == null) {
            IndexingStamp.$$$reportNull$$$0(6);
        }
        IndexingStamp.update(fileId, id, 0L);
    }

    static void dropTimestampMemoryCaches() {
        IndexingStamp.flushCaches();
        ourTimestampsCache.clear();
    }

    public static long getIndexStamp(int fileId, ID<?, ?> indexName) {
        return ourLock.withReadLock(fileId, () -> {
            Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
            return stamp.get(indexName);
        });
    }

    @TestOnly
    public static void dropIndexingTimeStamps(int fileId) throws IOException {
        ourTimestampsCache.remove(fileId);
        try (AttributeOutputStream out = FSRecords.writeAttribute((int)fileId, (FileAttribute)Timestamps.PERSISTENCE);){
            new Timestamps(null).writeToStream(out);
        }
    }

    @NotNull
    private static Timestamps createOrGetTimeStamp(int id) {
        Timestamps timestamps = IndexingStamp.getTimestamp(id, true);
        if (timestamps == null) {
            IndexingStamp.$$$reportNull$$$0(7);
        }
        return timestamps;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Contract(value="_, true->!null")
    private static Timestamps getTimestamp(int id, boolean createIfNoneSaved) {
        assert (id > 0);
        Timestamps timestamps = (Timestamps)ourTimestampsCache.get(id);
        if (timestamps != null) return timestamps;
        try (AttributeInputStream stream = FSRecords.readAttributeWithLock((int)id, (FileAttribute)Timestamps.PERSISTENCE);){
            if (stream == null && !createIfNoneSaved) {
                Timestamps timestamps2 = null;
                return timestamps2;
            }
            timestamps = new Timestamps(stream);
        }
        catch (IOException e) {
            throw FSRecords.handleError((Throwable)e);
        }
        ourTimestampsCache.cacheOrGet(id, timestamps);
        return timestamps;
    }

    @TestOnly
    public static boolean hasIndexingTimeStamp(int fileId) {
        return IndexingStamp.getTimestamp(fileId, false) != null;
    }

    public static void update(int fileId, @NotNull ID<?, ?> indexName, long indexCreationStamp) {
        if (indexName == null) {
            IndexingStamp.$$$reportNull$$$0(8);
        }
        assert (fileId > 0);
        ourLock.withWriteLock(fileId, () -> {
            Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
            stamp.set(indexName, indexCreationStamp);
            return null;
        });
    }

    @NotNull
    public static List<ID<?, ?>> getNontrivialFileIndexedStates(int fileId) {
        List list2 = ourLock.withReadLock(fileId, () -> {
            try {
                Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
                if (stamp.myIndexStamps != null && !stamp.myIndexStamps.isEmpty()) {
                    return List.copyOf(stamp.myIndexStamps.keySet());
                }
            }
            catch (InvalidVirtualFileAccessException invalidVirtualFileAccessException) {
                // empty catch block
            }
            return Collections.emptyList();
        });
        if (list2 == null) {
            IndexingStamp.$$$reportNull$$$0(9);
        }
        return list2;
    }

    public static void flushCaches() {
        IndexingStamp.doFlush();
    }

    public static void flushCache(int finishedFile) {
        boolean exit = ourLock.withReadLock(finishedFile, () -> {
            Timestamps timestamps = (Timestamps)ourTimestampsCache.get(finishedFile);
            if (timestamps == null) {
                return true;
            }
            if (!timestamps.isDirty()) {
                ourTimestampsCache.remove(finishedFile);
                return true;
            }
            return false;
        });
        if (exit) {
            return;
        }
        while (!ourFinishedFiles.offer(finishedFile)) {
            IndexingStamp.doFlush();
        }
    }

    @TestOnly
    public static int @NotNull [] dumpCachedUnfinishedFiles() {
        int[] nArray = ourLock.withAllLocksWriteLocked(() -> {
            int[] cachedKeys = ourTimestampsCache.entrySet().stream().filter(e -> ((Timestamps)e.getValue()).isDirty()).mapToInt(e -> e.getKey()).toArray();
            if (cachedKeys.length == 0) {
                return ArrayUtil.EMPTY_INT_ARRAY;
            }
            IntArraySet cachedIds = new IntArraySet(cachedKeys);
            HashSet<Integer> finishedIds = new HashSet<Integer>(ourFinishedFiles);
            cachedIds.removeAll(finishedIds);
            return cachedIds.toIntArray();
        });
        if (nArray == null) {
            IndexingStamp.$$$reportNull$$$0(10);
        }
        return nArray;
    }

    private static void doFlush() {
        ArrayList files2 = new ArrayList(ourFinishedFiles.size());
        ourFinishedFiles.drainTo(files2);
        if (!files2.isEmpty()) {
            for (Integer file2 : files2) {
                RuntimeException exception = ourLock.withWriteLock(file2, () -> {
                    try {
                        Timestamps timestamp = (Timestamps)ourTimestampsCache.remove(file2);
                        if (timestamp == null) {
                            return null;
                        }
                        if (timestamp.isDirty()) {
                            try (AttributeOutputStream sink = FSRecords.writeAttribute((int)file2, (FileAttribute)Timestamps.PERSISTENCE);){
                                timestamp.writeToStream(sink);
                            }
                        }
                        return null;
                    }
                    catch (IOException e) {
                        return new RuntimeException(e);
                    }
                });
                if (exception == null) continue;
                throw exception;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexingStamp";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexingStamp";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "isFileIndexedStateCurrent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrGetTimeStamp";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNontrivialFileIndexedStates";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpCachedUnfinishedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFileIndexedStateCurrent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFileIndexedStateCurrent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFileIndexedStateOutdated";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFileIndexedStateUnindexed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 7, 9, 10 -> new IllegalStateException(string2);
        };
    }

    private static final class Timestamps {
        private static final FileAttribute PERSISTENCE = new FileAttribute("__index_stamps__", 2, false);
        private Object2LongMap<ID<?, ?>> myIndexStamps;
        private boolean myIsDirty = false;

        private Timestamps(@Nullable DataInputStream stream) throws IOException {
            if (stream != null) {
                int[] outdatedIndices = null;
                long dominatingIndexStamp = DataInputOutputUtil.readTIME(stream);
                long diff = dominatingIndexStamp - 1040688000000L;
                if (diff > 0L && diff < 32767L) {
                    int numberOfOutdatedIndices = (int)diff;
                    outdatedIndices = new int[numberOfOutdatedIndices];
                    while (numberOfOutdatedIndices > 0) {
                        outdatedIndices[--numberOfOutdatedIndices] = DataInputOutputUtil.readINT(stream);
                    }
                    dominatingIndexStamp = DataInputOutputUtil.readTIME(stream);
                }
                while (stream.available() > 0) {
                    long stamp;
                    ID<?, ?> id = ID.findById(DataInputOutputUtil.readINT(stream));
                    if (id == null || id instanceof StubIndexKey || (stamp = IndexVersion.getIndexCreationStamp(id)) == 0L) continue;
                    if (this.myIndexStamps == null) {
                        this.myIndexStamps = new Object2LongOpenHashMap(5, 0.98f);
                    }
                    if (stamp > dominatingIndexStamp) continue;
                    this.myIndexStamps.put(id, stamp);
                }
                if (outdatedIndices != null) {
                    for (int outdatedIndexId : outdatedIndices) {
                        ID<?, ?> id = ID.findById(outdatedIndexId);
                        if (id == null || id instanceof StubIndexKey || IndexVersion.getIndexCreationStamp(id) == 0L) continue;
                        long stamp = -2L;
                        if (this.myIndexStamps == null) {
                            this.myIndexStamps = new Object2LongOpenHashMap(5, 0.98f);
                        }
                        if (stamp > dominatingIndexStamp) continue;
                        this.myIndexStamps.put(id, stamp);
                    }
                }
            }
        }

        private void writeToStream(DataOutputStream stream) throws IOException {
            if (this.myIndexStamps == null || this.myIndexStamps.isEmpty()) {
                DataInputOutputUtil.writeTIME(stream, 1040688000000L);
                return;
            }
            long[] data2 = new long[2];
            boolean dominatingStampIndex = false;
            boolean numberOfOutdatedIndex = true;
            ObjectSet<Object2LongMap.Entry<ID<?, ?>>> entries2 = this.myIndexStamps.object2LongEntrySet();
            for (Object2LongMap.Entry entry : entries2) {
                long b = entry.getLongValue();
                if (b == -2L) {
                    data2[1] = data2[1] + 1L;
                    b = IndexVersion.getIndexCreationStamp((ID)entry.getKey());
                }
                data2[0] = Math.max(data2[0], b);
                if (!IS_UNIT_TEST || b != 0L) continue;
                FileBasedIndexImpl.LOG.info("Wrong indexing timestamp state: " + this.myIndexStamps);
            }
            if (data2[1] > 0L) {
                assert (data2[1] < 32767L);
                DataInputOutputUtil.writeTIME(stream, 1040688000000L + data2[1]);
                for (Object2LongMap.Entry entry : entries2) {
                    if (entry.getLongValue() != -2L) continue;
                    DataInputOutputUtil.writeINT(stream, ((ID)entry.getKey()).getUniqueId());
                }
            }
            DataInputOutputUtil.writeTIME(stream, data2[0]);
            for (Object2LongMap.Entry entry : entries2) {
                if (entry.getLongValue() == -2L) continue;
                DataInputOutputUtil.writeINT(stream, ((ID)entry.getKey()).getUniqueId());
            }
        }

        private long get(ID<?, ?> id) {
            return this.myIndexStamps != null ? this.myIndexStamps.getLong(id) : 0L;
        }

        private void set(ID<?, ?> id, long tmst) {
            long previous;
            if (this.myIndexStamps == null) {
                this.myIndexStamps = new Object2LongOpenHashMap(5, 0.98f);
            }
            if (tmst == -2L && !this.myIndexStamps.containsKey(id)) {
                return;
            }
            long l = previous = tmst == 0L ? this.myIndexStamps.removeLong(id) : this.myIndexStamps.put(id, tmst);
            if (previous != tmst) {
                this.myIsDirty = true;
            }
        }

        public boolean isDirty() {
            return this.myIsDirty;
        }
    }
}

