/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.PerProjectIndexingQueue;
import com.intellij.util.indexing.PerProviderSinkFactory;
import com.intellij.util.indexing.UnindexedFilesIndexer;
import com.intellij.util.indexing.UnindexedFilesScanner;
import com.intellij.util.indexing.UnindexedFilesScannerExecutor;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0004,-./B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0014J\u0006\u0010\u0019\u001a\u00020\u0014J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J.\u0010#\u001a(\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b\u0012\u0004\u0012\u00020%\u0012\u0006\u0012\u0004\u0018\u00010\u00100$H\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\tJ\u0006\u0010)\u001a\u00020\u0014J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020%H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/util/indexing/PerProjectIndexingQueue;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cntFilesSoFar", "Ljava/util/concurrent/atomic/AtomicInteger;", "filesSoFar", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "scanningLatch", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/CountDownLatch;", "sinkFactory", "Lcom/intellij/util/indexing/PerProviderSinkFactory;", "addFiles", "", "iterator", "files", "", "cancelAllTasksAndWait", "clear", "dispose", "flushNow", "reason", "", "flushNowSync", "projectIndexingHistory", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getAndResetQueuedFiles", "Lkotlin/Triple;", "", "getSink", "Lcom/intellij/util/indexing/PerProjectIndexingQueue$PerProviderSink;", "provider", "resumeQueue", "startOrStopDumbModeIfManyOrFewFilesAreDirty", "cntUncommittedDirty", "Companion", "DumbModeWhileScanning", "PerProviderSink", "TestCompanion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nPerProjectIndexingQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerProjectIndexingQueue.kt\ncom/intellij/util/indexing/PerProjectIndexingQueue\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,310:1\n10#2:311\n*S KotlinDebug\n*F\n+ 1 PerProjectIndexingQueue.kt\ncom/intellij/util/indexing/PerProjectIndexingQueue\n*L\n277#1:311\n*E\n"})
public final class PerProjectIndexingQueue
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PerProviderSinkFactory sinkFactory;
    @NotNull
    private final AtomicReference<CountDownLatch> scanningLatch;
    @NotNull
    private final AtomicInteger cntFilesSoFar;
    @NotNull
    private ConcurrentMap<IndexableFilesIterator, Collection<VirtualFile>> filesSoFar;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Lazy<Integer> DUMB_MODE_THRESHOLD$delegate;

    public PerProjectIndexingQueue(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.sinkFactory = new PerProviderSinkFactory(new PerProviderSinkFactory.UncommittedFilesListener(this){
            private final boolean shouldScanInSmartMode;
            final /* synthetic */ PerProjectIndexingQueue this$0;
            {
                this.this$0 = $receiver;
                this.shouldScanInSmartMode = UnindexedFilesScanner.shouldScanInSmartMode();
            }

            public void onUncommittedCountChanged(int cntDirty) {
                if (this.shouldScanInSmartMode) {
                    PerProjectIndexingQueue.access$startOrStopDumbModeIfManyOrFewFilesAreDirty(this.this$0, cntDirty);
                }
            }

            public void commit(@NotNull IndexableFilesIterator iterator2, @NotNull List<? extends VirtualFile> files2) {
                Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
                Intrinsics.checkNotNullParameter(files2, (String)"files");
                PerProjectIndexingQueue.access$addFiles(this.this$0, iterator2, files2);
            }
        });
        this.scanningLatch = new AtomicReference();
        this.cntFilesSoFar = new AtomicInteger();
        this.filesSoFar = new ConcurrentHashMap();
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    public void dispose() {
        block0: {
            CountDownLatch countDownLatch = this.scanningLatch.get();
            if (countDownLatch == null) break block0;
            countDownLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addFiles(IndexableFilesIterator iterator2, List<? extends VirtualFile> files2) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            this.filesSoFar.compute(iterator2, (arg_0, arg_1) -> PerProjectIndexingQueue.addFiles$lambda$1$lambda$0((Function2)new Function2<IndexableFilesIterator, Collection<? extends VirtualFile>, Collection<? extends VirtualFile>>(files2){
                final /* synthetic */ List<VirtualFile> $files;
                {
                    this.$files = $files;
                    super(2);
                }

                @Nullable
                public final Collection<VirtualFile> invoke(IndexableFilesIterator indexableFilesIterator, @Nullable Collection<? extends VirtualFile> old) {
                    Collection<? extends VirtualFile> collection = old;
                    return collection == null ? (Collection)new ArrayList<E>(this.$files) : (Collection)CollectionsKt.plus(collection, (Iterable)this.$files);
                }
            }, arg_0, arg_1));
            int n = this.cntFilesSoFar.addAndGet(files2.size());
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startOrStopDumbModeIfManyOrFewFilesAreDirty(int cntUncommittedDirty) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            if (cntUncommittedDirty + this.cntFilesSoFar.get() >= PerProjectIndexingQueue.Companion.getDUMB_MODE_THRESHOLD()) {
                if (this.scanningLatch.get() != null) {
                    return;
                }
                CountDownLatch latch = new CountDownLatch(1);
                if (this.scanningLatch.compareAndSet(null, latch)) {
                    new DumbModeWhileScanning(latch, this.scanningLatch, this.project).queue(this.project);
                }
            } else {
                CountDownLatch latch = this.scanningLatch.get();
                if (latch != null && this.scanningLatch.compareAndSet(latch, null)) {
                    latch.countDown();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushNow(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Triple<ConcurrentMap<IndexableFilesIterator, Collection<VirtualFile>>, Integer, CountDownLatch> triple = this.getAndResetQueuedFiles();
        ConcurrentMap filesInQueue = (ConcurrentMap)triple.component1();
        int totalFiles = ((Number)triple.component2()).intValue();
        CountDownLatch currentLatch = (CountDownLatch)triple.component3();
        try {
            if (totalFiles > 0) {
                new UnindexedFilesIndexer(this.project, filesInQueue, reason).queue(this.project);
            } else {
                LOG.info("Finished for " + this.project.getName() + ". No files to index with loading content.");
            }
        }
        finally {
            CountDownLatch countDownLatch = currentLatch;
            if (countDownLatch != null) {
                countDownLatch.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushNowSync(@NotNull ProjectIndexingHistoryImpl projectIndexingHistory, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Triple<ConcurrentMap<IndexableFilesIterator, Collection<VirtualFile>>, Integer, CountDownLatch> triple = this.getAndResetQueuedFiles();
        ConcurrentMap filesInQueue = (ConcurrentMap)triple.component1();
        int totalFiles = ((Number)triple.component2()).intValue();
        CountDownLatch currentLatch = (CountDownLatch)triple.component3();
        try {
            if (totalFiles > 0) {
                Object object = projectIndexingHistory.getIndexingReason();
                if (object == null) {
                    object = "Flushing queue of project " + this.project.getName();
                }
                String indexingReason = object;
                new UnindexedFilesIndexer(this.project, filesInQueue, indexingReason).indexFiles(projectIndexingHistory, indicator);
            } else {
                LOG.info("Finished for " + this.project.getName() + ". No files to index with loading content.");
            }
        }
        finally {
            CountDownLatch countDownLatch = currentLatch;
            if (countDownLatch != null) {
                countDownLatch.countDown();
            }
        }
    }

    public final void clear() {
        block0: {
            CountDownLatch currentLatch;
            CountDownLatch countDownLatch = currentLatch = (CountDownLatch)this.getAndResetQueuedFiles().component3();
            if (countDownLatch == null) break block0;
            countDownLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Triple<ConcurrentMap<IndexableFilesIterator, Collection<VirtualFile>>, Integer, CountDownLatch> getAndResetQueuedFiles() {
        Triple triple;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            ConcurrentMap<IndexableFilesIterator, Collection<VirtualFile>> filesInQueue = this.filesSoFar;
            this.filesSoFar = new ConcurrentHashMap();
            int totalFiles = this.cntFilesSoFar.getAndSet(0);
            CountDownLatch currentLatch = this.scanningLatch.getAndSet(null);
            triple = new Triple(filesInQueue, (Object)totalFiles, (Object)currentLatch);
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return triple;
    }

    @NotNull
    public final PerProviderSink getSink(@NotNull IndexableFilesIterator provider2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        return this.sinkFactory.newSink(provider2);
    }

    public final void cancelAllTasksAndWait() {
        this.sinkFactory.cancelAllProducersAndWait();
    }

    public final void resumeQueue() {
        this.sinkFactory.resumeProducers();
    }

    private static final Collection addFiles$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Collection)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$startOrStopDumbModeIfManyOrFewFilesAreDirty(PerProjectIndexingQueue $this, int cntUncommittedDirty) {
        $this.startOrStopDumbModeIfManyOrFewFilesAreDirty(cntUncommittedDirty);
    }

    public static final /* synthetic */ void access$addFiles(PerProjectIndexingQueue $this, IndexableFilesIterator iterator2, List files2) {
        $this.addFiles(iterator2, files2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PerProjectIndexingQueue.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
        DUMB_MODE_THRESHOLD$delegate = LazyKt.lazy((Function0)Companion.DUMB_MODE_THRESHOLD.2.INSTANCE);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/util/indexing/PerProjectIndexingQueue$Companion;", "", "()V", "DUMB_MODE_THRESHOLD", "", "getDUMB_MODE_THRESHOLD", "()I", "DUMB_MODE_THRESHOLD$delegate", "Lkotlin/Lazy;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final int getDUMB_MODE_THRESHOLD() {
            Lazy lazy = DUMB_MODE_THRESHOLD$delegate;
            return ((Number)lazy.getValue()).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/util/indexing/PerProjectIndexingQueue$DumbModeWhileScanning;", "Lcom/intellij/openapi/project/DumbModeTask;", "latch", "Ljava/util/concurrent/CountDownLatch;", "latchRef", "Ljava/util/concurrent/atomic/AtomicReference;", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/util/concurrent/CountDownLatch;Ljava/util/concurrent/atomic/AtomicReference;Lcom/intellij/openapi/project/Project;)V", "dispose", "", "performInDumbMode", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nPerProjectIndexingQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerProjectIndexingQueue.kt\ncom/intellij/util/indexing/PerProjectIndexingQueue$DumbModeWhileScanning\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,310:1\n29#2,3:311\n*S KotlinDebug\n*F\n+ 1 PerProjectIndexingQueue.kt\ncom/intellij/util/indexing/PerProjectIndexingQueue$DumbModeWhileScanning\n*L\n293#1:311,3\n*E\n"})
    private static final class DumbModeWhileScanning
    extends DumbModeTask {
        @NotNull
        private final CountDownLatch latch;
        @NotNull
        private final AtomicReference<CountDownLatch> latchRef;
        @NotNull
        private final Project project;

        public DumbModeWhileScanning(@NotNull CountDownLatch latch, @NotNull AtomicReference<CountDownLatch> latchRef, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)latch, (String)"latch");
            Intrinsics.checkNotNullParameter(latchRef, (String)"latchRef");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.latch = latch;
            this.latchRef = latchRef;
            this.project = project2;
        }

        @Override
        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            indicator.setIndeterminate(true);
            indicator.setText(IndexingBundle.message((String)"progress.indexing.waiting.for.scanning.to.complete", (Object[])new Object[0]));
            ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)this.latch);
            ProgressIndicatorUtils.awaitWithCheckCanceled(() -> DumbModeWhileScanning.performInDumbMode$lambda$0(this));
        }

        @Override
        public void dispose() {
            this.latchRef.compareAndSet(this.latch, null);
        }

        private static final Boolean performInDumbMode$lambda$0(DumbModeWhileScanning this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            LockSupport.parkNanos(50000000L);
            ComponentManager $this$service$iv = this$0.project;
            boolean $i$f$service = false;
            Class<UnindexedFilesScannerExecutor> serviceClass$iv = UnindexedFilesScannerExecutor.class;
            UnindexedFilesScannerExecutor unindexedFilesScannerExecutor = $this$service$iv.getService(serviceClass$iv);
            if (unindexedFilesScannerExecutor == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return !unindexedFilesScannerExecutor.isRunning();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&J\b\u0010\u0007\u001a\u00020\u0003H&J\b\u0010\b\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/indexing/PerProjectIndexingQueue$PerProviderSink;", "Ljava/lang/AutoCloseable;", "addFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "clear", "close", "commit", "intellij.platform.lang.impl"})
    public static interface PerProviderSink
    extends AutoCloseable {
        public void addFile(@NotNull VirtualFile var1);

        public void clear();

        public void commit();

        @Override
        public void close();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a(\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/util/indexing/PerProjectIndexingQueue$TestCompanion;", "", "q", "Lcom/intellij/util/indexing/PerProjectIndexingQueue;", "(Lcom/intellij/util/indexing/PerProjectIndexingQueue;)V", "getAndResetQueuedFiles", "Lkotlin/Triple;", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Ljava/util/concurrent/CountDownLatch;", "intellij.platform.lang.impl"})
    @TestOnly
    public static final class TestCompanion {
        @NotNull
        private final PerProjectIndexingQueue q;

        public TestCompanion(@NotNull PerProjectIndexingQueue q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            this.q = q;
        }

        @NotNull
        public final Triple<ConcurrentMap<IndexableFilesIterator, Collection<VirtualFile>>, Integer, CountDownLatch> getAndResetQueuedFiles() {
            return this.q.getAndResetQueuedFiles();
        }
    }
}

