/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.PerProjectIndexingQueue;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0003\u0011\u0012\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/indexing/PerProviderSinkFactory;", "", "uncommittedListener", "Lcom/intellij/util/indexing/PerProviderSinkFactory$UncommittedFilesListener;", "(Lcom/intellij/util/indexing/PerProviderSinkFactory$UncommittedFilesListener;)V", "activeSinksCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "cancelActiveSinks", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cntFilesDirty", "cancelAllProducersAndWait", "", "newSink", "Lcom/intellij/util/indexing/PerProjectIndexingQueue$PerProviderSink;", "provider", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "resumeProducers", "Companion", "PerProviderSinkImpl", "UncommittedFilesListener", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nPerProjectIndexingQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerProjectIndexingQueue.kt\ncom/intellij/util/indexing/PerProviderSinkFactory\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,310:1\n10#2:311\n*S KotlinDebug\n*F\n+ 1 PerProjectIndexingQueue.kt\ncom/intellij/util/indexing/PerProviderSinkFactory\n*L\n118#1:311\n*E\n"})
final class PerProviderSinkFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UncommittedFilesListener uncommittedListener;
    @NotNull
    private final AtomicInteger activeSinksCount;
    @NotNull
    private final AtomicBoolean cancelActiveSinks;
    @NotNull
    private final AtomicInteger cntFilesDirty;
    @NotNull
    private static final Logger LOG;

    public PerProviderSinkFactory(@NotNull UncommittedFilesListener uncommittedListener) {
        Intrinsics.checkNotNullParameter((Object)uncommittedListener, (String)"uncommittedListener");
        this.uncommittedListener = uncommittedListener;
        this.activeSinksCount = new AtomicInteger();
        this.cancelActiveSinks = new AtomicBoolean();
        this.cntFilesDirty = new AtomicInteger();
    }

    @NotNull
    public final PerProjectIndexingQueue.PerProviderSink newSink(@NotNull IndexableFilesIterator provider2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        if (this.cancelActiveSinks.get()) {
            ProgressIndicator progressIndicator = ProgressManager.getGlobalProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.cancel();
            }
            ProgressManager.checkCanceled();
        }
        return new PerProviderSinkImpl(provider2);
    }

    public final void cancelAllProducersAndWait() {
        this.cancelActiveSinks.set(true);
        ProgressIndicatorUtils.awaitWithCheckCanceled(() -> PerProviderSinkFactory.cancelAllProducersAndWait$lambda$0(this));
        LOG.assertTrue(this.cntFilesDirty.get() == 0, "Should contain no dirty files. But got: " + this.cntFilesDirty.get());
    }

    public final void resumeProducers() {
        this.cancelActiveSinks.set(false);
    }

    private static final Boolean cancelAllProducersAndWait$lambda$0(PerProviderSinkFactory this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PingProgress.interactWithEdtProgress();
        LockSupport.parkNanos(50000000L);
        return this$0.activeSinksCount.get() == 0;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PerProviderSinkFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/indexing/PerProviderSinkFactory$UncommittedFilesListener;", "", "commit", "", "iterator", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "onUncommittedCountChanged", "cntDirty", "", "intellij.platform.lang.impl"})
    public static interface UncommittedFilesListener {
        public void onUncommittedCountChanged(int var1);

        public void commit(@NotNull IndexableFilesIterator var1, @NotNull List<? extends VirtualFile> var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/util/indexing/PerProviderSinkFactory$PerProviderSinkImpl;", "Lcom/intellij/util/indexing/PerProjectIndexingQueue$PerProviderSink;", "iterator", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "(Lcom/intellij/util/indexing/PerProviderSinkFactory;Lcom/intellij/util/indexing/roots/IndexableFilesIterator;)V", "closed", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "addFile", "", "file", "clear", "close", "commit", "intellij.platform.lang.impl"})
    public final class PerProviderSinkImpl
    implements PerProjectIndexingQueue.PerProviderSink {
        @NotNull
        private final IndexableFilesIterator iterator;
        @NotNull
        private final List<VirtualFile> files;
        private boolean closed;

        public PerProviderSinkImpl(IndexableFilesIterator iterator2) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            this.iterator = iterator2;
            this.files = new ArrayList();
            PerProviderSinkFactory.this.activeSinksCount.incrementAndGet();
        }

        @Override
        public void addFile(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            LOG.assertTrue(!this.closed, "Should not invoke 'addFile' after 'close'");
            if (PerProviderSinkFactory.this.cancelActiveSinks.get()) {
                ProgressIndicator progressIndicator = ProgressManager.getGlobalProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.cancel();
                }
                ProgressManager.checkCanceled();
            }
            this.files.add(file2);
            int cntDirty = PerProviderSinkFactory.this.cntFilesDirty.incrementAndGet();
            PerProviderSinkFactory.this.uncommittedListener.onUncommittedCountChanged(cntDirty);
        }

        @Override
        public void clear() {
            LOG.assertTrue(!this.closed, "Should not invoke 'clear' after 'close'");
            if (!((Collection)this.files).isEmpty()) {
                int cntDirty = PerProviderSinkFactory.this.cntFilesDirty.addAndGet(-this.files.size());
                LOG.assertTrue(cntDirty >= 0, "cntFilesDirty should be positive or 0: " + cntDirty);
                this.files.clear();
                PerProviderSinkFactory.this.uncommittedListener.onUncommittedCountChanged(cntDirty);
            }
        }

        @Override
        public void commit() {
            LOG.assertTrue(!this.closed, "Should not invoke 'commit' after 'close'");
            if (!((Collection)this.files).isEmpty()) {
                int cntDirty = PerProviderSinkFactory.this.cntFilesDirty.addAndGet(-this.files.size());
                LOG.assertTrue(cntDirty >= 0, "cntFilesDirty should be positive or 0: " + cntDirty);
                PerProviderSinkFactory.this.uncommittedListener.commit(this.iterator, this.files);
                this.files.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                this.clear();
            }
            finally {
                this.closed = true;
                PerProviderSinkFactory.this.activeSinksCount.decrementAndGet();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/indexing/PerProviderSinkFactory$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

