/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ApplicationKt;
import com.intellij.util.indexing.StaleIndexesChecker;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.PathKt;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/indexing/PersistentDirtyFilesQueue;", "", "()V", "dirtyFilesQueueFile", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "isUnittestMode", "", "()Z", "readIndexingQueue", "Lit/unimi/dsi/fastutil/ints/IntList;", "currentVfsVersion", "", "removeCurrentFile", "", "storeIndexingQueue", "fileIds", "Lit/unimi/dsi/fastutil/ints/IntCollection;", "vfsVersion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nPersistentDirtyFilesQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentDirtyFilesQueue.kt\ncom/intellij/util/indexing/PersistentDirtyFilesQueue\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,89:1\n8#2:90\n8#2:91\n8#2:92\n8#2:95\n8#2:102\n1855#3,2:93\n1549#3:96\n1620#3,3:97\n37#4,2:100\n*S KotlinDebug\n*F\n+ 1 PersistentDirtyFilesQueue.kt\ncom/intellij/util/indexing/PersistentDirtyFilesQueue\n*L\n34#1:90\n60#1:91\n63#1:92\n82#1:95\n86#1:102\n76#1:93,2\n85#1:96\n85#1:97,3\n85#1:100,2\n*E\n"})
public final class PersistentDirtyFilesQueue {
    @NotNull
    private final Path dirtyFilesQueueFile;

    @TestOnly
    public PersistentDirtyFilesQueue(@NotNull Path dirtyFilesQueueFile) {
        Intrinsics.checkNotNullParameter((Object)dirtyFilesQueueFile, (String)"dirtyFilesQueueFile");
        this.dirtyFilesQueueFile = dirtyFilesQueueFile;
    }

    private final boolean isUnittestMode() {
        return ApplicationKt.getApplication().isUnitTestMode();
    }

    public PersistentDirtyFilesQueue() {
        Path path2 = PathManager.getIndexRoot();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getIndexRoot()");
        Path path3 = path2;
        Path path4 = path3.resolve("dirty-file-ids");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"this.resolve(other)");
        this(path4);
    }

    public final void removeCurrentFile() {
        if (this.isUnittestMode()) {
            PersistentDirtyFilesQueue $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PersistentDirtyFilesQueue.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.info("removing " + ((Object)this.dirtyFilesQueueFile.toAbsolutePath()).toString());
        }
        try {
            Files.deleteIfExists(this.dirtyFilesQueueFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final IntList readIndexingQueue(long currentVfsVersion) {
        IntArrayList result2 = new IntArrayList();
        try {
            Closeable closeable = PathKt.inputStream(this.dirtyFilesQueueFile);
            int n = 8192;
            closeable = new DataInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
            Throwable throwable = null;
            try {
                DataInputStream it = (DataInputStream)closeable;
                boolean bl = false;
                long storedVfsVersion = it.readLong();
                if (storedVfsVersion == currentVfsVersion) {
                    while (it.available() > -1) {
                        result2.add(it.readInt());
                    }
                }
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (EOFException eOFException) {
        }
        catch (IOException e) {
            PersistentDirtyFilesQueue $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PersistentDirtyFilesQueue.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.info(e);
        }
        if (this.isUnittestMode()) {
            PersistentDirtyFilesQueue $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PersistentDirtyFilesQueue.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            String string2 = Arrays.toString(result2.toIntArray());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
            logger.info("read dirty file ids: " + string2);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void storeIndexingQueue(@NotNull IntCollection fileIds, long vfsVersion) {
        Pair[] $this$thisLogger$iv;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)fileIds, (String)"fileIds");
        try {
            if (fileIds.isEmpty()) {
                Files.deleteIfExists(this.dirtyFilesQueueFile);
            }
            Path path2 = this.dirtyFilesQueueFile.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"dirtyFilesQueueFile.parent");
            PathKt.createDirectories(path2);
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(this.dirtyFilesQueueFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(this, *options)");
            Closeable closeable = outputStream;
            int n = 8192;
            closeable = new DataOutputStream(closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n));
            Throwable throwable = null;
            try {
                DataOutputStream it = (DataOutputStream)closeable;
                boolean bl = false;
                it.writeLong(vfsVersion);
                $this$forEach$iv = fileIds;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Integer fileId = (Integer)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)fileId, (String)"fileId");
                    it.writeInt(fileId);
                }
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PersistentDirtyFilesQueue.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.error(e);
        }
        if (this.isUnittestMode()) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = fileIds;
            boolean $i$f$map = false;
            $this$forEach$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Integer bl2 = (Integer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(TuplesKt.to((Object)it, (Object)StaleIndexesChecker.getStaleRecordOrExceptionMessage(it.intValue())));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            $this$thisLogger$iv = thisCollection$iv.toArray(new Pair[0]);
            Map idsToPaths = MapsKt.mapOf((Pair[])Arrays.copyOf($this$thisLogger$iv, $this$thisLogger$iv.length));
            $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PersistentDirtyFilesQueue.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.info("dirty file ids stored. Ids & filenames: " + StringsKt.take((String)idsToPaths.toString(), (int)300));
        }
    }
}

