/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl;
import com.intellij.util.indexing.diagnostic.ScanningStatistics;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

class ProjectChangedFilesScanner {
    private static final Logger LOG = Logger.getInstance(ProjectChangedFilesScanner.class);
    @NotNull
    private final Project myProject;

    ProjectChangedFilesScanner(@NotNull Project project2) {
        if (project2 == null) {
            ProjectChangedFilesScanner.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<VirtualFile> scan(ProjectIndexingHistoryImpl projectIndexingHistory, String fileSetName) {
        long refreshedFilesCalcDuration = System.nanoTime();
        Collection<Object> files2 = Collections.emptyList();
        try {
            FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
            Collection<Object> collection = files2 = fileBasedIndex.getFilesToUpdate(this.myProject);
            return collection;
        }
        finally {
            refreshedFilesCalcDuration = System.nanoTime() - refreshedFilesCalcDuration;
            ScanningStatistics scanningStatistics = new ScanningStatistics(fileSetName);
            scanningStatistics.setNumberOfScannedFiles(files2.size());
            scanningStatistics.setNumberOfFilesForIndexing(files2.size());
            scanningStatistics.setScanningTime(refreshedFilesCalcDuration);
            scanningStatistics.setNoRootsForRefresh();
            projectIndexingHistory.addScanningStatistics(scanningStatistics);
            projectIndexingHistory.setScanFilesDuration(Duration.ofNanos(refreshedFilesCalcDuration));
            LOG.info("Scanning refreshed files of " + this.myProject.getName() + " : " + files2.size() + " to update, calculated in " + TimeUnit.NANOSECONDS.toMillis(refreshedFilesCalcDuration) + "ms");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/ProjectChangedFilesScanner", "<init>"));
    }
}

