/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.StorageException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public enum RebuildStatus {
    OK,
    REQUIRES_REBUILD,
    DOING_REBUILD;

    private static final Map<ID<?, ?>, AtomicReference<RebuildStatus>> ourRebuildStatus;

    public static void registerIndex(ID<?, ?> indexId) {
        ourRebuildStatus.put(indexId, new AtomicReference<RebuildStatus>(OK));
    }

    static boolean isOk(ID<?, ?> indexId) {
        AtomicReference<RebuildStatus> rebuildStatus = ourRebuildStatus.get(indexId);
        return rebuildStatus != null && rebuildStatus.get() == OK;
    }

    static boolean requestRebuild(ID<?, ?> indexId) {
        return ourRebuildStatus.get(indexId).compareAndSet(OK, REQUIRES_REBUILD);
    }

    static void clearIndexIfNecessary(ID<?, ?> indexId, ThrowableRunnable<StorageException> clearAction) throws StorageException {
        AtomicReference<RebuildStatus> rebuildStatus = ourRebuildStatus.get(indexId);
        if (rebuildStatus == null) {
            throw new StorageException("Problem updating " + indexId);
        }
        while (rebuildStatus.get() != OK) {
            if (rebuildStatus.compareAndSet(REQUIRES_REBUILD, DOING_REBUILD)) {
                try {
                    clearAction.run();
                    if (!rebuildStatus.compareAndSet(DOING_REBUILD, OK)) {
                        throw new AssertionError((Object)("Unexpected status " + (Object)((Object)rebuildStatus.get())));
                    }
                    continue;
                }
                catch (Throwable e) {
                    rebuildStatus.compareAndSet(DOING_REBUILD, REQUIRES_REBUILD);
                    throw e;
                }
            }
            ProgressManager.checkCanceled();
            TimeoutUtil.sleep(50L);
        }
    }

    static boolean isOk() {
        return ourRebuildStatus.values().stream().map(ref -> (RebuildStatus)((Object)((Object)ref.get()))).noneMatch(status -> status != OK);
    }

    static void reset() {
        ourRebuildStatus.clear();
    }

    @Nullable
    public static RebuildStatus getStatus(ID<?, ?> indexId) {
        AtomicReference<RebuildStatus> reference2 = ourRebuildStatus.get(indexId);
        return reference2 == null ? null : reference2.get();
    }

    static {
        ourRebuildStatus = new HashMap();
    }
}

