/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.actions.SynchronizeCurrentFileAction;
import com.intellij.ide.actions.cache.CacheInconsistencyProblem;
import com.intellij.ide.actions.cache.FilesRecoveryScope;
import com.intellij.ide.actions.cache.RecoveryAction;
import com.intellij.ide.actions.cache.RecoveryScope;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR%\u0010\u000b\u001a\u00130\u0004\u00a2\u0006\u000e\b\f\u0012\n\b\r\u0012\u0006\b\n0\u000e8\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/RefreshIndexableFilesAction;", "Lcom/intellij/ide/actions/cache/RecoveryAction;", "()V", "actionKey", "", "getActionKey", "()Ljava/lang/String;", "performanceRate", "", "getPerformanceRate", "()I", "presentableName", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "getPresentableName", "performSync", "", "Lcom/intellij/ide/actions/cache/CacheInconsistencyProblem;", "recoveryScope", "Lcom/intellij/ide/actions/cache/RecoveryScope;", "Event", "EventLog", "intellij.platform.lang.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRefreshIndexableFilesAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshIndexableFilesAction.kt\ncom/intellij/util/indexing/RefreshIndexableFilesAction\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 extensions.kt\ncom/intellij/openapi/util/ExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n37#2,2:92\n22#3,2:94\n26#3,2:115\n1360#4:96\n1446#4,5:97\n1603#4,9:102\n1855#4:111\n1856#4:113\n1612#4:114\n766#4:117\n857#4,2:118\n1549#4:120\n1620#4,3:121\n1#5:112\n*S KotlinDebug\n*F\n+ 1 RefreshIndexableFilesAction.kt\ncom/intellij/util/indexing/RefreshIndexableFilesAction\n*L\n36#1:92,2\n40#1:94,2\n40#1:115,2\n47#1:96\n47#1:97,5\n48#1:102,9\n48#1:111\n48#1:113\n48#1:114\n53#1:117\n53#1:118,2\n54#1:120\n54#1:121,3\n48#1:112\n*E\n"})
public final class RefreshIndexableFilesAction
implements RecoveryAction {
    public int getPerformanceRate() {
        return 9999;
    }

    @NotNull
    public String getPresentableName() {
        String string2 = LangBundle.message("refresh.indexable.files.recovery.action.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"refresh.indexab\u2026es.recovery.action.name\")");
        return string2;
    }

    @NotNull
    public String getActionKey() {
        return "refresh";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<CacheInconsistencyProblem> performSync(@NotNull RecoveryScope recoveryScope) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Disposable actionDisposable;
        VirtualFile[] virtualFileArray;
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        Project project2 = recoveryScope.getProject();
        if (recoveryScope instanceof FilesRecoveryScope) {
            Collection $this$toTypedArray$iv = ((FilesRecoveryScope)recoveryScope).getFiles();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        } else {
            VirtualFile[] virtualFileArray2 = ManagingFS.getInstance().getLocalRoots();
            virtualFileArray = virtualFileArray2;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getInstance().localRoots");
        }
        VirtualFile[] rootsToRefresh = virtualFileArray;
        RefreshQueue.getInstance().refresh(false, true, null, Arrays.copyOf(rootsToRefresh, rootsToRefresh.length));
        EventLog eventLog = new EventLog();
        Object $this$use$iv = Disposer.newDisposable();
        boolean $i$f$use = false;
        try {
            actionDisposable = $this$use$iv;
            boolean bl = false;
            MessageBus messageBus = project2.getMessageBus();
            Intrinsics.checkNotNullExpressionValue((Object)actionDisposable, (String)"actionDisposable");
            MessageBusConnection messageBusConnection = messageBus.connect(actionDisposable);
            Topic<BulkFileListener> topic = VirtualFileManager.VFS_CHANGES;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"VFS_CHANGES");
            messageBusConnection.subscribe(topic, eventLog);
            Collection files2 = null;
            if (recoveryScope instanceof FilesRecoveryScope) {
                files2 = ((FilesRecoveryScope)recoveryScope).getFiles();
            } else {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$flatMapTo$iv$iv;
                FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
                FileBasedIndexImpl fileBasedIndex2 = (FileBasedIndexImpl)fileBasedIndex;
                List list2 = fileBasedIndex2.getIndexableFilesProviders(project2);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"fileBasedIndex.getIndexableFilesProviders(project)");
                Iterable $this$flatMap$iv = list2;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    IndexableFilesIterator it = (IndexableFilesIterator)element$iv$iv;
                    boolean bl2 = false;
                    Set set2 = it.getRootUrls(project2);
                    Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"it.getRootUrls(project)");
                    Iterable list$iv$iv = set2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List rootUrls = (List)destination$iv$iv;
                Iterable $this$mapNotNull$iv = rootUrls;
                boolean $i$f$mapNotNull = false;
                $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    VirtualFile it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    String it = (String)element$iv$iv;
                    boolean bl4 = false;
                    if (VirtualFileManager.getInstance().refreshAndFindFileByUrl(it) == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                files2 = (List)destination$iv$iv;
            }
            SynchronizeCurrentFileAction.synchronizeFiles(files2, project2, false);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if ($this$use$iv != null) {
                Disposer.dispose((Disposable)$this$use$iv);
            }
        }
        $this$use$iv = eventLog.getLoggedEvents();
        boolean $i$f$filter = false;
        actionDisposable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Event event = (Event)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)ActionsKt.runReadAction((Function0)new Function0<Boolean>(event, rootsToRefresh){
                final /* synthetic */ Event $event;
                final /* synthetic */ VirtualFile[] $rootsToRefresh;
                {
                    this.$event = $event;
                    this.$rootsToRefresh = $rootsToRefresh;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke() {
                    boolean bl;
                    if (this.$event.getFile().isValid()) {
                        boolean bl2;
                        block3: {
                            void $this$any$iv;
                            VirtualFile[] virtualFileArray = this.$rootsToRefresh;
                            Event event = this.$event;
                            boolean $i$f$any = false;
                            int n = ((void)$this$any$iv).length;
                            for (int j = 0; j < n; ++j) {
                                void element$iv;
                                void it = element$iv = $this$any$iv[j];
                                boolean bl3 = false;
                                if (!(it.isValid() && VfsUtilCore.isAncestor((VirtualFile)it, event.getFile(), false))) continue;
                                bl2 = true;
                                break block3;
                            }
                            bl2 = false;
                        }
                        if (bl2) {
                            bl = true;
                            return bl;
                        }
                    }
                    bl = false;
                    return bl;
                }
            })).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Event event = (Event)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toCacheInconsistencyProblem());
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0016\u0010\r\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\fH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/util/indexing/RefreshIndexableFilesAction$EventLog;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "()V", "loggedEvents", "", "Lcom/intellij/util/indexing/RefreshIndexableFilesAction$Event;", "getLoggedEvents", "()Ljava/util/List;", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "before", "logEvent", "event", "intellij.platform.lang.impl"})
    private static final class EventLog
    implements BulkFileListener {
        @NotNull
        private final List<Event> loggedEvents = new ArrayList();

        @NotNull
        public final List<Event> getLoggedEvents() {
            return this.loggedEvents;
        }

        @Override
        public void before(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                if (vFileEvent instanceof VFileCreateEvent) continue;
                this.logEvent(vFileEvent);
            }
        }

        @Override
        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                if (!(vFileEvent instanceof VFileCreateEvent)) continue;
                this.logEvent(vFileEvent);
            }
        }

        private final void logEvent(VFileEvent event) {
            block0: {
                VirtualFile virtualFile2 = event.getFile();
                if (virtualFile2 == null) break block0;
                VirtualFile it = virtualFile2;
                boolean bl = false;
                this.loggedEvents.add(new Event(it));
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/indexing/RefreshIndexableFilesAction$Event;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "copy", "equals", "", "other", "hashCode", "", "toCacheInconsistencyProblem", "Lcom/intellij/ide/actions/cache/CacheInconsistencyProblem;", "toString", "", "intellij.platform.lang.impl"})
    private static final class Event {
        @NotNull
        private final VirtualFile file;

        public Event(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            this.file = file2;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final CacheInconsistencyProblem toCacheInconsistencyProblem() {
            return new CacheInconsistencyProblem(this){
                final /* synthetic */ Event this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public String getMessage() {
                    return "vfs event on " + this.this$0.getFile().getUrl();
                }
            };
        }

        @NotNull
        public final VirtualFile component1() {
            return this.file;
        }

        @NotNull
        public final Event copy(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return new Event(file2);
        }

        public static /* synthetic */ Event copy$default(Event event, VirtualFile virtualFile2, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile2 = event.file;
            }
            return event.copy(virtualFile2);
        }

        @NotNull
        public String toString() {
            return "Event(file=" + this.file + ")";
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Event)) {
                return false;
            }
            Event event = (Event)other;
            return Intrinsics.areEqual((Object)this.file, (Object)event.file);
        }
    }
}

