/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class StaleIndexesChecker {
    private static final Logger LOG = Logger.getInstance(StaleIndexesChecker.class);
    private static final ThreadLocal<Boolean> IS_IN_STALE_IDS_DELETION = new ThreadLocal();

    public static boolean isStaleIdDeletion() {
        return IS_IN_STALE_IDS_DELETION.get() == Boolean.TRUE;
    }

    @NotNull
    static IntSet checkIndexForStaleRecords(@NotNull UpdatableIndex<?, ?, FileContent, ?> index2, IntSet knownStaleIds, boolean onStartup) throws StorageException {
        if (index2 == null) {
            StaleIndexesChecker.$$$reportNull$$$0(0);
        }
        if (!ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isEAP()) {
            IntSets.EmptySet emptySet = IntSets.EMPTY_SET;
            if (emptySet == null) {
                StaleIndexesChecker.$$$reportNull$$$0(1);
            }
            return emptySet;
        }
        IndexExtension extension2 = index2.getExtension();
        IndexId indexId = extension2.getName();
        LOG.assertTrue(indexId.equals(StubUpdatingIndex.INDEX_ID));
        LOG.assertTrue(extension2 instanceof SingleEntryFileBasedIndexExtension);
        Int2ObjectOpenHashMap<String> staleFiles = new Int2ObjectOpenHashMap<String>();
        IntListIterator intListIterator = (onStartup ? FSRecords.getRemainFreeRecords() : FSRecords.getNewFreeRecords()).iterator();
        while (intListIterator.hasNext()) {
            Map dataAsMap;
            Object data2;
            int freeRecord = (Integer)intListIterator.next();
            if (knownStaleIds.contains(freeRecord) || (data2 = ContainerUtil.getFirstItem((dataAsMap = index2.getIndexedFileData(freeRecord)).values())) == null) continue;
            String name = StaleIndexesChecker.getStaleRecordOrExceptionMessage(freeRecord);
            staleFiles.put(freeRecord, name);
        }
        if (!staleFiles.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode() && onStartup) {
                Disposer.register(ApplicationManager.getApplication(), () -> LOG.error(StaleIndexesChecker.getStaleInputIdsMessage(staleFiles, indexId)));
            } else {
                LOG.error(StaleIndexesChecker.getStaleInputIdsMessage(staleFiles, indexId));
            }
        }
        IntSet intSet = staleFiles.keySet();
        if (intSet == null) {
            StaleIndexesChecker.$$$reportNull$$$0(2);
        }
        return intSet;
    }

    static String getStaleRecordOrExceptionMessage(int record) {
        try {
            return StaleIndexesChecker.getRecordPath(record);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private static String getRecordPath(int record) {
        StringBuilder name = new StringBuilder(FSRecords.getName((int)record));
        int parent2 = FSRecords.getParent((int)record);
        while (parent2 > 0) {
            name.insert(0, FSRecords.getName((int)parent2) + "/");
            parent2 = FSRecords.getParent((int)parent2);
        }
        return name.toString();
    }

    static void clearStaleIndexes(@NotNull IntSet staleIds) {
        if (staleIds == null) {
            StaleIndexesChecker.$$$reportNull$$$0(3);
        }
        IS_IN_STALE_IDS_DELETION.set(Boolean.TRUE);
        boolean unitTest = ApplicationManager.getApplication().isUnitTestMode();
        try {
            ProgressManager.getInstance().executeNonCancelableSection(() -> staleIds.forEach(staleId -> {
                if (unitTest) {
                    LOG.info("clearing stale id = " + staleId + ", path =  " + StaleIndexesChecker.getRecordPath(staleId));
                }
                StaleIndexesChecker.clearStaleIndexesForId(staleId);
            }));
        }
        finally {
            IS_IN_STALE_IDS_DELETION.remove();
        }
    }

    static void clearStaleIndexesForId(int staleInputId) {
        FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        Collection indexIds = fileBasedIndex.getRegisteredIndexes().getState().getIndexIDs();
        fileBasedIndex.removeFileDataFromIndices(indexIds, staleInputId, null);
    }

    @NotNull
    private static String getStaleInputIdsMessage(Int2ObjectMap<String> staleTrees, IndexId<?, ?> indexId) {
        String string2 = "`" + indexId + "` index contains several stale file ids (size = " + staleTrees.size() + "). Ids & paths: " + StringUtil.first(staleTrees.toString(), 300, true) + ".";
        if (string2 == null) {
            StaleIndexesChecker.$$$reportNull$$$0(4);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/StaleIndexesChecker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staleIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/StaleIndexesChecker";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "checkIndexForStaleRecords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaleInputIdsMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkIndexForStaleRecords";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "clearStaleIndexes";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 4 -> new IllegalStateException(string2);
        };
    }
}

