/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.PoweredProgressIndicator;
import com.intellij.util.indexing.ProjectChangedFilesScanner;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.contentQueue.IndexUpdateRunner;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl;
import com.intellij.util.indexing.diagnostic.ScanningType;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingsStatistics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

class UnindexedFilesIndexer
extends DumbModeTask {
    private static final Logger LOG = Logger.getInstance(UnindexedFilesIndexer.class);
    @NotNull
    private final Project myProject;
    private final FileBasedIndexImpl myIndex;
    @NotNull
    private final @NotNull Map<@NotNull IndexableFilesIterator, @NotNull Collection<@NotNull VirtualFile>> providerToFiles;
    @NonNls
    @NotNull
    private final String indexingReason;

    UnindexedFilesIndexer(@NotNull Project project2, @NonNls @NotNull String indexingReason) {
        if (project2 == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(0);
        }
        if (indexingReason == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(1);
        }
        this(project2, Collections.emptyMap(), indexingReason);
    }

    UnindexedFilesIndexer(@NotNull Project project2, @NotNull @NotNull Map<@NotNull IndexableFilesIterator, @NotNull Collection<@NotNull VirtualFile>> providerToFiles, @NonNls @NotNull String indexingReason) {
        if (project2 == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(2);
        }
        if (providerToFiles == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(3);
        }
        if (indexingReason == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(4);
        }
        this.myProject = project2;
        this.myIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        this.providerToFiles = providerToFiles;
        this.indexingReason = indexingReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void indexFiles(@NotNull ProjectIndexingHistoryImpl projectIndexingHistory, @NotNull ProgressIndicator indicator) {
        if (projectIndexingHistory == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(6);
        }
        if (SystemProperties.getBooleanProperty("idea.indexes.pretendNoFiles", false)) {
            LOG.info("Finished for " + this.myProject.getName() + ". System property 'idea.indexes.pretendNoFiles' is enabled.");
            return;
        }
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        ProgressIndicator poweredIndicator = PoweredProgressIndicator.wrap(indicator, UnindexedFilesIndexer.getPowerForSmoothProgressIndicator());
        poweredIndicator.setIndeterminate(false);
        poweredIndicator.setFraction(0.0);
        poweredIndicator.setText(IndexingBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
        this.myIndex.resetSnapshotInputMappingStatistics();
        projectIndexingHistory.startStage(ProjectIndexingHistoryImpl.Stage.Indexing);
        try {
            this.doIndexFiles(projectIndexingHistory, poweredIndicator);
        }
        finally {
            projectIndexingHistory.stopStage(ProjectIndexingHistoryImpl.Stage.Indexing);
        }
        LOG.info(snapshot.getLogResponsivenessSinceCreationMessage("Finished for " + this.myProject.getName() + ". Unindexed files update"));
        List<SnapshotInputMappingsStatistics> snapshotInputMappingsStatistics = this.myIndex.dumpSnapshotInputMappingStatistics();
        projectIndexingHistory.addSnapshotInputMappingStatistics(snapshotInputMappingsStatistics);
    }

    private void doIndexFiles(@NotNull ProjectIndexingHistoryImpl projectIndexingHistory, @NotNull ProgressIndicator progressIndicator) {
        if (projectIndexingHistory == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(7);
        }
        if (progressIndicator == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(8);
        }
        int numberOfIndexingThreads = UnindexedFilesUpdater.getNumberOfIndexingThreads();
        LOG.info("Use " + numberOfIndexingThreads + " indexing " + StringUtil.pluralize("thread", numberOfIndexingThreads) + " for indexing of " + this.myProject.getName());
        IndexUpdateRunner indexUpdateRunner = new IndexUpdateRunner(this.myIndex, numberOfIndexingThreads);
        List<IndexUpdateRunner.FileSet> fileSets = this.getExplicitlyRequestedFilesSets();
        if (!fileSets.isEmpty()) {
            this.doIndexFiles(projectIndexingHistory, progressIndicator, indexUpdateRunner, fileSets);
        }
        if (!(fileSets = this.getRefreshedFiles(projectIndexingHistory)).isEmpty()) {
            this.doIndexFiles(projectIndexingHistory, progressIndicator, indexUpdateRunner, fileSets);
        }
    }

    private List<IndexUpdateRunner.FileSet> getRefreshedFiles(@NotNull ProjectIndexingHistoryImpl projectIndexingHistory) {
        if (projectIndexingHistory == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(9);
        }
        String filesetName = "Refreshed files";
        Collection<VirtualFile> files2 = new ProjectChangedFilesScanner(this.myProject).scan(projectIndexingHistory, filesetName);
        return Collections.singletonList(new IndexUpdateRunner.FileSet(this.myProject, filesetName, files2));
    }

    @NotNull
    private List<IndexUpdateRunner.FileSet> getExplicitlyRequestedFilesSets() {
        ArrayList<IndexableFilesIterator> providers = new ArrayList<IndexableFilesIterator>(this.providerToFiles.keySet());
        ArrayList<IndexUpdateRunner.FileSet> fileSets = new ArrayList<IndexUpdateRunner.FileSet>();
        for (IndexableFilesIterator provider2 : providers) {
            Collection providerFiles = this.providerToFiles.getOrDefault(provider2, Collections.emptyList());
            if (providerFiles.isEmpty()) continue;
            String progressText = provider2.getIndexingProgressText();
            fileSets.add(new IndexUpdateRunner.FileSet(this.myProject, provider2.getDebugName(), providerFiles, progressText));
        }
        ArrayList<IndexUpdateRunner.FileSet> arrayList = fileSets;
        if (arrayList == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private void doIndexFiles(@NotNull ProjectIndexingHistoryImpl projectIndexingHistory, @NotNull ProgressIndicator progressIndicator, IndexUpdateRunner indexUpdateRunner, List<IndexUpdateRunner.FileSet> fileSets) {
        if (projectIndexingHistory == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(11);
        }
        if (progressIndicator == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(12);
        }
        IndexUpdateRunner.IndexingInterruptedException exception = null;
        try {
            indexUpdateRunner.indexFiles(this.myProject, fileSets, progressIndicator, projectIndexingHistory);
        }
        catch (IndexUpdateRunner.IndexingInterruptedException e) {
            exception = e;
        }
        try {
            fileSets.forEach(b -> projectIndexingHistory.addProviderStatistics(b.statistics));
        }
        catch (Exception e) {
            LOG.error("Failed to add indexing statistics", e);
        }
        if (exception != null) {
            ExceptionUtil.rethrow(exception.getCause());
        }
    }

    @Override
    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(13);
        }
        this.myIndex.loadIndexes();
        if (!IndexInfrastructure.hasIndices()) {
            return;
        }
        ProjectIndexingHistoryImpl projectIndexingHistory = new ProjectIndexingHistoryImpl(this.myProject, this.indexingReason, ScanningType.REFRESH);
        IndexDiagnosticDumper.getInstance().onIndexingStarted(projectIndexingHistory);
        ProgressSuspender suspender = ProgressSuspender.getSuspender((ProgressIndicator)indicator);
        if (suspender != null) {
            ApplicationManager.getApplication().getMessageBus().connect(this).subscribe(ProgressSuspender.TOPIC, projectIndexingHistory.getSuspendListener(suspender));
        }
        try {
            ((GistManagerImpl)GistManager.getInstance()).runWithMergingDependentCacheInvalidations(() -> this.indexFiles(projectIndexingHistory, indicator));
        }
        catch (Throwable e) {
            projectIndexingHistory.setWasInterrupted(true);
            if (e instanceof ControlFlowException) {
                LOG.info("Cancelled indexing of " + this.myProject.getName());
            }
            throw e;
        }
        finally {
            projectIndexingHistory.finishTotalUpdatingTime();
            IndexDiagnosticDumper.getInstance().onIndexingFinished(projectIndexingHistory);
        }
    }

    @Override
    @Nullable
    public UnindexedFilesIndexer tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
        if (taskFromQueue == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(14);
        }
        if (!(taskFromQueue instanceof UnindexedFilesIndexer)) {
            return null;
        }
        UnindexedFilesIndexer otherIndexingTask = (UnindexedFilesIndexer)taskFromQueue;
        Map<IndexableFilesIterator, Collection<VirtualFile>> largeMap = otherIndexingTask.providerToFiles.size() > this.providerToFiles.size() ? otherIndexingTask.providerToFiles : this.providerToFiles;
        Map<IndexableFilesIterator, Collection<VirtualFile>> smallMap = largeMap == this.providerToFiles ? otherIndexingTask.providerToFiles : this.providerToFiles;
        HashMap<IndexableFilesIterator, Collection<VirtualFile>> mergedFilesToIndex = new HashMap<IndexableFilesIterator, Collection<VirtualFile>>(largeMap);
        for (Map.Entry<IndexableFilesIterator, Collection<VirtualFile>> e : smallMap.entrySet()) {
            Collection<VirtualFile> mergedList;
            if (mergedFilesToIndex.containsKey(e.getKey())) {
                HashSet<VirtualFile> mergedSet = new HashSet<VirtualFile>((Collection)mergedFilesToIndex.get(e.getKey()));
                mergedSet.addAll(e.getValue());
                mergedList = new ArrayList<VirtualFile>(mergedSet);
            } else {
                mergedList = e.getValue();
            }
            mergedFilesToIndex.put(e.getKey(), mergedList);
        }
        String mergedReason = this.mergeReasons(otherIndexingTask);
        return new UnindexedFilesIndexer(this.myProject, mergedFilesToIndex, mergedReason);
    }

    @NotNull
    private String mergeReasons(@NotNull UnindexedFilesIndexer otherIndexingTask) {
        if (otherIndexingTask == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(15);
        }
        String trimmedReason = StringUtil.trimStart(this.indexingReason, "Merged ");
        String trimmedOtherReason = StringUtil.trimStart(otherIndexingTask.indexingReason, "Merged ");
        if (otherIndexingTask.providerToFiles.isEmpty() && trimmedReason.endsWith(trimmedOtherReason)) {
            String string2 = this.indexingReason;
            if (string2 == null) {
                UnindexedFilesIndexer.$$$reportNull$$$0(16);
            }
            return string2;
        }
        String string3 = "Merged " + trimmedReason + " with " + trimmedOtherReason;
        if (string3 == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(17);
        }
        return string3;
    }

    private static double getPowerForSmoothProgressIndicator() {
        String rawValue = Registry.stringValue("indexing.progress.indicator.power");
        if ("-".equals(rawValue)) {
            return 1.0;
        }
        try {
            return Double.parseDouble(rawValue);
        }
        catch (NumberFormatException e) {
            return 1.0;
        }
    }

    @TestOnly
    @NotNull
    @NotNull Map<@NotNull IndexableFilesIterator, @NotNull Collection<@NotNull VirtualFile>> getProviderToFiles() {
        Map<IndexableFilesIterator, Collection<VirtualFile>> map2 = this.providerToFiles;
        if (map2 == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(18);
        }
        return map2;
    }

    @NotNull
    public final String getIndexingReason() {
        String string2 = this.indexingReason;
        if (string2 == null) {
            UnindexedFilesIndexer.$$$reportNull$$$0(19);
        }
        return string2;
    }

    public String toString() {
        return "UnindexedFilesIndexer[" + this.myProject.getName() + ", " + this.providerToFiles.size() + " iterators, reason: " + this.indexingReason + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingReason";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerToFiles";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectIndexingHistory";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/UnindexedFilesIndexer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskFromQueue";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherIndexingTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/UnindexedFilesIndexer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitlyRequestedFilesSets";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeReasons";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderToFiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingReason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "indexFiles";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doIndexFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRefreshedFiles";
                break;
            }
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performInDumbMode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryMergeWith";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mergeReasons";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 10, 16, 17, 18, 19 -> new IllegalStateException(string2);
        };
    }
}

