/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.project.DumbModeProgressTitle;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.MergeableQueueTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsUsageCollector;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.BooleanFunction;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FilePropertyPusherEx;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.PerProjectIndexingQueue;
import com.intellij.util.indexing.UnindexedFileStatus;
import com.intellij.util.indexing.UnindexedFilesFinder;
import com.intellij.util.indexing.UnindexedFilesScannerExecutor;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.dependenciesCache.DependenciesIndexedStatusService;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl;
import com.intellij.util.indexing.diagnostic.ScanningStatistics;
import com.intellij.util.indexing.diagnostic.ScanningType;
import com.intellij.util.indexing.diagnostic.dto.JsonScanningStatistics;
import com.intellij.util.indexing.roots.IndexableFileScanner;
import com.intellij.util.indexing.roots.IndexableFilesDeduplicateFilter;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.kind.ModuleRootOrigin;
import com.intellij.util.indexing.roots.kind.SdkOrigin;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class UnindexedFilesScanner
implements MergeableQueueTask<UnindexedFilesScanner> {
    @VisibleForTesting
    public static final Key<Boolean> INDEX_PROJECT_WITH_MANY_UPDATERS_TEST_KEY = new Key("INDEX_PROJECT_WITH_MANY_UPDATERS_TEST_KEY");
    private static final Logger LOG = Logger.getInstance(UnindexedFilesScanner.class);
    @VisibleForTesting
    public static volatile TestMode ourTestMode;
    @NotNull
    private static final Key<Boolean> CONTENT_SCANNED;
    @NotNull
    private static final Key<Boolean> INDEX_UPDATE_IN_PROGRESS;
    private final FileBasedIndexImpl myIndex;
    protected final Project myProject;
    private final boolean myStartSuspended;
    private final boolean myOnProjectOpen;
    @NotNull
    @NonNls
    private final String myIndexingReason;
    @NotNull
    private final ScanningType myScanningType;
    private final PushedFilePropertiesUpdater myPusher;
    @Nullable
    private final DependenciesIndexedStatusService.StatusMark myProvidedStatusMark;
    @Nullable
    private final List<IndexableFilesIterator> myPredefinedIndexableFilesIterators;

    public UnindexedFilesScanner(@NotNull Project project2, boolean startSuspended, boolean onProjectOpen, @Nullable List<IndexableFilesIterator> predefinedIndexableFilesIterators, @Nullable DependenciesIndexedStatusService.StatusMark mark, @Nullable @NonNls String indexingReason, @NotNull ScanningType scanningType2) {
        if (project2 == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(0);
        }
        if (scanningType2 == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(1);
        }
        this.myIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        this.myProject = project2;
        this.myStartSuspended = startSuspended;
        this.myOnProjectOpen = onProjectOpen;
        this.myIndexingReason = indexingReason != null ? indexingReason : "<unknown>";
        this.myScanningType = scanningType2;
        this.myPusher = PushedFilePropertiesUpdater.getInstance(this.myProject);
        this.myProvidedStatusMark = predefinedIndexableFilesIterators == null ? null : mark;
        this.myPredefinedIndexableFilesIterators = predefinedIndexableFilesIterators;
        LOG.assertTrue(this.myPredefinedIndexableFilesIterators == null || !this.myPredefinedIndexableFilesIterators.isEmpty());
        if (this.isFullIndexUpdate()) {
            this.myProject.putUserData(CONTENT_SCANNED, null);
        }
    }

    protected boolean isFullIndexUpdate() {
        return this.myPredefinedIndexableFilesIterators == null;
    }

    @Override
    public void dispose() {
    }

    @Override
    @Nullable
    public UnindexedFilesScanner tryMergeWith(@NotNull UnindexedFilesScanner oldTask) {
        if (oldTask == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(2);
        }
        if (oldTask.getClass() != this.getClass()) {
            return null;
        }
        if (!this.myProject.equals(oldTask.myProject)) {
            return null;
        }
        Object reason = oldTask.isFullIndexUpdate() ? oldTask.myIndexingReason : (this.isFullIndexUpdate() ? this.myIndexingReason : "Merged " + StringUtil.trimStart(this.myIndexingReason, "Merged ") + " with " + StringUtil.trimStart(oldTask.myIndexingReason, "Merged "));
        LOG.debug("Merged " + this + " task");
        return new UnindexedFilesScanner(this.myProject, this.myStartSuspended, false, UnindexedFilesScanner.mergeIterators(this.myPredefinedIndexableFilesIterators, oldTask.myPredefinedIndexableFilesIterators), DependenciesIndexedStatusService.StatusMark.mergeStatus(this.myProvidedStatusMark, oldTask.myProvidedStatusMark), (String)reason, ScanningType.Companion.merge(oldTask.myScanningType, oldTask.myScanningType));
    }

    @Nullable
    private static List<IndexableFilesIterator> mergeIterators(@Nullable List<? extends IndexableFilesIterator> iterators, @Nullable List<? extends IndexableFilesIterator> otherIterators) {
        if (iterators == null || otherIterators == null) {
            return null;
        }
        LinkedHashMap<IndexableSetOrigin, IndexableFilesIterator> uniqueIterators = new LinkedHashMap<IndexableSetOrigin, IndexableFilesIterator>();
        for (IndexableFilesIterator indexableFilesIterator : iterators) {
            uniqueIterators.putIfAbsent(indexableFilesIterator.getOrigin(), indexableFilesIterator);
        }
        for (IndexableFilesIterator indexableFilesIterator : otherIterators) {
            uniqueIterators.putIfAbsent(indexableFilesIterator.getOrigin(), indexableFilesIterator);
        }
        return new ArrayList<IndexableFilesIterator>(uniqueIterators.values());
    }

    public UnindexedFilesScanner(@NotNull Project project2, @Nullable @NonNls String indexingReason) {
        if (project2 == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(3);
        }
        this(project2, false, false, null, null, indexingReason, ScanningType.FULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(@NotNull PerformanceWatcher.Snapshot snapshot, @NotNull ProjectIndexingHistoryImpl projectIndexingHistory, @NotNull ProgressIndicator indicator, @NotNull Ref<? super DependenciesIndexedStatusService.StatusMark> markRef) {
        List orderedProviders;
        if (snapshot == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(4);
        }
        if (projectIndexingHistory == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(6);
        }
        if (markRef == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(7);
        }
        projectIndexingHistory.startStage(ProjectIndexingHistoryImpl.Stage.PushProperties);
        try {
            if (this.myPusher instanceof PushedFilePropertiesUpdaterImpl) {
                ((PushedFilePropertiesUpdaterImpl)this.myPusher).performDelayedPushTasks();
            }
        }
        finally {
            projectIndexingHistory.stopStage(ProjectIndexingHistoryImpl.Stage.PushProperties);
        }
        LOG.info(snapshot.getLogResponsivenessSinceCreationMessage("Performing delayed pushing properties tasks for " + this.myProject.getName()));
        snapshot = PerformanceWatcher.takeSnapshot();
        if (this.isFullIndexUpdate()) {
            this.myIndex.clearIndicesIfNecessary();
        }
        projectIndexingHistory.startStage(ProjectIndexingHistoryImpl.Stage.CreatingIterators);
        try {
            if (this.myPredefinedIndexableFilesIterators == null) {
                Pair<@NotNull List<IndexableFilesIterator>, @NotNull DependenciesIndexedStatusService.StatusMark> pair = UnindexedFilesScanner.collectProviders(this.myProject, this.myIndex);
                orderedProviders = (List)pair.getFirst();
                markRef.set((DependenciesIndexedStatusService.StatusMark)pair.getSecond());
            } else {
                orderedProviders = this.myPredefinedIndexableFilesIterators;
            }
        }
        finally {
            projectIndexingHistory.stopStage(ProjectIndexingHistoryImpl.Stage.CreatingIterators);
        }
        projectIndexingHistory.startStage(ProjectIndexingHistoryImpl.Stage.Scanning);
        try {
            this.collectIndexableFilesConcurrently(this.myProject, indicator, orderedProviders, projectIndexingHistory);
            if (this.isFullIndexUpdate()) {
                this.myProject.putUserData(CONTENT_SCANNED, true);
            }
        }
        finally {
            projectIndexingHistory.stopStage(ProjectIndexingHistoryImpl.Stage.Scanning);
        }
        String scanningCompletedMessage = UnindexedFilesScanner.getLogScanningCompletedStageMessage(projectIndexingHistory);
        LOG.info(snapshot.getLogResponsivenessSinceCreationMessage(scanningCompletedMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanAndUpdateUnindexedFiles(@NotNull ProjectIndexingHistoryImpl projectIndexingHistory, @NotNull ProgressIndicator indicator, @NotNull Ref<? super DependenciesIndexedStatusService.StatusMark> markRef) {
        if (projectIndexingHistory == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(9);
        }
        if (markRef == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(10);
        }
        if (!IndexInfrastructure.hasIndices()) {
            return;
        }
        LOG.info("Started scanning for indexing of " + this.myProject.getName() + ". Reason: " + this.myIndexingReason);
        ProgressSuspender suspender = ProgressSuspender.getSuspender((ProgressIndicator)indicator);
        if (suspender != null) {
            ApplicationManager.getApplication().getMessageBus().connect(this).subscribe(ProgressSuspender.TOPIC, projectIndexingHistory.getSuspendListener(suspender));
        }
        if (this.myStartSuspended) {
            if (suspender == null) {
                throw new IllegalStateException("Indexing progress indicator must be suspendable!");
            }
            if (!suspender.isSuspended()) {
                suspender.suspendProcess(IndexingBundle.message((String)"progress.indexing.started.as.suspended", (Object[])new Object[0]));
            }
        }
        indicator.setIndeterminate(true);
        indicator.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        Disposable scanningLifetime = Disposer.newDisposable();
        try {
            if (!UnindexedFilesScanner.shouldScanInSmartMode()) {
                DumbModeProgressTitle.getInstance((Project)this.myProject).attachProgressTitleText(IndexingBundle.message((String)"progress.indexing.scanning.title", (Object[])new Object[0]), scanningLifetime);
            }
            this.scan(snapshot, projectIndexingHistory, indicator, markRef);
        }
        finally {
            Disposer.dispose(scanningLifetime);
        }
        boolean skipInitialRefresh = UnindexedFilesScanner.skipInitialRefresh();
        boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (this.myOnProjectOpen && !isUnitTestMode && !skipInitialRefresh) {
            this.scheduleInitialVfsRefresh();
        }
        if (UnindexedFilesScanner.shouldScanInSmartMode()) {
            this.myProject.getService(PerProjectIndexingQueue.class).flushNow(this.myIndexingReason);
        } else {
            this.myProject.getService(PerProjectIndexingQueue.class).flushNowSync(projectIndexingHistory, indicator);
        }
    }

    static boolean shouldScanInSmartMode() {
        return !DumbServiceImpl.isSynchronousTaskExecution() && Registry.is("scanning.in.smart.mode", true);
    }

    @NotNull
    private static String getLogScanningCompletedStageMessage(@NotNull ProjectIndexingHistoryImpl projectIndexingHistory) {
        if (projectIndexingHistory == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(11);
        }
        List statistics = projectIndexingHistory.getScanningStatistics();
        int numberOfScannedFiles = statistics.stream().mapToInt(JsonScanningStatistics::getNumberOfScannedFiles).sum();
        int numberOfFilesForIndexing = statistics.stream().mapToInt(JsonScanningStatistics::getNumberOfFilesForIndexing).sum();
        String string2 = "Scanning completed for " + projectIndexingHistory.getProject().getName() + ". Number of scanned files: " + numberOfScannedFiles + "; Number of files for indexing: " + numberOfFilesForIndexing;
        if (string2 == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(12);
        }
        return string2;
    }

    public static boolean isIndexUpdateInProgress(@NotNull Project project2) {
        if (project2 == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(13);
        }
        return project2.getUserData(INDEX_UPDATE_IN_PROGRESS) == Boolean.TRUE;
    }

    public static boolean isProjectContentFullyScanned(@NotNull Project project2) {
        if (project2 == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(14);
        }
        return Boolean.TRUE.equals(project2.getUserData(CONTENT_SCANNED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static @NotNull Pair<@NotNull List<IndexableFilesIterator>, @Nullable DependenciesIndexedStatusService.StatusMark> collectProviders(@NotNull Project project2, FileBasedIndexImpl index2) {
        List originalOrderedProviders;
        if (project2 == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(15);
        }
        boolean cache2 = DependenciesIndexedStatusService.shouldBeUsed();
        DependenciesIndexedStatusService.StatusMark mark = null;
        if (cache2) {
            DependenciesIndexedStatusService.getInstance(project2).startCollectingStatus();
        }
        try {
            originalOrderedProviders = index2.getIndexableFilesProviders(project2);
        }
        finally {
            if (cache2) {
                mark = DependenciesIndexedStatusService.getInstance(project2).finishCollectingStatus();
            }
        }
        ArrayList orderedProviders = new ArrayList();
        originalOrderedProviders.stream().filter(p -> !(p.getOrigin() instanceof SdkOrigin)).collect(Collectors.toCollection(() -> orderedProviders));
        originalOrderedProviders.stream().filter(p -> p.getOrigin() instanceof SdkOrigin).collect(Collectors.toCollection(() -> orderedProviders));
        return new Pair(orderedProviders, (Object)mark);
    }

    @Nullable
    protected BooleanFunction<IndexedFile> getForceReindexingTrigger() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectIndexableFilesConcurrently(@NotNull Project project2, @NotNull ProgressIndicator indicator, @NotNull List<? extends IndexableFilesIterator> providers, @NotNull ProjectIndexingHistoryImpl projectIndexingHistory) {
        if (project2 == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(16);
        }
        if (indicator == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(17);
        }
        if (providers == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(18);
        }
        if (projectIndexingHistory == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(19);
        }
        if (providers.isEmpty()) {
            return;
        }
        List<IndexableFileScanner.ScanSession> sessions = ContainerUtil.map(IndexableFileScanner.EP_NAME.getExtensionList(), scanner -> scanner.startSession(project2));
        UnindexedFilesFinder unindexedFileFinder = new UnindexedFilesFinder(project2, this.myIndex, this.getForceReindexingTrigger());
        IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter = IndexableFilesDeduplicateFilter.create();
        indicator.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        ConcurrentTasksProgressManager concurrentTasksProgressManager = new ConcurrentTasksProgressManager(indicator, providers.size());
        Ref<Boolean> allTasksFinished = Ref.create(false);
        List<Runnable> tasks = ContainerUtil.map(providers, provider2 -> {
            SubTaskProgressIndicator subTaskIndicator = concurrentTasksProgressManager.createSubTaskIndicator(1);
            ScanningStatistics scanningStatistics = new ScanningStatistics(provider2.getDebugName());
            scanningStatistics.setProviderRoots((IndexableFilesIterator)provider2, project2);
            IndexableSetOrigin origin = provider2.getOrigin();
            List<// Could not load outer class - annotation placement on inner may be incorrect
            @NotNull IndexableFileScanner.IndexableFileVisitor> fileScannerVisitors = ContainerUtil.mapNotNull(sessions, s -> s.createVisitor(origin));
            IndexableFilesDeduplicateFilter thisProviderDeduplicateFilter = IndexableFilesDeduplicateFilter.createDelegatingTo((IndexableFilesDeduplicateFilter)indexableFilesDeduplicateFilter);
            ProgressManager.checkCanceled();
            return () -> {
                subTaskIndicator.setText(provider2.getRootsScanningProgressText());
                try (PerProjectIndexingQueue.PerProviderSink perProviderSink = project2.getService(PerProjectIndexingQueue.class).getSink((IndexableFilesIterator)provider2);){
                    CollectingIterator collectingIterator = new CollectingIterator(project2, subTaskIndicator, (IndexableFilesIterator)provider2, fileScannerVisitors, unindexedFileFinder, scanningStatistics, perProviderSink);
                    provider2.iterateFiles(project2, (ContentIterator)collectingIterator, (VirtualFileFilter)thisProviderDeduplicateFilter);
                    perProviderSink.commit();
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Exception e) {
                    LOG.error("Error while scanning files of " + provider2.getDebugName() + "\nTo reindex files under this origin IDEA has to be restarted", e);
                }
                finally {
                    scanningStatistics.setNumberOfSkippedFiles(thisProviderDeduplicateFilter.getNumberOfSkippedFiles());
                    Ref ref = allTasksFinished;
                    synchronized (ref) {
                        if (!((Boolean)allTasksFinished.get()).booleanValue()) {
                            projectIndexingHistory.addScanningStatistics(scanningStatistics);
                        }
                    }
                    subTaskIndicator.finished();
                }
            };
        });
        LOG.info("Scanning of " + this.myProject.getName() + " uses " + UnindexedFilesUpdater.getNumberOfScanningThreads() + " scanning threads");
        try {
            PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
        }
        finally {
            Ref<Boolean> ref = allTasksFinished;
            synchronized (ref) {
                allTasksFinished.set(true);
            }
        }
    }

    private void scheduleInitialVfsRefresh() {
        final String projectId = this.myProject.getLocationHash();
        LOG.info(projectId + ": marking roots for initial VFS refresh");
        ProjectRootManagerEx.getInstanceEx(this.myProject).markRootsForRefresh();
        LOG.info(projectId + ": starting initial VFS refresh");
        Application app = ApplicationManager.getApplication();
        long t = System.nanoTime();
        if (!app.isCommandLine() || CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode()) {
            final long sessionId = VirtualFileManager.getInstance().asyncRefresh(() -> this.timeInitialVfsRefresh(t));
            final MessageBusConnection connection = app.getMessageBus().connect();
            connection.subscribe(ProjectCloseListener.TOPIC, new ProjectCloseListener(){

                @Override
                public void projectClosed(@NotNull Project project2) {
                    if (project2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (project2 == UnindexedFilesScanner.this.myProject) {
                        LOG.info(projectId + ": cancelling initial VFS refresh");
                        RefreshQueue.getInstance().cancelSession(sessionId);
                        connection.disconnect();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/UnindexedFilesScanner$1", "projectClosed"));
                }
            });
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                VirtualFileManager.getInstance().syncRefresh();
                this.timeInitialVfsRefresh(t);
            });
        }
    }

    private void timeInitialVfsRefresh(long t) {
        long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t);
        LOG.info(this.myProject.getLocationHash() + ": initial VFS refresh finished " + duration + " ms");
        VfsUsageCollector.logInitialRefresh((Project)this.myProject, (long)duration);
    }

    @Override
    public void perform(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(20);
        }
        LOG.assertTrue(this.myProject.getUserData(INDEX_UPDATE_IN_PROGRESS) != Boolean.TRUE, "Scanning is already in progress");
        this.myProject.putUserData(INDEX_UPDATE_IN_PROGRESS, true);
        try {
            this.performScanningAndIndexing(indicator);
        }
        finally {
            this.myProject.putUserData(INDEX_UPDATE_IN_PROGRESS, false);
        }
    }

    @NotNull
    protected ProjectIndexingHistoryImpl performScanningAndIndexing(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(21);
        }
        ProjectIndexingHistoryImpl projectIndexingHistory = new ProjectIndexingHistoryImpl(this.myProject, this.myIndexingReason, this.myScanningType);
        this.myIndex.loadIndexes();
        this.myIndex.filesUpdateStarted(this.myProject, this.isFullIndexUpdate());
        IndexDiagnosticDumper.getInstance().onIndexingStarted(projectIndexingHistory);
        Ref markRef = new Ref();
        try {
            ((GistManagerImpl)GistManager.getInstance()).runWithMergingDependentCacheInvalidations(() -> this.scanAndUpdateUnindexedFiles(projectIndexingHistory, indicator, markRef));
            this.myIndex.filesUpdateFinished(this.myProject);
            projectIndexingHistory.finishTotalUpdatingTime();
        }
        catch (Throwable e) {
            try {
                projectIndexingHistory.setWasInterrupted(true);
                if (e instanceof ControlFlowException) {
                    LOG.info("Cancelled indexing of " + this.myProject.getName());
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.myIndex.filesUpdateFinished(this.myProject);
                projectIndexingHistory.finishTotalUpdatingTime();
                if (DependenciesIndexedStatusService.shouldBeUsed() && IndexInfrastructure.hasIndices()) {
                    DependenciesIndexedStatusService.getInstance(this.myProject).indexingFinished(!projectIndexingHistory.getTimes().getWasInterrupted(), (DependenciesIndexedStatusService.StatusMark)markRef.get());
                }
                IndexDiagnosticDumper.getInstance().onIndexingFinished(projectIndexingHistory);
                throw throwable;
            }
        }
        if (DependenciesIndexedStatusService.shouldBeUsed() && IndexInfrastructure.hasIndices()) {
            DependenciesIndexedStatusService.getInstance(this.myProject).indexingFinished(!projectIndexingHistory.getTimes().getWasInterrupted(), (DependenciesIndexedStatusService.StatusMark)markRef.get());
        }
        IndexDiagnosticDumper.getInstance().onIndexingFinished(projectIndexingHistory);
        ProjectIndexingHistoryImpl projectIndexingHistoryImpl = projectIndexingHistory;
        if (projectIndexingHistoryImpl == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(22);
        }
        return projectIndexingHistoryImpl;
    }

    public String toString() {
        String partialInfo = this.myPredefinedIndexableFilesIterators != null ? ", " + this.myPredefinedIndexableFilesIterators.size() + " iterators" : "";
        return "UnindexedFilesScanner[" + this.myProject.getName() + partialInfo + "]";
    }

    private static boolean skipInitialRefresh() {
        return SystemProperties.getBooleanProperty("ij.indexes.skip.initial.refresh", false);
    }

    public static void scanAndIndexProjectAfterOpen(@NotNull Project project2, boolean startSuspended, @Nullable @NonNls String indexingReason) {
        if (project2 == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(23);
        }
        ((FileBasedIndexImpl)FileBasedIndex.getInstance()).loadIndexes();
        if (TestModeFlags.is(INDEX_PROJECT_WITH_MANY_UPDATERS_TEST_KEY)) {
            LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode());
            List iterators = (List)UnindexedFilesScanner.collectProviders(project2, (FileBasedIndexImpl)FileBasedIndex.getInstance()).getFirst();
            for (IndexableFilesIterator iterator2 : iterators) {
                new UnindexedFilesScanner(project2, startSuspended, true, Collections.singletonList(iterator2), null, indexingReason, ScanningType.FULL_ON_PROJECT_OPEN).queue(project2);
            }
            project2.putUserData(CONTENT_SCANNED, true);
        } else {
            new UnindexedFilesScanner(project2, startSuspended, true, null, null, indexingReason, ScanningType.FULL_ON_PROJECT_OPEN).queue(project2);
        }
    }

    void queue(@NotNull Project project2) {
        if (project2 == null) {
            UnindexedFilesScanner.$$$reportNull$$$0(24);
        }
        project2.getService(UnindexedFilesScannerExecutor.class).submitTask(this);
    }

    @Nullable
    List<IndexableFilesIterator> getPredefinedIndexableFilesIterators() {
        return this.myPredefinedIndexableFilesIterators;
    }

    static {
        CONTENT_SCANNED = Key.create("CONTENT_SCANNED");
        INDEX_UPDATE_IN_PROGRESS = Key.create("INDEX_UPDATE_IN_PROGRESS");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scanningType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldTask";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectIndexingHistory";
                break;
            }
            case 6: 
            case 9: 
            case 17: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markRef";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/UnindexedFilesScanner";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/UnindexedFilesScanner";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogScanningCompletedStageMessage";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "performScanningAndIndexing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryMergeWith";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "scan";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scanAndUpdateUnindexedFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLogScanningCompletedStageMessage";
                break;
            }
            case 12: 
            case 22: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isIndexUpdateInProgress";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isProjectContentFullyScanned";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectProviders";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectIndexableFilesConcurrently";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "performScanningAndIndexing";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "scanAndIndexProjectAfterOpen";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "queue";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 12, 22 -> new IllegalStateException(string2);
        };
    }

    private static final class CollectingIterator
    implements ContentIterator {
        private final Project project;
        private final PerProjectIndexingQueue.PerProviderSink perProviderSink;
        private final SubTaskProgressIndicator subTaskIndicator;
        private final List<// Could not load outer class - annotation placement on inner may be incorrect
        @NotNull IndexableFileScanner.IndexableFileVisitor> fileScannerVisitors;
        private final List<FilePropertyPusher<?>> pushers;
        private final List<FilePropertyPusherEx<?>> pusherExs;
        private final Object[] moduleValues;
        private final UnindexedFilesFinder unindexedFileFinder;
        private final ScanningStatistics scanningStatistics;
        private final PushedFilePropertiesUpdater pushedFilePropertiesUpdater;

        CollectingIterator(Project project2, SubTaskProgressIndicator subTaskIndicator, IndexableFilesIterator provider2, List<// Could not load outer class - annotation placement on inner may be incorrect
        @NotNull IndexableFileScanner.IndexableFileVisitor> fileScannerVisitors, UnindexedFilesFinder unindexedFileFinder, ScanningStatistics scanningStatistics, PerProjectIndexingQueue.PerProviderSink perProviderSink) {
            this.project = project2;
            this.subTaskIndicator = subTaskIndicator;
            this.fileScannerVisitors = fileScannerVisitors;
            this.unindexedFileFinder = unindexedFileFinder;
            this.scanningStatistics = scanningStatistics;
            this.pushedFilePropertiesUpdater = PushedFilePropertiesUpdater.getInstance(project2);
            this.perProviderSink = perProviderSink;
            IndexableSetOrigin origin = provider2.getOrigin();
            if (origin instanceof ModuleRootOrigin && !((ModuleRootOrigin)origin).getModule().isDisposed()) {
                this.pushers = FilePropertyPusher.EP_NAME.getExtensionList();
                this.pusherExs = null;
                this.moduleValues = ReadAction.compute(() -> PushedFilePropertiesUpdaterImpl.getModuleImmediateValues(this.pushers, ((ModuleRootOrigin)origin).getModule()));
            } else {
                this.pushers = null;
                SmartList extendedPushers = new SmartList();
                for (FilePropertyPusher<?> pusher : FilePropertyPusher.EP_NAME.getExtensionList()) {
                    if (!(pusher instanceof FilePropertyPusherEx) || !((FilePropertyPusherEx)pusher).acceptsOrigin(project2, origin)) continue;
                    extendedPushers.add((FilePropertyPusherEx)pusher);
                }
                if (extendedPushers.isEmpty()) {
                    this.pusherExs = null;
                    this.moduleValues = null;
                } else {
                    this.pusherExs = extendedPushers;
                    this.moduleValues = ReadAction.compute(() -> PushedFilePropertiesUpdaterImpl.getImmediateValuesEx(extendedPushers, origin));
                }
            }
        }

        @Override
        public boolean processFile(@NotNull VirtualFile fileOrDir) {
            if (fileOrDir == null) {
                CollectingIterator.$$$reportNull$$$0(0);
            }
            ProgressManager.checkCanceled();
            if (this.subTaskIndicator.isCanceled()) {
                return false;
            }
            try {
                this.processFileRethrowExceptions(fileOrDir);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Exception e) {
                LOG.error("Error while scanning " + fileOrDir.getPresentableUrl() + "\nTo reindex this file IDEA has to be restarted", e);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFileRethrowExceptions(@NotNull VirtualFile fileOrDir) {
            UnindexedFileStatus status;
            if (fileOrDir == null) {
                CollectingIterator.$$$reportNull$$$0(1);
            }
            long scanningStart = System.nanoTime();
            PushedFilePropertiesUpdaterImpl.applyScannersToFile(fileOrDir, this.fileScannerVisitors);
            if (this.pushers != null && this.pushedFilePropertiesUpdater instanceof PushedFilePropertiesUpdaterImpl) {
                ((PushedFilePropertiesUpdaterImpl)this.pushedFilePropertiesUpdater).applyPushersToFile(fileOrDir, this.pushers, this.moduleValues);
            } else if (this.pusherExs != null && this.pushedFilePropertiesUpdater instanceof PushedFilePropertiesUpdaterImpl) {
                ((PushedFilePropertiesUpdaterImpl)this.pushedFilePropertiesUpdater).applyPushersToFile(fileOrDir, this.pusherExs, this.moduleValues);
            }
            long statusTime = System.nanoTime();
            try {
                status = ourTestMode == TestMode.PUSHING ? null : this.unindexedFileFinder.getFileStatus(fileOrDir);
            }
            finally {
                statusTime = System.nanoTime() - statusTime;
            }
            if (status != null) {
                if (status.getShouldIndex() && ourTestMode == null) {
                    this.perProviderSink.addFile(fileOrDir);
                }
                this.scanningStatistics.addStatus(fileOrDir, status, statusTime, this.project);
            }
            this.scanningStatistics.addScanningTime(System.nanoTime() - scanningStart);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "fileOrDir";
            objectArray2[1] = "com/intellij/util/indexing/UnindexedFilesScanner$CollectingIterator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFileRethrowExceptions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum TestMode {
        PUSHING,
        PUSHING_AND_SCANNING;

    }
}

