/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.FilesScanningListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.indexing.UnindexedFilesScanner;
import com.intellij.util.indexing.UnindexedFilesScannerExecutor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/indexing/UnindexedFilesScannerAsDumbModeTaskWrapper;", "Lcom/intellij/openapi/project/DumbModeTask;", "task", "Lcom/intellij/util/indexing/UnindexedFilesScanner;", "runningTask", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/util/indexing/UnindexedFilesScanner;Ljava/util/concurrent/atomic/AtomicReference;)V", "getTask", "()Lcom/intellij/util/indexing/UnindexedFilesScanner;", "dispose", "", "performInDumbMode", "indicator", "tryMergeWith", "taskFromQueue", "Companion", "intellij.platform.lang.impl"})
@ApiStatus.Internal
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nUnindexedFilesScannerAsDumbModeTaskWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnindexedFilesScannerAsDumbModeTaskWrapper.kt\ncom/intellij/util/indexing/UnindexedFilesScannerAsDumbModeTaskWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,57:1\n1#2:58\n10#3:59\n*S KotlinDebug\n*F\n+ 1 UnindexedFilesScannerAsDumbModeTaskWrapper.kt\ncom/intellij/util/indexing/UnindexedFilesScannerAsDumbModeTaskWrapper\n*L\n19#1:59\n*E\n"})
public final class UnindexedFilesScannerAsDumbModeTaskWrapper
extends DumbModeTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @VisibleForTesting
    @NotNull
    private final UnindexedFilesScanner task;
    @NotNull
    private final AtomicReference<ProgressIndicator> runningTask;
    @NotNull
    private static final Logger LOG;

    public UnindexedFilesScannerAsDumbModeTaskWrapper(@NotNull UnindexedFilesScanner task2, @NotNull AtomicReference<ProgressIndicator> runningTask) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter(runningTask, (String)"runningTask");
        this.task = task2;
        this.runningTask = runningTask;
    }

    @NotNull
    public final UnindexedFilesScanner getTask() {
        return this.task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        MessageBus messageBus = this.task.myProject.getMessageBus();
        Topic topic = FilesScanningListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        FilesScanningListener publisher = (FilesScanningListener)messageBus.syncPublisher(topic);
        try {
            ProgressIndicator old;
            publisher.filesScanningStarted();
            try {
                old = this.runningTask.getAndSet(indicator);
                LOG.assertTrue(old == null, "Old = " + old);
                this.task.perform(indicator);
            }
            catch (Throwable throwable) {
                ProgressIndicator old2 = this.runningTask.getAndSet(null);
                LOG.assertTrue(old2 == indicator, "Old = " + old2);
                throw throwable;
            }
            old = this.runningTask.getAndSet(null);
            LOG.assertTrue(old == indicator, "Old = " + old);
        }
        finally {
            publisher.filesScanningFinished();
        }
    }

    @Override
    @Nullable
    public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
        Intrinsics.checkNotNullParameter((Object)taskFromQueue, (String)"taskFromQueue");
        if (taskFromQueue instanceof UnindexedFilesScannerAsDumbModeTaskWrapper) {
            UnindexedFilesScannerAsDumbModeTaskWrapper unindexedFilesScannerAsDumbModeTaskWrapper;
            UnindexedFilesScanner scanningTaskFromQueue = ((UnindexedFilesScannerAsDumbModeTaskWrapper)taskFromQueue).task;
            UnindexedFilesScanner merged = this.task.tryMergeWith(scanningTaskFromQueue);
            LOG.assertTrue(((UnindexedFilesScannerAsDumbModeTaskWrapper)taskFromQueue).runningTask == this.runningTask, "Should be the same object: " + this.runningTask + ", " + ((UnindexedFilesScannerAsDumbModeTaskWrapper)taskFromQueue).runningTask);
            UnindexedFilesScanner unindexedFilesScanner = merged;
            if (unindexedFilesScanner != null) {
                UnindexedFilesScanner it = unindexedFilesScanner;
                boolean bl = false;
                unindexedFilesScannerAsDumbModeTaskWrapper = new UnindexedFilesScannerAsDumbModeTaskWrapper(it, this.runningTask);
            } else {
                unindexedFilesScannerAsDumbModeTaskWrapper = null;
            }
            return unindexedFilesScannerAsDumbModeTaskWrapper;
        }
        return super.tryMergeWith(taskFromQueue);
    }

    @Override
    public void dispose() {
        Disposer.dispose(this.task);
        super.dispose();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UnindexedFilesScannerExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/indexing/UnindexedFilesScannerAsDumbModeTaskWrapper$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

