/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.FilesScanningListener;
import com.intellij.openapi.project.MergeableQueueTask;
import com.intellij.openapi.project.MergingQueueGuiExecutor;
import com.intellij.openapi.project.MergingTaskQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.UnindexedFilesScanner;
import com.intellij.util.indexing.UnindexedFilesScannerAsDumbModeTaskWrapper;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.PROJECT})
public final class UnindexedFilesScannerExecutor
extends MergingQueueGuiExecutor<UnindexedFilesScanner>
implements Disposable {
    private static final Logger LOG = Logger.getInstance(UnindexedFilesScannerExecutor.class);
    private final AtomicReference<ProgressIndicator> runningTask = new AtomicReference();

    @NotNull
    public static UnindexedFilesScannerExecutor getInstance(@NotNull Project project2) {
        if (project2 == null) {
            UnindexedFilesScannerExecutor.$$$reportNull$$$0(0);
        }
        UnindexedFilesScannerExecutor unindexedFilesScannerExecutor = project2.getService(UnindexedFilesScannerExecutor.class);
        if (unindexedFilesScannerExecutor == null) {
            UnindexedFilesScannerExecutor.$$$reportNull$$$0(1);
        }
        return unindexedFilesScannerExecutor;
    }

    public UnindexedFilesScannerExecutor(Project project2) {
        super(project2, new MergingTaskQueue(), (MergingQueueGuiExecutor.ExecutorStateListener)new TaskQueueListener(project2), IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]), IndexingBundle.message((String)"progress.indexing.scanning.paused", (Object[])new Object[0]));
    }

    public void submitTask(UnindexedFilesScanner task2) {
        if (task2.isFullIndexUpdate()) {
            this.getTaskQueue().cancelAllTasks();
            this.cancelRunningTask();
        }
        if (UnindexedFilesScanner.shouldScanInSmartMode()) {
            this.startTaskInSmartMode(task2);
        } else {
            this.startTaskInDumbMode(task2);
        }
    }

    private void startTaskInSmartMode(@NotNull UnindexedFilesScanner task2) {
        if (task2 == null) {
            UnindexedFilesScannerExecutor.$$$reportNull$$$0(2);
        }
        this.getTaskQueue().addTask((MergeableQueueTask)task2);
        this.startBackgroundProcess();
    }

    private void startTaskInDumbMode(@NotNull UnindexedFilesScanner task2) {
        if (task2 == null) {
            UnindexedFilesScannerExecutor.$$$reportNull$$$0(3);
        }
        this.wrapAsDumbTask(task2).queue(this.getProject());
    }

    @NotNull
    @VisibleForTesting
    DumbModeTask wrapAsDumbTask(@NotNull UnindexedFilesScanner task2) {
        if (task2 == null) {
            UnindexedFilesScannerExecutor.$$$reportNull$$$0(4);
        }
        return new UnindexedFilesScannerAsDumbModeTaskWrapper(task2, this.runningTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runSingleTask(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull MergingTaskQueue.QueuedTask<UnindexedFilesScanner> task2, @Nullable StructuredIdeActivity activity) {
        if (task2 == null) {
            UnindexedFilesScannerExecutor.$$$reportNull$$$0(5);
        }
        ProgressIndicatorEx indicator = task2.getIndicator();
        ProgressIndicator old = this.runningTask.getAndSet(indicator);
        try {
            LOG.assertTrue(old == null, "Old = " + old);
            this.runningTask.set(indicator);
            super.runSingleTask(task2, activity);
        }
        catch (Throwable throwable) {
            old = this.runningTask.getAndSet(null);
            LOG.assertTrue(old == indicator, "Old = " + old);
            throw throwable;
        }
        old = this.runningTask.getAndSet(null);
        LOG.assertTrue(old == indicator, "Old = " + old);
    }

    private void cancelRunningTask() {
        ProgressIndicator indicator = this.runningTask.get();
        if (indicator != null) {
            indicator.cancel();
            ProgressSuspender suspender = ProgressSuspender.getSuspender((ProgressIndicator)indicator);
            if (suspender != null && suspender.isSuspended()) {
                suspender.resumeProcess();
            }
        }
    }

    public void cancelAllTasksAndWait() {
        this.getTaskQueue().cancelAllTasks();
        this.cancelRunningTask();
        while (this.isRunning()) {
            PingProgress.interactWithEdtProgress();
            LockSupport.parkNanos(50000000L);
        }
    }

    @Override
    public void dispose() {
        this.getTaskQueue().disposePendingTasks();
    }

    public void suspendScanningAndIndexingThenRun(@NotNull @NlsContexts.ProgressText String activityName, @NotNull Runnable runnable) {
        if (activityName == null) {
            UnindexedFilesScannerExecutor.$$$reportNull$$$0(6);
        }
        if (runnable == null) {
            UnindexedFilesScannerExecutor.$$$reportNull$$$0(7);
        }
        this.suspendAndRun(activityName, () -> DumbService.getInstance(this.getProject()).suspendIndexingAndRun(activityName, runnable));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/UnindexedFilesScannerExecutor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/UnindexedFilesScannerExecutor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startTaskInSmartMode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startTaskInDumbMode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrapAsDumbTask";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runSingleTask";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suspendScanningAndIndexingThenRun";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    private static class TaskQueueListener
    implements MergingQueueGuiExecutor.ExecutorStateListener {
        private final FilesScanningListener projectLevelEventPublisher;
        private final Project project;

        private TaskQueueListener(Project project2) {
            this.project = project2;
            this.projectLevelEventPublisher = (FilesScanningListener)project2.getMessageBus().syncPublisher(FilesScanningListener.TOPIC);
        }

        public boolean beforeFirstTask() {
            this.projectLevelEventPublisher.filesScanningStarted();
            return true;
        }

        public void afterLastTask() {
            if (this.project.isDisposed()) {
                return;
            }
            this.projectLevelEventPublisher.filesScanningFinished();
        }
    }
}

