/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.UnindexedFilesScanner;
import com.intellij.util.indexing.dependenciesCache.DependenciesIndexedStatusService;
import com.intellij.util.indexing.diagnostic.ScanningType;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnindexedFilesUpdater {
    private static final Logger LOG = Logger.getInstance(UnindexedFilesUpdater.class);
    private static final boolean useConservativeThreadCountPolicy = SystemProperties.getBooleanProperty("idea.indexing.use.conservative.thread.count.policy", false);
    private static final int DEFAULT_MAX_INDEXER_THREADS = 4;
    private static final int INDEXER_THREAD_COUNT = SystemProperties.getIntProperty("caches.indexerThreadsCount", -1);
    @NotNull
    private final Project myProject;
    private final boolean myStartSuspended;
    private final boolean myOnProjectOpen;
    @Nullable
    private final String myIndexingReason;
    @NotNull
    private final ScanningType myScanningType;
    @Nullable
    private final DependenciesIndexedStatusService.StatusMark myMark;
    @Nullable
    private final List<IndexableFilesIterator> myPredefinedIndexableFilesIterators;

    public UnindexedFilesUpdater(@NotNull Project project2, boolean startSuspended, boolean onProjectOpen, @Nullable List<IndexableFilesIterator> predefinedIndexableFilesIterators, @Nullable DependenciesIndexedStatusService.StatusMark mark, @Nullable @NonNls String indexingReason, @NotNull ScanningType scanningType2) {
        if (project2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(0);
        }
        if (scanningType2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myStartSuspended = startSuspended;
        this.myOnProjectOpen = onProjectOpen;
        this.myIndexingReason = indexingReason;
        this.myScanningType = scanningType2;
        this.myMark = mark;
        this.myPredefinedIndexableFilesIterators = predefinedIndexableFilesIterators;
        LOG.assertTrue(this.myPredefinedIndexableFilesIterators == null || !this.myPredefinedIndexableFilesIterators.isEmpty());
        if (indexingReason == null) {
            LOG.warn("Please provide an indexing reason (was provided 'null')");
        }
    }

    @Deprecated
    public UnindexedFilesUpdater(@NotNull Project project2) {
        if (project2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(2);
        }
        this(project2, false, false, null, null, null, ScanningType.FULL);
    }

    public UnindexedFilesUpdater(@NotNull Project project2, @Nullable @NonNls String indexingReason) {
        if (project2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(3);
        }
        this(project2, false, false, null, null, indexingReason, ScanningType.FULL);
    }

    public UnindexedFilesUpdater(@NotNull Project project2, @Nullable List<IndexableFilesIterator> predefinedIndexableFilesIterators, @Nullable DependenciesIndexedStatusService.StatusMark mark, @Nullable @NonNls String indexingReason) {
        if (project2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(4);
        }
        this(project2, false, false, predefinedIndexableFilesIterators, mark, indexingReason, predefinedIndexableFilesIterators == null ? ScanningType.FULL : ScanningType.PARTIAL);
    }

    public void queue() {
        new UnindexedFilesScanner(this.myProject, this.myStartSuspended, this.myOnProjectOpen, this.myPredefinedIndexableFilesIterators, this.myMark, this.myIndexingReason, this.myScanningType).queue(this.myProject);
    }

    public static int getNumberOfIndexingThreads() {
        int threadCount = INDEXER_THREAD_COUNT;
        if (threadCount <= 0) {
            threadCount = Math.max(1, Math.min(useConservativeThreadCountPolicy ? 4 : UnindexedFilesUpdater.getMaxBackgroundThreadCount(), UnindexedFilesUpdater.getMaxBackgroundThreadCount()));
        }
        return threadCount;
    }

    public static int getMaxNumberOfIndexingThreads() {
        int threadCount = INDEXER_THREAD_COUNT;
        return Math.max(1, threadCount <= 0 ? UnindexedFilesUpdater.getMaxBackgroundThreadCount() : threadCount);
    }

    public static int getNumberOfScanningThreads() {
        int scanningThreadCount = Registry.intValue("caches.scanningThreadsCount");
        if (scanningThreadCount > 0) {
            return scanningThreadCount;
        }
        int maxBackgroundThreadCount = UnindexedFilesUpdater.getMaxBackgroundThreadCount();
        return Math.max(maxBackgroundThreadCount, UnindexedFilesUpdater.getNumberOfIndexingThreads());
    }

    private static int getMaxBackgroundThreadCount() {
        int coresToLeaveForOtherActivity = DumbServiceImpl.ALWAYS_SMART ? UnindexedFilesUpdater.getMaxNumberOfIndexingThreads() : (ApplicationManager.getApplication().isCommandLine() ? 0 : 1);
        return Runtime.getRuntime().availableProcessors() - coresToLeaveForOtherActivity;
    }

    public static boolean isIndexUpdateInProgress(@NotNull Project project2) {
        if (project2 == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(5);
        }
        return UnindexedFilesScanner.isIndexUpdateInProgress(project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scanningType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/UnindexedFilesUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isIndexUpdateInProgress";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

