/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.contentQueue;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.CachedFileType;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileIndexesValuesApplier;
import com.intellij.util.indexing.IndexingFlag;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.contentQueue.CachedFileContent;
import com.intellij.util.indexing.contentQueue.CachedFileContentLoader;
import com.intellij.util.indexing.contentQueue.CurrentProjectHintedCachedFileContentLoader;
import com.intellij.util.indexing.contentQueue.FailedToLoadContentException;
import com.intellij.util.indexing.contentQueue.TooLargeContentException;
import com.intellij.util.indexing.diagnostic.IndexingFileSetStatistics;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl;
import com.intellij.util.indexing.roots.IndexableFilesDeduplicateFilter;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.io.FileNotFoundException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IndexUpdateRunner {
    private static final Logger LOG = Logger.getInstance(IndexUpdateRunner.class);
    private static final long SOFT_MAX_TOTAL_BYTES_LOADED_INTO_MEMORY = 0x1400000L;
    private static final CopyOnWriteArrayList<IndexingJob> ourIndexingJobs = new CopyOnWriteArrayList();
    private static final ExecutorService GLOBAL_INDEXING_EXECUTOR = AppExecutorUtil.createBoundedApplicationPoolExecutor("Indexing", UnindexedFilesUpdater.getMaxNumberOfIndexingThreads());
    private final FileBasedIndexImpl myFileBasedIndex;
    private final ExecutorService myIndexingExecutor;
    private final int myNumberOfIndexingThreads;
    private final AtomicInteger myIndexingAttemptCount;
    private final AtomicInteger myIndexingSuccessfulCount;
    private final boolean WRITE_INDEXES_ON_SEPARATE_THREAD;
    private final ExecutorService myIndexWriteExecutor;
    private static long ourTotalBytesLoadedIntoMemory = 0L;
    private static final Lock ourLoadedBytesLimitLock = new ReentrantLock();
    private static final Condition ourLoadedBytesAreReleasedCondition = ourLoadedBytesLimitLock.newCondition();

    public IndexUpdateRunner(@NotNull FileBasedIndexImpl fileBasedIndex, int numberOfIndexingThreads) {
        if (fileBasedIndex == null) {
            IndexUpdateRunner.$$$reportNull$$$0(0);
        }
        this.myIndexingAttemptCount = new AtomicInteger();
        this.myIndexingSuccessfulCount = new AtomicInteger();
        this.WRITE_INDEXES_ON_SEPARATE_THREAD = Boolean.getBoolean("idea.write.indexes.on.separate.thread");
        this.myIndexWriteExecutor = this.WRITE_INDEXES_ON_SEPARATE_THREAD ? SequentialTaskExecutor.createSequentialApplicationPoolExecutor("Index Write Thread") : null;
        this.myFileBasedIndex = fileBasedIndex;
        this.myIndexingExecutor = GLOBAL_INDEXING_EXECUTOR;
        this.myNumberOfIndexingThreads = numberOfIndexingThreads;
    }

    public void indexFiles(@NotNull Project project2, @NotNull List<FileSet> fileSets, @NotNull ProgressIndicator indicator, @NotNull ProjectIndexingHistoryImpl projectIndexingHistory) throws IndexingInterruptedException {
        if (project2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(1);
        }
        if (fileSets == null) {
            IndexUpdateRunner.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            IndexUpdateRunner.$$$reportNull$$$0(3);
        }
        if (projectIndexingHistory == null) {
            IndexUpdateRunner.$$$reportNull$$$0(4);
        }
        long startTime = System.nanoTime();
        try {
            this.doIndexFiles(project2, fileSets, indicator);
        }
        catch (RuntimeException e) {
            try {
                throw new IndexingInterruptedException(e);
            }
            catch (Throwable throwable) {
                long visibleProcessingTime = System.nanoTime() - startTime;
                long totalProcessingTimeInAllThreads = fileSets.stream().mapToLong(b -> b.statistics.getProcessingTimeInAllThreads()).sum();
                projectIndexingHistory.setVisibleTimeToAllThreadsTimeRatio(totalProcessingTimeInAllThreads == 0L ? 0.0 : (double)visibleProcessingTime / (double)totalProcessingTimeInAllThreads);
                if (this.myIndexWriteExecutor != null) {
                    ProgressIndicatorUtils.awaitWithCheckCanceled(this.myIndexWriteExecutor.submit(EmptyRunnable.getInstance()));
                }
                throw throwable;
            }
        }
        long visibleProcessingTime = System.nanoTime() - startTime;
        long totalProcessingTimeInAllThreads = fileSets.stream().mapToLong(b -> b.statistics.getProcessingTimeInAllThreads()).sum();
        projectIndexingHistory.setVisibleTimeToAllThreadsTimeRatio(totalProcessingTimeInAllThreads == 0L ? 0.0 : (double)visibleProcessingTime / (double)totalProcessingTimeInAllThreads);
        if (this.myIndexWriteExecutor != null) {
            ProgressIndicatorUtils.awaitWithCheckCanceled(this.myIndexWriteExecutor.submit(EmptyRunnable.getInstance()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIndexFiles(@NotNull Project project2, @NotNull List<FileSet> fileSets, @NotNull ProgressIndicator indicator) {
        if (project2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(5);
        }
        if (fileSets == null) {
            IndexUpdateRunner.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            IndexUpdateRunner.$$$reportNull$$$0(7);
        }
        if (ContainerUtil.and(fileSets, b -> b.files.isEmpty())) {
            return;
        }
        indicator.checkCanceled();
        indicator.setIndeterminate(false);
        CurrentProjectHintedCachedFileContentLoader contentLoader = new CurrentProjectHintedCachedFileContentLoader(project2);
        ProgressIndicator originalIndicator = IndexUpdateRunner.unwrapAll(indicator);
        ProgressSuspender originalSuspender = ProgressSuspender.getSuspender((ProgressIndicator)originalIndicator);
        IndexingJob indexingJob = new IndexingJob(project2, indicator, contentLoader, fileSets, originalIndicator, originalSuspender);
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            while (!indexingJob.areAllFilesProcessed()) {
                this.indexOneFileOfJob(indexingJob);
            }
        } else {
            ourIndexingJobs.add(indexingJob);
            try {
                Throwable error2;
                AtomicInteger numberOfRunningWorkers = new AtomicInteger();
                Runnable worker = () -> {
                    try {
                        this.indexJobsFairly();
                    }
                    finally {
                        numberOfRunningWorkers.decrementAndGet();
                    }
                };
                for (int i2 = 0; i2 < this.myNumberOfIndexingThreads; ++i2) {
                    this.myIndexingExecutor.execute(worker);
                    numberOfRunningWorkers.incrementAndGet();
                }
                while (!project2.isDisposed() && !indexingJob.areAllFilesProcessed() && indexingJob.myError.get() == null) {
                    indicator.checkCanceled();
                    int toAddWorkersNumber = this.myNumberOfIndexingThreads - numberOfRunningWorkers.get();
                    for (int i3 = 0; i3 < toAddWorkersNumber; ++i3) {
                        this.myIndexingExecutor.execute(worker);
                        numberOfRunningWorkers.incrementAndGet();
                    }
                    try {
                        if (!indexingJob.myAllFilesAreProcessedLatch.await(100L, TimeUnit.MILLISECONDS)) continue;
                        break;
                    }
                    catch (InterruptedException e) {
                        throw new ProcessCanceledException(e);
                    }
                }
                if ((error2 = indexingJob.myError.get()) instanceof ProcessCanceledException) {
                    ProcessCanceledException pce = new ProcessCanceledException();
                    pce.addSuppressed(error2);
                    throw pce;
                }
                if (error2 != null) {
                    throw new RuntimeException("Indexing of " + project2.getName() + " has failed", error2);
                }
            }
            finally {
                ourIndexingJobs.remove(indexingJob);
            }
        }
    }

    private void indexJobsFairly() {
        while (!ourIndexingJobs.isEmpty()) {
            boolean allJobsAreSuspended = true;
            for (IndexingJob job2 : ourIndexingJobs) {
                ProgressIndicator jobIndicator = job2.myIndicator;
                if (job2.myProject.isDisposed() || job2.myNoMoreFilesInQueue.get() || jobIndicator.isCanceled() || job2.myError.get() != null) {
                    ourIndexingJobs.remove(job2);
                    allJobsAreSuspended = false;
                    continue;
                }
                ProgressSuspender suspender = job2.myOriginalProgressSuspender;
                if (suspender != null && suspender.isSuspended()) continue;
                allJobsAreSuspended = false;
                try {
                    Runnable work = () -> this.indexOneFileOfJob(job2);
                    if (suspender != null) {
                        suspender.executeNonSuspendableSection(job2.myOriginalProgressIndicator, work);
                        continue;
                    }
                    work.run();
                }
                catch (Throwable e) {
                    job2.myError.compareAndSet(null, e);
                    ourIndexingJobs.remove(job2);
                }
            }
            if (!allJobsAreSuspended) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    private void indexOneFileOfJob(@NotNull IndexingJob indexingJob) throws ProcessCanceledException {
        ContentLoadingResult loadingResult;
        if (indexingJob == null) {
            IndexUpdateRunner.$$$reportNull$$$0(8);
        }
        long startTime = System.nanoTime();
        FileIndexingJob fileIndexingJob = indexingJob.myQueueOfFiles.poll();
        if (fileIndexingJob == null) {
            indexingJob.myNoMoreFilesInQueue.set(true);
            return;
        }
        VirtualFile file2 = fileIndexingJob.file;
        try {
            loadingResult = this.loadContent(indexingJob.myIndicator, file2, indexingJob.myContentLoader);
        }
        catch (ProcessCanceledException e) {
            indexingJob.myQueueOfFiles.add(fileIndexingJob);
            throw e;
        }
        catch (TooLargeContentException e) {
            IndexingFileSetStatistics statistics;
            indexingJob.oneMoreFileProcessed();
            IndexingFileSetStatistics indexingFileSetStatistics = statistics = indexingJob.getStatistics(fileIndexingJob);
            synchronized (indexingFileSetStatistics) {
                statistics.addTooLargeForIndexingFile(e.getFile());
            }
            FileBasedIndexImpl.LOG.info("File: " + e.getFile().getUrl() + " is too large for indexing");
            return;
        }
        catch (FailedToLoadContentException e) {
            indexingJob.oneMoreFileProcessed();
            IndexUpdateRunner.logFailedToLoadContentException(e);
            return;
        }
        finally {
            long contentLoadingTime = System.nanoTime() - startTime;
        }
        CachedFileContent fileContent = loadingResult.cachedFileContent;
        long length = loadingResult.fileLength;
        if (file2.isDirectory()) {
            LOG.info("Directory was passed for indexing unexpectedly: " + file2.getPath());
        }
        try {
            long contentLoadingTime;
            indexingJob.setLocationBeingIndexed(fileIndexingJob);
            @NotNull @NotNull Supplier fileTypeChangeChecker = CachedFileType.getFileTypeChangeChecker();
            FileType type = FileTypeRegistry.getInstance().getFileTypeByFile(file2, fileContent.getBytes());
            FileIndexesValuesApplier applier = ReadAction.nonBlocking(() -> this.lambda$indexOneFileOfJob$4((Supplier)fileTypeChangeChecker, type, indexingJob, fileContent)).expireWith(indexingJob.myProject).wrapProgress(indexingJob.myIndicator).executeSynchronously();
            this.myIndexingSuccessfulCount.incrementAndGet();
            if (LOG.isTraceEnabled() && this.myIndexingSuccessfulCount.longValue() % 10000L == 0L) {
                LOG.trace("File indexing attempts = " + this.myIndexingAttemptCount.longValue() + ", indexed file count = " + this.myIndexingSuccessfulCount.longValue());
            }
            this.writeIndexesForFile(indexingJob, fileIndexingJob, applier, startTime, length, contentLoadingTime);
        }
        catch (ProcessCanceledException e) {
            indexingJob.myQueueOfFiles.add(fileIndexingJob);
            IndexUpdateRunner.releaseFile(file2, length);
            throw e;
        }
        catch (Throwable e) {
            indexingJob.oneMoreFileProcessed();
            IndexUpdateRunner.releaseFile(file2, length);
            FileBasedIndexImpl.LOG.error("Error while indexing " + file2.getPresentableUrl() + "\nTo reindex this file IDEA has to be restarted", e);
        }
    }

    private void writeIndexesForFile(@NotNull IndexingJob indexingJob, @NotNull FileIndexingJob fileIndexingJob, @NotNull FileIndexesValuesApplier applier, long startTime, long length, long l) {
        if (indexingJob == null) {
            IndexUpdateRunner.$$$reportNull$$$0(9);
        }
        if (fileIndexingJob == null) {
            IndexUpdateRunner.$$$reportNull$$$0(10);
        }
        if (applier == null) {
            IndexUpdateRunner.$$$reportNull$$$0(11);
        }
        if (this.myIndexWriteExecutor != null) {
            this.myIndexWriteExecutor.execute(() -> IndexUpdateRunner.lambda$writeIndexesForFile$5(indexingJob, fileIndexingJob, applier, startTime, length, (long)contentLoadingTime));
        } else {
            IndexUpdateRunner.doWriteIndexesForFile(indexingJob, fileIndexingJob, applier, startTime, length, (long)contentLoadingTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void doWriteIndexesForFile(@NotNull IndexingJob indexingJob, @NotNull FileIndexingJob fileIndexingJob, @NotNull FileIndexesValuesApplier applier, long startTime, long length, long l) {
        if (indexingJob == null) {
            IndexUpdateRunner.$$$reportNull$$$0(12);
        }
        if (fileIndexingJob == null) {
            IndexUpdateRunner.$$$reportNull$$$0(13);
        }
        if (applier == null) {
            IndexUpdateRunner.$$$reportNull$$$0(14);
        }
        VirtualFile file2 = fileIndexingJob.file;
        try {
            IndexingFileSetStatistics statistics;
            applier.apply(file2);
            long processingTime = System.nanoTime() - startTime;
            IndexingFileSetStatistics indexingFileSetStatistics = statistics = indexingJob.getStatistics(fileIndexingJob);
            synchronized (indexingFileSetStatistics) {
                void contentLoadingTime;
                statistics.addFileStatistics(file2, applier.stats, processingTime, (long)contentLoadingTime, length, applier.isWriteValuesSeparately, applier.getSeparateApplicationTimeNanos());
            }
            indexingJob.oneMoreFileProcessed();
        }
        finally {
            IndexUpdateRunner.releaseFile(file2, length);
        }
    }

    private static void releaseFile(VirtualFile file2, long length) {
        IndexUpdateRunner.signalThatFileIsUnloaded(length);
        IndexingStamp.flushCache(FileBasedIndex.getFileId((VirtualFile)file2));
        IndexingFlag.unlockFile(file2);
    }

    @NotNull
    private ContentLoadingResult loadContent(@NotNull ProgressIndicator indicator, @NotNull VirtualFile file2, @NotNull CachedFileContentLoader loader) throws TooLargeContentException, FailedToLoadContentException {
        long fileLength;
        if (indicator == null) {
            IndexUpdateRunner.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(16);
        }
        if (loader == null) {
            IndexUpdateRunner.$$$reportNull$$$0(17);
        }
        if (this.myFileBasedIndex.isTooLarge(file2)) {
            throw new TooLargeContentException(file2);
        }
        try {
            fileLength = file2.getLength();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new FailedToLoadContentException(file2, e);
        }
        IndexUpdateRunner.waitForFreeMemoryToLoadFileContent(indicator, fileLength);
        try {
            CachedFileContent fileContent = loader.loadContent(file2);
            return new ContentLoadingResult(fileContent, fileLength);
        }
        catch (Throwable e) {
            IndexUpdateRunner.signalThatFileIsUnloaded(fileLength);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForFreeMemoryToLoadFileContent(@NotNull ProgressIndicator indicator, long fileLength) throws ProcessCanceledException {
        if (indicator == null) {
            IndexUpdateRunner.$$$reportNull$$$0(18);
        }
        ourLoadedBytesLimitLock.lock();
        try {
            while (ourTotalBytesLoadedIntoMemory >= 0x1400000L) {
                indicator.checkCanceled();
                try {
                    ourLoadedBytesAreReleasedCondition.await(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException(e);
                }
            }
            ourTotalBytesLoadedIntoMemory += fileLength;
        }
        finally {
            ourLoadedBytesLimitLock.unlock();
        }
    }

    private static void signalThatFileIsUnloaded(long fileLength) {
        ourLoadedBytesLimitLock.lock();
        try {
            assert (ourTotalBytesLoadedIntoMemory >= fileLength);
            if ((ourTotalBytesLoadedIntoMemory -= fileLength) < 0x1400000L) {
                ourLoadedBytesAreReleasedCondition.signalAll();
            }
        }
        finally {
            ourLoadedBytesLimitLock.unlock();
        }
    }

    private static void logFailedToLoadContentException(@NotNull FailedToLoadContentException e) {
        if (e == null) {
            IndexUpdateRunner.$$$reportNull$$$0(19);
        }
        Throwable cause = e.getCause();
        VirtualFile file2 = e.getFile();
        String fileUrl = "File: " + file2.getUrl();
        if (cause instanceof FileNotFoundException || cause instanceof NoSuchFileException) {
            FileBasedIndexImpl.LOG.debug(fileUrl, e);
        } else if (cause instanceof IndexOutOfBoundsException || cause instanceof InvalidVirtualFileAccessException) {
            FileBasedIndexImpl.LOG.info(fileUrl, e);
        } else {
            FileBasedIndexImpl.LOG.error(fileUrl, e);
        }
    }

    @NotNull
    @NlsSafe
    public static String getPresentableLocationBeingIndexed(@NotNull Project project2, @NotNull VirtualFile file2) {
        String path2;
        VirtualFile actualFile;
        if (project2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(20);
        }
        if (file2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(21);
        }
        if ((actualFile = file2).getFileSystem() instanceof ArchiveFileSystem) {
            actualFile = VfsUtil.getLocalFile(actualFile);
        }
        path2 = "/".equals(path2 = IndexUpdateRunner.getProjectRelativeOrAbsolutePath(project2, actualFile)) ? actualFile.getName() : path2;
        String string2 = FileUtil.toSystemDependentName(path2);
        if (string2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(22);
        }
        return string2;
    }

    @NotNull
    private static String getProjectRelativeOrAbsolutePath(@NotNull Project project2, @NotNull VirtualFile file2) {
        String filePath;
        String projectBase;
        if (project2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(23);
        }
        if (file2 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(24);
        }
        if (StringUtil.isNotEmpty(projectBase = project2.getBasePath()) && FileUtil.isAncestor(projectBase, filePath = file2.getPath(), true)) {
            String projectDirName = PathUtil.getFileName(projectBase);
            String relativePath = FileUtil.getRelativePath(projectBase, filePath, '/');
            if (StringUtil.isNotEmpty(projectDirName) && StringUtil.isNotEmpty(relativePath)) {
                String string2 = projectDirName + "/" + relativePath;
                if (string2 == null) {
                    IndexUpdateRunner.$$$reportNull$$$0(25);
                }
                return string2;
            }
        }
        String string3 = file2.getPath();
        if (string3 == null) {
            IndexUpdateRunner.$$$reportNull$$$0(26);
        }
        return string3;
    }

    @NotNull
    private static ProgressIndicator unwrapAll(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            IndexUpdateRunner.$$$reportNull$$$0(27);
        }
        while (indicator instanceof WrappedProgressIndicator) {
            indicator = ((WrappedProgressIndicator)indicator).getOriginalProgressIndicator();
        }
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator == null) {
            IndexUpdateRunner.$$$reportNull$$$0(28);
        }
        return progressIndicator;
    }

    private static /* synthetic */ void lambda$writeIndexesForFile$5(IndexingJob indexingJob, FileIndexingJob fileIndexingJob, FileIndexesValuesApplier applier, long startTime, long length, long contentLoadingTime) {
        IndexUpdateRunner.doWriteIndexesForFile(indexingJob, fileIndexingJob, applier, startTime, length, contentLoadingTime);
    }

    private /* synthetic */ FileIndexesValuesApplier lambda$indexOneFileOfJob$4(Supplier fileTypeChangeChecker, FileType type, IndexingJob indexingJob, CachedFileContent fileContent) throws Exception {
        this.myIndexingAttemptCount.incrementAndGet();
        FileType fileType = (Boolean)fileTypeChangeChecker.get() != false ? type : null;
        return this.myFileBasedIndex.indexFileContent(indexingJob.myProject, fileContent, fileType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 22, 25, 26, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBasedIndex";
                break;
            }
            case 1: 
            case 5: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSets";
                break;
            }
            case 3: 
            case 7: 
            case 15: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectIndexingHistory";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingJob";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndexingJob";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applier";
                break;
            }
            case 16: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 22: 
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/contentQueue/IndexUpdateRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/contentQueue/IndexUpdateRunner";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableLocationBeingIndexed";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRelativeOrAbsolutePath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "indexFiles";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doIndexFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "indexOneFileOfJob";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeIndexesForFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doWriteIndexesForFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadContent";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "waitForFreeMemoryToLoadFileContent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "logFailedToLoadContentException";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableLocationBeingIndexed";
                break;
            }
            case 22: 
            case 25: 
            case 26: 
            case 28: {
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRelativeOrAbsolutePath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAll";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 22, 25, 26, 28 -> new IllegalStateException(string2);
        };
    }

    public static class IndexingInterruptedException
    extends Exception {
        public IndexingInterruptedException(@NotNull Throwable cause) {
            if (cause == null) {
                IndexingInterruptedException.$$$reportNull$$$0(0);
            }
            super(cause);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "com/intellij/util/indexing/contentQueue/IndexUpdateRunner$IndexingInterruptedException", "<init>"));
        }
    }

    private static class IndexingJob {
        final Project myProject;
        final CachedFileContentLoader myContentLoader;
        final ArrayBlockingQueue<FileIndexingJob> myQueueOfFiles;
        final ProgressIndicator myIndicator;
        final int myTotalFiles;
        final AtomicBoolean myNoMoreFilesInQueue;
        final CountDownLatch myAllFilesAreProcessedLatch;
        final ProgressIndicator myOriginalProgressIndicator;
        @Nullable
        final ProgressSuspender myOriginalProgressSuspender;
        final AtomicReference<Throwable> myError;

        IndexingJob(@NotNull Project project2, @NotNull ProgressIndicator indicator, @NotNull CachedFileContentLoader contentLoader, @NotNull List<FileSet> fileSets, @NotNull ProgressIndicator originalProgressIndicator, @Nullable ProgressSuspender originalProgressSuspender) {
            if (project2 == null) {
                IndexingJob.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                IndexingJob.$$$reportNull$$$0(1);
            }
            if (contentLoader == null) {
                IndexingJob.$$$reportNull$$$0(2);
            }
            if (fileSets == null) {
                IndexingJob.$$$reportNull$$$0(3);
            }
            if (originalProgressIndicator == null) {
                IndexingJob.$$$reportNull$$$0(4);
            }
            this.myNoMoreFilesInQueue = new AtomicBoolean();
            this.myError = new AtomicReference();
            this.myProject = project2;
            this.myIndicator = indicator;
            int maxFilesCount = fileSets.stream().mapToInt(fileSet -> fileSet.files.size()).sum();
            this.myQueueOfFiles = new ArrayBlockingQueue(maxFilesCount);
            IndexableFilesDeduplicateFilter deduplicateFilter = IndexableFilesDeduplicateFilter.create();
            for (FileSet fileSet2 : fileSets) {
                for (VirtualFile file2 : fileSet2.files) {
                    if (!deduplicateFilter.accept(file2)) continue;
                    this.myQueueOfFiles.add(new FileIndexingJob(file2, fileSet2));
                }
            }
            this.myTotalFiles = this.myQueueOfFiles.size();
            this.myContentLoader = contentLoader;
            this.myAllFilesAreProcessedLatch = new CountDownLatch(this.myTotalFiles);
            this.myOriginalProgressIndicator = originalProgressIndicator;
            this.myOriginalProgressSuspender = originalProgressSuspender;
        }

        @NotNull
        public IndexingFileSetStatistics getStatistics(@NotNull FileIndexingJob fileIndexingJob) {
            if (fileIndexingJob == null) {
                IndexingJob.$$$reportNull$$$0(5);
            }
            IndexingFileSetStatistics indexingFileSetStatistics = fileIndexingJob.fileSet.statistics;
            if (indexingFileSetStatistics == null) {
                IndexingJob.$$$reportNull$$$0(6);
            }
            return indexingFileSetStatistics;
        }

        public void oneMoreFileProcessed() {
            this.myAllFilesAreProcessedLatch.countDown();
            double newFraction = 1.0 - (double)this.myAllFilesAreProcessedLatch.getCount() / (double)this.myTotalFiles;
            try {
                this.myIndicator.setFraction(newFraction);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        boolean areAllFilesProcessed() {
            return this.myAllFilesAreProcessedLatch.getCount() == 0L;
        }

        public void setLocationBeingIndexed(@NotNull FileIndexingJob fileIndexingJob) {
            if (fileIndexingJob == null) {
                IndexingJob.$$$reportNull$$$0(7);
            }
            String presentableLocation = IndexUpdateRunner.getPresentableLocationBeingIndexed(this.myProject, fileIndexingJob.file);
            if (this.myIndicator instanceof SubTaskProgressIndicator) {
                this.myIndicator.setText(presentableLocation);
            } else {
                FileSet fileSet = fileIndexingJob.fileSet;
                if (fileSet.progressText != null && !fileSet.progressText.equals(this.myIndicator.getText())) {
                    this.myIndicator.setText(fileSet.progressText);
                }
                this.myIndicator.setText2(presentableLocation);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentLoader";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileSets";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalProgressIndicator";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileIndexingJob";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/contentQueue/IndexUpdateRunner$IndexingJob";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/contentQueue/IndexUpdateRunner$IndexingJob";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatistics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatistics";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setLocationBeingIndexed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 6 -> new IllegalStateException(string2);
            };
        }
    }

    private record FileIndexingJob(VirtualFile file, FileSet fileSet) {
    }

    private record ContentLoadingResult(@NotNull CachedFileContent cachedFileContent, long fileLength) {
        @NotNull
        private final CachedFileContent cachedFileContent;

        private ContentLoadingResult(@NotNull CachedFileContent cachedFileContent, long fileLength) {
            if (cachedFileContent == null) {
                ContentLoadingResult.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public CachedFileContent cachedFileContent() {
            CachedFileContent cachedFileContent = this.cachedFileContent;
            if (cachedFileContent == null) {
                ContentLoadingResult.$$$reportNull$$$0(1);
            }
            return cachedFileContent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cachedFileContent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/contentQueue/IndexUpdateRunner$ContentLoadingResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/contentQueue/IndexUpdateRunner$ContentLoadingResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cachedFileContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    public static final class FileSet {
        public final String debugName;
        @Nullable
        public final @NlsContexts.ProgressText String progressText;
        public final Collection<VirtualFile> files;
        public final IndexingFileSetStatistics statistics;

        public FileSet(@NotNull Project project2, @NotNull String debugName, @NotNull Collection<VirtualFile> files2) {
            if (project2 == null) {
                FileSet.$$$reportNull$$$0(0);
            }
            if (debugName == null) {
                FileSet.$$$reportNull$$$0(1);
            }
            if (files2 == null) {
                FileSet.$$$reportNull$$$0(2);
            }
            this(project2, debugName, files2, null);
        }

        public FileSet(@NotNull Project project2, @NotNull String debugName, @NotNull Collection<VirtualFile> files2, @Nullable @NlsContexts.ProgressText String progressText) {
            if (project2 == null) {
                FileSet.$$$reportNull$$$0(3);
            }
            if (debugName == null) {
                FileSet.$$$reportNull$$$0(4);
            }
            if (files2 == null) {
                FileSet.$$$reportNull$$$0(5);
            }
            this.debugName = debugName;
            this.files = files2;
            this.progressText = progressText;
            this.statistics = new IndexingFileSetStatistics(project2, debugName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "debugName";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "files";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/indexing/contentQueue/IndexUpdateRunner$FileSet";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

