/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.dependenciesCache;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.dependenciesCache.ExcludePolicyDescriptor;
import com.intellij.util.indexing.dependenciesCache.IndexableSetContributorDescriptor;
import com.intellij.util.indexing.dependenciesCache.RescannedRootsUtil;
import com.intellij.util.indexing.dependenciesCache.SyntheticLibraryDescriptor;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
@ApiStatus.Experimental
public class DependenciesIndexedStatusService {
    private static final Logger LOG = Logger.getInstance(DependenciesIndexedStatusService.class);
    @VisibleForTesting
    static final Key<Boolean> ENFORCEMENT_USAGE_TEST_MODE_FLAG = new Key("enforce.DependenciesIndexedStatusService.usage");
    private final Object LOCK;
    private volatile int statusVersionCounter;
    @NotNull
    private final Project project;
    @Nullable
    private MyStatus lastIndexedStatus;
    private MyStatus currentlyCollectedStatus;
    private final ThreadLocal<Boolean> listenToStatus;

    @NotNull
    public static DependenciesIndexedStatusService getInstance(@NotNull Project project2) {
        if (project2 == null) {
            DependenciesIndexedStatusService.$$$reportNull$$$0(0);
        }
        DependenciesIndexedStatusService dependenciesIndexedStatusService = project2.getService(DependenciesIndexedStatusService.class);
        if (dependenciesIndexedStatusService == null) {
            DependenciesIndexedStatusService.$$$reportNull$$$0(1);
        }
        return dependenciesIndexedStatusService;
    }

    public static boolean shouldBeUsed() {
        return Registry.is("use.dependencies.cache.service", false) || TestModeFlags.is(ENFORCEMENT_USAGE_TEST_MODE_FLAG);
    }

    DependenciesIndexedStatusService(@NotNull Project project2) {
        if (project2 == null) {
            DependenciesIndexedStatusService.$$$reportNull$$$0(2);
        }
        this.LOCK = new Object();
        this.statusVersionCounter = 0;
        this.listenToStatus = ThreadLocal.withInitial(() -> Boolean.FALSE);
        this.project = project2;
    }

    public boolean shouldSaveStatus() {
        return DependenciesIndexedStatusService.shouldBeUsed() && this.listenToStatus.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCollectingStatus() {
        if (!DependenciesIndexedStatusService.shouldBeUsed()) {
            return;
        }
        this.listenToStatus.set(true);
        Object object = this.LOCK;
        synchronized (object) {
            this.currentlyCollectedStatus = new MyStatus(this.getVersion(), null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getVersion() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.statusVersionCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public StatusMark finishCollectingStatus() {
        MyStatus status;
        this.listenToStatus.set(false);
        Object object = this.LOCK;
        synchronized (object) {
            status = this.currentlyCollectedStatus;
            this.currentlyCollectedStatus = null;
        }
        MyStatus myStatus = status;
        if (myStatus == null) {
            DependenciesIndexedStatusService.$$$reportNull$$$0(3);
        }
        return myStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexingFinished(boolean successfully, @Nullable StatusMark mark) {
        Object object = this.LOCK;
        synchronized (object) {
            if (successfully && mark != null) {
                String message = ((MyStatus)mark).collectionStatusMessage();
                if (message == null) {
                    this.lastIndexedStatus = (MyStatus)mark;
                } else {
                    LOG.error("Status of indexed iterators was not collected: " + message);
                }
            }
            this.currentlyCollectedStatus = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveExcludePolicies() {
        if (!this.shouldSaveStatus()) {
            return;
        }
        List<ExcludePolicyDescriptor> descriptors = ExcludePolicyDescriptor.collectDescriptors(this.project);
        Object object = this.LOCK;
        synchronized (object) {
            this.currentlyCollectedStatus = this.currentlyCollectedStatus.createWithExcludePolicies(this.getVersion(), descriptors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<IndexableFilesIterator> saveLibsAndInstantiateLibraryIterators() {
        LOG.assertTrue(this.shouldSaveStatus());
        List<SyntheticLibraryDescriptor> libraries2 = DependenciesIndexedStatusService.collectAdditionalLibDescriptors(this.project);
        Object object = this.LOCK;
        synchronized (object) {
            this.currentlyCollectedStatus = this.currentlyCollectedStatus.createWithLibs(this.getVersion(), libraries2);
        }
        List<IndexableFilesIterator> list2 = ContainerUtil.map(libraries2, lib -> lib.toIndexableIterator());
        if (list2 == null) {
            DependenciesIndexedStatusService.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    private static List<SyntheticLibraryDescriptor> collectAdditionalLibDescriptors(@NotNull Project project2) {
        if (project2 == null) {
            DependenciesIndexedStatusService.$$$reportNull$$$0(5);
        }
        ArrayList<SyntheticLibraryDescriptor> libraries2 = new ArrayList<SyntheticLibraryDescriptor>();
        for (AdditionalLibraryRootsProvider provider2 : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
            HashSet<String> comparisonIds = new HashSet<String>();
            Collection<SyntheticLibrary> allLibs = provider2.getAdditionalProjectLibraries(project2);
            for (SyntheticLibrary library : allLibs) {
                String id = library.getComparisonId();
                if (id != null && !comparisonIds.add(id)) {
                    LOG.error("Multiple libraries have comparison id " + id + ": " + ContainerUtil.filter(allLibs, lib -> id.equals(lib.getComparisonId())));
                }
                libraries2.add(new SyntheticLibraryDescriptor(library, provider2));
            }
        }
        ArrayList<SyntheticLibraryDescriptor> arrayList = libraries2;
        if (arrayList == null) {
            DependenciesIndexedStatusService.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<IndexableFilesIterator> saveIndexableSetsAndInstantiateIterators() {
        LOG.assertTrue(this.shouldSaveStatus());
        @NotNull List<IndexableSetContributorDescriptor> descriptors = IndexableSetContributorDescriptor.collectDescriptors(this.project);
        Object object = this.LOCK;
        synchronized (object) {
            this.currentlyCollectedStatus = this.currentlyCollectedStatus.createWithIndexableSets(this.getVersion(), descriptors);
        }
        List<IndexableFilesIterator> list2 = ContainerUtil.flatMap(descriptors, descriptor2 -> descriptor2.toIndexableIterators());
        if (list2 == null) {
            DependenciesIndexedStatusService.$$$reportNull$$$0(7);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable kotlin.Pair<@NotNull Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder>, @NotNull StatusMark> getDeltaWithLastIndexedStatus() {
        MyStatus statusBefore;
        if (!DependenciesIndexedStatusService.shouldBeUsed()) {
            return null;
        }
        Object object = this.LOCK;
        synchronized (object) {
            statusBefore = this.lastIndexedStatus;
        }
        if (statusBefore == null) {
            return null;
        }
        MyStatus statusAfter = this.getCurrentStatus();
        Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> iterators = DependenciesIndexedStatusService.getDependenciesIterators(this.project, statusBefore, statusAfter);
        return new kotlin.Pair(iterators, (Object)statusAfter);
    }

    @NotNull
    private MyStatus getCurrentStatus() {
        List<SyntheticLibraryDescriptor> libraries2 = DependenciesIndexedStatusService.collectAdditionalLibDescriptors(this.project);
        List<IndexableSetContributorDescriptor> contributors = IndexableSetContributorDescriptor.collectDescriptors(this.project);
        List<ExcludePolicyDescriptor> excludePolicies = ExcludePolicyDescriptor.collectDescriptors(this.project);
        return new MyStatus(this.getVersion(), libraries2, contributors, excludePolicies);
    }

    @NotNull
    private static Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getDependenciesIterators(@NotNull Project project2, @NotNull MyStatus before, @NotNull MyStatus after2) {
        if (project2 == null) {
            DependenciesIndexedStatusService.$$$reportNull$$$0(8);
        }
        if (before == null) {
            DependenciesIndexedStatusService.$$$reportNull$$$0(9);
        }
        if (after2 == null) {
            DependenciesIndexedStatusService.$$$reportNull$$$0(10);
        }
        ArrayList<? extends IndexableEntityProvider.IndexableIteratorBuilder> result2 = new ArrayList<IndexableEntityProvider.IndexableIteratorBuilder>(RescannedRootsUtil.getUnexcludedRootsIteratorBuilders(project2, before.libraries, before.excludePolicyDescriptors, after2.libraries));
        MultiMap<AdditionalLibraryRootsProvider, SyntheticLibraryDescriptor> afterLibs = after2.librariesToMap();
        MultiMap<AdditionalLibraryRootsProvider, SyntheticLibraryDescriptor> beforeLibs = before.librariesToMap();
        for (Map.Entry<AdditionalLibraryRootsProvider, Collection<SyntheticLibraryDescriptor>> entry : afterLibs.entrySet()) {
            result2.addAll(RescannedRootsUtil.getLibraryIteratorBuilders(beforeLibs.get(entry.getKey()), entry.getValue()));
        }
        Map<IndexableSetContributor, IndexableSetContributorDescriptor> beforeContributors = before.contributorsToMap();
        for (IndexableSetContributorDescriptor indexableSetContributorDescriptor : after2.contributors) {
            result2.addAll(RescannedRootsUtil.getIndexableSetIteratorBuilders(beforeContributors.get(indexableSetContributorDescriptor.contributor), indexableSetContributorDescriptor));
        }
        ArrayList<? extends IndexableEntityProvider.IndexableIteratorBuilder> arrayList = result2;
        if (arrayList == null) {
            DependenciesIndexedStatusService.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 6, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/dependenciesCache/DependenciesIndexedStatusService";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/dependenciesCache/DependenciesIndexedStatusService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "finishCollectingStatus";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "saveLibsAndInstantiateLibraryIterators";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAdditionalLibDescriptors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "saveIndexableSetsAndInstantiateIterators";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependenciesIterators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectAdditionalLibDescriptors";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDependenciesIterators";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 3, 4, 6, 7, 11 -> new IllegalStateException(string2);
        };
    }

    private record MyStatus(int version, @Nullable List<? extends SyntheticLibraryDescriptor> libraries, @Nullable List<? extends IndexableSetContributorDescriptor> contributors, @Nullable List<? extends ExcludePolicyDescriptor> excludePolicyDescriptors) implements StatusMark
    {
        private MyStatus(int version, @Nullable List<? extends SyntheticLibraryDescriptor> libraries2, @Nullable List<? extends IndexableSetContributorDescriptor> contributors, @Nullable List<? extends ExcludePolicyDescriptor> excludePolicyDescriptors) {
            this.version = version;
            this.libraries = libraries2 == null ? null : List.copyOf(libraries2);
            this.contributors = contributors == null ? null : List.copyOf(contributors);
            this.excludePolicyDescriptors = excludePolicyDescriptors == null ? null : List.copyOf(excludePolicyDescriptors);
        }

        private MyStatus createWithLibs(int version, @NotNull List<? extends SyntheticLibraryDescriptor> newLibraries) {
            if (newLibraries == null) {
                MyStatus.$$$reportNull$$$0(0);
            }
            return new MyStatus(version, newLibraries, this.contributors, this.excludePolicyDescriptors);
        }

        private MyStatus createWithIndexableSets(int version, @NotNull List<? extends IndexableSetContributorDescriptor> newContributors) {
            if (newContributors == null) {
                MyStatus.$$$reportNull$$$0(1);
            }
            return new MyStatus(version, this.libraries, newContributors, this.excludePolicyDescriptors);
        }

        private MyStatus createWithExcludePolicies(int version, @NotNull List<? extends ExcludePolicyDescriptor> newExcludePolicyDescriptors) {
            if (newExcludePolicyDescriptors == null) {
                MyStatus.$$$reportNull$$$0(2);
            }
            return new MyStatus(version, this.libraries, this.contributors, newExcludePolicyDescriptors);
        }

        @Nullable
        private String collectionStatusMessage() {
            Object message = "";
            if (this.libraries == null) {
                message = (String)message + "No AdditionalLibraries data provided. ";
            }
            if (this.contributors == null) {
                message = (String)message + "No IndexableSetContributor data provided. ";
            }
            if (this.excludePolicyDescriptors == null) {
                message = (String)message + "No ExcludeDirectoryPolicy data provided. ";
            }
            return ((String)message).isEmpty() ? null : message;
        }

        @NotNull
        public MultiMap<AdditionalLibraryRootsProvider, SyntheticLibraryDescriptor> librariesToMap() {
            LOG.assertTrue(this.libraries != null);
            MultiMap<AdditionalLibraryRootsProvider, SyntheticLibraryDescriptor> result2 = new MultiMap<AdditionalLibraryRootsProvider, SyntheticLibraryDescriptor>();
            for (SyntheticLibraryDescriptor syntheticLibraryDescriptor : this.libraries) {
                result2.putValue(syntheticLibraryDescriptor.provider, syntheticLibraryDescriptor);
            }
            MultiMap<AdditionalLibraryRootsProvider, SyntheticLibraryDescriptor> multiMap = result2;
            if (multiMap == null) {
                MyStatus.$$$reportNull$$$0(3);
            }
            return multiMap;
        }

        @NotNull
        public Map<IndexableSetContributor, IndexableSetContributorDescriptor> contributorsToMap() {
            LOG.assertTrue(this.contributors != null);
            Map<IndexableSetContributor, IndexableSetContributorDescriptor> map2 = ContainerUtil.map2Map(this.contributors, descriptor2 -> Pair.create(descriptor2.contributor, descriptor2));
            if (map2 == null) {
                MyStatus.$$$reportNull$$$0(4);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newLibraries";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newContributors";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newExcludePolicyDescriptors";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/dependenciesCache/DependenciesIndexedStatusService$MyStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/dependenciesCache/DependenciesIndexedStatusService$MyStatus";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "librariesToMap";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contributorsToMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createWithLibs";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createWithIndexableSets";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createWithExcludePolicies";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4 -> new IllegalStateException(string2);
            };
        }
    }

    public static interface StatusMark {
        @Nullable
        public static StatusMark mergeStatus(@Nullable StatusMark one, @Nullable StatusMark another) {
            if (one == null) {
                return another;
            }
            if (another == null) {
                return one;
            }
            if (((MyStatus)one).version > ((MyStatus)another).version) {
                return one;
            }
            return another;
        }
    }
}

