/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.dependenciesCache;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ExcludePolicyDescriptor {
    @NotNull
    public final Class<? extends DirectoryIndexExcludePolicy> policyClass;
    public final String[] excludedRootUrls;
    @NotNull
    public final Set<VirtualFile> excludedFromSdkRoots;

    @NotNull
    static ExcludePolicyDescriptor create(@NotNull DirectoryIndexExcludePolicy policy, @NotNull Set<? extends Sdk> sdks, @NotNull Set<? extends VirtualFile> sdkRoots) {
        Set<VirtualFile> excludedFromSdkRoots;
        if (policy == null) {
            ExcludePolicyDescriptor.$$$reportNull$$$0(0);
        }
        if (sdks == null) {
            ExcludePolicyDescriptor.$$$reportNull$$$0(1);
        }
        if (sdkRoots == null) {
            ExcludePolicyDescriptor.$$$reportNull$$$0(2);
        }
        String[] excludedRootUrls = policy.getExcludeUrlsForProject();
        Function<Sdk, List<VirtualFile>> strategy = policy.getExcludeSdkRootsStrategy();
        if (strategy == null) {
            excludedFromSdkRoots = Collections.emptySet();
        } else {
            ArrayList<VirtualFile> excludedFromSdk = new ArrayList<VirtualFile>();
            for (Sdk sdk2 : sdks) {
                List<VirtualFile> excluded = strategy.fun(sdk2);
                for (VirtualFile file2 : excluded) {
                    if (sdkRoots.contains(file2)) continue;
                    excludedFromSdk.add(file2);
                }
            }
            excludedFromSdkRoots = Set.copyOf(excludedFromSdk);
        }
        return new ExcludePolicyDescriptor(policy.getClass(), excludedRootUrls, excludedFromSdkRoots);
    }

    private ExcludePolicyDescriptor(@NotNull Class<? extends DirectoryIndexExcludePolicy> policyClass, String[] excludedRootUrls, @NotNull Set<VirtualFile> excludedFromSdkRoots) {
        if (policyClass == null) {
            ExcludePolicyDescriptor.$$$reportNull$$$0(3);
        }
        if (excludedFromSdkRoots == null) {
            ExcludePolicyDescriptor.$$$reportNull$$$0(4);
        }
        this.policyClass = policyClass;
        this.excludedRootUrls = excludedRootUrls;
        this.excludedFromSdkRoots = excludedFromSdkRoots;
    }

    @NotNull
    public Set<VirtualFile> getExcludedRoots() {
        Set<VirtualFile> set2 = Set.copyOf(ContainerUtil.mapNotNull(this.excludedRootUrls, url -> VirtualFileManager.getInstance().findFileByUrl((String)url)));
        if (set2 == null) {
            ExcludePolicyDescriptor.$$$reportNull$$$0(5);
        }
        return set2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExcludePolicyDescriptor that = (ExcludePolicyDescriptor)o;
        return this.policyClass.equals(that.policyClass) && Arrays.equals(this.excludedRootUrls, that.excludedRootUrls) && this.excludedFromSdkRoots.equals(that.excludedFromSdkRoots);
    }

    public int hashCode() {
        int result2 = Objects.hash(this.policyClass, this.excludedFromSdkRoots);
        result2 = 31 * result2 + Arrays.hashCode(this.excludedRootUrls);
        return result2;
    }

    public String toString() {
        if (this.excludedRootUrls.length == 0 && this.excludedFromSdkRoots.isEmpty()) {
            return "ExcludePolicyDescriptor{policyClass=" + this.policyClass.getSimpleName() + "; empty}";
        }
        return "ExcludePolicyDescriptor{policyClass=" + this.policyClass.getSimpleName() + ", excludedRootUrls=" + Arrays.toString(this.excludedRootUrls) + ", excludedFromSdkRoots=" + this.excludedFromSdkRoots + "}";
    }

    @NotNull
    public static List<ExcludePolicyDescriptor> collectDescriptors(@NotNull Project project2) {
        if (project2 == null) {
            ExcludePolicyDescriptor.$$$reportNull$$$0(6);
        }
        HashSet<Sdk> sdks = new HashSet<Sdk>();
        for (Module module2 : ModuleManager.getInstance(project2).getModules()) {
            Sdk sdk2 = ModuleRootManager.getInstance(module2).getSdk();
            if (sdk2 == null) continue;
            sdks.add(sdk2);
        }
        HashSet<VirtualFile> roots2 = new HashSet<VirtualFile>();
        for (Sdk sdk3 : sdks) {
            roots2.addAll(Arrays.asList(sdk3.getRootProvider().getFiles(OrderRootType.CLASSES)));
        }
        ArrayList<ExcludePolicyDescriptor> excludePolicies = new ArrayList<ExcludePolicyDescriptor>();
        for (DirectoryIndexExcludePolicy policy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions(project2)) {
            excludePolicies.add(ExcludePolicyDescriptor.create(policy, sdks, roots2));
        }
        ArrayList<ExcludePolicyDescriptor> arrayList = excludePolicies;
        if (arrayList == null) {
            ExcludePolicyDescriptor.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkRoots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policyClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedFromSdkRoots";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/dependenciesCache/ExcludePolicyDescriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/dependenciesCache/ExcludePolicyDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectDescriptors";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 7 -> new IllegalStateException(string2);
        };
    }
}

