/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.dependenciesCache;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.IndexableSetContributorFilesIterator;
import com.intellij.util.indexing.roots.builders.IndexableSetContributorFilesIteratorBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IndexableSetContributorDescriptor {
    @Nullable
    @NlsSafe
    public final String presentableText;
    @NotNull
    @NlsSafe
    public final String debugName;
    @NotNull
    public final Set<VirtualFile> projectRoots;
    @NotNull
    public final Set<VirtualFile> applicationRoots;
    @NotNull
    public final IndexableSetContributor contributor;

    IndexableSetContributorDescriptor(@NotNull IndexableSetContributor contributor, @NotNull Project project2) {
        if (contributor == null) {
            IndexableSetContributorDescriptor.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            IndexableSetContributorDescriptor.$$$reportNull$$$0(1);
        }
        this.presentableText = contributor instanceof ItemPresentation ? ((ItemPresentation)contributor).getPresentableText() : null;
        this.debugName = contributor.getDebugName();
        this.projectRoots = Set.copyOf(contributor.getAdditionalProjectRootsToIndex(project2));
        this.applicationRoots = Set.copyOf(contributor.getAdditionalRootsToIndex());
        this.contributor = contributor;
    }

    @NotNull
    public List<IndexableFilesIterator> toIndexableIterators() {
        List<IndexableFilesIterator> list2 = Arrays.asList(new IndexableSetContributorFilesIterator(this.presentableText, this.debugName, true, this.projectRoots, this.contributor), new IndexableSetContributorFilesIterator(this.presentableText, this.debugName, false, this.applicationRoots, this.contributor));
        if (list2 == null) {
            IndexableSetContributorDescriptor.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public String toString() {
        return this.debugName + ": " + this.projectRoots + ", " + this.applicationRoots;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexableSetContributorDescriptor that = (IndexableSetContributorDescriptor)o;
        return Objects.equals(this.presentableText, that.presentableText) && this.debugName.equals(that.debugName) && this.projectRoots.equals(that.projectRoots) && this.applicationRoots.equals(that.applicationRoots);
    }

    public int hashCode() {
        return Objects.hash(this.presentableText, this.debugName, this.projectRoots, this.applicationRoots);
    }

    @NotNull
    public List<IndexableSetContributorFilesIteratorBuilder> toIteratorBuilders() {
        List<IndexableSetContributorFilesIteratorBuilder> list2 = Arrays.asList(new IndexableSetContributorFilesIteratorBuilder(this.presentableText, this.debugName, this.projectRoots, true, this.contributor), new IndexableSetContributorFilesIteratorBuilder(this.presentableText, this.debugName, this.applicationRoots, false, this.contributor));
        if (list2 == null) {
            IndexableSetContributorDescriptor.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public IndexableSetContributorFilesIteratorBuilder toIteratorBuilderWithRoots(@NotNull Set<? extends VirtualFile> roots2, boolean projectAware) {
        if (roots2 == null) {
            IndexableSetContributorDescriptor.$$$reportNull$$$0(4);
        }
        return new IndexableSetContributorFilesIteratorBuilder(this.presentableText, this.debugName, roots2, projectAware, this.contributor);
    }

    @NotNull
    public static List<IndexableSetContributorDescriptor> collectDescriptors(@NotNull Project project2) {
        if (project2 == null) {
            IndexableSetContributorDescriptor.$$$reportNull$$$0(5);
        }
        List<IndexableSetContributorDescriptor> list2 = ContainerUtil.map(IndexableSetContributor.EP_NAME.getExtensionList(), contributor -> new IndexableSetContributorDescriptor((IndexableSetContributor)contributor, project2));
        if (list2 == null) {
            IndexableSetContributorDescriptor.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/dependenciesCache/IndexableSetContributorDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/dependenciesCache/IndexableSetContributorDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toIndexableIterators";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toIteratorBuilders";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toIteratorBuilderWithRoots";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectDescriptors";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 6 -> new IllegalStateException(string2);
        };
    }
}

