/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.dependenciesCache;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.dependenciesCache.ExcludePolicyDescriptor;
import com.intellij.util.indexing.dependenciesCache.IndexableSetContributorDescriptor;
import com.intellij.util.indexing.dependenciesCache.SyntheticLibraryDescriptor;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilders;
import com.intellij.util.indexing.roots.builders.IndexableSetContributorFilesIteratorBuilder;
import com.intellij.util.indexing.roots.builders.SyntheticLibraryIteratorBuilder;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetRecognizer;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class RescannedRootsUtil {
    private static final Logger LOG = Logger.getInstance(RescannedRootsUtil.class);

    RescannedRootsUtil() {
    }

    static Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getUnexcludedRootsIteratorBuilders(@NotNull Project project2, @NotNull List<? extends SyntheticLibraryDescriptor> libraryDescriptorsBefore, @NotNull List<? extends ExcludePolicyDescriptor> excludedDescriptorsBefore, @NotNull List<? extends SyntheticLibraryDescriptor> librariesDescriptorsAfter) {
        if (project2 == null) {
            RescannedRootsUtil.$$$reportNull$$$0(0);
        }
        if (libraryDescriptorsBefore == null) {
            RescannedRootsUtil.$$$reportNull$$$0(1);
        }
        if (excludedDescriptorsBefore == null) {
            RescannedRootsUtil.$$$reportNull$$$0(2);
        }
        if (librariesDescriptorsAfter == null) {
            RescannedRootsUtil.$$$reportNull$$$0(3);
        }
        HashSet<VirtualFile> excludedRoots = new HashSet<VirtualFile>();
        for (SyntheticLibraryDescriptor syntheticLibraryDescriptor : libraryDescriptorsBefore) {
            excludedRoots.addAll(syntheticLibraryDescriptor.excludedRoots);
        }
        for (ExcludePolicyDescriptor excludePolicyDescriptor : excludedDescriptorsBefore) {
            excludedRoots.addAll(excludePolicyDescriptor.getExcludedRoots());
            excludedRoots.addAll(excludePolicyDescriptor.excludedFromSdkRoots);
        }
        return RescannedRootsUtil.createBuildersForReincludedFiles(project2, excludedRoots, librariesDescriptorsAfter);
    }

    @NotNull
    private static List<IndexableEntityProvider.IndexableIteratorBuilder> createBuildersForReincludedFiles(@NotNull Project project2, @NotNull Collection<VirtualFile> reincludedRoots, @NotNull List<? extends SyntheticLibraryDescriptor> librariesDescriptorsAfter) {
        if (project2 == null) {
            RescannedRootsUtil.$$$reportNull$$$0(4);
        }
        if (reincludedRoots == null) {
            RescannedRootsUtil.$$$reportNull$$$0(5);
        }
        if (librariesDescriptorsAfter == null) {
            RescannedRootsUtil.$$$reportNull$$$0(6);
        }
        if (reincludedRoots.isEmpty()) {
            List<IndexableEntityProvider.IndexableIteratorBuilder> list2 = Collections.emptyList();
            if (list2 == null) {
                RescannedRootsUtil.$$$reportNull$$$0(7);
            }
            return list2;
        }
        ArrayList<VirtualFile> filesFromIndexableSetContributors = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> filesFromAdditionalLibraryRootsProviders = new ArrayList<VirtualFile>();
        EntityStorage entityStorage = WorkspaceModel.getInstance(project2).getEntityStorage().getCurrent();
        WorkspaceFileIndex workspaceFileIndex = WorkspaceFileIndex.getInstance(project2);
        ArrayList<IndexableEntityProvider.IndexableIteratorBuilder> result2 = new ArrayList<IndexableEntityProvider.IndexableIteratorBuilder>();
        Iterator<VirtualFile> iterator2 = reincludedRoots.iterator();
        while (iterator2.hasNext()) {
            VirtualFile file2 = iterator2.next();
            WorkspaceFileSet fileSet = workspaceFileIndex.findFileSet(file2, true, true, true, true);
            if (fileSet == null) {
                filesFromIndexableSetContributors.add(file2);
                iterator2.remove();
                continue;
            }
            if (fileSet.getKind() == WorkspaceFileKind.CONTENT || fileSet.getKind() == WorkspaceFileKind.TEST_CONTENT) {
                Module module2 = WorkspaceFileSetRecognizer.INSTANCE.getModuleForContent(fileSet);
                if (module2 != null) {
                    result2.addAll(IndexableIteratorBuilders.INSTANCE.forModuleRootsFileBased(((ModuleBridge)module2).getModuleEntityId(), Collections.singletonList(file2)));
                    iterator2.remove();
                    continue;
                }
                EntityReference<?> entityReference = WorkspaceFileSetRecognizer.INSTANCE.getEntityReference(fileSet);
                LOG.assertTrue(entityReference != null, "Content element's fileSet without entity reference, " + fileSet);
                result2.addAll(IndexableIteratorBuilders.INSTANCE.forModuleUnawareContentEntity(entityReference, Collections.singletonList(file2)));
                iterator2.remove();
                continue;
            }
            List<Object> roots2 = fileSet.getKind() == WorkspaceFileKind.EXTERNAL ? Collections.singletonList(file2) : Collections.emptyList();
            List<Object> sourceRoots = fileSet.getKind() == WorkspaceFileKind.EXTERNAL_SOURCE ? Collections.singletonList(file2) : Collections.emptyList();
            Sdk sdk2 = WorkspaceFileSetRecognizer.INSTANCE.getSdk(fileSet);
            if (sdk2 != null) {
                result2.addAll(IndexableIteratorBuilders.INSTANCE.forSdk(sdk2, Collections.singletonList(file2)));
                iterator2.remove();
                continue;
            }
            if (WorkspaceFileSetRecognizer.INSTANCE.isFromAdditionalLibraryRootsProvider(fileSet)) {
                filesFromAdditionalLibraryRootsProviders.add(file2);
                iterator2.remove();
                continue;
            }
            LibraryId libraryId = WorkspaceFileSetRecognizer.INSTANCE.getLibraryId(fileSet, entityStorage);
            if (libraryId != null) {
                result2.addAll(IndexableIteratorBuilders.INSTANCE.forLibraryEntity(libraryId, true, roots2, sourceRoots));
                iterator2.remove();
                continue;
            }
            EntityReference<?> entityReference = WorkspaceFileSetRecognizer.INSTANCE.getEntityReference(fileSet);
            LOG.assertTrue(entityReference != null, "External element's fileSet without entity reference, " + fileSet);
            IndexableIteratorBuilders.INSTANCE.forExternalEntity(entityReference, roots2, sourceRoots);
            iterator2.remove();
        }
        if (!filesFromAdditionalLibraryRootsProviders.isEmpty()) {
            result2.addAll(RescannedRootsUtil.createSyntheticLibraryIteratorBuilders(librariesDescriptorsAfter, filesFromAdditionalLibraryRootsProviders));
        }
        if (!filesFromIndexableSetContributors.isEmpty()) {
            for (IndexableSetContributor contributor : IndexableSetContributor.EP_NAME.getExtensionList()) {
                Set<VirtualFile> applicationRoots = RescannedRootsUtil.collectAndRemoveFilesUnder(filesFromIndexableSetContributors, contributor.getAdditionalRootsToIndex());
                Set<VirtualFile> projectRoots = RescannedRootsUtil.collectAndRemoveFilesUnder(filesFromIndexableSetContributors, contributor.getAdditionalProjectRootsToIndex(project2));
                if (!applicationRoots.isEmpty()) {
                    result2.add(new IndexableSetContributorFilesIteratorBuilder(null, contributor.getDebugName(), applicationRoots, false, contributor));
                }
                if (!projectRoots.isEmpty()) {
                    result2.add(new IndexableSetContributorFilesIteratorBuilder(null, contributor.getDebugName(), projectRoots, true, contributor));
                }
                if (!filesFromIndexableSetContributors.isEmpty()) continue;
                break;
            }
        }
        if (!reincludedRoots.isEmpty()) {
            throw new IllegalStateException("Roots were not found: " + StringUtil.join(reincludedRoots, "\n"));
        }
        ArrayList<IndexableEntityProvider.IndexableIteratorBuilder> arrayList = result2;
        if (arrayList == null) {
            RescannedRootsUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static Set<VirtualFile> collectAndRemoveFilesUnder(List<VirtualFile> fileToCheck, Set<VirtualFile> roots2) {
        Iterator<VirtualFile> iterator2 = fileToCheck.iterator();
        HashSet<VirtualFile> applicationRoots = new HashSet<VirtualFile>();
        while (iterator2.hasNext()) {
            VirtualFile next2 = iterator2.next();
            if (!VfsUtilCore.isUnder(next2, roots2)) continue;
            applicationRoots.add(next2);
            iterator2.remove();
        }
        HashSet<VirtualFile> hashSet = applicationRoots;
        if (hashSet == null) {
            RescannedRootsUtil.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    private static Collection<SyntheticLibraryIteratorBuilder> createSyntheticLibraryIteratorBuilders(List<? extends SyntheticLibraryDescriptor> librariesDescriptorsAfter, Collection<VirtualFile> files2) {
        ArrayList<SyntheticLibraryIteratorBuilder> builders = new ArrayList<SyntheticLibraryIteratorBuilder>();
        for (SyntheticLibraryDescriptor syntheticLibraryDescriptor : librariesDescriptorsAfter) {
            ArrayList<VirtualFile> roots2 = new ArrayList<VirtualFile>();
            Iterator<VirtualFile> iterator2 = files2.iterator();
            while (iterator2.hasNext()) {
                VirtualFile file2 = iterator2.next();
                if (!syntheticLibraryDescriptor.contains(file2)) continue;
                roots2.add(file2);
                iterator2.remove();
            }
            if (!roots2.isEmpty()) {
                builders.add(new SyntheticLibraryIteratorBuilder(syntheticLibraryDescriptor.library, syntheticLibraryDescriptor.presentableLibraryName, roots2));
            }
            if (!files2.isEmpty()) continue;
            return builders;
        }
        LOG.error("Failed fo find SyntheticLibrary roots for " + StringUtil.join(files2, "\n"));
        return builders;
    }

    @NotNull
    static Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getLibraryIteratorBuilders(@Nullable Collection<? extends SyntheticLibraryDescriptor> before, @NotNull Collection<? extends SyntheticLibraryDescriptor> after2) {
        if (after2 == null) {
            RescannedRootsUtil.$$$reportNull$$$0(10);
        }
        if (after2.size() == 1 && before != null && before.size() == 1) {
            SyntheticLibraryDescriptor afterLib = after2.iterator().next();
            SyntheticLibraryDescriptor beforeLib = before.iterator().next();
            if (afterLib.comparisonId == null && beforeLib.comparisonId == null && !afterLib.hasExcludeFileCondition && !beforeLib.hasExcludeFileCondition) {
                return RescannedRootsUtil.createLibraryIteratorBuilders(beforeLib, afterLib);
            }
        }
        ArrayList<? extends IndexableEntityProvider.IndexableIteratorBuilder> result2 = new ArrayList<IndexableEntityProvider.IndexableIteratorBuilder>();
        for (SyntheticLibraryDescriptor syntheticLibraryDescriptor : after2) {
            SyntheticLibraryDescriptor libForIncrementalRescanning = syntheticLibraryDescriptor.getLibForIncrementalRescanning(before);
            if (libForIncrementalRescanning != null) {
                result2.addAll(RescannedRootsUtil.createLibraryIteratorBuilders(libForIncrementalRescanning, syntheticLibraryDescriptor));
                continue;
            }
            result2.add(new SyntheticLibraryIteratorBuilder(syntheticLibraryDescriptor.library, syntheticLibraryDescriptor.presentableLibraryName, syntheticLibraryDescriptor.getAllRoots()));
        }
        ArrayList<? extends IndexableEntityProvider.IndexableIteratorBuilder> arrayList = result2;
        if (arrayList == null) {
            RescannedRootsUtil.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static List<? extends IndexableEntityProvider.IndexableIteratorBuilder> createLibraryIteratorBuilders(@NotNull SyntheticLibraryDescriptor beforeLib, @NotNull SyntheticLibraryDescriptor afterLib) {
        Collection<VirtualFile> newRoots;
        if (beforeLib == null) {
            RescannedRootsUtil.$$$reportNull$$$0(12);
        }
        if (afterLib == null) {
            RescannedRootsUtil.$$$reportNull$$$0(13);
        }
        if (!(newRoots = ContainerUtil.subtract(afterLib.getAllRoots(), beforeLib.getAllRoots())).isEmpty()) {
            List<SyntheticLibraryIteratorBuilder> list2 = Collections.singletonList(new SyntheticLibraryIteratorBuilder(afterLib.library, afterLib.presentableLibraryName, newRoots));
            if (list2 == null) {
                RescannedRootsUtil.$$$reportNull$$$0(14);
            }
            return list2;
        }
        List list3 = Collections.emptyList();
        if (list3 == null) {
            RescannedRootsUtil.$$$reportNull$$$0(15);
        }
        return list3;
    }

    @NotNull
    public static Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getIndexableSetIteratorBuilders(@Nullable IndexableSetContributorDescriptor before, @NotNull IndexableSetContributorDescriptor after2) {
        if (after2 == null) {
            RescannedRootsUtil.$$$reportNull$$$0(16);
        }
        if (before == null) {
            List<IndexableSetContributorFilesIteratorBuilder> list2 = after2.toIteratorBuilders();
            if (list2 == null) {
                RescannedRootsUtil.$$$reportNull$$$0(17);
            }
            return list2;
        }
        Set<VirtualFile> applicationRootsToIndex = RescannedRootsUtil.subtract(after2.applicationRoots, before.applicationRoots);
        Set<VirtualFile> projectRootsToIndex = RescannedRootsUtil.subtract(after2.projectRoots, before.projectRoots);
        ArrayList<IndexableSetContributorFilesIteratorBuilder> result2 = new ArrayList<IndexableSetContributorFilesIteratorBuilder>(2);
        if (!projectRootsToIndex.isEmpty()) {
            result2.add(after2.toIteratorBuilderWithRoots(projectRootsToIndex, true));
        }
        if (!applicationRootsToIndex.isEmpty()) {
            result2.add(after2.toIteratorBuilderWithRoots(applicationRootsToIndex, false));
        }
        ArrayList<IndexableSetContributorFilesIteratorBuilder> arrayList = result2;
        if (arrayList == null) {
            RescannedRootsUtil.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    private static <T> Set<T> subtract(@NotNull Collection<? extends T> from, @NotNull Collection<? extends T> what) {
        if (from == null) {
            RescannedRootsUtil.$$$reportNull$$$0(19);
        }
        if (what == null) {
            RescannedRootsUtil.$$$reportNull$$$0(20);
        }
        HashSet<T> set2 = new HashSet<T>(from);
        set2.removeAll(what);
        HashSet<T> hashSet = set2;
        if (hashSet == null) {
            RescannedRootsUtil.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 11, 14, 15, 17, 18, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDescriptorsBefore";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedDescriptorsBefore";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesDescriptorsAfter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reincludedRoots";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/dependenciesCache/RescannedRootsUtil";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeLib";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterLib";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/dependenciesCache/RescannedRootsUtil";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildersForReincludedFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAndRemoveFilesUnder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryIteratorBuilders";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryIteratorBuilders";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexableSetIteratorBuilders";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUnexcludedRootsIteratorBuilders";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createBuildersForReincludedFiles";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryIteratorBuilders";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryIteratorBuilders";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getIndexableSetIteratorBuilders";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 8, 9, 11, 14, 15, 17, 18, 21 -> new IllegalStateException(string2);
        };
    }
}

