/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.dependenciesCache;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.roots.SyntheticLibraryIndexableFilesIteratorImpl;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SyntheticLibraryDescriptor {
    @NotNull
    public final Class<? extends AdditionalLibraryRootsProvider> providerClass;
    @NotNull
    public final AdditionalLibraryRootsProvider provider;
    @Nullable
    public final String comparisonId;
    @NotNull
    public final SyntheticLibrary library;
    @Nullable
    @NlsSafe
    public final String presentableLibraryName;
    @NotNull
    @NlsSafe
    public final String debugLibraryName;
    @NotNull
    public final Set<VirtualFile> sourceRoots;
    @NotNull
    public final Set<VirtualFile> binaryRoots;
    @NotNull
    public final Set<VirtualFile> excludedRoots;
    public final boolean hasExcludeFileCondition;

    SyntheticLibraryDescriptor(@NotNull SyntheticLibrary library, @NotNull AdditionalLibraryRootsProvider provider2) {
        if (library == null) {
            SyntheticLibraryDescriptor.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            SyntheticLibraryDescriptor.$$$reportNull$$$0(1);
        }
        this(provider2, library, library instanceof ItemPresentation ? ((ItemPresentation)((Object)library)).getPresentableText() : null, library.toString(), Set.copyOf(library.getSourceRoots()), Set.copyOf(library.getBinaryRoots()), Set.copyOf(library.getExcludedRoots()), library.getExcludeFileCondition());
    }

    private SyntheticLibraryDescriptor(@NotNull AdditionalLibraryRootsProvider provider2, @NotNull SyntheticLibrary library, @Nullable String presentableLibraryName, @NotNull String debugLibraryName, @NotNull Set<VirtualFile> sourceRoots, @NotNull Set<VirtualFile> binaryRoots, @NotNull Set<VirtualFile> excludedRoots, @Nullable Condition<VirtualFile> excludeFileCondition) {
        if (provider2 == null) {
            SyntheticLibraryDescriptor.$$$reportNull$$$0(2);
        }
        if (library == null) {
            SyntheticLibraryDescriptor.$$$reportNull$$$0(3);
        }
        if (debugLibraryName == null) {
            SyntheticLibraryDescriptor.$$$reportNull$$$0(4);
        }
        if (sourceRoots == null) {
            SyntheticLibraryDescriptor.$$$reportNull$$$0(5);
        }
        if (binaryRoots == null) {
            SyntheticLibraryDescriptor.$$$reportNull$$$0(6);
        }
        if (excludedRoots == null) {
            SyntheticLibraryDescriptor.$$$reportNull$$$0(7);
        }
        this.provider = provider2;
        this.providerClass = provider2.getClass();
        this.comparisonId = library.getComparisonId();
        this.library = library;
        this.presentableLibraryName = presentableLibraryName;
        this.debugLibraryName = debugLibraryName;
        this.sourceRoots = sourceRoots;
        this.binaryRoots = binaryRoots;
        this.excludedRoots = excludedRoots;
        this.hasExcludeFileCondition = excludeFileCondition != null;
    }

    @NotNull
    public SyntheticLibraryIndexableFilesIteratorImpl toIndexableIterator() {
        return new SyntheticLibraryIndexableFilesIteratorImpl(this.presentableLibraryName, this.library, this.getAllRoots());
    }

    @Nullable
    public SyntheticLibraryDescriptor getLibForIncrementalRescanning(@Nullable Collection<? extends SyntheticLibraryDescriptor> before) {
        if (before == null || this.comparisonId == null || this.hasExcludeFileCondition) {
            return null;
        }
        return (SyntheticLibraryDescriptor)((Object)ContainerUtil.find(before, lib -> this.comparisonId.equals(lib.comparisonId)));
    }

    @NotNull
    public Set<VirtualFile> getAllRoots() {
        Set<VirtualFile> set2 = ContainerUtil.union(this.sourceRoots, this.binaryRoots);
        if (set2 == null) {
            SyntheticLibraryDescriptor.$$$reportNull$$$0(8);
        }
        return set2;
    }

    public final boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            SyntheticLibraryDescriptor.$$$reportNull$$$0(9);
        }
        return this.contains(file2, true, true);
    }

    public boolean contains(@NotNull VirtualFile file2, boolean includeSources, boolean includeBinaries) {
        if (file2 == null) {
            SyntheticLibraryDescriptor.$$$reportNull$$$0(10);
        }
        return this.isUnderRoots(file2, includeSources, includeBinaries) && !VfsUtilCore.isUnder(file2, this.excludedRoots);
    }

    private boolean isUnderRoots(@NotNull VirtualFile file2, boolean includeSources, boolean includeBinaries) {
        if (file2 == null) {
            SyntheticLibraryDescriptor.$$$reportNull$$$0(11);
        }
        if (includeSources && VfsUtilCore.isUnder(file2, this.sourceRoots)) {
            return true;
        }
        return includeBinaries && VfsUtilCore.isUnder(file2, this.binaryRoots);
    }

    public String toString() {
        return "SyntheticLibraryDescriptor{providerClass=" + this.providerClass.getSimpleName() + ", sourceRoots=" + this.sourceRoots + ", binaryRoots=" + this.binaryRoots + ", excludedRoots=" + this.excludedRoots + ", hasExcludeFileCondition=" + this.hasExcludeFileCondition + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugLibraryName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryRoots";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/dependenciesCache/SyntheticLibraryDescriptor";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/dependenciesCache/SyntheticLibraryDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUnderRoots";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8 -> new IllegalStateException(string2);
        };
    }
}

