/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.diagnostic.ChangedFilesPushedDiagnostic;
import com.intellij.util.indexing.diagnostic.ChangedFilesPushedEvent;
import com.intellij.util.indexing.diagnostic.ChangedFilesPushingStatistics;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.dto.JsonDuration;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u000e\u001a\u00020\u000fR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/diagnostic/ChangedFilesPushedDiagnostic;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJacksonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "jacksonMapper$delegate", "Lkotlin/Lazy;", "addEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/util/indexing/diagnostic/ChangedFilesPushingStatistics;", "appendEvent", "Lcom/intellij/util/indexing/diagnostic/ChangedFilesPushedEvent;", "getEventsFile", "Ljava/nio/file/Path;", "readEvents", "", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nChangedFilesPushedDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangedFilesPushedDiagnostic.kt\ncom/intellij/util/indexing/diagnostic/ChangedFilesPushedDiagnostic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,64:1\n1549#2:65\n1620#2,2:66\n1622#2:70\n50#3:68\n43#3:69\n8#4:71\n*S KotlinDebug\n*F\n+ 1 ChangedFilesPushedDiagnostic.kt\ncom/intellij/util/indexing/diagnostic/ChangedFilesPushedDiagnostic\n*L\n33#1:65\n33#1:66,2\n33#1:70\n33#1:68\n33#1:69\n21#1:71\n*E\n"})
public final class ChangedFilesPushedDiagnostic {
    @NotNull
    public static final ChangedFilesPushedDiagnostic INSTANCE;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Lazy jacksonMapper$delegate;

    private ChangedFilesPushedDiagnostic() {
    }

    public final void addEvent(@NotNull Project project2, @NotNull ChangedFilesPushingStatistics event) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.appendEvent(project2, new ChangedFilesPushedEvent(event.getReason(), event.getStartTime(), new JsonDuration(event.getDuration()), event.isCancelled()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ChangedFilesPushedEvent> readEvents(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Path eventsFile = this.getEventsFile(project2);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(eventsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return CollectionsKt.emptyList();
        }
        try {
            void $this$mapTo$iv$iv;
            Path path2 = eventsFile;
            List<String> list2 = Files.readAllLines(path2, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(this, charset)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ObjectMapper $this$readValue$iv = INSTANCE.getJacksonMapper();
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                collection.add((ChangedFilesPushedEvent)$this$readValue$iv.readValue((String)it, (TypeReference)new TypeReference<ChangedFilesPushedEvent>(){}));
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            LOG.warn("Failed to read " + eventsFile, e);
            return CollectionsKt.emptyList();
        }
    }

    private final void appendEvent(Project project2, ChangedFilesPushedEvent event) {
        try {
            Path file2 = this.getEventsFile(project2);
            String string2 = this.getJacksonMapper().writeValueAsString((Object)event);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jacksonMapper.writeValueAsString(event)");
            String jsonLine = StringsKt.replace$default((String)string2, (String)"\n", (String)" ", (boolean)false, (int)4, null);
            Path path2 = file2;
            Iterable iterable = CollectionsKt.listOf((Object)jsonLine);
            Charset charset = Charsets.UTF_8;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
            Intrinsics.checkNotNullExpressionValue((Object)Files.write(path2, (Iterable<? extends CharSequence>)iterable, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(this, lines, charset, *options)");
        }
        catch (Exception e) {
            LOG.warn("Failed to append changed files pushing event: " + event, e);
        }
    }

    private final Path getEventsFile(Project project2) {
        Path path2 = IndexDiagnosticDumper.Companion.getProjectDiagnosticDirectory(project2).resolve("changed-files-pushing-events.json");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"IndexDiagnosticDumper.ge\u2026les-pushing-events.json\")");
        return path2;
    }

    private final ObjectMapper getJacksonMapper() {
        Lazy lazy = jacksonMapper$delegate;
        return (ObjectMapper)lazy.getValue();
    }

    static {
        ChangedFilesPushedDiagnostic $this$thisLogger$iv = INSTANCE = new ChangedFilesPushedDiagnostic();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ChangedFilesPushedDiagnostic.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
        jacksonMapper$delegate = LazyKt.lazy((Function0)jacksonMapper.2.INSTANCE);
    }
}

