/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.util.indexing.diagnostic.dto.JsonDateTime;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0012\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eR\u001e\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/indexing/diagnostic/ChangedFilesPushingStatistics;", "", "reason", "", "Lorg/jetbrains/annotations/NonNls;", "(Ljava/lang/String;)V", "duration", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "getDuration", "()J", "setDuration", "(J)V", "isCancelled", "", "()Z", "setCancelled", "(Z)V", "getReason", "()Ljava/lang/String;", "startTime", "Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime;", "getStartTime", "()Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime;", "setStartTime", "(Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime;)V", "finished", "", "cancelled", "intellij.platform.lang.impl"})
public final class ChangedFilesPushingStatistics {
    @NotNull
    private final String reason;
    @NotNull
    private JsonDateTime startTime;
    private long duration;
    private boolean isCancelled;

    public ChangedFilesPushingStatistics(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.reason = reason;
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now()");
        this.startTime = new JsonDateTime(zonedDateTime);
        this.duration = System.nanoTime();
    }

    @NotNull
    public final String getReason() {
        return this.reason;
    }

    @NotNull
    public final JsonDateTime getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(@NotNull JsonDateTime jsonDateTime) {
        Intrinsics.checkNotNullParameter((Object)jsonDateTime, (String)"<set-?>");
        this.startTime = jsonDateTime;
    }

    public final long getDuration() {
        return this.duration;
    }

    public final void setDuration(long l) {
        this.duration = l;
    }

    public final boolean isCancelled() {
        return this.isCancelled;
    }

    public final void setCancelled(boolean bl) {
        this.isCancelled = bl;
    }

    public final void finished(boolean cancelled) {
        this.isCancelled = cancelled;
        this.duration = System.nanoTime() - this.duration;
    }
}

