/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.fasterxml.jackson.core.JsonParser;
import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.indexing.diagnostic.ChangedFilesPushedDiagnostic;
import com.intellij.util.indexing.diagnostic.ChangedFilesPushedEvent;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumperUtils;
import com.intellij.util.indexing.diagnostic.JsonSharedIndexDiagnosticEvent;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryListener;
import com.intellij.util.indexing.diagnostic.SharedIndexDiagnostic;
import com.intellij.util.indexing.diagnostic.dto.JsonIndexDiagnostic;
import com.intellij.util.indexing.diagnostic.dto.JsonIndexDiagnosticAppInfo;
import com.intellij.util.indexing.diagnostic.dto.JsonProjectIndexingFileCount;
import com.intellij.util.indexing.diagnostic.dto.JsonProjectIndexingHistoryTimes;
import com.intellij.util.indexing.diagnostic.dto.JsonRuntimeInfo;
import com.intellij.util.indexing.diagnostic.presentation.JsonToHtmlConverterKt;
import com.intellij.util.io.PathKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u000201B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J3\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001e0\"H\u0002\u00a2\u0006\u0002\u0010#J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180'2\u0006\u0010(\u001a\u00020\u0018H\u0002J\u000e\u0010)\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010*\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\nJ\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010(\u001a\u00020\u0018H\u0002J!\u0010,\u001a\u00020\u00122\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120.\u00a2\u0006\u0002\b/H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\b\u001a(\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b \u0005*\u0012\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\f\u00a2\u0006\u0002\b\u000b0\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper;", "Lcom/intellij/openapi/Disposable;", "()V", "indexingHistoryListenerPublisher", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryListener;", "kotlin.jvm.PlatformType", "isDisposed", "", "unsavedIndexingHistories", "", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl;", "Lorg/jetbrains/annotations/NotNull;", "", "deleteOutdatedDiagnostics", "", "Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ExistingDiagnostic;", "existingDiagnostics", "dispose", "", "dumpProjectIndexingHistoryToLogSubdirectory", "projectIndexingHistory", "fastReadAppInfo", "Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnosticAppInfo;", "jsonFile", "Ljava/nio/file/Path;", "fastReadFileCount", "Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingFileCount;", "fastReadIndexingHistoryTimes", "Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingHistoryTimes;", "fastReadJsonField", "T", "propertyName", "", "type", "Ljava/lang/Class;", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "fastReadRuntimeInfo", "Lcom/intellij/util/indexing/diagnostic/dto/JsonRuntimeInfo;", "getFilesForNewJsonAndHtmlDiagnostics", "Lkotlin/Pair;", "indexDiagnosticDirectory", "onIndexingFinished", "onIndexingStarted", "parseExistingDiagnostics", "runAllListenersSafely", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "Companion", "ExistingDiagnostic", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nIndexDiagnosticDumper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexDiagnosticDumper.kt\ncom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n1054#2:356\n*S KotlinDebug\n*F\n+ 1 IndexDiagnosticDumper.kt\ncom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper\n*L\n287#1:356\n*E\n"})
public final class IndexDiagnosticDumper
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final ProjectIndexingHistoryListener indexingHistoryListenerPublisher = ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectIndexingHistoryListener.Companion.getTOPIC());
    private boolean isDisposed;
    @NotNull
    private final Set<ProjectIndexingHistoryImpl> unsavedIndexingHistories;
    @NotNull
    private static final String fileNamePrefix = "diagnostic-";
    @NotNull
    private static final ExtensionPointName<ProjectIndexingHistoryListener> projectIndexingHistoryListenerEpName = ExtensionPointName.Companion.create("com.intellij.projectIndexingHistoryListener");
    @TestOnly
    private static boolean shouldDumpInUnitTestMode;
    private static final boolean shouldDumpPathsOfFilesIndexedByInfrastructureExtensions;
    @NotNull
    private static final Logger LOG;

    public IndexDiagnosticDumper() {
        Set set2 = ConcurrentCollectionFactory.createConcurrentIdentitySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"createConcurrentIdentity\u2026ectIndexingHistoryImpl>()");
        this.unsavedIndexingHistories = set2;
    }

    public final void onIndexingStarted(@NotNull ProjectIndexingHistoryImpl projectIndexingHistory) {
        Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
        this.runAllListenersSafely((Function1<? super ProjectIndexingHistoryListener, Unit>)((Function1)new Function1<ProjectIndexingHistoryListener, Unit>(projectIndexingHistory){
            final /* synthetic */ ProjectIndexingHistoryImpl $projectIndexingHistory;
            {
                this.$projectIndexingHistory = $projectIndexingHistory;
                super(1);
            }

            public final void invoke(@NotNull ProjectIndexingHistoryListener $this$runAllListenersSafely) {
                Intrinsics.checkNotNullParameter((Object)$this$runAllListenersSafely, (String)"$this$runAllListenersSafely");
                $this$runAllListenersSafely.onStartedIndexing(this.$projectIndexingHistory);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onIndexingFinished(@NotNull ProjectIndexingHistoryImpl projectIndexingHistory) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
                try {
                    if (!ApplicationManager.getApplication().isUnitTestMode() || shouldDumpInUnitTestMode) break block4;
                    this.runAllListenersSafely((Function1<? super ProjectIndexingHistoryListener, Unit>)((Function1)new Function1<ProjectIndexingHistoryListener, Unit>(projectIndexingHistory){
                        final /* synthetic */ ProjectIndexingHistoryImpl $projectIndexingHistory;
                        {
                            this.$projectIndexingHistory = $projectIndexingHistory;
                            super(1);
                        }

                        public final void invoke(@NotNull ProjectIndexingHistoryListener $this$runAllListenersSafely) {
                            Intrinsics.checkNotNullParameter((Object)$this$runAllListenersSafely, (String)"$this$runAllListenersSafely");
                            $this$runAllListenersSafely.onFinishedIndexing(this.$projectIndexingHistory);
                        }
                    }));
                    return;
                }
                catch (Throwable throwable) {
                    this.runAllListenersSafely((Function1<? super ProjectIndexingHistoryListener, Unit>)((Function1)new /* invalid duplicate definition of identical inner class */));
                    throw throwable;
                }
            }
            if (!projectIndexingHistory.getTimes().getWasInterrupted() || IndexDiagnosticDumper.Companion.getShouldDumpDiagnosticsForInterruptedUpdaters()) break block5;
            this.runAllListenersSafely((Function1<? super ProjectIndexingHistoryListener, Unit>)((Function1)new /* invalid duplicate definition of identical inner class */));
            return;
        }
        projectIndexingHistory.indexingFinished();
        this.unsavedIndexingHistories.add(projectIndexingHistory);
        NonUrgentExecutor.getInstance().execute(() -> IndexDiagnosticDumper.onIndexingFinished$lambda$0(this, projectIndexingHistory));
        this.runAllListenersSafely((Function1<? super ProjectIndexingHistoryListener, Unit>)((Function1)new /* invalid duplicate definition of identical inner class */));
    }

    private final void runAllListenersSafely(Function1<? super ProjectIndexingHistoryListener, Unit> block) {
        List listeners = ProgressManager.getInstance().computeInNonCancelableSection(IndexDiagnosticDumper::runAllListenersSafely$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)listeners, (String)"listeners");
        for (ProjectIndexingHistoryListener listener2 : SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)listeners), (Object)this.indexingHistoryListenerPublisher)) {
            try {
                Intrinsics.checkNotNullExpressionValue((Object)listener2, (String)"listener");
                block.invoke((Object)listener2);
            }
            catch (Exception e) {
                if (e instanceof ControlFlowException) continue;
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void dumpProjectIndexingHistoryToLogSubdirectory(ProjectIndexingHistoryImpl projectIndexingHistory) {
        if (!this.unsavedIndexingHistories.remove(projectIndexingHistory)) {
            return;
        }
        try {
            if (!(!this.isDisposed)) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            Path indexDiagnosticDirectory = Companion.getProjectDiagnosticDirectory(projectIndexingHistory.getProject());
            Pair<Path, Path> pair = this.getFilesForNewJsonAndHtmlDiagnostics(indexDiagnosticDirectory);
            Path diagnosticJson = (Path)pair.component1();
            Path diagnosticHtml = (Path)pair.component2();
            JsonIndexDiagnostic jsonIndexDiagnostic = JsonIndexDiagnostic.Companion.generateForHistory(projectIndexingHistory);
            IndexDiagnosticDumperUtils.INSTANCE.writeValue(diagnosticJson, jsonIndexDiagnostic);
            Object object = diagnosticHtml;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            object = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
            object2 = null;
            try {
                Object it = (BufferedWriter)object;
                boolean bl = false;
                it = JsonToHtmlConverterKt.generateHtml(jsonIndexDiagnostic, (Appendable)it);
            }
            catch (Throwable it) {
                object2 = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            List<ExistingDiagnostic> existingDiagnostics = this.parseExistingDiagnostics(indexDiagnosticDirectory);
            List<ExistingDiagnostic> survivedDiagnostics = this.deleteOutdatedDiagnostics(existingDiagnostics);
            List<JsonSharedIndexDiagnosticEvent> sharedIndexEvents = SharedIndexDiagnostic.INSTANCE.readEvents(projectIndexingHistory.getProject());
            List<ChangedFilesPushedEvent> changedFilesPushedEvents = ChangedFilesPushedDiagnostic.INSTANCE.readEvents(projectIndexingHistory.getProject());
            Path path2 = indexDiagnosticDirectory.resolve("report.html");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"indexDiagnosticDirectory.resolve(\"report.html\")");
            Object object3 = path2;
            OpenOption[] openOptionArray2 = new OpenOption[]{};
            Object object4 = Charsets.UTF_8;
            int n2 = 8192;
            object3 = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object3, Arrays.copyOf(openOptionArray2, openOptionArray2.length)), (Charset)object4), n2);
            object4 = null;
            try {
                BufferedWriter it = (BufferedWriter)object3;
                boolean bl = false;
                Appendable appendable = it;
                String string3 = projectIndexingHistory.getProject().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"projectIndexingHistory.project.name");
                JsonToHtmlConverterKt.createAggregateHtml(appendable, string3, survivedDiagnostics, sharedIndexEvents, changedFilesPushedEvents);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object4 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)object4);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to dump index diagnostic", e);
        }
    }

    private final Pair<Path, Path> getFilesForNewJsonAndHtmlDiagnostics(Path indexDiagnosticDirectory) {
        Path diagnosticJson = null;
        Path diagnosticHtml = null;
        LocalDateTime nowTime = LocalDateTime.now();
        while (true) {
            LocalDateTime localDateTime = nowTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"nowTime");
            diagnosticJson = IndexDiagnosticDumperUtils.getDumpFilePath$default(IndexDiagnosticDumperUtils.INSTANCE, fileNamePrefix, localDateTime, "json", indexDiagnosticDirectory, null, 16, null);
            LocalDateTime localDateTime2 = nowTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"nowTime");
            diagnosticHtml = IndexDiagnosticDumperUtils.getDumpFilePath$default(IndexDiagnosticDumperUtils.INSTANCE, fileNamePrefix, localDateTime2, "html", indexDiagnosticDirectory, null, 16, null);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(diagnosticJson, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.exists(diagnosticHtml, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break;
            }
            nowTime = nowTime.plusNanos(TimeUnit.MILLISECONDS.toNanos(1L));
        }
        return TuplesKt.to((Object)diagnosticJson, (Object)diagnosticHtml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final <T> T fastReadJsonField(Path jsonFile, String propertyName, Class<T> type) {
        try {
            Object object = jsonFile;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
            object2 = null;
            try {
                BufferedReader reader = (BufferedReader)object;
                boolean bl = false;
                Closeable closeable = (Closeable)IndexDiagnosticDumperUtils.INSTANCE.getJacksonMapper().getFactory().createParser((Reader)reader);
                Throwable throwable = null;
                try {
                    JsonParser parser = (JsonParser)closeable;
                    boolean bl2 = false;
                    while (parser.nextToken() != null) {
                        String property = parser.getCurrentName();
                        if (!Intrinsics.areEqual((Object)property, (Object)propertyName)) continue;
                        parser.nextToken();
                        Object object3 = IndexDiagnosticDumperUtils.INSTANCE.getJacksonMapper().readValue(parser, type);
                        Object object4 = object3;
                        return (T)object4;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Unit unit = Unit.INSTANCE;
                return null;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to parse project indexing time", e);
        }
        return null;
    }

    private final JsonProjectIndexingHistoryTimes fastReadIndexingHistoryTimes(Path jsonFile) {
        return this.fastReadJsonField(jsonFile, "times", JsonProjectIndexingHistoryTimes.class);
    }

    private final JsonProjectIndexingFileCount fastReadFileCount(Path jsonFile) {
        return this.fastReadJsonField(jsonFile, "fileCount", JsonProjectIndexingFileCount.class);
    }

    private final JsonIndexDiagnosticAppInfo fastReadAppInfo(Path jsonFile) {
        return this.fastReadJsonField(jsonFile, "appInfo", JsonIndexDiagnosticAppInfo.class);
    }

    private final JsonRuntimeInfo fastReadRuntimeInfo(Path jsonFile) {
        return this.fastReadJsonField(jsonFile, "runtimeInfo", JsonRuntimeInfo.class);
    }

    private final List<ExistingDiagnostic> deleteOutdatedDiagnostics(List<ExistingDiagnostic> existingDiagnostics) {
        Iterable $this$sortedByDescending$iv = existingDiagnostics;
        boolean $i$f$sortedByDescending = false;
        List sortedDiagnostics = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ExistingDiagnostic it = (ExistingDiagnostic)b;
                boolean bl = false;
                Comparable comparable = it.getIndexingTimes().getUpdatingStart().getInstant();
                it = (ExistingDiagnostic)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getIndexingTimes().getUpdatingStart().getInstant());
            }
        });
        long sizeLimit = (long)(IndexDiagnosticDumper.Companion.getIndexingDiagnosticsSizeLimitOfFilesInMiBPerProject() * 1024) * 1024L;
        int numberLimit = 0;
        if (ApplicationManagerEx.isInIntegrationTest()) {
            numberLimit = existingDiagnostics.size();
        } else if (sizeLimit > 0L) {
            Pair pair = IndexDiagnosticDumper.Companion.getDiagnosticNumberLimitWithinSizeLimit(existingDiagnostics, sizeLimit);
            numberLimit = ((Number)pair.getFirst()).intValue();
            sizeLimit = ((Number)pair.getSecond()).longValue();
        } else {
            numberLimit = IndexDiagnosticDumper.Companion.getIndexingDiagnosticsLimitOfFiles();
        }
        LOG.debug("deleteOutdatedDiagnostics, existing size " + existingDiagnostics.size() + "; sizeLimit " + sizeLimit + ", indexingDiagnosticsLimitOfFiles " + IndexDiagnosticDumper.Companion.getIndexingDiagnosticsLimitOfFiles() + ", numberLimit " + numberLimit);
        List survivedDiagnostics = CollectionsKt.take((Iterable)sortedDiagnostics, (int)numberLimit);
        List outdatedDiagnostics = CollectionsKt.drop((Iterable)sortedDiagnostics, (int)numberLimit);
        for (ExistingDiagnostic diagnostic : outdatedDiagnostics) {
            PathKt.delete$default(diagnostic.getJsonFile(), false, 1, null);
            PathKt.delete$default(diagnostic.getHtmlFile(), false, 1, null);
        }
        return survivedDiagnostics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<ExistingDiagnostic> parseExistingDiagnostics(Path indexDiagnosticDirectory) {
        List list2;
        AutoCloseable autoCloseable = Files.list(indexDiagnosticDirectory);
        Throwable throwable = null;
        try {
            Stream files2 = (Stream)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)files2, (String)"files");
            list2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)files2), (Function1)parseExistingDiagnostics.1.1.INSTANCE), (Function1)((Function1)new Function1<Path, ExistingDiagnostic>(this){
                final /* synthetic */ IndexDiagnosticDumper this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final ExistingDiagnostic invoke(Path jsonFile) {
                    Intrinsics.checkNotNullExpressionValue((Object)jsonFile, (String)"jsonFile");
                    JsonProjectIndexingHistoryTimes jsonProjectIndexingHistoryTimes = IndexDiagnosticDumper.access$fastReadIndexingHistoryTimes(this.this$0, jsonFile);
                    if (jsonProjectIndexingHistoryTimes == null) {
                        return null;
                    }
                    JsonProjectIndexingHistoryTimes times = jsonProjectIndexingHistoryTimes;
                    JsonIndexDiagnosticAppInfo jsonIndexDiagnosticAppInfo = IndexDiagnosticDumper.access$fastReadAppInfo(this.this$0, jsonFile);
                    if (jsonIndexDiagnosticAppInfo == null) {
                        return null;
                    }
                    JsonIndexDiagnosticAppInfo appInfo = jsonIndexDiagnosticAppInfo;
                    JsonRuntimeInfo jsonRuntimeInfo = IndexDiagnosticDumper.access$fastReadRuntimeInfo(this.this$0, jsonFile);
                    if (jsonRuntimeInfo == null) {
                        return null;
                    }
                    JsonRuntimeInfo runtimeInfo = jsonRuntimeInfo;
                    JsonProjectIndexingFileCount fileCount = IndexDiagnosticDumper.access$fastReadFileCount(this.this$0, jsonFile);
                    Path htmlFile = jsonFile.resolveSibling(PathsKt.getNameWithoutExtension((Path)jsonFile) + ".html");
                    Intrinsics.checkNotNullExpressionValue((Object)htmlFile, (String)"htmlFile");
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.exists(htmlFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        return null;
                    }
                    return new ExistingDiagnostic(jsonFile, htmlFile, times, appInfo, runtimeInfo, fileCount);
                }
            })));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list2;
    }

    @Override
    public synchronized void dispose() {
        for (ProjectIndexingHistoryImpl unsavedIndexingHistory : this.unsavedIndexingHistories) {
            Intrinsics.checkNotNullExpressionValue((Object)unsavedIndexingHistory, (String)"unsavedIndexingHistory");
            this.dumpProjectIndexingHistoryToLogSubdirectory(unsavedIndexingHistory);
        }
        this.isDisposed = true;
    }

    private static final void onIndexingFinished$lambda$0(IndexDiagnosticDumper this$0, ProjectIndexingHistoryImpl $projectIndexingHistory) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$projectIndexingHistory, (String)"$projectIndexingHistory");
        this$0.dumpProjectIndexingHistoryToLogSubdirectory($projectIndexingHistory);
    }

    private static final List runAllListenersSafely$lambda$1() {
        return projectIndexingHistoryListenerEpName.getExtensionList();
    }

    @JvmStatic
    @NotNull
    public static final IndexDiagnosticDumper getInstance() {
        return Companion.getInstance();
    }

    @NotNull
    public static final ExtensionPointName<ProjectIndexingHistoryListener> getProjectIndexingHistoryListenerEpName() {
        return Companion.getProjectIndexingHistoryListenerEpName();
    }

    private static final boolean getShouldDumpDiagnosticsForInterruptedUpdaters() {
        return IndexDiagnosticDumper.Companion.getShouldDumpDiagnosticsForInterruptedUpdaters();
    }

    private static final int getIndexingDiagnosticsLimitOfFiles() {
        return IndexDiagnosticDumper.Companion.getIndexingDiagnosticsLimitOfFiles();
    }

    private static final int getIndexingDiagnosticsSizeLimitOfFilesInMiBPerProject() {
        return IndexDiagnosticDumper.Companion.getIndexingDiagnosticsSizeLimitOfFilesInMiBPerProject();
    }

    public static final boolean getShouldDumpPathsOfIndexedFiles() {
        return Companion.getShouldDumpPathsOfIndexedFiles();
    }

    public static final boolean getShouldDumpProviderRootPaths() {
        return Companion.getShouldDumpProviderRootPaths();
    }

    public static final boolean getShouldProvideVisibleAndAllThreadsTimeInfo() {
        return Companion.getShouldProvideVisibleAndAllThreadsTimeInfo();
    }

    public static final boolean getShouldDumpInUnitTestMode() {
        return Companion.getShouldDumpInUnitTestMode();
    }

    public static final void setShouldDumpInUnitTestMode(boolean bl) {
        Companion.setShouldDumpInUnitTestMode(bl);
    }

    public static final boolean getShouldDumpPathsOfFilesIndexedByInfrastructureExtensions() {
        return Companion.getShouldDumpPathsOfFilesIndexedByInfrastructureExtensions();
    }

    public static final /* synthetic */ JsonProjectIndexingHistoryTimes access$fastReadIndexingHistoryTimes(IndexDiagnosticDumper $this, Path jsonFile) {
        return $this.fastReadIndexingHistoryTimes(jsonFile);
    }

    public static final /* synthetic */ JsonIndexDiagnosticAppInfo access$fastReadAppInfo(IndexDiagnosticDumper $this, Path jsonFile) {
        return $this.fastReadAppInfo(jsonFile);
    }

    public static final /* synthetic */ JsonRuntimeInfo access$fastReadRuntimeInfo(IndexDiagnosticDumper $this, Path jsonFile) {
        return $this.fastReadRuntimeInfo(jsonFile);
    }

    public static final /* synthetic */ JsonProjectIndexingFileCount access$fastReadFileCount(IndexDiagnosticDumper $this, Path jsonFile) {
        return $this.fastReadFileCount(jsonFile);
    }

    static {
        shouldDumpPathsOfFilesIndexedByInfrastructureExtensions = SystemProperties.getBooleanProperty("intellij.indexes.diagnostics.should.dump.paths.indexed.by.infrastructure.extensions", ApplicationManagerEx.isInIntegrationTest());
        Logger logger = Logger.getInstance(IndexDiagnosticDumper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(IndexDiagnosticDumper::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010,\u001a\u00020-J\u0016\u0010.\u001a\u00020\t2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0007J*\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u000203022\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00104\u001a\u000203H\u0002J\b\u00105\u001a\u000206H\u0007J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\b\u0010;\u001a\u00020\u0017H\u0002J\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u000208R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\t8BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\t8BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\fR\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0002\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u00178BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\u00020\u00178\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001c\u0010\u0002\u001a\u0004\b\u001d\u0010\u001a\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u00020\u00178\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\u0002\u001a\u0004\b\"\u0010\u001aR\u001a\u0010#\u001a\u00020\u00178FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b$\u0010\u0002\u001a\u0004\b%\u0010\u001aR\u001a\u0010&\u001a\u00020\u00178FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b'\u0010\u0002\u001a\u0004\b(\u0010\u001aR\u001a\u0010)\u001a\u00020\u00178FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b*\u0010\u0002\u001a\u0004\b+\u0010\u001a\u00a8\u0006?"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "fileNamePrefix", "", "indexingDiagnosticsLimitOfFiles", "", "getIndexingDiagnosticsLimitOfFiles$annotations", "getIndexingDiagnosticsLimitOfFiles", "()I", "indexingDiagnosticsSizeLimitOfFilesInMiBPerProject", "getIndexingDiagnosticsSizeLimitOfFilesInMiBPerProject$annotations", "getIndexingDiagnosticsSizeLimitOfFilesInMiBPerProject", "projectIndexingHistoryListenerEpName", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryListener;", "getProjectIndexingHistoryListenerEpName$annotations", "getProjectIndexingHistoryListenerEpName", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "shouldDumpDiagnosticsForInterruptedUpdaters", "", "getShouldDumpDiagnosticsForInterruptedUpdaters$annotations", "getShouldDumpDiagnosticsForInterruptedUpdaters", "()Z", "shouldDumpInUnitTestMode", "getShouldDumpInUnitTestMode$annotations", "getShouldDumpInUnitTestMode", "setShouldDumpInUnitTestMode", "(Z)V", "shouldDumpPathsOfFilesIndexedByInfrastructureExtensions", "getShouldDumpPathsOfFilesIndexedByInfrastructureExtensions$annotations", "getShouldDumpPathsOfFilesIndexedByInfrastructureExtensions", "shouldDumpPathsOfIndexedFiles", "getShouldDumpPathsOfIndexedFiles$annotations", "getShouldDumpPathsOfIndexedFiles", "shouldDumpProviderRootPaths", "getShouldDumpProviderRootPaths$annotations", "getShouldDumpProviderRootPaths", "shouldProvideVisibleAndAllThreadsTimeInfo", "getShouldProvideVisibleAndAllThreadsTimeInfo$annotations", "getShouldProvideVisibleAndAllThreadsTimeInfo", "clearDiagnostic", "", "getDiagnosticNumberLimitWithinSizeLimit", "existingDiagnostics", "", "Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ExistingDiagnostic;", "Lkotlin/Pair;", "", "sizeLimit", "getInstance", "Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper;", "getProjectDiagnosticDirectory", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "hasProvidedDiagnosticsLimitOfFilesValue", "readJsonIndexDiagnostic", "Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnostic;", "file", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nIndexDiagnosticDumper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexDiagnosticDumper.kt\ncom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 path.kt\ncom/intellij/util/io/PathKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,355:1\n39#2,3:356\n206#3,2:359\n209#3,3:363\n1855#4,2:361\n8#5:366\n*S KotlinDebug\n*F\n+ 1 IndexDiagnosticDumper.kt\ncom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$Companion\n*L\n48#1:356,3\n131#1:359,2\n131#1:363,3\n132#1:361,2\n144#1:366\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IndexDiagnosticDumper getInstance() {
            boolean $i$f$service = false;
            Class<IndexDiagnosticDumper> serviceClass$iv = IndexDiagnosticDumper.class;
            IndexDiagnosticDumper indexDiagnosticDumper = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (indexDiagnosticDumper == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return indexDiagnosticDumper;
        }

        @NotNull
        public final ExtensionPointName<ProjectIndexingHistoryListener> getProjectIndexingHistoryListenerEpName() {
            return projectIndexingHistoryListenerEpName;
        }

        @JvmStatic
        public static /* synthetic */ void getProjectIndexingHistoryListenerEpName$annotations() {
        }

        private final boolean getShouldDumpDiagnosticsForInterruptedUpdaters() {
            return SystemProperties.getBooleanProperty("intellij.indexes.diagnostics.should.dump.for.interrupted.index.updaters", false);
        }

        @JvmStatic
        private static /* synthetic */ void getShouldDumpDiagnosticsForInterruptedUpdaters$annotations() {
        }

        private final int getIndexingDiagnosticsLimitOfFiles() {
            return SystemProperties.getIntProperty("intellij.indexes.diagnostics.limit.of.files", 300);
        }

        @JvmStatic
        private static /* synthetic */ void getIndexingDiagnosticsLimitOfFiles$annotations() {
        }

        private final boolean hasProvidedDiagnosticsLimitOfFilesValue() {
            String providedLimitOfFilesValue = System.getProperty("intellij.indexes.diagnostics.limit.of.files");
            if (providedLimitOfFilesValue == null) {
                return false;
            }
            try {
                Integer.parseInt(providedLimitOfFilesValue);
            }
            catch (NumberFormatException ignored) {
                return false;
            }
            return true;
        }

        private final int getIndexingDiagnosticsSizeLimitOfFilesInMiBPerProject() {
            String providedValue = System.getProperty("intellij.indexes.diagnostics.size.limit.of.files.MiB.per.project");
            if (providedValue != null) {
                try {
                    return Integer.parseInt(providedValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.hasProvidedDiagnosticsLimitOfFilesValue() ? 0 : 10;
        }

        @JvmStatic
        private static /* synthetic */ void getIndexingDiagnosticsSizeLimitOfFilesInMiBPerProject$annotations() {
        }

        public final boolean getShouldDumpPathsOfIndexedFiles() {
            return SystemProperties.getBooleanProperty("intellij.indexes.diagnostics.should.dump.paths.of.indexed.files", false);
        }

        @JvmStatic
        public static /* synthetic */ void getShouldDumpPathsOfIndexedFiles$annotations() {
        }

        public final boolean getShouldDumpProviderRootPaths() {
            return SystemProperties.getBooleanProperty("intellij.indexes.diagnostics.should.dump.provider.root.paths", false);
        }

        @JvmStatic
        public static /* synthetic */ void getShouldDumpProviderRootPaths$annotations() {
        }

        public final boolean getShouldProvideVisibleAndAllThreadsTimeInfo() {
            return SystemProperties.getBooleanProperty("intellij.indexes.diagnostics.should.provide.visible.and.all.threads.time.info", false);
        }

        @JvmStatic
        public static /* synthetic */ void getShouldProvideVisibleAndAllThreadsTimeInfo$annotations() {
        }

        public final boolean getShouldDumpInUnitTestMode() {
            return shouldDumpInUnitTestMode;
        }

        public final void setShouldDumpInUnitTestMode(boolean bl) {
            shouldDumpInUnitTestMode = bl;
        }

        @JvmStatic
        public static /* synthetic */ void getShouldDumpInUnitTestMode$annotations() {
        }

        public final boolean getShouldDumpPathsOfFilesIndexedByInfrastructureExtensions() {
            return shouldDumpPathsOfFilesIndexedByInfrastructureExtensions;
        }

        @JvmStatic
        public static /* synthetic */ void getShouldDumpPathsOfFilesIndexedByInfrastructureExtensions$annotations() {
        }

        @NotNull
        public final JsonIndexDiagnostic readJsonIndexDiagnostic(@NotNull Path file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Object object = IndexDiagnosticDumperUtils.INSTANCE.getJacksonMapper().readValue(file2.toFile(), JsonIndexDiagnostic.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jacksonMapper.readValue(\u2026exDiagnostic::class.java)");
            return (JsonIndexDiagnostic)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clearDiagnostic() {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(IndexDiagnosticDumperUtils.INSTANCE.getIndexingDiagnosticDir(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path $this$directoryStreamIfExists$iv = IndexDiagnosticDumperUtils.INSTANCE.getIndexingDiagnosticDir();
                boolean $i$f$directoryStreamIfExists = false;
                try {
                    Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
                    Throwable throwable = null;
                    try {
                        DirectoryStream dirStream = (DirectoryStream)closeable;
                        boolean bl = false;
                        Iterable $this$forEach$iv = dirStream;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Path it = (Path)element$iv;
                            boolean bl2 = false;
                            FileUtil.deleteWithRenaming(it);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (NoSuchFileException noSuchFileException) {
                }
            }
        }

        @NotNull
        public final Path getProjectDiagnosticDirectory(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Path directory = ProjectUtil.getProjectCachePath$default((Project)project2, (Path)IndexDiagnosticDumperUtils.INSTANCE.getIndexingDiagnosticDir(), (boolean)false, null, (int)6, null);
            PathKt.createDirectories(directory);
            return directory;
        }

        private final Pair<Integer, Long> getDiagnosticNumberLimitWithinSizeLimit(List<ExistingDiagnostic> existingDiagnostics, long sizeLimit) {
            Companion $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Companion.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.assertTrue(sizeLimit > 0L);
            long sizeLimitLevel = sizeLimit;
            int number = 0;
            for (ExistingDiagnostic diagnostic : existingDiagnostics) {
                sizeLimitLevel -= Math.max(0L, PathKt.sizeOrNull(diagnostic.getJsonFile()));
                if ((sizeLimitLevel -= Math.max(0L, PathKt.sizeOrNull(diagnostic.getHtmlFile()))) <= 0L) break;
                ++number;
            }
            return new Pair((Object)Math.min(this.getIndexingDiagnosticsLimitOfFiles(), number), (Object)sizeLimitLevel);
        }

        @TestOnly
        public final int getDiagnosticNumberLimitWithinSizeLimit(@NotNull List<ExistingDiagnostic> existingDiagnostics) {
            Intrinsics.checkNotNullParameter(existingDiagnostics, (String)"existingDiagnostics");
            return ((Number)this.getDiagnosticNumberLimitWithinSizeLimit(existingDiagnostics, (long)(this.getIndexingDiagnosticsSizeLimitOfFilesInMiBPerProject() * 1024) * 1024L).getFirst()).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u00c6\u0003JG\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ExistingDiagnostic;", "", "jsonFile", "Ljava/nio/file/Path;", "htmlFile", "indexingTimes", "Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingHistoryTimes;", "appInfo", "Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnosticAppInfo;", "runtimeInfo", "Lcom/intellij/util/indexing/diagnostic/dto/JsonRuntimeInfo;", "fileCount", "Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingFileCount;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingHistoryTimes;Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnosticAppInfo;Lcom/intellij/util/indexing/diagnostic/dto/JsonRuntimeInfo;Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingFileCount;)V", "getAppInfo", "()Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnosticAppInfo;", "getFileCount", "()Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingFileCount;", "getHtmlFile", "()Ljava/nio/file/Path;", "getIndexingTimes", "()Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingHistoryTimes;", "getJsonFile", "getRuntimeInfo", "()Lcom/intellij/util/indexing/diagnostic/dto/JsonRuntimeInfo;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    public static final class ExistingDiagnostic {
        @NotNull
        private final Path jsonFile;
        @NotNull
        private final Path htmlFile;
        @NotNull
        private final JsonProjectIndexingHistoryTimes indexingTimes;
        @NotNull
        private final JsonIndexDiagnosticAppInfo appInfo;
        @NotNull
        private final JsonRuntimeInfo runtimeInfo;
        @Nullable
        private final JsonProjectIndexingFileCount fileCount;

        public ExistingDiagnostic(@NotNull Path jsonFile, @NotNull Path htmlFile, @NotNull JsonProjectIndexingHistoryTimes indexingTimes, @NotNull JsonIndexDiagnosticAppInfo appInfo, @NotNull JsonRuntimeInfo runtimeInfo, @Nullable JsonProjectIndexingFileCount fileCount) {
            Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
            Intrinsics.checkNotNullParameter((Object)htmlFile, (String)"htmlFile");
            Intrinsics.checkNotNullParameter((Object)indexingTimes, (String)"indexingTimes");
            Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
            Intrinsics.checkNotNullParameter((Object)runtimeInfo, (String)"runtimeInfo");
            this.jsonFile = jsonFile;
            this.htmlFile = htmlFile;
            this.indexingTimes = indexingTimes;
            this.appInfo = appInfo;
            this.runtimeInfo = runtimeInfo;
            this.fileCount = fileCount;
        }

        @NotNull
        public final Path getJsonFile() {
            return this.jsonFile;
        }

        @NotNull
        public final Path getHtmlFile() {
            return this.htmlFile;
        }

        @NotNull
        public final JsonProjectIndexingHistoryTimes getIndexingTimes() {
            return this.indexingTimes;
        }

        @NotNull
        public final JsonIndexDiagnosticAppInfo getAppInfo() {
            return this.appInfo;
        }

        @NotNull
        public final JsonRuntimeInfo getRuntimeInfo() {
            return this.runtimeInfo;
        }

        @Nullable
        public final JsonProjectIndexingFileCount getFileCount() {
            return this.fileCount;
        }

        @NotNull
        public final Path component1() {
            return this.jsonFile;
        }

        @NotNull
        public final Path component2() {
            return this.htmlFile;
        }

        @NotNull
        public final JsonProjectIndexingHistoryTimes component3() {
            return this.indexingTimes;
        }

        @NotNull
        public final JsonIndexDiagnosticAppInfo component4() {
            return this.appInfo;
        }

        @NotNull
        public final JsonRuntimeInfo component5() {
            return this.runtimeInfo;
        }

        @Nullable
        public final JsonProjectIndexingFileCount component6() {
            return this.fileCount;
        }

        @NotNull
        public final ExistingDiagnostic copy(@NotNull Path jsonFile, @NotNull Path htmlFile, @NotNull JsonProjectIndexingHistoryTimes indexingTimes, @NotNull JsonIndexDiagnosticAppInfo appInfo, @NotNull JsonRuntimeInfo runtimeInfo, @Nullable JsonProjectIndexingFileCount fileCount) {
            Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
            Intrinsics.checkNotNullParameter((Object)htmlFile, (String)"htmlFile");
            Intrinsics.checkNotNullParameter((Object)indexingTimes, (String)"indexingTimes");
            Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
            Intrinsics.checkNotNullParameter((Object)runtimeInfo, (String)"runtimeInfo");
            return new ExistingDiagnostic(jsonFile, htmlFile, indexingTimes, appInfo, runtimeInfo, fileCount);
        }

        public static /* synthetic */ ExistingDiagnostic copy$default(ExistingDiagnostic existingDiagnostic, Path path2, Path path3, JsonProjectIndexingHistoryTimes jsonProjectIndexingHistoryTimes, JsonIndexDiagnosticAppInfo jsonIndexDiagnosticAppInfo, JsonRuntimeInfo jsonRuntimeInfo, JsonProjectIndexingFileCount jsonProjectIndexingFileCount, int n, Object object) {
            if ((n & 1) != 0) {
                path2 = existingDiagnostic.jsonFile;
            }
            if ((n & 2) != 0) {
                path3 = existingDiagnostic.htmlFile;
            }
            if ((n & 4) != 0) {
                jsonProjectIndexingHistoryTimes = existingDiagnostic.indexingTimes;
            }
            if ((n & 8) != 0) {
                jsonIndexDiagnosticAppInfo = existingDiagnostic.appInfo;
            }
            if ((n & 0x10) != 0) {
                jsonRuntimeInfo = existingDiagnostic.runtimeInfo;
            }
            if ((n & 0x20) != 0) {
                jsonProjectIndexingFileCount = existingDiagnostic.fileCount;
            }
            return existingDiagnostic.copy(path2, path3, jsonProjectIndexingHistoryTimes, jsonIndexDiagnosticAppInfo, jsonRuntimeInfo, jsonProjectIndexingFileCount);
        }

        @NotNull
        public String toString() {
            return "ExistingDiagnostic(jsonFile=" + this.jsonFile + ", htmlFile=" + this.htmlFile + ", indexingTimes=" + this.indexingTimes + ", appInfo=" + this.appInfo + ", runtimeInfo=" + this.runtimeInfo + ", fileCount=" + this.fileCount + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.jsonFile).hashCode();
            result2 = result2 * 31 + ((Object)this.htmlFile).hashCode();
            result2 = result2 * 31 + this.indexingTimes.hashCode();
            result2 = result2 * 31 + this.appInfo.hashCode();
            result2 = result2 * 31 + this.runtimeInfo.hashCode();
            result2 = result2 * 31 + (this.fileCount == null ? 0 : this.fileCount.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExistingDiagnostic)) {
                return false;
            }
            ExistingDiagnostic existingDiagnostic = (ExistingDiagnostic)other;
            if (!Intrinsics.areEqual((Object)this.jsonFile, (Object)existingDiagnostic.jsonFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.htmlFile, (Object)existingDiagnostic.htmlFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexingTimes, (Object)existingDiagnostic.indexingTimes)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.appInfo, (Object)existingDiagnostic.appInfo)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.runtimeInfo, (Object)existingDiagnostic.runtimeInfo)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fileCount, (Object)existingDiagnostic.fileCount);
        }
    }
}

