/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.diagnostic.FileIndexingStatistics;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.LimitedPriorityQueue;
import com.intellij.util.indexing.diagnostic.SlowIndexedFile;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePaths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 O2\u00020\u0001:\u0004OPQRB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JN\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\n\u0010F\u001a\u00060\bj\u0002`\t2\n\u0010G\u001a\u00060\bj\u0002`\t2\n\u0010H\u001a\u00060\bj\u0002`I2\u0006\u0010J\u001a\u00020\u000f2\n\u0010K\u001a\u00060\bj\u0002`\tJ\u000e\u0010L\u001a\u00020A2\u0006\u0010B\u001a\u00020CJ\u0010\u0010M\u001a\u00020N2\u0006\u0010B\u001a\u00020CH\u0002R\u001e\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00060\bj\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u001aj\b\u0012\u0004\u0012\u00020\u001b`\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR*\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u001aj\b\u0012\u0004\u0012\u00020\u0005`\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001e\"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u001a\u0010,\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010&\"\u0004\b.\u0010(R\u001e\u0010/\u001a\u00060\bj\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u000b\"\u0004\b1\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020403\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R-\u00107\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020908j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u000209`:\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R-\u0010=\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020>08j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020>`:\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010<\u00a8\u0006S"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingFileSetStatistics;", "", "project", "Lcom/intellij/openapi/project/Project;", "fileSetName", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "allSeparateApplicationTimeInAllThreads", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "getAllSeparateApplicationTimeInAllThreads", "()J", "setAllSeparateApplicationTimeInAllThreads", "(J)V", "allValuesAppliedSeparately", "", "getAllValuesAppliedSeparately", "()Z", "setAllValuesAppliedSeparately", "(Z)V", "contentLoadingTimeInAllThreads", "getContentLoadingTimeInAllThreads", "setContentLoadingTimeInAllThreads", "getFileSetName", "()Ljava/lang/String;", "indexedFiles", "Ljava/util/ArrayList;", "Lcom/intellij/util/indexing/diagnostic/IndexingFileSetStatistics$IndexedFile;", "Lkotlin/collections/ArrayList;", "getIndexedFiles", "()Ljava/util/ArrayList;", "listOfFilesFullyIndexedByExtensions", "getListOfFilesFullyIndexedByExtensions", "setListOfFilesFullyIndexedByExtensions", "(Ljava/util/ArrayList;)V", "numberOfFilesFullyIndexedByExtensions", "", "getNumberOfFilesFullyIndexedByExtensions", "()I", "setNumberOfFilesFullyIndexedByExtensions", "(I)V", "numberOfIndexedFiles", "getNumberOfIndexedFiles", "setNumberOfIndexedFiles", "numberOfTooLargeForIndexingFiles", "getNumberOfTooLargeForIndexingFiles", "setNumberOfTooLargeForIndexingFiles", "processingTimeInAllThreads", "getProcessingTimeInAllThreads", "setProcessingTimeInAllThreads", "slowIndexedFiles", "Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "Lcom/intellij/util/indexing/diagnostic/SlowIndexedFile;", "getSlowIndexedFiles", "()Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "statsPerFileType", "Ljava/util/HashMap;", "Lcom/intellij/util/indexing/diagnostic/IndexingFileSetStatistics$StatsPerFileType;", "Lkotlin/collections/HashMap;", "getStatsPerFileType", "()Ljava/util/HashMap;", "statsPerIndexer", "Lcom/intellij/util/indexing/diagnostic/IndexingFileSetStatistics$StatsPerIndexer;", "getStatsPerIndexer", "addFileStatistics", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileStatistics", "Lcom/intellij/util/indexing/diagnostic/FileIndexingStatistics;", "processingTime", "contentLoadingTime", "fileSize", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "valuesAppliedSeparately", "separateApplicationTime", "addTooLargeForIndexingFile", "getIndexedFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "Companion", "IndexedFile", "StatsPerFileType", "StatsPerIndexer", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nIndexingFileSetStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexingFileSetStatistics.kt\ncom/intellij/util/indexing/diagnostic/IndexingFileSetStatistics\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,128:1\n215#2,2:129\n215#2:131\n216#2:139\n361#3,7:132\n361#3,7:140\n*S KotlinDebug\n*F\n+ 1 IndexingFileSetStatistics.kt\ncom/intellij/util/indexing/diagnostic/IndexingFileSetStatistics\n*L\n80#1:129,2\n83#1:131\n83#1:139\n84#1:132,7\n95#1:140,7\n*E\n"})
public final class IndexingFileSetStatistics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String fileSetName;
    private long processingTimeInAllThreads;
    private long contentLoadingTimeInAllThreads;
    private int numberOfIndexedFiles;
    @NotNull
    private ArrayList<String> listOfFilesFullyIndexedByExtensions;
    private int numberOfFilesFullyIndexedByExtensions;
    private int numberOfTooLargeForIndexingFiles;
    @NotNull
    private final HashMap<String, StatsPerIndexer> statsPerIndexer;
    @NotNull
    private final HashMap<String, StatsPerFileType> statsPerFileType;
    @NotNull
    private final ArrayList<IndexedFile> indexedFiles;
    @NotNull
    private final LimitedPriorityQueue<SlowIndexedFile> slowIndexedFiles;
    private boolean allValuesAppliedSeparately;
    private long allSeparateApplicationTimeInAllThreads;
    public static final int SLOW_FILES_LIMIT = 10;
    public static final int SLOW_FILE_PROCESSING_THRESHOLD_MS = 500;

    public IndexingFileSetStatistics(@NotNull Project project2, @NotNull String fileSetName) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileSetName, (String)"fileSetName");
        this.project = project2;
        this.fileSetName = fileSetName;
        this.listOfFilesFullyIndexedByExtensions = new ArrayList();
        this.statsPerIndexer = new HashMap();
        this.statsPerFileType = new HashMap();
        this.indexedFiles = new ArrayList();
        this.slowIndexedFiles = new LimitedPriorityQueue(10, new Comparator(){

            public final int compare(T a, T b) {
                SlowIndexedFile it = (SlowIndexedFile)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getProcessingTime());
                it = (SlowIndexedFile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getProcessingTime()));
            }
        });
        this.allValuesAppliedSeparately = true;
    }

    @NotNull
    public final String getFileSetName() {
        return this.fileSetName;
    }

    public final long getProcessingTimeInAllThreads() {
        return this.processingTimeInAllThreads;
    }

    public final void setProcessingTimeInAllThreads(long l) {
        this.processingTimeInAllThreads = l;
    }

    public final long getContentLoadingTimeInAllThreads() {
        return this.contentLoadingTimeInAllThreads;
    }

    public final void setContentLoadingTimeInAllThreads(long l) {
        this.contentLoadingTimeInAllThreads = l;
    }

    public final int getNumberOfIndexedFiles() {
        return this.numberOfIndexedFiles;
    }

    public final void setNumberOfIndexedFiles(int n) {
        this.numberOfIndexedFiles = n;
    }

    @NotNull
    public final ArrayList<String> getListOfFilesFullyIndexedByExtensions() {
        return this.listOfFilesFullyIndexedByExtensions;
    }

    public final void setListOfFilesFullyIndexedByExtensions(@NotNull ArrayList<String> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.listOfFilesFullyIndexedByExtensions = arrayList;
    }

    public final int getNumberOfFilesFullyIndexedByExtensions() {
        return this.numberOfFilesFullyIndexedByExtensions;
    }

    public final void setNumberOfFilesFullyIndexedByExtensions(int n) {
        this.numberOfFilesFullyIndexedByExtensions = n;
    }

    public final int getNumberOfTooLargeForIndexingFiles() {
        return this.numberOfTooLargeForIndexingFiles;
    }

    public final void setNumberOfTooLargeForIndexingFiles(int n) {
        this.numberOfTooLargeForIndexingFiles = n;
    }

    @NotNull
    public final HashMap<String, StatsPerIndexer> getStatsPerIndexer() {
        return this.statsPerIndexer;
    }

    @NotNull
    public final HashMap<String, StatsPerFileType> getStatsPerFileType() {
        return this.statsPerFileType;
    }

    @NotNull
    public final ArrayList<IndexedFile> getIndexedFiles() {
        return this.indexedFiles;
    }

    @NotNull
    public final LimitedPriorityQueue<SlowIndexedFile> getSlowIndexedFiles() {
        return this.slowIndexedFiles;
    }

    public final boolean getAllValuesAppliedSeparately() {
        return this.allValuesAppliedSeparately;
    }

    public final void setAllValuesAppliedSeparately(boolean bl) {
        this.allValuesAppliedSeparately = bl;
    }

    public final long getAllSeparateApplicationTimeInAllThreads() {
        return this.allSeparateApplicationTimeInAllThreads;
    }

    public final void setAllSeparateApplicationTimeInAllThreads(long l) {
        this.allSeparateApplicationTimeInAllThreads = l;
    }

    /*
     * WARNING - void declaration
     */
    public final void addFileStatistics(@NotNull VirtualFile file2, @NotNull FileIndexingStatistics fileStatistics, long processingTime, long contentLoadingTime, long fileSize, boolean valuesAppliedSeparately, long separateApplicationTime) {
        Object object;
        long time2;
        ID<?, ?> indexId;
        Map.Entry<ID<?, ?>, Long> entry;
        Map.Entry<ID<Object, Object>, Long> element$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileStatistics, (String)"fileStatistics");
        int n = this.numberOfIndexedFiles;
        this.numberOfIndexedFiles = n + 1;
        if (fileStatistics.getWasFullyIndexedByExtensions()) {
            n = this.numberOfFilesFullyIndexedByExtensions;
            this.numberOfFilesFullyIndexedByExtensions = n + 1;
            if (IndexDiagnosticDumper.Companion.getShouldDumpPathsOfFilesIndexedByInfrastructureExtensions()) {
                this.listOfFilesFullyIndexedByExtensions.add(file2.toString());
            }
        }
        this.processingTimeInAllThreads += processingTime;
        this.contentLoadingTimeInAllThreads += contentLoadingTime;
        Map perIndexerEvaluationOfValueChangerTimes = MapsKt.toMutableMap(fileStatistics.getPerIndexerEvaluateIndexValueTimes());
        Map $this$forEach$iv = fileStatistics.getPerIndexerEvaluatingIndexValueRemoversTimes();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ID<Object, Object>, Long>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl = false;
            indexId = entry.getKey();
            time2 = ((Number)entry.getValue()).longValue();
            perIndexerEvaluationOfValueChangerTimes.put(indexId, time2 + ((Number)perIndexerEvaluationOfValueChangerTimes.getOrDefault(indexId, 0L)).longValue());
        }
        $this$forEach$iv = perIndexerEvaluationOfValueChangerTimes;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object2;
            String key$iv;
            void $this$getOrPut$iv;
            entry = element$iv = iterator2.next();
            boolean bl = false;
            indexId = entry.getKey();
            time2 = ((Number)entry.getValue()).longValue();
            Map map2 = this.statsPerIndexer;
            Intrinsics.checkNotNullExpressionValue((Object)indexId.getName(), (String)"indexId.name");
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                StatsPerIndexer answer$iv = new StatsPerIndexer(0L, 0, 0, 0L);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            StatsPerIndexer stats = (StatsPerIndexer)object2;
            stats.setEvaluateIndexValueChangerTime(stats.getEvaluateIndexValueChangerTime() + time2);
            int n2 = stats.getNumberOfFiles();
            stats.setNumberOfFiles(n2 + 1);
            if (fileStatistics.getIndexesProvidedByExtensions().contains(indexId)) {
                n2 = stats.getNumberOfFilesIndexedByExtensions();
                stats.setNumberOfFilesIndexedByExtensions(n2 + 1);
            }
            stats.setTotalBytes(stats.getTotalBytes() + fileSize);
        }
        String string2 = fileStatistics.getFileType().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fileStatistics.fileType.name");
        String fileTypeName = string2;
        Map $this$getOrPut$iv = this.statsPerFileType;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(fileTypeName);
        if (value$iv == null) {
            boolean bl = false;
            StatsPerFileType answer$iv = new StatsPerFileType(0L, 0L, 0, 0L);
            $this$getOrPut$iv.put(fileTypeName, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        StatsPerFileType stats = (StatsPerFileType)object;
        stats.setContentLoadingTimeInAllThreads(stats.getContentLoadingTimeInAllThreads() + contentLoadingTime);
        long evaluationOfIndexValueChangerTime = CollectionsKt.sumOfLong((Iterable)perIndexerEvaluationOfValueChangerTimes.values());
        stats.setProcessingTimeInAllThreads(stats.getProcessingTimeInAllThreads() + processingTime);
        stats.setTotalBytes(stats.getTotalBytes() + fileSize);
        int n3 = stats.getNumberOfFiles();
        stats.setNumberOfFiles(n3 + 1);
        if (IndexDiagnosticDumper.Companion.getShouldDumpPathsOfIndexedFiles()) {
            ((Collection)this.indexedFiles).add(new IndexedFile(this.getIndexedFilePath(file2), fileStatistics.getWasFullyIndexedByExtensions()));
        }
        if (processingTime > 500000000L) {
            String string3 = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.name");
            this.slowIndexedFiles.addElement(new SlowIndexedFile(string3, processingTime, evaluationOfIndexValueChangerTime, contentLoadingTime));
        }
        this.allValuesAppliedSeparately = this.allValuesAppliedSeparately && valuesAppliedSeparately;
        this.allSeparateApplicationTimeInAllThreads += separateApplicationTime;
    }

    public final void addTooLargeForIndexingFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        int n = this.numberOfIndexedFiles;
        this.numberOfIndexedFiles = n + 1;
        n = this.numberOfTooLargeForIndexingFiles;
        this.numberOfTooLargeForIndexingFiles = n + 1;
        if (IndexDiagnosticDumper.Companion.getShouldDumpPathsOfIndexedFiles()) {
            ((Collection)this.indexedFiles).add(new IndexedFile(this.getIndexedFilePath(file2), false));
        }
    }

    private final PortableFilePath getIndexedFilePath(VirtualFile file2) {
        PortableFilePath portableFilePath;
        try {
            portableFilePath = PortableFilePaths.INSTANCE.getPortableFilePath(file2, this.project);
        }
        catch (Exception e) {
            String string2 = file2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.url");
            portableFilePath = new PortableFilePath.AbsolutePath(string2);
        }
        return portableFilePath;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\n\u0010\b\u001a\u00060\u0003j\u0002`\t\u00a2\u0006\u0002\u0010\nJ\r\u0010\u0017\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\r\u0010\u001a\u001a\u00060\u0003j\u0002`\tH\u00c6\u0003J9\u0010\u001b\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\f\b\u0002\u0010\b\u001a\u00060\u0003j\u0002`\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u001e\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u001e\u0010\b\u001a\u00060\u0003j\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingFileSetStatistics$StatsPerIndexer;", "", "evaluateIndexValueChangerTime", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "numberOfFiles", "", "numberOfFilesIndexedByExtensions", "totalBytes", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "(JIIJ)V", "getEvaluateIndexValueChangerTime", "()J", "setEvaluateIndexValueChangerTime", "(J)V", "getNumberOfFiles", "()I", "setNumberOfFiles", "(I)V", "getNumberOfFilesIndexedByExtensions", "setNumberOfFilesIndexedByExtensions", "getTotalBytes", "setTotalBytes", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerIndexer {
        private long evaluateIndexValueChangerTime;
        private int numberOfFiles;
        private int numberOfFilesIndexedByExtensions;
        private long totalBytes;

        public StatsPerIndexer(long evaluateIndexValueChangerTime, int numberOfFiles, int numberOfFilesIndexedByExtensions, long totalBytes) {
            this.evaluateIndexValueChangerTime = evaluateIndexValueChangerTime;
            this.numberOfFiles = numberOfFiles;
            this.numberOfFilesIndexedByExtensions = numberOfFilesIndexedByExtensions;
            this.totalBytes = totalBytes;
        }

        public final long getEvaluateIndexValueChangerTime() {
            return this.evaluateIndexValueChangerTime;
        }

        public final void setEvaluateIndexValueChangerTime(long l) {
            this.evaluateIndexValueChangerTime = l;
        }

        public final int getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public final void setNumberOfFiles(int n) {
            this.numberOfFiles = n;
        }

        public final int getNumberOfFilesIndexedByExtensions() {
            return this.numberOfFilesIndexedByExtensions;
        }

        public final void setNumberOfFilesIndexedByExtensions(int n) {
            this.numberOfFilesIndexedByExtensions = n;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        public final long component1() {
            return this.evaluateIndexValueChangerTime;
        }

        public final int component2() {
            return this.numberOfFiles;
        }

        public final int component3() {
            return this.numberOfFilesIndexedByExtensions;
        }

        public final long component4() {
            return this.totalBytes;
        }

        @NotNull
        public final StatsPerIndexer copy(long evaluateIndexValueChangerTime, int numberOfFiles, int numberOfFilesIndexedByExtensions, long totalBytes) {
            return new StatsPerIndexer(evaluateIndexValueChangerTime, numberOfFiles, numberOfFilesIndexedByExtensions, totalBytes);
        }

        public static /* synthetic */ StatsPerIndexer copy$default(StatsPerIndexer statsPerIndexer, long l, int n, int n2, long l2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                l = statsPerIndexer.evaluateIndexValueChangerTime;
            }
            if ((n3 & 2) != 0) {
                n = statsPerIndexer.numberOfFiles;
            }
            if ((n3 & 4) != 0) {
                n2 = statsPerIndexer.numberOfFilesIndexedByExtensions;
            }
            if ((n3 & 8) != 0) {
                l2 = statsPerIndexer.totalBytes;
            }
            return statsPerIndexer.copy(l, n, n2, l2);
        }

        @NotNull
        public String toString() {
            return "StatsPerIndexer(evaluateIndexValueChangerTime=" + this.evaluateIndexValueChangerTime + ", numberOfFiles=" + this.numberOfFiles + ", numberOfFilesIndexedByExtensions=" + this.numberOfFilesIndexedByExtensions + ", totalBytes=" + this.totalBytes + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.evaluateIndexValueChangerTime);
            result2 = result2 * 31 + Integer.hashCode(this.numberOfFiles);
            result2 = result2 * 31 + Integer.hashCode(this.numberOfFilesIndexedByExtensions);
            result2 = result2 * 31 + Long.hashCode(this.totalBytes);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StatsPerIndexer)) {
                return false;
            }
            StatsPerIndexer statsPerIndexer = (StatsPerIndexer)other;
            if (this.evaluateIndexValueChangerTime != statsPerIndexer.evaluateIndexValueChangerTime) {
                return false;
            }
            if (this.numberOfFiles != statsPerIndexer.numberOfFiles) {
                return false;
            }
            if (this.numberOfFilesIndexedByExtensions != statsPerIndexer.numberOfFilesIndexedByExtensions) {
                return false;
            }
            return this.totalBytes == statsPerIndexer.totalBytes;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u00060\u0003j\u0002`\t\u00a2\u0006\u0002\u0010\nJ\r\u0010\u0017\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\r\u0010\u0018\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\r\u0010\u001a\u001a\u00060\u0003j\u0002`\tH\u00c6\u0003J=\u0010\u001b\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\f\b\u0002\u0010\u0005\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\f\b\u0002\u0010\b\u001a\u00060\u0003j\u0002`\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u001e\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001e\u0010\b\u001a\u00060\u0003j\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingFileSetStatistics$StatsPerFileType;", "", "processingTimeInAllThreads", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "contentLoadingTimeInAllThreads", "numberOfFiles", "", "totalBytes", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "(JJIJ)V", "getContentLoadingTimeInAllThreads", "()J", "setContentLoadingTimeInAllThreads", "(J)V", "getNumberOfFiles", "()I", "setNumberOfFiles", "(I)V", "getProcessingTimeInAllThreads", "setProcessingTimeInAllThreads", "getTotalBytes", "setTotalBytes", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerFileType {
        private long processingTimeInAllThreads;
        private long contentLoadingTimeInAllThreads;
        private int numberOfFiles;
        private long totalBytes;

        public StatsPerFileType(long processingTimeInAllThreads, long contentLoadingTimeInAllThreads, int numberOfFiles, long totalBytes) {
            this.processingTimeInAllThreads = processingTimeInAllThreads;
            this.contentLoadingTimeInAllThreads = contentLoadingTimeInAllThreads;
            this.numberOfFiles = numberOfFiles;
            this.totalBytes = totalBytes;
        }

        public final long getProcessingTimeInAllThreads() {
            return this.processingTimeInAllThreads;
        }

        public final void setProcessingTimeInAllThreads(long l) {
            this.processingTimeInAllThreads = l;
        }

        public final long getContentLoadingTimeInAllThreads() {
            return this.contentLoadingTimeInAllThreads;
        }

        public final void setContentLoadingTimeInAllThreads(long l) {
            this.contentLoadingTimeInAllThreads = l;
        }

        public final int getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public final void setNumberOfFiles(int n) {
            this.numberOfFiles = n;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        public final long component1() {
            return this.processingTimeInAllThreads;
        }

        public final long component2() {
            return this.contentLoadingTimeInAllThreads;
        }

        public final int component3() {
            return this.numberOfFiles;
        }

        public final long component4() {
            return this.totalBytes;
        }

        @NotNull
        public final StatsPerFileType copy(long processingTimeInAllThreads, long contentLoadingTimeInAllThreads, int numberOfFiles, long totalBytes) {
            return new StatsPerFileType(processingTimeInAllThreads, contentLoadingTimeInAllThreads, numberOfFiles, totalBytes);
        }

        public static /* synthetic */ StatsPerFileType copy$default(StatsPerFileType statsPerFileType, long l, long l2, int n, long l3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = statsPerFileType.processingTimeInAllThreads;
            }
            if ((n2 & 2) != 0) {
                l2 = statsPerFileType.contentLoadingTimeInAllThreads;
            }
            if ((n2 & 4) != 0) {
                n = statsPerFileType.numberOfFiles;
            }
            if ((n2 & 8) != 0) {
                l3 = statsPerFileType.totalBytes;
            }
            return statsPerFileType.copy(l, l2, n, l3);
        }

        @NotNull
        public String toString() {
            return "StatsPerFileType(processingTimeInAllThreads=" + this.processingTimeInAllThreads + ", contentLoadingTimeInAllThreads=" + this.contentLoadingTimeInAllThreads + ", numberOfFiles=" + this.numberOfFiles + ", totalBytes=" + this.totalBytes + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.processingTimeInAllThreads);
            result2 = result2 * 31 + Long.hashCode(this.contentLoadingTimeInAllThreads);
            result2 = result2 * 31 + Integer.hashCode(this.numberOfFiles);
            result2 = result2 * 31 + Long.hashCode(this.totalBytes);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StatsPerFileType)) {
                return false;
            }
            StatsPerFileType statsPerFileType = (StatsPerFileType)other;
            if (this.processingTimeInAllThreads != statsPerFileType.processingTimeInAllThreads) {
                return false;
            }
            if (this.contentLoadingTimeInAllThreads != statsPerFileType.contentLoadingTimeInAllThreads) {
                return false;
            }
            if (this.numberOfFiles != statsPerFileType.numberOfFiles) {
                return false;
            }
            return this.totalBytes == statsPerFileType.totalBytes;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingFileSetStatistics$IndexedFile;", "", "portableFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "wasFullyIndexedByExtensions", "", "(Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;Z)V", "getPortableFilePath", "()Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "getWasFullyIndexedByExtensions", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    public static final class IndexedFile {
        @NotNull
        private final PortableFilePath portableFilePath;
        private final boolean wasFullyIndexedByExtensions;

        public IndexedFile(@NotNull PortableFilePath portableFilePath, boolean wasFullyIndexedByExtensions) {
            Intrinsics.checkNotNullParameter((Object)portableFilePath, (String)"portableFilePath");
            this.portableFilePath = portableFilePath;
            this.wasFullyIndexedByExtensions = wasFullyIndexedByExtensions;
        }

        @NotNull
        public final PortableFilePath getPortableFilePath() {
            return this.portableFilePath;
        }

        public final boolean getWasFullyIndexedByExtensions() {
            return this.wasFullyIndexedByExtensions;
        }

        @NotNull
        public final PortableFilePath component1() {
            return this.portableFilePath;
        }

        public final boolean component2() {
            return this.wasFullyIndexedByExtensions;
        }

        @NotNull
        public final IndexedFile copy(@NotNull PortableFilePath portableFilePath, boolean wasFullyIndexedByExtensions) {
            Intrinsics.checkNotNullParameter((Object)portableFilePath, (String)"portableFilePath");
            return new IndexedFile(portableFilePath, wasFullyIndexedByExtensions);
        }

        public static /* synthetic */ IndexedFile copy$default(IndexedFile indexedFile, PortableFilePath portableFilePath, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                portableFilePath = indexedFile.portableFilePath;
            }
            if ((n & 2) != 0) {
                bl = indexedFile.wasFullyIndexedByExtensions;
            }
            return indexedFile.copy(portableFilePath, bl);
        }

        @NotNull
        public String toString() {
            return "IndexedFile(portableFilePath=" + this.portableFilePath + ", wasFullyIndexedByExtensions=" + this.wasFullyIndexedByExtensions + ")";
        }

        public int hashCode() {
            int result2 = this.portableFilePath.hashCode();
            int n = this.wasFullyIndexedByExtensions ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IndexedFile)) {
                return false;
            }
            IndexedFile indexedFile = (IndexedFile)other;
            if (!Intrinsics.areEqual((Object)this.portableFilePath, (Object)indexedFile.portableFilePath)) {
                return false;
            }
            return this.wasFullyIndexedByExtensions == indexedFile.wasFullyIndexedByExtensions;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexingFileSetStatistics$Companion;", "", "()V", "SLOW_FILES_LIMIT", "", "SLOW_FILE_PROCESSING_THRESHOLD_MS", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

