/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00018\u00008\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "T", "", "sizeLimit", "", "comparator", "Ljava/util/Comparator;", "(ILjava/util/Comparator;)V", "biggestElements", "", "getBiggestElements", "()Ljava/util/List;", "queue", "Ljava/util/PriorityQueue;", "kotlin.jvm.PlatformType", "addElement", "", "element", "(Ljava/lang/Object;)V", "intellij.platform.lang.impl"})
public final class LimitedPriorityQueue<T> {
    private final int sizeLimit;
    @NotNull
    private final PriorityQueue<T> queue;

    public LimitedPriorityQueue(int sizeLimit, @NotNull Comparator<T> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        this.sizeLimit = sizeLimit;
        this.queue = new PriorityQueue<T>(comparator);
    }

    @NotNull
    public final synchronized List<T> getBiggestElements() {
        return CollectionsKt.toList((Iterable)this.queue);
    }

    public final synchronized void addElement(T element) {
        this.queue.add(element);
        while (this.queue.size() > this.sizeLimit) {
            this.queue.poll();
        }
    }
}

