/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.UnindexedFileStatus;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePaths;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001IB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020'J&\u0010<\u001a\u00020:2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010-\u001a\u00020'2\u0006\u0010A\u001a\u00020BJ\u0018\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020>2\u0006\u0010A\u001a\u00020BH\u0002J\u0006\u0010F\u001a\u00020:J\u0016\u0010!\u001a\u00020:2\u0006\u0010G\u001a\u00020H2\u0006\u0010A\u001a\u00020BR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R*\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00030\bj\b\u0012\u0004\u0012\u00020\u0003`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u001a\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R!\u0010#\u001a\u0012\u0012\u0004\u0012\u00020$0\bj\b\u0012\u0004\u0012\u00020$`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000bR\u001e\u0010&\u001a\u00060'j\u0002`(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001e\u0010-\u001a\u00060'j\u0002`(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010*\"\u0004\b/\u0010,R\u001e\u00100\u001a\u00060'j\u0002`(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010*\"\u0004\b2\u0010,R\u001e\u00103\u001a\u00060'j\u0002`(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010*\"\u0004\b5\u0010,R\u001e\u00106\u001a\u00060'j\u0002`(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010*\"\u0004\b8\u0010,\u00a8\u0006J"}, d2={"Lcom/intellij/util/indexing/diagnostic/ScanningStatistics;", "", "fileSetName", "", "(Ljava/lang/String;)V", "getFileSetName", "()Ljava/lang/String;", "listOfFilesFullyIndexedByInfrastructureExtension", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getListOfFilesFullyIndexedByInfrastructureExtension", "()Ljava/util/ArrayList;", "setListOfFilesFullyIndexedByInfrastructureExtension", "(Ljava/util/ArrayList;)V", "numberOfFilesForIndexing", "", "getNumberOfFilesForIndexing", "()I", "setNumberOfFilesForIndexing", "(I)V", "numberOfFilesFullyIndexedByInfrastructureExtension", "getNumberOfFilesFullyIndexedByInfrastructureExtension", "setNumberOfFilesFullyIndexedByInfrastructureExtension", "numberOfScannedFiles", "getNumberOfScannedFiles", "setNumberOfScannedFiles", "numberOfSkippedFiles", "getNumberOfSkippedFiles", "setNumberOfSkippedFiles", "providerRoots", "", "getProviderRoots", "()Ljava/util/List;", "setProviderRoots", "(Ljava/util/List;)V", "scannedFiles", "Lcom/intellij/util/indexing/diagnostic/ScanningStatistics$ScannedFile;", "getScannedFiles", "scanningTime", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "getScanningTime", "()J", "setScanningTime", "(J)V", "statusTime", "getStatusTime", "setStatusTime", "timeIndexingWithoutContent", "getTimeIndexingWithoutContent", "setTimeIndexingWithoutContent", "timeProcessingUpToDateFiles", "getTimeProcessingUpToDateFiles", "setTimeProcessingUpToDateFiles", "timeUpdatingContentLessIndexes", "getTimeUpdatingContentLessIndexes", "setTimeUpdatingContentLessIndexes", "addScanningTime", "", "time", "addStatus", "fileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "unindexedFileStatus", "Lcom/intellij/util/indexing/UnindexedFileStatus;", "project", "Lcom/intellij/openapi/project/Project;", "getIndexedFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "file", "setNoRootsForRefresh", "provider", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "ScannedFile", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nScanningStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanningStatistics.kt\ncom/intellij/util/indexing/diagnostic/ScanningStatistics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1549#2:94\n1620#2,3:95\n*S KotlinDebug\n*F\n+ 1 ScanningStatistics.kt\ncom/intellij/util/indexing/diagnostic/ScanningStatistics\n*L\n87#1:94\n87#1:95,3\n*E\n"})
public final class ScanningStatistics {
    @NotNull
    private final String fileSetName;
    private int numberOfScannedFiles;
    private int numberOfSkippedFiles;
    private int numberOfFilesForIndexing;
    private int numberOfFilesFullyIndexedByInfrastructureExtension;
    @NotNull
    private ArrayList<String> listOfFilesFullyIndexedByInfrastructureExtension;
    private long scanningTime;
    private long statusTime;
    private long timeProcessingUpToDateFiles;
    private long timeUpdatingContentLessIndexes;
    private long timeIndexingWithoutContent;
    @NotNull
    private List<String> providerRoots;
    @NotNull
    private final ArrayList<ScannedFile> scannedFiles;

    public ScanningStatistics(@NotNull String fileSetName) {
        Intrinsics.checkNotNullParameter((Object)fileSetName, (String)"fileSetName");
        this.fileSetName = fileSetName;
        this.listOfFilesFullyIndexedByInfrastructureExtension = new ArrayList();
        this.providerRoots = CollectionsKt.emptyList();
        this.scannedFiles = new ArrayList();
    }

    @NotNull
    public final String getFileSetName() {
        return this.fileSetName;
    }

    public final int getNumberOfScannedFiles() {
        return this.numberOfScannedFiles;
    }

    public final void setNumberOfScannedFiles(int n) {
        this.numberOfScannedFiles = n;
    }

    public final int getNumberOfSkippedFiles() {
        return this.numberOfSkippedFiles;
    }

    public final void setNumberOfSkippedFiles(int n) {
        this.numberOfSkippedFiles = n;
    }

    public final int getNumberOfFilesForIndexing() {
        return this.numberOfFilesForIndexing;
    }

    public final void setNumberOfFilesForIndexing(int n) {
        this.numberOfFilesForIndexing = n;
    }

    public final int getNumberOfFilesFullyIndexedByInfrastructureExtension() {
        return this.numberOfFilesFullyIndexedByInfrastructureExtension;
    }

    public final void setNumberOfFilesFullyIndexedByInfrastructureExtension(int n) {
        this.numberOfFilesFullyIndexedByInfrastructureExtension = n;
    }

    @NotNull
    public final ArrayList<String> getListOfFilesFullyIndexedByInfrastructureExtension() {
        return this.listOfFilesFullyIndexedByInfrastructureExtension;
    }

    public final void setListOfFilesFullyIndexedByInfrastructureExtension(@NotNull ArrayList<String> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.listOfFilesFullyIndexedByInfrastructureExtension = arrayList;
    }

    public final long getScanningTime() {
        return this.scanningTime;
    }

    public final void setScanningTime(long l) {
        this.scanningTime = l;
    }

    public final long getStatusTime() {
        return this.statusTime;
    }

    public final void setStatusTime(long l) {
        this.statusTime = l;
    }

    public final long getTimeProcessingUpToDateFiles() {
        return this.timeProcessingUpToDateFiles;
    }

    public final void setTimeProcessingUpToDateFiles(long l) {
        this.timeProcessingUpToDateFiles = l;
    }

    public final long getTimeUpdatingContentLessIndexes() {
        return this.timeUpdatingContentLessIndexes;
    }

    public final void setTimeUpdatingContentLessIndexes(long l) {
        this.timeUpdatingContentLessIndexes = l;
    }

    public final long getTimeIndexingWithoutContent() {
        return this.timeIndexingWithoutContent;
    }

    public final void setTimeIndexingWithoutContent(long l) {
        this.timeIndexingWithoutContent = l;
    }

    @NotNull
    public final List<String> getProviderRoots() {
        return this.providerRoots;
    }

    public final void setProviderRoots(@NotNull List<String> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.providerRoots = list2;
    }

    @NotNull
    public final ArrayList<ScannedFile> getScannedFiles() {
        return this.scannedFiles;
    }

    public final void addStatus(@NotNull VirtualFile fileOrDir, @NotNull UnindexedFileStatus unindexedFileStatus, long statusTime, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        Intrinsics.checkNotNullParameter((Object)unindexedFileStatus, (String)"unindexedFileStatus");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (fileOrDir.isDirectory()) {
            return;
        }
        int n = this.numberOfScannedFiles;
        this.numberOfScannedFiles = n + 1;
        if (unindexedFileStatus.getShouldIndex()) {
            n = this.numberOfFilesForIndexing;
            this.numberOfFilesForIndexing = n + 1;
        }
        this.statusTime += statusTime;
        this.timeProcessingUpToDateFiles += unindexedFileStatus.getTimeProcessingUpToDateFiles();
        this.timeUpdatingContentLessIndexes += unindexedFileStatus.getTimeUpdatingContentLessIndexes();
        this.timeIndexingWithoutContent += unindexedFileStatus.getTimeIndexingWithoutContent();
        if (unindexedFileStatus.getWasFullyIndexedByInfrastructureExtension()) {
            n = this.numberOfFilesFullyIndexedByInfrastructureExtension;
            this.numberOfFilesFullyIndexedByInfrastructureExtension = n + 1;
            if (IndexDiagnosticDumper.Companion.getShouldDumpPathsOfFilesIndexedByInfrastructureExtensions()) {
                this.listOfFilesFullyIndexedByInfrastructureExtension.add(fileOrDir.toString());
            }
        }
        if (IndexDiagnosticDumper.Companion.getShouldDumpPathsOfIndexedFiles()) {
            PortableFilePath portableFilePath = this.getIndexedFilePath(fileOrDir, project2);
            ((Collection)this.scannedFiles).add(new ScannedFile(portableFilePath, !unindexedFileStatus.getShouldIndex(), unindexedFileStatus.getWasFullyIndexedByInfrastructureExtension()));
        }
    }

    private final PortableFilePath getIndexedFilePath(VirtualFile file2, Project project2) {
        PortableFilePath portableFilePath;
        try {
            portableFilePath = PortableFilePaths.INSTANCE.getPortableFilePath(file2, project2);
        }
        catch (Exception e) {
            String string2 = file2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.url");
            portableFilePath = new PortableFilePath.AbsolutePath(string2);
        }
        return portableFilePath;
    }

    public final void addScanningTime(long time2) {
        this.scanningTime += time2;
    }

    public final void setNoRootsForRefresh() {
        this.providerRoots = CollectionsKt.listOf((Object)"Not collected for refresh");
    }

    /*
     * WARNING - void declaration
     */
    public final void setProviderRoots(@NotNull IndexableFilesIterator provider2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!IndexDiagnosticDumper.Companion.getShouldDumpProviderRootPaths()) {
            return;
        }
        Set set2 = provider2.getRootUrls(project2);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"provider.getRootUrls(project)");
        Set rootUrls = set2;
        if (rootUrls.isEmpty()) {
            return;
        }
        String basePath = project2.getBasePath();
        if (basePath == null) {
            this.providerRoots = CollectionsKt.toList((Iterable)rootUrls);
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String baseUrl = "file://" + basePath;
            Iterable iterable = rootUrls;
            ScanningStatistics scanningStatistics = this;
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string2;
                void url;
                String string3 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
                if (StringsKt.startsWith$default((String)url, (String)baseUrl, (boolean)false, (int)2, null)) {
                    void var15_16 = url;
                    int n = 0;
                    int n2 = baseUrl.length();
                    CharSequence charSequence = "<project root>";
                    string2 = ((Object)StringsKt.replaceRange((CharSequence)((CharSequence)var15_16), (int)n, (int)n2, (CharSequence)charSequence)).toString();
                } else {
                    string2 = url;
                }
                collection.add(string2);
            }
            scanningStatistics.providerRoots = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/indexing/diagnostic/ScanningStatistics$ScannedFile;", "", "portableFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "isUpToDate", "", "wasFullyIndexedByInfrastructureExtension", "(Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;ZZ)V", "()Z", "getPortableFilePath", "()Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "getWasFullyIndexedByInfrastructureExtension", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    public static final class ScannedFile {
        @NotNull
        private final PortableFilePath portableFilePath;
        private final boolean isUpToDate;
        private final boolean wasFullyIndexedByInfrastructureExtension;

        public ScannedFile(@NotNull PortableFilePath portableFilePath, boolean isUpToDate, boolean wasFullyIndexedByInfrastructureExtension) {
            Intrinsics.checkNotNullParameter((Object)portableFilePath, (String)"portableFilePath");
            this.portableFilePath = portableFilePath;
            this.isUpToDate = isUpToDate;
            this.wasFullyIndexedByInfrastructureExtension = wasFullyIndexedByInfrastructureExtension;
        }

        @NotNull
        public final PortableFilePath getPortableFilePath() {
            return this.portableFilePath;
        }

        public final boolean isUpToDate() {
            return this.isUpToDate;
        }

        public final boolean getWasFullyIndexedByInfrastructureExtension() {
            return this.wasFullyIndexedByInfrastructureExtension;
        }

        @NotNull
        public final PortableFilePath component1() {
            return this.portableFilePath;
        }

        public final boolean component2() {
            return this.isUpToDate;
        }

        public final boolean component3() {
            return this.wasFullyIndexedByInfrastructureExtension;
        }

        @NotNull
        public final ScannedFile copy(@NotNull PortableFilePath portableFilePath, boolean isUpToDate, boolean wasFullyIndexedByInfrastructureExtension) {
            Intrinsics.checkNotNullParameter((Object)portableFilePath, (String)"portableFilePath");
            return new ScannedFile(portableFilePath, isUpToDate, wasFullyIndexedByInfrastructureExtension);
        }

        public static /* synthetic */ ScannedFile copy$default(ScannedFile scannedFile, PortableFilePath portableFilePath, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                portableFilePath = scannedFile.portableFilePath;
            }
            if ((n & 2) != 0) {
                bl = scannedFile.isUpToDate;
            }
            if ((n & 4) != 0) {
                bl2 = scannedFile.wasFullyIndexedByInfrastructureExtension;
            }
            return scannedFile.copy(portableFilePath, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "ScannedFile(portableFilePath=" + this.portableFilePath + ", isUpToDate=" + this.isUpToDate + ", wasFullyIndexedByInfrastructureExtension=" + this.wasFullyIndexedByInfrastructureExtension + ")";
        }

        public int hashCode() {
            int result2 = this.portableFilePath.hashCode();
            int n = this.isUpToDate ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            int n2 = this.wasFullyIndexedByInfrastructureExtension ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result2 = result2 * 31 + n2;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScannedFile)) {
                return false;
            }
            ScannedFile scannedFile = (ScannedFile)other;
            if (!Intrinsics.areEqual((Object)this.portableFilePath, (Object)scannedFile.portableFilePath)) {
                return false;
            }
            if (this.isUpToDate != scannedFile.isUpToDate) {
                return false;
            }
            return this.wasFullyIndexedByInfrastructureExtension == scannedFile.wasFullyIndexedByInfrastructureExtension;
        }
    }
}

