/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.JsonSharedIndexDiagnosticEvent;
import com.intellij.util.indexing.diagnostic.SharedIndexDiagnostic;
import com.intellij.util.indexing.diagnostic.dto.JsonDateTime;
import com.intellij.util.indexing.diagnostic.dto.JsonDuration;
import com.intellij.util.indexing.diagnostic.dto.JsonFileSize;
import com.intellij.util.indexing.diagnostic.dto.JsonPercentages;
import com.intellij.util.indexing.diagnostic.dto.JsonProcessingSpeed;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J6\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJJ\u0010\u001e\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010%J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110'2\u0006\u0010\u000e\u001a\u00020\u000fR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006("}, d2={"Lcom/intellij/util/indexing/diagnostic/SharedIndexDiagnostic;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJacksonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "jacksonMapper$delegate", "Lkotlin/Lazy;", "appendEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/util/indexing/diagnostic/JsonSharedIndexDiagnosticEvent;", "getEventsFile", "Ljava/nio/file/Path;", "onIndexAttachIncompatible", "kind", "", "indexId", "onIndexAttachSuccess", "indexName", "chunkUniqueId", "fbMatch", "Lcom/intellij/util/indexing/diagnostic/dto/JsonPercentages;", "stubMatch", "onIndexDownloaded", "finishType", "downloadTimeNano", "", "packedSizeBytes", "unpackedSizeBytes", "generationTime", "Ljava/time/ZonedDateTime;", "readEvents", "", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nSharedIndexDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexDiagnostic.kt\ncom/intellij/util/indexing/diagnostic/SharedIndexDiagnostic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1549#2:161\n1620#2,2:162\n1622#2:166\n50#3:164\n43#3:165\n1#4:167\n*S KotlinDebug\n*F\n+ 1 SharedIndexDiagnostic.kt\ncom/intellij/util/indexing/diagnostic/SharedIndexDiagnostic\n*L\n59#1:161\n59#1:162,2\n59#1:166\n59#1:164\n59#1:165\n*E\n"})
public final class SharedIndexDiagnostic {
    @NotNull
    public static final SharedIndexDiagnostic INSTANCE = new SharedIndexDiagnostic();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Lazy jacksonMapper$delegate;

    private SharedIndexDiagnostic() {
    }

    public final void onIndexAttachSuccess(@NotNull Project project2, @NotNull String kind, @NotNull String indexName, @NotNull String chunkUniqueId, @NotNull JsonPercentages fbMatch, @NotNull JsonPercentages stubMatch) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)chunkUniqueId, (String)"chunkUniqueId");
        Intrinsics.checkNotNullParameter((Object)fbMatch, (String)"fbMatch");
        Intrinsics.checkNotNullParameter((Object)stubMatch, (String)"stubMatch");
        this.appendEvent(project2, new JsonSharedIndexDiagnosticEvent.Attached.Success(JsonSharedIndexDiagnosticEvent.Companion.now(), kind, chunkUniqueId, indexName, fbMatch, stubMatch));
    }

    public final void onIndexAttachIncompatible(@NotNull Project project2, @NotNull String kind, @NotNull String indexId) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)indexId, (String)"indexId");
        this.appendEvent(project2, new JsonSharedIndexDiagnosticEvent.Attached.Incompatible(JsonSharedIndexDiagnosticEvent.Companion.now(), kind, indexId));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JsonSharedIndexDiagnosticEvent> readEvents(@NotNull Project project2) {
        Iterable<Path> iterable;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Path eventsFile = this.getEventsFile(project2);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(eventsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return CollectionsKt.emptyList();
        }
        try {
            void $this$mapTo$iv$iv;
            iterable = eventsFile;
            List<String> list2 = Files.readAllLines(iterable, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(this, charset)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ObjectMapper $this$readValue$iv = INSTANCE.getJacksonMapper();
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                collection.add((JsonSharedIndexDiagnosticEvent)$this$readValue$iv.readValue((String)it, (TypeReference)new TypeReference<JsonSharedIndexDiagnosticEvent>(){}));
            }
            iterable = (List)destination$iv$iv;
        }
        catch (Exception e) {
            LOG.warn("Failed to read " + eventsFile, e);
            return CollectionsKt.emptyList();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    public final void onIndexDownloaded(@Nullable Project project2, @NotNull String kind, @NotNull String indexId, @NotNull String finishType, long downloadTimeNano, long packedSizeBytes, long unpackedSizeBytes, @Nullable ZonedDateTime generationTime) {
        JsonDateTime jsonDateTime;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)indexId, (String)"indexId");
        Intrinsics.checkNotNullParameter((Object)finishType, (String)"finishType");
        JsonDuration downloadTime = new JsonDuration(downloadTimeNano);
        JsonDateTime jsonDateTime2 = JsonSharedIndexDiagnosticEvent.Companion.now();
        String string2 = kind;
        String string3 = indexId;
        String string4 = finishType;
        JsonDuration jsonDuration = downloadTime;
        JsonFileSize jsonFileSize = new JsonFileSize(packedSizeBytes);
        JsonFileSize jsonFileSize2 = new JsonFileSize(unpackedSizeBytes);
        JsonProcessingSpeed jsonProcessingSpeed = new JsonProcessingSpeed(packedSizeBytes, downloadTimeNano);
        ZonedDateTime zonedDateTime = generationTime;
        if (zonedDateTime != null) {
            void it;
            ZonedDateTime zonedDateTime2 = zonedDateTime;
            JsonProcessingSpeed jsonProcessingSpeed2 = jsonProcessingSpeed;
            JsonFileSize jsonFileSize3 = jsonFileSize2;
            JsonFileSize jsonFileSize4 = jsonFileSize;
            JsonDuration jsonDuration2 = jsonDuration;
            String string5 = string4;
            String string6 = string3;
            String string7 = string2;
            JsonDateTime jsonDateTime3 = jsonDateTime2;
            boolean bl = false;
            JsonDateTime jsonDateTime4 = new JsonDateTime((ZonedDateTime)it);
            jsonDateTime2 = jsonDateTime3;
            string2 = string7;
            string3 = string6;
            string4 = string5;
            jsonDuration = jsonDuration2;
            jsonFileSize = jsonFileSize4;
            jsonFileSize2 = jsonFileSize3;
            jsonProcessingSpeed = jsonProcessingSpeed2;
            jsonDateTime = jsonDateTime4;
        } else {
            jsonDateTime = null;
        }
        JsonDateTime jsonDateTime5 = jsonDateTime;
        JsonProcessingSpeed jsonProcessingSpeed3 = jsonProcessingSpeed;
        JsonFileSize jsonFileSize5 = jsonFileSize2;
        JsonFileSize jsonFileSize6 = jsonFileSize;
        JsonDuration jsonDuration3 = jsonDuration;
        String string8 = string4;
        String string9 = string3;
        String string10 = string2;
        JsonDateTime jsonDateTime6 = jsonDateTime2;
        JsonSharedIndexDiagnosticEvent.Downloaded event = new JsonSharedIndexDiagnosticEvent.Downloaded(jsonDateTime6, string10, string9, string8, jsonDuration3, jsonFileSize6, jsonFileSize5, jsonProcessingSpeed3, jsonDateTime5);
        if (project2 != null) {
            this.appendEvent(project2, event);
        }
    }

    private final ObjectMapper getJacksonMapper() {
        Lazy lazy = jacksonMapper$delegate;
        return (ObjectMapper)lazy.getValue();
    }

    private final Path getEventsFile(Project project2) {
        Path path2 = IndexDiagnosticDumper.Companion.getProjectDiagnosticDirectory(project2).resolve("shared-index-events.json");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"IndexDiagnosticDumper.ge\u2026hared-index-events.json\")");
        return path2;
    }

    private final void appendEvent(Project project2, JsonSharedIndexDiagnosticEvent event) {
        try {
            Path file2 = this.getEventsFile(project2);
            String string2 = this.getJacksonMapper().writeValueAsString((Object)event);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jacksonMapper.writeValueAsString(event)");
            String jsonLine = StringsKt.replace$default((String)string2, (String)"\n", (String)" ", (boolean)false, (int)4, null);
            Path path2 = file2;
            Iterable iterable = CollectionsKt.listOf((Object)jsonLine);
            Charset charset = Charsets.UTF_8;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
            Intrinsics.checkNotNullExpressionValue((Object)Files.write(path2, (Iterable<? extends CharSequence>)iterable, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(this, lines, charset, *options)");
        }
        catch (Exception e) {
            LOG.warn("Failed to append shared index event: " + event, e);
        }
    }

    static {
        Logger logger = Logger.getInstance(SharedIndexDiagnostic.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(SharedIndexDiagnostic::class.java)");
        LOG = logger;
        jacksonMapper$delegate = LazyKt.lazy((Function0)jacksonMapper.2.INSTANCE);
    }
}

