/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.intellij.diagnostic.telemetry.ReentrantReadWriteLockUsageMonitor;
import com.intellij.diagnostic.telemetry.TraceManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumperUtils;
import com.intellij.util.io.DirectByteBufferAllocator;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.stats.FilePageCacheStatistics;
import com.intellij.util.io.stats.PersistentEnumeratorStatistics;
import com.intellij.util.io.stats.PersistentHashMapStatistics;
import com.intellij.util.io.stats.StorageStatsRegistrar;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003()*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\b\u0010\u0010\u001a\u00020\rH\u0007J\b\u0010\u0011\u001a\u00020\rH\u0007J6\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\u0004\b\u0000\u0010\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00140\u00162\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0007J0\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020 0\u00162\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\"0\u0016H\u0002J0\u0010#\u001a\u00020$2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020 0%2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\"0%H\u0002J\b\u0010&\u001a\u00020\rH\u0002J0\u0010'\u001a\u00020$2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020 0\u00162\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\"0\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData;", "", "()V", "MONITOR_STORAGE_LOCK", "", "dumpPeriodInMinutes", "", "fileNamePrefix", "", "maxFiles", "", "onShutdownFileNameSuffix", "deleteOutdatedDiagnostics", "", "onShutdown", "dump", "dumpOnShutdown", "dumpPeriodically", "filterStatsForStoragesUnderDir", "Ljava/util/SortedMap;", "Stats", "mapStats", "", "Ljava/nio/file/Path;", "dir", "getDumpFile", "time", "Ljava/time/LocalDateTime;", "getStorageDataStatistics", "Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StorageDataStats;", "indexStorageStatistics", "Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$IndexStorageStats;", "Lcom/intellij/util/io/stats/PersistentHashMapStatistics;", "enumeratorStats", "Lcom/intellij/util/io/stats/PersistentEnumeratorStatistics;", "otherGeneralStorageStatistics", "Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "", "setupReportingToOpenTelemetry", "vfsStorageStatistics", "IndexStorageStats", "StatsPerStorage", "StorageDataStats", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nStorageDiagnosticData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageDiagnosticData.kt\ncom/intellij/util/indexing/diagnostic/StorageDiagnosticData\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,323:1\n8#2:324\n1045#3:325\n1238#3,4:328\n1238#3,4:334\n1549#3:338\n1620#3,3:339\n1789#3,3:342\n1238#3,4:354\n457#4:326\n403#4:327\n457#4:332\n403#4:333\n467#4,7:345\n457#4:352\n403#4:353\n*S KotlinDebug\n*F\n+ 1 StorageDiagnosticData.kt\ncom/intellij/util/indexing/diagnostic/StorageDiagnosticData\n*L\n82#1:324\n120#1:325\n134#1:328,4\n135#1:334,4\n145#1:338\n145#1:339,3\n150#1:342,3\n183#1:354,4\n134#1:326\n134#1:327\n135#1:332\n135#1:333\n177#1:345,7\n183#1:352\n183#1:353\n*E\n"})
public final class StorageDiagnosticData {
    @NotNull
    public static final StorageDiagnosticData INSTANCE = new StorageDiagnosticData();
    private static final boolean MONITOR_STORAGE_LOCK = SystemProperties.getBooleanProperty("vfs.storage-lock.enable-diagnostic", true);
    @NotNull
    private static final String fileNamePrefix = "storage-diagnostic-";
    @NotNull
    private static final String onShutdownFileNameSuffix = "on-shutdown-";
    private static final int maxFiles = 10;
    private static final long dumpPeriodInMinutes = 1L;

    private StorageDiagnosticData() {
    }

    @JvmStatic
    public static final void dumpPeriodically() {
        INSTANCE.setupReportingToOpenTelemetry();
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService("Storage Diagnostic Dumper", 1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"createBoundedScheduledEx\u2026c Dumper\",\n      1,\n    )");
        ScheduledExecutorService executor = scheduledExecutorService;
        executor.scheduleWithFixedDelay(StorageDiagnosticData::dumpPeriodically$lambda$0, 1L, 1L, TimeUnit.MINUTES);
    }

    @JvmStatic
    public static final void dumpOnShutdown() {
        INSTANCE.dump(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void dump(boolean onShutdown) {
        long sessionStartTime = ApplicationManager.getApplication().getStartTime();
        LocalDateTime sessionLocalDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(sessionStartTime), ZoneId.systemDefault());
        try {
            StorageDataStats stats = this.getStorageDataStatistics();
            Intrinsics.checkNotNullExpressionValue((Object)sessionLocalDateTime, (String)"sessionLocalDateTime");
            Path file2 = this.getDumpFile(sessionLocalDateTime, onShutdown);
            IndexDiagnosticDumperUtils.INSTANCE.writeValue(file2, stats);
        }
        catch (Exception e) {
            StorageDiagnosticData $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(StorageDiagnosticData.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.error(e);
        }
        finally {
            this.deleteOutdatedDiagnostics(onShutdown);
        }
    }

    private final Path getDumpFile(LocalDateTime time2, boolean onShutdown) {
        return IndexDiagnosticDumperUtils.INSTANCE.getDumpFilePath(fileNamePrefix, time2, "json", IndexDiagnosticDumperUtils.INSTANCE.getIndexingDiagnosticDir(), onShutdown ? onShutdownFileNameSuffix : "");
    }

    @VisibleForTesting
    @NotNull
    public final StorageDataStats getStorageDataStatistics() {
        Map mapStats = MapsKt.toMutableMap(StorageStatsRegistrar.INSTANCE.dumpStatsForOpenMaps());
        Map enumeratorStats = MapsKt.toMutableMap(StorageStatsRegistrar.INSTANCE.dumpStatsForOpenEnumerators());
        StatsPerStorage vfsStorageStats = this.vfsStorageStatistics(mapStats, enumeratorStats);
        IndexStorageStats indexStorageStats = this.indexStorageStatistics(mapStats, enumeratorStats);
        StatsPerStorage otherStorageStats = this.otherGeneralStorageStatistics(mapStats, enumeratorStats);
        FilePageCacheStatistics filePageCacheStatistics = StorageLockContext.getStatistics();
        Intrinsics.checkNotNullExpressionValue((Object)filePageCacheStatistics, (String)"getStatistics()");
        FilePageCacheStatistics pageCacheStats = filePageCacheStatistics;
        return new StorageDataStats(pageCacheStats, vfsStorageStats.nullize(), indexStorageStats, otherStorageStats.nullize());
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteOutdatedDiagnostics(boolean onShutdown) {
        void $this$sortedBy$iv;
        String suffix = onShutdown ? onShutdownFileNameSuffix : "";
        Iterable iterable = PathsKt.listDirectoryEntries((Path)IndexDiagnosticDumperUtils.INSTANCE.getIndexingDiagnosticDir(), (String)(fileNamePrefix + suffix + "[0-9]*"));
        boolean $i$f$sortedBy = false;
        List allDiagnosticFiles = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Path it = (Path)a;
                boolean bl = false;
                Comparable comparable = it.getFileName();
                it = (Path)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getFileName());
            }
        });
        if (allDiagnosticFiles.size() - 10 > 0) {
            List outdatedFiles = CollectionsKt.take((Iterable)allDiagnosticFiles, (int)(allDiagnosticFiles.size() - 10));
            for (Path outdatedFile : outdatedFiles) {
                PathKt.delete$default(outdatedFile, false, 1, null);
            }
        }
    }

    private final StatsPerStorage otherGeneralStorageStatistics(Map<Path, PersistentHashMapStatistics> mapStats, Map<Path, PersistentEnumeratorStatistics> enumeratorStats) {
        Object v;
        Map.Entry it$iv$iv;
        boolean bl;
        Map map2;
        String string2;
        Map.Entry it;
        Map map3;
        Map<Path, Object> $this$mapKeysTo$iv$iv;
        PathMacroManager pathMacroManager = PathMacroManager.getInstance(ApplicationManager.getApplication());
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(ApplicationManager.getApplication())");
        PathMacroManager macroManager = pathMacroManager;
        Map<Path, Object> $this$mapKeys$iv = mapStats;
        boolean $i$f$mapKeys = false;
        Map<Path, PersistentHashMapStatistics> map4 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map3 = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            string2 = macroManager.collapsePath(((Object)((Path)it.getKey())).toString());
            map2 = map3;
            bl = false;
            v = it$iv$iv.getValue();
            map2.put(string2, v);
        }
        $this$mapKeys$iv = enumeratorStats;
        map3 = MapsKt.toSortedMap((Map)destination$iv$iv);
        $i$f$mapKeys = false;
        $this$mapKeysTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        $i$f$mapKeysTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            it = (Map.Entry)element$iv$iv$iv;
            Map map5 = destination$iv$iv;
            boolean bl3 = false;
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            string2 = macroManager.collapsePath(((Object)((Path)it.getKey())).toString());
            map2 = map5;
            bl = false;
            v = it$iv$iv.getValue();
            map2.put(string2, v);
        }
        SortedMap sortedMap = MapsKt.toSortedMap((Map)destination$iv$iv);
        Map map6 = map3;
        return new StatsPerStorage((SortedMap<String, PersistentHashMapStatistics>)map6, sortedMap);
    }

    /*
     * WARNING - void declaration
     */
    private final IndexStorageStats indexStorageStatistics(Map<Path, PersistentHashMapStatistics> mapStats, Map<Path, PersistentEnumeratorStatistics> enumeratorStats) {
        SortedMap perIndexStats = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        for (ID<?, ?> id : ID.getRegisteredIds()) {
            void $this$fold$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object object = new Path[]{IndexInfrastructure.getIndexRootDir(id), IndexInfrastructure.getPersistentIndexRootDir(id)};
            object = CollectionsKt.listOf((Object[])object);
            boolean $i$f$map = false;
            void var9_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path2 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(new StatsPerStorage(INSTANCE.filterStatsForStoragesUnderDir(mapStats, (Path)it), INSTANCE.filterStatsForStoragesUnderDir(enumeratorStats, (Path)it)));
            }
            $this$map$iv = (List)destination$iv$iv;
            StatsPerStorage initial$iv = StatsPerStorage.Companion.getEMPTY();
            boolean $i$f$fold = false;
            StatsPerStorage accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void b;
                Object item$iv$iv;
                item$iv$iv = (StatsPerStorage)element$iv;
                StatsPerStorage a = accumulator$iv;
                boolean bl = false;
                accumulator$iv = a.plus((StatsPerStorage)b);
            }
            StatsPerStorage indexStats = accumulator$iv;
            if (indexStats.isEmpty()) continue;
            perIndexStats.put(id.getName(), indexStats);
        }
        Path path3 = PathManager.getIndexRoot();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getIndexRoot()");
        Path indexDir = path3;
        StatsPerStorage otherIndexStorageStats = new StatsPerStorage(this.filterStatsForStoragesUnderDir(mapStats, indexDir), this.filterStatsForStoragesUnderDir(enumeratorStats, indexDir)).nullize();
        return new IndexStorageStats(perIndexStats, otherIndexStorageStats);
    }

    private final StatsPerStorage vfsStorageStatistics(Map<Path, PersistentHashMapStatistics> mapStats, Map<Path, PersistentEnumeratorStatistics> enumeratorStats) {
        Path path2 = Path.of(FSRecords.getCachesDir(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(FSRecords.getCachesDir())");
        Path path3 = path2.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toAbsolutePath()");
        Path cachesDir = path3;
        return new StatsPerStorage(this.filterStatsForStoragesUnderDir(mapStats, cachesDir), this.filterStatsForStoragesUnderDir(enumeratorStats, cachesDir));
    }

    /*
     * WARNING - void declaration
     */
    private final <Stats> SortedMap<String, Stats> filterStatsForStoragesUnderDir(Map<Path, Stats> mapStats, Path dir) {
        void $this$mapKeysTo$iv$iv;
        if (!dir.isAbsolute()) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        Map<Path, Stats> $this$filterKeys$iv = mapStats;
        boolean $i$f$filterKeys = false;
        Map<Path, Stats> result$iv = new LinkedHashMap();
        for (Map.Entry<Path, Stats> entry$iv : $this$filterKeys$iv.entrySet()) {
            Path it = entry$iv.getKey();
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getFileSystem(), (Object)dir.getFileSystem()) && it.startsWith(dir))) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map filtered = result$iv;
        for (Path key : filtered.keySet()) {
            mapStats.remove(key);
        }
        Map $this$mapKeys$iv = filtered;
        boolean $i$f$mapKeys = false;
        result$iv = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string3 = ((Object)PathsKt.relativeTo((Path)((Path)it.getKey()), (Path)dir)).toString();
            Map map3 = map2;
            boolean bl2 = false;
            Object v = it$iv$iv.getValue();
            map3.put(string3, v);
        }
        return MapsKt.toSortedMap((Map)destination$iv$iv);
    }

    private final void setupReportingToOpenTelemetry() {
        Meter otelMeter = TraceManager.INSTANCE.getMeter("storage");
        if (MONITOR_STORAGE_LOCK) {
            new ReentrantReadWriteLockUsageMonitor(StorageLockContext.defaultContextLock(), "StorageLockContext", otelMeter);
        }
        ObservableLongMeasurement uncachedFileAccess = otelMeter.counterBuilder("FilePageCache.uncachedFileAccess").buildObserver();
        ObservableLongMeasurement maxRegisteredFiles = otelMeter.gaugeBuilder("FilePageCache.maxRegisteredFiles").ofLongs().buildObserver();
        ObservableLongMeasurement pageHits = otelMeter.counterBuilder("FilePageCache.pageHits").buildObserver();
        ObservableLongMeasurement pageFastCacheHit = otelMeter.counterBuilder("FilePageCache.pageFastCacheHits").buildObserver();
        ObservableLongMeasurement pageLoads = otelMeter.counterBuilder("FilePageCache.pageLoads").buildObserver();
        ObservableLongMeasurement pageLoadsAboveSizeThreshold = otelMeter.counterBuilder("FilePageCache.pageLoadsAboveSizeThreshold").buildObserver();
        ObservableLongMeasurement totalPageLoadsUs = otelMeter.counterBuilder("FilePageCache.totalPageLoadsUs").setUnit("us").buildObserver();
        ObservableLongMeasurement totalPageDisposalsUs = otelMeter.counterBuilder("FilePageCache.totalPageDisposalsUs").setUnit("us").buildObserver();
        ObservableLongMeasurement disposedBuffers = otelMeter.counterBuilder("FilePageCache.disposedBuffers").buildObserver();
        ObservableLongMeasurement totalCachedSizeInBytes = otelMeter.gaugeBuilder("FilePageCache.totalCachedSizeInBytes").setUnit("bytes").setDescription("Total size of all pages currently cached").ofLongs().buildObserver();
        ObservableLongMeasurement maxCacheSizeInBytes = otelMeter.gaugeBuilder("FilePageCache.maxCacheSizeInBytes").setUnit("bytes").setDescription("Max size of all cached pages observed since application start").ofLongs().buildObserver();
        ObservableLongMeasurement capacityInBytes = otelMeter.gaugeBuilder("FilePageCache.capacityInBytes").setUnit("bytes").setDescription("Cache capacity, configured on application startup").ofLongs().buildObserver();
        ObservableLongMeasurement directBufferAllocatorHits = otelMeter.counterBuilder("DirectByteBufferAllocator.hits").buildObserver();
        ObservableLongMeasurement directBufferAllocatorMisses = otelMeter.counterBuilder("DirectByteBufferAllocator.misses").buildObserver();
        ObservableLongMeasurement directBufferAllocatorReclaimed = otelMeter.counterBuilder("DirectByteBufferAllocator.reclaimed").buildObserver();
        ObservableLongMeasurement directBufferAllocatorDisposed = otelMeter.counterBuilder("DirectByteBufferAllocator.disposed").buildObserver();
        ObservableLongMeasurement directBufferAllocatorTotalSizeCached = otelMeter.counterBuilder("DirectByteBufferAllocator.totalSizeOfBuffersCachedInBytes").buildObserver();
        ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{(ObservableMeasurement)maxRegisteredFiles, (ObservableMeasurement)maxCacheSizeInBytes, (ObservableMeasurement)pageHits, (ObservableMeasurement)pageFastCacheHit, (ObservableMeasurement)pageLoadsAboveSizeThreshold, (ObservableMeasurement)pageLoads, (ObservableMeasurement)totalPageLoadsUs, (ObservableMeasurement)totalPageDisposalsUs, (ObservableMeasurement)disposedBuffers, (ObservableMeasurement)capacityInBytes, (ObservableMeasurement)directBufferAllocatorHits, (ObservableMeasurement)directBufferAllocatorMisses, (ObservableMeasurement)directBufferAllocatorReclaimed, (ObservableMeasurement)directBufferAllocatorDisposed, (ObservableMeasurement)directBufferAllocatorTotalSizeCached};
        otelMeter.batchCallback(() -> StorageDiagnosticData.setupReportingToOpenTelemetry$lambda$8(uncachedFileAccess, maxRegisteredFiles, maxCacheSizeInBytes, capacityInBytes, totalCachedSizeInBytes, pageFastCacheHit, pageHits, pageLoads, pageLoadsAboveSizeThreshold, totalPageLoadsUs, totalPageDisposalsUs, disposedBuffers, directBufferAllocatorHits, directBufferAllocatorMisses, directBufferAllocatorReclaimed, directBufferAllocatorDisposed, directBufferAllocatorTotalSizeCached), (ObservableMeasurement)uncachedFileAccess, observableMeasurementArray);
    }

    private static final void dumpPeriodically$lambda$0() {
        INSTANCE.dump(false);
    }

    private static final void setupReportingToOpenTelemetry$lambda$8(ObservableLongMeasurement $uncachedFileAccess, ObservableLongMeasurement $maxRegisteredFiles, ObservableLongMeasurement $maxCacheSizeInBytes, ObservableLongMeasurement $capacityInBytes, ObservableLongMeasurement $totalCachedSizeInBytes, ObservableLongMeasurement $pageFastCacheHit, ObservableLongMeasurement $pageHits, ObservableLongMeasurement $pageLoads, ObservableLongMeasurement $pageLoadsAboveSizeThreshold, ObservableLongMeasurement $totalPageLoadsUs, ObservableLongMeasurement $totalPageDisposalsUs, ObservableLongMeasurement $disposedBuffers, ObservableLongMeasurement $directBufferAllocatorHits, ObservableLongMeasurement $directBufferAllocatorMisses, ObservableLongMeasurement $directBufferAllocatorReclaimed, ObservableLongMeasurement $directBufferAllocatorDisposed, ObservableLongMeasurement $directBufferAllocatorTotalSizeCached) {
        try {
            FilePageCacheStatistics filePageCacheStatistics = StorageLockContext.getStatistics();
            Intrinsics.checkNotNullExpressionValue((Object)filePageCacheStatistics, (String)"getStatistics()");
            FilePageCacheStatistics pageCacheStats = filePageCacheStatistics;
            $uncachedFileAccess.record((long)pageCacheStats.getUncachedFileAccess());
            $maxRegisteredFiles.record((long)pageCacheStats.getMaxRegisteredFiles());
            $maxCacheSizeInBytes.record(pageCacheStats.getMaxCacheSizeInBytes());
            $capacityInBytes.record(pageCacheStats.getCapacityInBytes());
            $totalCachedSizeInBytes.record(pageCacheStats.getTotalCachedSizeInBytes());
            $pageFastCacheHit.record((long)pageCacheStats.getPageFastCacheHits());
            $pageHits.record((long)pageCacheStats.getPageHits());
            $pageLoads.record((long)pageCacheStats.getRegularPageLoads());
            $pageLoadsAboveSizeThreshold.record((long)pageCacheStats.getPageLoadsAboveSizeThreshold());
            $totalPageLoadsUs.record(pageCacheStats.getTotalPageLoadUs());
            $totalPageDisposalsUs.record(pageCacheStats.getTotalPageDisposalUs());
            $disposedBuffers.record((long)pageCacheStats.getDisposedBuffers());
            DirectByteBufferAllocator.Statistics bufferAllocatorStats = DirectByteBufferAllocator.ALLOCATOR.getStatistics();
            $directBufferAllocatorHits.record((long)bufferAllocatorStats.hits);
            $directBufferAllocatorMisses.record((long)bufferAllocatorStats.misses);
            $directBufferAllocatorReclaimed.record((long)bufferAllocatorStats.reclaimed);
            $directBufferAllocatorDisposed.record((long)bufferAllocatorStats.disposed);
            $directBufferAllocatorTotalSizeCached.record((long)bufferAllocatorStats.totalSizeOfBuffersCachedInBytes);
        }
        catch (AlreadyDisposedException alreadyDisposedException) {
            // empty catch block
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J7\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StorageDataStats;", "", "pageCacheStats", "Lcom/intellij/util/io/stats/FilePageCacheStatistics;", "vfsStorageStats", "Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "indexStorageStats", "Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$IndexStorageStats;", "otherStorageStats", "(Lcom/intellij/util/io/stats/FilePageCacheStatistics;Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$IndexStorageStats;Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;)V", "getIndexStorageStats", "()Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$IndexStorageStats;", "getOtherStorageStats", "()Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "getPageCacheStats", "()Lcom/intellij/util/io/stats/FilePageCacheStatistics;", "getVfsStorageStats", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    public static final class StorageDataStats {
        @NotNull
        private final FilePageCacheStatistics pageCacheStats;
        @Nullable
        private final StatsPerStorage vfsStorageStats;
        @Nullable
        private final IndexStorageStats indexStorageStats;
        @Nullable
        private final StatsPerStorage otherStorageStats;

        public StorageDataStats(@NotNull FilePageCacheStatistics pageCacheStats, @Nullable StatsPerStorage vfsStorageStats, @Nullable IndexStorageStats indexStorageStats, @Nullable StatsPerStorage otherStorageStats) {
            Intrinsics.checkNotNullParameter((Object)pageCacheStats, (String)"pageCacheStats");
            this.pageCacheStats = pageCacheStats;
            this.vfsStorageStats = vfsStorageStats;
            this.indexStorageStats = indexStorageStats;
            this.otherStorageStats = otherStorageStats;
        }

        @NotNull
        public final FilePageCacheStatistics getPageCacheStats() {
            return this.pageCacheStats;
        }

        @Nullable
        public final StatsPerStorage getVfsStorageStats() {
            return this.vfsStorageStats;
        }

        @Nullable
        public final IndexStorageStats getIndexStorageStats() {
            return this.indexStorageStats;
        }

        @Nullable
        public final StatsPerStorage getOtherStorageStats() {
            return this.otherStorageStats;
        }

        @NotNull
        public final FilePageCacheStatistics component1() {
            return this.pageCacheStats;
        }

        @Nullable
        public final StatsPerStorage component2() {
            return this.vfsStorageStats;
        }

        @Nullable
        public final IndexStorageStats component3() {
            return this.indexStorageStats;
        }

        @Nullable
        public final StatsPerStorage component4() {
            return this.otherStorageStats;
        }

        @NotNull
        public final StorageDataStats copy(@NotNull FilePageCacheStatistics pageCacheStats, @Nullable StatsPerStorage vfsStorageStats, @Nullable IndexStorageStats indexStorageStats, @Nullable StatsPerStorage otherStorageStats) {
            Intrinsics.checkNotNullParameter((Object)pageCacheStats, (String)"pageCacheStats");
            return new StorageDataStats(pageCacheStats, vfsStorageStats, indexStorageStats, otherStorageStats);
        }

        public static /* synthetic */ StorageDataStats copy$default(StorageDataStats storageDataStats, FilePageCacheStatistics filePageCacheStatistics, StatsPerStorage statsPerStorage, IndexStorageStats indexStorageStats, StatsPerStorage statsPerStorage2, int n, Object object) {
            if ((n & 1) != 0) {
                filePageCacheStatistics = storageDataStats.pageCacheStats;
            }
            if ((n & 2) != 0) {
                statsPerStorage = storageDataStats.vfsStorageStats;
            }
            if ((n & 4) != 0) {
                indexStorageStats = storageDataStats.indexStorageStats;
            }
            if ((n & 8) != 0) {
                statsPerStorage2 = storageDataStats.otherStorageStats;
            }
            return storageDataStats.copy(filePageCacheStatistics, statsPerStorage, indexStorageStats, statsPerStorage2);
        }

        @NotNull
        public String toString() {
            return "StorageDataStats(pageCacheStats=" + this.pageCacheStats + ", vfsStorageStats=" + this.vfsStorageStats + ", indexStorageStats=" + this.indexStorageStats + ", otherStorageStats=" + this.otherStorageStats + ")";
        }

        public int hashCode() {
            int result2 = this.pageCacheStats.hashCode();
            result2 = result2 * 31 + (this.vfsStorageStats == null ? 0 : this.vfsStorageStats.hashCode());
            result2 = result2 * 31 + (this.indexStorageStats == null ? 0 : this.indexStorageStats.hashCode());
            result2 = result2 * 31 + (this.otherStorageStats == null ? 0 : this.otherStorageStats.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StorageDataStats)) {
                return false;
            }
            StorageDataStats storageDataStats = (StorageDataStats)other;
            if (!Intrinsics.areEqual((Object)this.pageCacheStats, (Object)storageDataStats.pageCacheStats)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.vfsStorageStats, (Object)storageDataStats.vfsStorageStats)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexStorageStats, (Object)storageDataStats.indexStorageStats)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.otherStorageStats, (Object)storageDataStats.otherStorageStats);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0087\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B-\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0003J5\u0010\u000e\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0010H\u0007J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0000J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "", "statsPerPhm", "Ljava/util/SortedMap;", "", "Lcom/intellij/util/io/stats/PersistentHashMapStatistics;", "statsPerEnumerator", "Lcom/intellij/util/io/stats/PersistentEnumeratorStatistics;", "(Ljava/util/SortedMap;Ljava/util/SortedMap;)V", "getStatsPerEnumerator", "()Ljava/util/SortedMap;", "getStatsPerPhm", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "isEmpty", "nullize", "plus", "another", "toString", "Companion", "intellij.platform.lang.impl"})
    public static final class StatsPerStorage {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SortedMap<String, PersistentHashMapStatistics> statsPerPhm;
        @NotNull
        private final SortedMap<String, PersistentEnumeratorStatistics> statsPerEnumerator;
        @NotNull
        private static final StatsPerStorage EMPTY = new StatsPerStorage(MapsKt.sortedMapOf((Pair[])new Pair[0]), MapsKt.sortedMapOf((Pair[])new Pair[0]));

        public StatsPerStorage(@NotNull SortedMap<String, PersistentHashMapStatistics> statsPerPhm, @NotNull SortedMap<String, PersistentEnumeratorStatistics> statsPerEnumerator) {
            Intrinsics.checkNotNullParameter(statsPerPhm, (String)"statsPerPhm");
            Intrinsics.checkNotNullParameter(statsPerEnumerator, (String)"statsPerEnumerator");
            this.statsPerPhm = statsPerPhm;
            this.statsPerEnumerator = statsPerEnumerator;
        }

        @NotNull
        public final SortedMap<String, PersistentHashMapStatistics> getStatsPerPhm() {
            return this.statsPerPhm;
        }

        @NotNull
        public final SortedMap<String, PersistentEnumeratorStatistics> getStatsPerEnumerator() {
            return this.statsPerEnumerator;
        }

        @NotNull
        public final StatsPerStorage plus(@NotNull StatsPerStorage another) {
            Intrinsics.checkNotNullParameter((Object)another, (String)"another");
            return new StatsPerStorage(MapsKt.toSortedMap((Map)MapsKt.plus((Map)this.statsPerPhm, (Map)another.statsPerPhm)), MapsKt.toSortedMap((Map)MapsKt.plus((Map)this.statsPerEnumerator, (Map)another.statsPerEnumerator)));
        }

        @JsonIgnore
        public final boolean isEmpty() {
            return this.statsPerPhm.isEmpty() && this.statsPerEnumerator.isEmpty();
        }

        @Nullable
        public final StatsPerStorage nullize() {
            return this.isEmpty() ? null : this;
        }

        @NotNull
        public final SortedMap<String, PersistentHashMapStatistics> component1() {
            return this.statsPerPhm;
        }

        @NotNull
        public final SortedMap<String, PersistentEnumeratorStatistics> component2() {
            return this.statsPerEnumerator;
        }

        @NotNull
        public final StatsPerStorage copy(@NotNull SortedMap<String, PersistentHashMapStatistics> statsPerPhm, @NotNull SortedMap<String, PersistentEnumeratorStatistics> statsPerEnumerator) {
            Intrinsics.checkNotNullParameter(statsPerPhm, (String)"statsPerPhm");
            Intrinsics.checkNotNullParameter(statsPerEnumerator, (String)"statsPerEnumerator");
            return new StatsPerStorage(statsPerPhm, statsPerEnumerator);
        }

        public static /* synthetic */ StatsPerStorage copy$default(StatsPerStorage statsPerStorage, SortedMap sortedMap, SortedMap sortedMap2, int n, Object object) {
            if ((n & 1) != 0) {
                sortedMap = statsPerStorage.statsPerPhm;
            }
            if ((n & 2) != 0) {
                sortedMap2 = statsPerStorage.statsPerEnumerator;
            }
            return statsPerStorage.copy(sortedMap, sortedMap2);
        }

        @NotNull
        public String toString() {
            return "StatsPerStorage(statsPerPhm=" + this.statsPerPhm + ", statsPerEnumerator=" + this.statsPerEnumerator + ")";
        }

        public int hashCode() {
            int result2 = this.statsPerPhm.hashCode();
            result2 = result2 * 31 + this.statsPerEnumerator.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StatsPerStorage)) {
                return false;
            }
            StatsPerStorage statsPerStorage = (StatsPerStorage)other;
            if (!Intrinsics.areEqual(this.statsPerPhm, statsPerStorage.statsPerPhm)) {
                return false;
            }
            return Intrinsics.areEqual(this.statsPerEnumerator, statsPerStorage.statsPerEnumerator);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage$Companion;", "", "()V", "EMPTY", "Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "getEMPTY", "()Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "intellij.platform.lang.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final StatsPerStorage getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$IndexStorageStats;", "", "indexStoragesStats", "", "", "Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "otherStoragesStats", "(Ljava/util/Map;Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;)V", "getIndexStoragesStats", "()Ljava/util/Map;", "getOtherStoragesStats", "()Lcom/intellij/util/indexing/diagnostic/StorageDiagnosticData$StatsPerStorage;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    public static final class IndexStorageStats {
        @NotNull
        private final Map<String, StatsPerStorage> indexStoragesStats;
        @Nullable
        private final StatsPerStorage otherStoragesStats;

        public IndexStorageStats(@NotNull Map<String, StatsPerStorage> indexStoragesStats, @Nullable StatsPerStorage otherStoragesStats) {
            Intrinsics.checkNotNullParameter(indexStoragesStats, (String)"indexStoragesStats");
            this.indexStoragesStats = indexStoragesStats;
            this.otherStoragesStats = otherStoragesStats;
        }

        @NotNull
        public final Map<String, StatsPerStorage> getIndexStoragesStats() {
            return this.indexStoragesStats;
        }

        @Nullable
        public final StatsPerStorage getOtherStoragesStats() {
            return this.otherStoragesStats;
        }

        @NotNull
        public final Map<String, StatsPerStorage> component1() {
            return this.indexStoragesStats;
        }

        @Nullable
        public final StatsPerStorage component2() {
            return this.otherStoragesStats;
        }

        @NotNull
        public final IndexStorageStats copy(@NotNull Map<String, StatsPerStorage> indexStoragesStats, @Nullable StatsPerStorage otherStoragesStats) {
            Intrinsics.checkNotNullParameter(indexStoragesStats, (String)"indexStoragesStats");
            return new IndexStorageStats(indexStoragesStats, otherStoragesStats);
        }

        public static /* synthetic */ IndexStorageStats copy$default(IndexStorageStats indexStorageStats, Map map2, StatsPerStorage statsPerStorage, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = indexStorageStats.indexStoragesStats;
            }
            if ((n & 2) != 0) {
                statsPerStorage = indexStorageStats.otherStoragesStats;
            }
            return indexStorageStats.copy(map2, statsPerStorage);
        }

        @NotNull
        public String toString() {
            return "IndexStorageStats(indexStoragesStats=" + this.indexStoragesStats + ", otherStoragesStats=" + this.otherStoragesStats + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.indexStoragesStats).hashCode();
            result2 = result2 * 31 + (this.otherStoragesStats == null ? 0 : this.otherStoragesStats.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IndexStorageStats)) {
                return false;
            }
            IndexStorageStats indexStorageStats = (IndexStorageStats)other;
            if (!Intrinsics.areEqual(this.indexStoragesStats, indexStorageStats.indexStoragesStats)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.otherStoragesStats, (Object)indexStorageStats.otherStoragesStats);
        }
    }
}

