/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0087\b\u0018\u0000 \u00112\u00020\u0001:\u0003\u0011\u0012\u0013B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime;", "", "instant", "Ljava/time/ZonedDateTime;", "(Ljava/time/ZonedDateTime;)V", "getInstant", "()Ljava/time/ZonedDateTime;", "component1", "copy", "equals", "", "other", "hashCode", "", "presentableLocalDateTime", "", "toString", "Companion", "Deserializer", "Serializer", "intellij.platform.lang.impl"})
public final class JsonDateTime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZonedDateTime instant;
    @NotNull
    private static final DateTimeFormatter LOCAL_DATE_TIME_SHORT_FORMAT;

    public JsonDateTime(@NotNull ZonedDateTime instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        this.instant = instant;
    }

    public /* synthetic */ JsonDateTime(ZonedDateTime zonedDateTime, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ZonedDateTime zonedDateTime2 = ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"ofInstant(Instant.EPOCH, ZoneOffset.UTC)");
            zonedDateTime = zonedDateTime2;
        }
        this(zonedDateTime);
    }

    @NotNull
    public final ZonedDateTime getInstant() {
        return this.instant;
    }

    @NotNull
    public final String presentableLocalDateTime() {
        String string2 = this.instant.withZoneSameInstant(ZoneOffset.systemDefault()).format(LOCAL_DATE_TIME_SHORT_FORMAT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"instant.withZoneSameInst\u2026L_DATE_TIME_SHORT_FORMAT)");
        return string2;
    }

    @NotNull
    public final ZonedDateTime component1() {
        return this.instant;
    }

    @NotNull
    public final JsonDateTime copy(@NotNull ZonedDateTime instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return new JsonDateTime(instant);
    }

    public static /* synthetic */ JsonDateTime copy$default(JsonDateTime jsonDateTime, ZonedDateTime zonedDateTime, int n, Object object) {
        if ((n & 1) != 0) {
            zonedDateTime = jsonDateTime.instant;
        }
        return jsonDateTime.copy(zonedDateTime);
    }

    @NotNull
    public String toString() {
        return "JsonDateTime(instant=" + this.instant + ")";
    }

    public int hashCode() {
        return this.instant.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JsonDateTime)) {
            return false;
        }
        JsonDateTime jsonDateTime = (JsonDateTime)other;
        return Intrinsics.areEqual((Object)this.instant, (Object)jsonDateTime.instant);
    }

    public JsonDateTime() {
        this(null, 1, null);
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss dd MMM");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(\"HH:mm:ss dd MMM\")");
        LOCAL_DATE_TIME_SHORT_FORMAT = dateTimeFormatter;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime$Companion;", "", "()V", "LOCAL_DATE_TIME_SHORT_FORMAT", "Ljava/time/format/DateTimeFormatter;", "getLOCAL_DATE_TIME_SHORT_FORMAT", "()Ljava/time/format/DateTimeFormatter;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateTimeFormatter getLOCAL_DATE_TIME_SHORT_FORMAT() {
            return LOCAL_DATE_TIME_SHORT_FORMAT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime$Serializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime;", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "intellij.platform.lang.impl"})
    public static final class Serializer
    extends JsonSerializer<JsonDateTime> {
        public void serialize(@NotNull JsonDateTime value, @NotNull JsonGenerator gen, @Nullable SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            gen.writeString(DateTimeFormatter.ISO_ZONED_DATE_TIME.format(value.getInstant()));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime$Deserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime;", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "intellij.platform.lang.impl"})
    public static final class Deserializer
    extends JsonDeserializer<JsonDateTime> {
        @NotNull
        public JsonDateTime deserialize(@NotNull JsonParser p, @Nullable DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(p.getValueAsString(), DateTimeFormatter.ISO_ZONED_DATE_TIME);
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"parse(p.valueAsString, D\u2026tter.ISO_ZONED_DATE_TIME)");
            return new JsonDateTime(zonedDateTime);
        }
    }
}

