/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.indexing.diagnostic.dto.JsonDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0001 BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006!"}, d2={"Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnosticAppInfo;", "", "build", "", "buildDate", "Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime;", "productCode", "generated", "os", "runtime", "(Ljava/lang/String;Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime;Ljava/lang/String;Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime;Ljava/lang/String;Ljava/lang/String;)V", "getBuild", "()Ljava/lang/String;", "getBuildDate", "()Lcom/intellij/util/indexing/diagnostic/dto/JsonDateTime;", "getGenerated", "getOs", "getProductCode", "getRuntime", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.platform.lang.impl"})
public final class JsonIndexDiagnosticAppInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String build;
    @NotNull
    private final JsonDateTime buildDate;
    @NotNull
    private final String productCode;
    @NotNull
    private final JsonDateTime generated;
    @NotNull
    private final String os;
    @NotNull
    private final String runtime;

    public JsonIndexDiagnosticAppInfo(@NotNull String build2, @NotNull JsonDateTime buildDate, @NotNull String productCode, @NotNull JsonDateTime generated, @NotNull String os, @NotNull String runtime) {
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        Intrinsics.checkNotNullParameter((Object)buildDate, (String)"buildDate");
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        Intrinsics.checkNotNullParameter((Object)generated, (String)"generated");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        this.build = build2;
        this.buildDate = buildDate;
        this.productCode = productCode;
        this.generated = generated;
        this.os = os;
        this.runtime = runtime;
    }

    public /* synthetic */ JsonIndexDiagnosticAppInfo(String string2, JsonDateTime jsonDateTime, String string3, JsonDateTime jsonDateTime2, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        if ((n & 2) != 0) {
            jsonDateTime = new JsonDateTime(null, 1, null);
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            jsonDateTime2 = new JsonDateTime(null, 1, null);
        }
        if ((n & 0x10) != 0) {
            string4 = "";
        }
        if ((n & 0x20) != 0) {
            string5 = "";
        }
        this(string2, jsonDateTime, string3, jsonDateTime2, string4, string5);
    }

    @NotNull
    public final String getBuild() {
        return this.build;
    }

    @NotNull
    public final JsonDateTime getBuildDate() {
        return this.buildDate;
    }

    @NotNull
    public final String getProductCode() {
        return this.productCode;
    }

    @NotNull
    public final JsonDateTime getGenerated() {
        return this.generated;
    }

    @NotNull
    public final String getOs() {
        return this.os;
    }

    @NotNull
    public final String getRuntime() {
        return this.runtime;
    }

    @NotNull
    public final String component1() {
        return this.build;
    }

    @NotNull
    public final JsonDateTime component2() {
        return this.buildDate;
    }

    @NotNull
    public final String component3() {
        return this.productCode;
    }

    @NotNull
    public final JsonDateTime component4() {
        return this.generated;
    }

    @NotNull
    public final String component5() {
        return this.os;
    }

    @NotNull
    public final String component6() {
        return this.runtime;
    }

    @NotNull
    public final JsonIndexDiagnosticAppInfo copy(@NotNull String build2, @NotNull JsonDateTime buildDate, @NotNull String productCode, @NotNull JsonDateTime generated, @NotNull String os, @NotNull String runtime) {
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        Intrinsics.checkNotNullParameter((Object)buildDate, (String)"buildDate");
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        Intrinsics.checkNotNullParameter((Object)generated, (String)"generated");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        return new JsonIndexDiagnosticAppInfo(build2, buildDate, productCode, generated, os, runtime);
    }

    public static /* synthetic */ JsonIndexDiagnosticAppInfo copy$default(JsonIndexDiagnosticAppInfo jsonIndexDiagnosticAppInfo, String string2, JsonDateTime jsonDateTime, String string3, JsonDateTime jsonDateTime2, String string4, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = jsonIndexDiagnosticAppInfo.build;
        }
        if ((n & 2) != 0) {
            jsonDateTime = jsonIndexDiagnosticAppInfo.buildDate;
        }
        if ((n & 4) != 0) {
            string3 = jsonIndexDiagnosticAppInfo.productCode;
        }
        if ((n & 8) != 0) {
            jsonDateTime2 = jsonIndexDiagnosticAppInfo.generated;
        }
        if ((n & 0x10) != 0) {
            string4 = jsonIndexDiagnosticAppInfo.os;
        }
        if ((n & 0x20) != 0) {
            string5 = jsonIndexDiagnosticAppInfo.runtime;
        }
        return jsonIndexDiagnosticAppInfo.copy(string2, jsonDateTime, string3, jsonDateTime2, string4, string5);
    }

    @NotNull
    public String toString() {
        return "JsonIndexDiagnosticAppInfo(build=" + this.build + ", buildDate=" + this.buildDate + ", productCode=" + this.productCode + ", generated=" + this.generated + ", os=" + this.os + ", runtime=" + this.runtime + ")";
    }

    public int hashCode() {
        int result2 = this.build.hashCode();
        result2 = result2 * 31 + this.buildDate.hashCode();
        result2 = result2 * 31 + this.productCode.hashCode();
        result2 = result2 * 31 + this.generated.hashCode();
        result2 = result2 * 31 + this.os.hashCode();
        result2 = result2 * 31 + this.runtime.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JsonIndexDiagnosticAppInfo)) {
            return false;
        }
        JsonIndexDiagnosticAppInfo jsonIndexDiagnosticAppInfo = (JsonIndexDiagnosticAppInfo)other;
        if (!Intrinsics.areEqual((Object)this.build, (Object)jsonIndexDiagnosticAppInfo.build)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildDate, (Object)jsonIndexDiagnosticAppInfo.buildDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.productCode, (Object)jsonIndexDiagnosticAppInfo.productCode)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.generated, (Object)jsonIndexDiagnosticAppInfo.generated)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.os, (Object)jsonIndexDiagnosticAppInfo.os)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.runtime, (Object)jsonIndexDiagnosticAppInfo.runtime);
    }

    public JsonIndexDiagnosticAppInfo() {
        this(null, null, null, null, null, null, 63, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnosticAppInfo$Companion;", "", "()V", "create", "Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnosticAppInfo;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JsonIndexDiagnosticAppInfo create() {
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            String string2 = appInfo.getBuild().asStringWithoutProductCode();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"appInfo.build.asStringWithoutProductCode()");
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(appInfo.getBuildDate().toInstant(), appInfo.getBuildDate().getTimeZone().toZoneId());
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ofInstant(appInfo.buildD\u2026Date.timeZone.toZoneId())");
            JsonDateTime jsonDateTime = new JsonDateTime(zonedDateTime);
            String string3 = appInfo.getBuild().getProductCode();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"appInfo.build.productCode");
            ZonedDateTime zonedDateTime2 = ZonedDateTime.now(ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"now(ZoneOffset.UTC)");
            JsonDateTime jsonDateTime2 = new JsonDateTime(zonedDateTime2);
            String string4 = SystemInfo.getOsNameAndVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getOsNameAndVersion()");
            return new JsonIndexDiagnosticAppInfo(string2, jsonDateTime, string3, jsonDateTime2, string4, SystemInfo.JAVA_VENDOR + " " + SystemInfo.JAVA_VERSION + " " + SystemInfo.JAVA_RUNTIME_VERSION);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

