/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePaths;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePaths;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnosticBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "allIndexedFilePaths", "", "Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "filesFromUnsupportedFileSystems", "projectIndexedFileProviderDebugNameToFileIds", "", "", "", "addFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "providerName", "build", "Lcom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnostic;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nIndexContentDiagnosticDumper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexContentDiagnosticDumper.kt\ncom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnosticBuilder\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n361#2,7:83\n442#2:90\n392#2:91\n1238#3,4:92\n*S KotlinDebug\n*F\n+ 1 IndexContentDiagnosticDumper.kt\ncom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnosticBuilder\n*L\n34#1:83,7\n45#1:90\n45#1:91\n45#1:92,4\n*E\n"})
public final class IndexContentDiagnosticBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<IndexedFilePath> allIndexedFilePaths;
    @NotNull
    private final Set<IndexedFilePath> filesFromUnsupportedFileSystems;
    @NotNull
    private final Map<String, Set<Integer>> projectIndexedFileProviderDebugNameToFileIds;

    public IndexContentDiagnosticBuilder(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        Set set2 = ContainerUtil.newConcurrentSet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"newConcurrentSet()");
        this.allIndexedFilePaths = set2;
        Set set3 = ContainerUtil.newConcurrentSet();
        Intrinsics.checkNotNullExpressionValue(set3, (String)"newConcurrentSet()");
        this.filesFromUnsupportedFileSystems = set3;
        this.projectIndexedFileProviderDebugNameToFileIds = new ConcurrentHashMap();
    }

    public final void addFile(@NotNull VirtualFile file2, @NotNull String providerName) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        if (file2.isDirectory()) {
            return;
        }
        IndexedFilePath indexedFilePath = IndexedFilePaths.INSTANCE.createIndexedFilePath(file2, this.project);
        if (PortableFilePaths.INSTANCE.isSupportedFileSystem(file2)) {
            Set<Integer> set2;
            ((Collection)this.allIndexedFilePaths).add(indexedFilePath);
            Map<String, Set<Integer>> $this$getOrPut$iv = this.projectIndexedFileProviderDebugNameToFileIds;
            boolean $i$f$getOrPut = false;
            Set<Integer> value$iv = $this$getOrPut$iv.get(providerName);
            if (value$iv == null) {
                boolean bl = false;
                Set set3 = ContainerUtil.newConcurrentSet();
                Intrinsics.checkNotNullExpressionValue(set3, (String)"newConcurrentSet()");
                Set answer$iv = set3;
                $this$getOrPut$iv.put(providerName, answer$iv);
                set2 = answer$iv;
            } else {
                set2 = value$iv;
            }
            Collection collection = set2;
            collection.add(indexedFilePath.getOriginalFileSystemId());
        } else {
            ((Collection)this.filesFromUnsupportedFileSystems).add(indexedFilePath);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IndexContentDiagnostic build() {
        Map map2;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map<String, Set<Integer>> map3 = this.projectIndexedFileProviderDebugNameToFileIds;
        List list2 = CollectionsKt.toList((Iterable)this.filesFromUnsupportedFileSystems);
        List list3 = CollectionsKt.toList((Iterable)this.allIndexedFilePaths);
        boolean $i$f$mapValues = false;
        void var3_5 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map2 = map4;
            boolean bl2 = false;
            Set ids = (Set)entry2.getValue();
            SortedSet sortedSet = CollectionsKt.toSortedSet((Iterable)ids);
            map2.put(k, sortedSet);
        }
        Map map5 = map2 = destination$iv$iv;
        List list4 = list2;
        List list5 = list3;
        return new IndexContentDiagnostic(list5, list4, map5);
    }
}

