/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticBuilder;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnosticDumper;", "", "()V", "jacksonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getIndexContentDiagnosticForProject", "Lcom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnostic;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "readFrom", "file", "Ljava/nio/file/Path;", "writeTo", "", "destination", "contentDiagnostic", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nIndexContentDiagnosticDumper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexContentDiagnosticDumper.kt\ncom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnosticDumper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,82:1\n1549#2:83\n1620#2,3:84\n48#3:87\n43#3:88\n*S KotlinDebug\n*F\n+ 1 IndexContentDiagnosticDumper.kt\ncom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnosticDumper\n*L\n63#1:83\n63#1:84,3\n81#1:87\n81#1:88\n*E\n"})
public final class IndexContentDiagnosticDumper {
    @NotNull
    public static final IndexContentDiagnosticDumper INSTANCE = new IndexContentDiagnosticDumper();
    @NotNull
    private static final ObjectMapper jacksonObjectMapper = ExtensionsKt.jacksonObjectMapper();

    private IndexContentDiagnosticDumper() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IndexContentDiagnostic getIndexContentDiagnosticForProject(@NotNull Project project2, @NotNull ProgressIndicator indicator) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        List list2 = ((FileBasedIndexImpl)fileBasedIndex).getIndexableFilesProviders(project2);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"FileBasedIndex.getInstan\u2026leFilesProviders(project)");
        List providers = list2;
        indicator.setText(IndexingBundle.message((String)"index.content.diagnostic.dumping", (Object[])new Object[0]));
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        IndexContentDiagnosticBuilder builder2 = new IndexContentDiagnosticBuilder(project2);
        AtomicInteger processed2 = new AtomicInteger();
        Iterable $this$map$iv = providers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void provider2;
            IndexableFilesIterator indexableFilesIterator = (IndexableFilesIterator)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(() -> IndexContentDiagnosticDumper.getIndexContentDiagnosticForProject$lambda$2$lambda$1(indicator, (IndexableFilesIterator)provider2, project2, processed2, providers, builder2));
        }
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible((List)destination$iv$iv);
        return builder2.build();
    }

    public final void writeTo(@NotNull Path destination, @NotNull IndexContentDiagnostic contentDiagnostic) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)contentDiagnostic, (String)"contentDiagnostic");
        jacksonObjectMapper.writerWithDefaultPrettyPrinter().writeValue(destination.toFile(), (Object)contentDiagnostic);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IndexContentDiagnostic readFrom(@NotNull Path file2) {
        void $this$readValue$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ObjectMapper objectMapper = jacksonObjectMapper;
        File file3 = file2.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file.toFile()");
        File src$iv = file3;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        return (IndexContentDiagnostic)$this$readValue$iv.readValue(src$iv, (TypeReference)new TypeReference<IndexContentDiagnostic>(){});
    }

    private static final boolean getIndexContentDiagnosticForProject$lambda$2$lambda$1$lambda$0(IndexContentDiagnosticBuilder $builder, IndexableFilesIterator $provider, VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        String string2 = $provider.getDebugName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"provider.debugName");
        $builder.addFile(fileOrDir, string2);
        return true;
    }

    private static final void getIndexContentDiagnosticForProject$lambda$2$lambda$1(ProgressIndicator $indicator, IndexableFilesIterator $provider, Project $project, AtomicInteger $processed, List $providers, IndexContentDiagnosticBuilder $builder) {
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$processed, (String)"$processed");
        Intrinsics.checkNotNullParameter((Object)$providers, (String)"$providers");
        Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
        $indicator.setText2($provider.getDebugName());
        $provider.iterateFiles($project, arg_0 -> IndexContentDiagnosticDumper.getIndexContentDiagnosticForProject$lambda$2$lambda$1$lambda$0($builder, $provider, arg_0), VirtualFileFilter.ALL);
        $indicator.setFraction((double)$processed.incrementAndGet() / (double)$providers.size());
    }
}

