/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump.paths;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u001e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0010\u0010#\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0016J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u000bH\u00c6\u0003J\u0015\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rH\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003Jz\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010*J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020\u0003H\u00d6\u0001J\b\u0010/\u001a\u00020\u0005H\u0016R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0012\u00a8\u00060"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "", "originalFileSystemId", "", "fileType", "", "substitutedFileType", "fileSize", "", "originalFileUrl", "portableFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "filePropertyPusherValues", "", "contentHash", "indexedFileHash", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;)V", "getContentHash", "()Ljava/lang/String;", "getFilePropertyPusherValues", "()Ljava/util/Map;", "getFileSize", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getFileType", "getIndexedFileHash", "getOriginalFileSystemId", "()I", "getOriginalFileUrl", "getPortableFilePath", "()Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "getSubstitutedFileType", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;)Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "equals", "", "other", "hashCode", "toString", "intellij.platform.lang.impl"})
public final class IndexedFilePath {
    private final int originalFileSystemId;
    @Nullable
    private final String fileType;
    @Nullable
    private final String substitutedFileType;
    @Nullable
    private final Long fileSize;
    @NotNull
    private final String originalFileUrl;
    @NotNull
    private final PortableFilePath portableFilePath;
    @NotNull
    private final Map<String, String> filePropertyPusherValues;
    @NotNull
    private final String contentHash;
    @NotNull
    private final String indexedFileHash;

    public IndexedFilePath(int originalFileSystemId, @Nullable String fileType, @Nullable String substitutedFileType2, @Nullable Long fileSize, @NotNull String originalFileUrl, @NotNull PortableFilePath portableFilePath, @NotNull Map<String, String> filePropertyPusherValues, @NotNull String contentHash, @NotNull String indexedFileHash) {
        Intrinsics.checkNotNullParameter((Object)originalFileUrl, (String)"originalFileUrl");
        Intrinsics.checkNotNullParameter((Object)portableFilePath, (String)"portableFilePath");
        Intrinsics.checkNotNullParameter(filePropertyPusherValues, (String)"filePropertyPusherValues");
        Intrinsics.checkNotNullParameter((Object)contentHash, (String)"contentHash");
        Intrinsics.checkNotNullParameter((Object)indexedFileHash, (String)"indexedFileHash");
        this.originalFileSystemId = originalFileSystemId;
        this.fileType = fileType;
        this.substitutedFileType = substitutedFileType2;
        this.fileSize = fileSize;
        this.originalFileUrl = originalFileUrl;
        this.portableFilePath = portableFilePath;
        this.filePropertyPusherValues = filePropertyPusherValues;
        this.contentHash = contentHash;
        this.indexedFileHash = indexedFileHash;
    }

    public final int getOriginalFileSystemId() {
        return this.originalFileSystemId;
    }

    @Nullable
    public final String getFileType() {
        return this.fileType;
    }

    @Nullable
    public final String getSubstitutedFileType() {
        return this.substitutedFileType;
    }

    @Nullable
    public final Long getFileSize() {
        return this.fileSize;
    }

    @NotNull
    public final String getOriginalFileUrl() {
        return this.originalFileUrl;
    }

    @NotNull
    public final PortableFilePath getPortableFilePath() {
        return this.portableFilePath;
    }

    @NotNull
    public final Map<String, String> getFilePropertyPusherValues() {
        return this.filePropertyPusherValues;
    }

    @NotNull
    public final String getContentHash() {
        return this.contentHash;
    }

    @NotNull
    public final String getIndexedFileHash() {
        return this.indexedFileHash;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$toString_u24lambda_u240.append("File URL = " + this.originalFileUrl);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder3 = $this$toString_u24lambda_u240.append("File ID = " + this.originalFileSystemId);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        if (this.fileSize == null) {
            StringBuilder stringBuilder4 = $this$toString_u24lambda_u240.append("This is a directory");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        } else {
            StringBuilder stringBuilder5 = $this$toString_u24lambda_u240.append("File size = " + this.fileSize);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
        }
        if (this.fileType != null) {
            StringBuilder stringBuilder6 = $this$toString_u24lambda_u240.append("File type = " + this.fileType);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
        }
        if (this.substitutedFileType != null) {
            StringBuilder stringBuilder7 = $this$toString_u24lambda_u240.append("Substituted file type = " + this.substitutedFileType);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
        }
        StringBuilder stringBuilder8 = $this$toString_u24lambda_u240.append("Portable path = " + this.portableFilePath.getPresentablePath());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append('\\n')");
        $this$toString_u24lambda_u240.append("File property pusher values: ");
        if (!this.filePropertyPusherValues.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u240.append('\n'), (String)"append('\\n')");
            for (Map.Entry<String, String> entry : this.filePropertyPusherValues.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                StringBuilder stringBuilder9 = $this$toString_u24lambda_u240.append("  " + key + " -> " + value);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append('\\n')");
            }
        } else {
            StringBuilder stringBuilder10 = $this$toString_u24lambda_u240.append("<empty>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append('\\n')");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public final int component1() {
        return this.originalFileSystemId;
    }

    @Nullable
    public final String component2() {
        return this.fileType;
    }

    @Nullable
    public final String component3() {
        return this.substitutedFileType;
    }

    @Nullable
    public final Long component4() {
        return this.fileSize;
    }

    @NotNull
    public final String component5() {
        return this.originalFileUrl;
    }

    @NotNull
    public final PortableFilePath component6() {
        return this.portableFilePath;
    }

    @NotNull
    public final Map<String, String> component7() {
        return this.filePropertyPusherValues;
    }

    @NotNull
    public final String component8() {
        return this.contentHash;
    }

    @NotNull
    public final String component9() {
        return this.indexedFileHash;
    }

    @NotNull
    public final IndexedFilePath copy(int originalFileSystemId, @Nullable String fileType, @Nullable String substitutedFileType2, @Nullable Long fileSize, @NotNull String originalFileUrl, @NotNull PortableFilePath portableFilePath, @NotNull Map<String, String> filePropertyPusherValues, @NotNull String contentHash, @NotNull String indexedFileHash) {
        Intrinsics.checkNotNullParameter((Object)originalFileUrl, (String)"originalFileUrl");
        Intrinsics.checkNotNullParameter((Object)portableFilePath, (String)"portableFilePath");
        Intrinsics.checkNotNullParameter(filePropertyPusherValues, (String)"filePropertyPusherValues");
        Intrinsics.checkNotNullParameter((Object)contentHash, (String)"contentHash");
        Intrinsics.checkNotNullParameter((Object)indexedFileHash, (String)"indexedFileHash");
        return new IndexedFilePath(originalFileSystemId, fileType, substitutedFileType2, fileSize, originalFileUrl, portableFilePath, filePropertyPusherValues, contentHash, indexedFileHash);
    }

    public static /* synthetic */ IndexedFilePath copy$default(IndexedFilePath indexedFilePath, int n, String string2, String string3, Long l, String string4, PortableFilePath portableFilePath, Map map2, String string5, String string6, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = indexedFilePath.originalFileSystemId;
        }
        if ((n2 & 2) != 0) {
            string2 = indexedFilePath.fileType;
        }
        if ((n2 & 4) != 0) {
            string3 = indexedFilePath.substitutedFileType;
        }
        if ((n2 & 8) != 0) {
            l = indexedFilePath.fileSize;
        }
        if ((n2 & 0x10) != 0) {
            string4 = indexedFilePath.originalFileUrl;
        }
        if ((n2 & 0x20) != 0) {
            portableFilePath = indexedFilePath.portableFilePath;
        }
        if ((n2 & 0x40) != 0) {
            map2 = indexedFilePath.filePropertyPusherValues;
        }
        if ((n2 & 0x80) != 0) {
            string5 = indexedFilePath.contentHash;
        }
        if ((n2 & 0x100) != 0) {
            string6 = indexedFilePath.indexedFileHash;
        }
        return indexedFilePath.copy(n, string2, string3, l, string4, portableFilePath, map2, string5, string6);
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.originalFileSystemId);
        result2 = result2 * 31 + (this.fileType == null ? 0 : this.fileType.hashCode());
        result2 = result2 * 31 + (this.substitutedFileType == null ? 0 : this.substitutedFileType.hashCode());
        result2 = result2 * 31 + (this.fileSize == null ? 0 : ((Object)this.fileSize).hashCode());
        result2 = result2 * 31 + this.originalFileUrl.hashCode();
        result2 = result2 * 31 + this.portableFilePath.hashCode();
        result2 = result2 * 31 + ((Object)this.filePropertyPusherValues).hashCode();
        result2 = result2 * 31 + this.contentHash.hashCode();
        result2 = result2 * 31 + this.indexedFileHash.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IndexedFilePath)) {
            return false;
        }
        IndexedFilePath indexedFilePath = (IndexedFilePath)other;
        if (this.originalFileSystemId != indexedFilePath.originalFileSystemId) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fileType, (Object)indexedFilePath.fileType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.substitutedFileType, (Object)indexedFilePath.substitutedFileType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fileSize, (Object)indexedFilePath.fileSize)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.originalFileUrl, (Object)indexedFilePath.originalFileUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.portableFilePath, (Object)indexedFilePath.portableFilePath)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.filePropertyPusherValues, indexedFilePath.filePropertyPusherValues)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contentHash, (Object)indexedFilePath.contentHash)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.indexedFileHash, (Object)indexedFilePath.indexedFileHash);
    }
}

