/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump.paths;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Base64;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexedHashesSupport;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePaths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePaths;", "", "()V", "FAILED_TO_LOAD", "", "TOO_LARGE_FILE", "pusherName", "Lcom/intellij/openapi/roots/impl/FilePropertyPusher;", "getPusherName", "(Lcom/intellij/openapi/roots/impl/FilePropertyPusher;)Ljava/lang/String;", "createIndexedFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "fileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "dumpFilePropertyPusherValues", "", "file", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nindexedFilePaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 indexedFilePaths.kt\ncom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePaths\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n442#2:85\n392#2:86\n1238#3,4:87\n*S KotlinDebug\n*F\n+ 1 indexedFilePaths.kt\ncom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePaths\n*L\n51#1:85\n51#1:86\n51#1:87,4\n*E\n"})
public final class IndexedFilePaths {
    @NotNull
    public static final IndexedFilePaths INSTANCE = new IndexedFilePaths();
    @NotNull
    private static final String TOO_LARGE_FILE = "<TOO LARGE>";
    @NotNull
    private static final String FAILED_TO_LOAD = "<FAILED TO LOAD: %s>";

    private IndexedFilePaths() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IndexedFilePath createIndexedFilePath(@NotNull VirtualFile fileOrDir, @NotNull Project project2) {
        void $this$mapValuesTo$iv$iv;
        Object fileContent;
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        int fileId = FileBasedIndex.getFileId((VirtualFile)fileOrDir);
        String string2 = fileOrDir.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fileOrDir.url");
        String fileUrl = string2;
        String fileType = fileOrDir.isDirectory() ? null : fileOrDir.getFileType().getName();
        String substitutedFileType2 = fileOrDir.isDirectory() ? null : (String)ActionsKt.runReadAction((Function0)new Function0<String>(fileOrDir, project2, fileType){
            final /* synthetic */ VirtualFile $fileOrDir;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $fileType;
            {
                this.$fileOrDir = $fileOrDir;
                this.$project = $project;
                this.$fileType = $fileType;
                super(0);
            }

            @Nullable
            public final String invoke() {
                String string2 = SubstitutedFileType.substituteFileType(this.$fileOrDir, this.$fileOrDir.getFileType(), this.$project).getName();
                String string3 = this.$fileType;
                String it = string2;
                boolean bl = false;
                return !Intrinsics.areEqual((Object)it, (Object)string3) ? string2 : null;
            }
        });
        try {
            FileContent fileContent2 = FileContentImpl.createByFile(fileOrDir);
            Intrinsics.checkNotNull((Object)fileContent2, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileContentImpl");
            fileContent = (FileContentImpl)fileContent2;
            fileContent = (Pair)ActionsKt.runReadAction((Function0)new Function0<Pair<? extends String, ? extends String>>((FileContentImpl)fileContent){
                final /* synthetic */ FileContentImpl $fileContent;
                {
                    this.$fileContent = $fileContent;
                    super(0);
                }

                @NotNull
                public final Pair<String, String> invoke() {
                    byte[] contentHash = IndexedHashesSupport.getBinaryContentHash(this.$fileContent.getContent());
                    byte[] indexedHash = IndexedHashesSupport.calculateIndexedHash(this.$fileContent, contentHash);
                    return TuplesKt.to((Object)Base64.encode(contentHash), (Object)Base64.encode(indexedHash));
                }
            });
        }
        catch (FileTooBigException e) {
            fileContent = TuplesKt.to((Object)TOO_LARGE_FILE, (Object)TOO_LARGE_FILE);
        }
        catch (Throwable e) {
            String string3 = FAILED_TO_LOAD;
            Object[] objectArray = new Object[]{e.getMessage()};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(this, *args)");
            String msg = string4;
            fileContent = TuplesKt.to((Object)msg, (Object)msg);
        }
        Object object = fileContent;
        String contentHash = (String)object.component1();
        String indexedHash = (String)object.component2();
        Long fileSize = fileOrDir.isDirectory() ? null : Long.valueOf(fileOrDir.getLength());
        PortableFilePath portableFilePath = PortableFilePaths.INSTANCE.getPortableFilePath(fileOrDir, project2);
        Map<String, Object> $this$mapValues$iv = this.dumpFilePropertyPusherValues(fileOrDir, project2);
        boolean $i$f$mapValues = false;
        Map<String, Object> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Object v = it.getValue();
            if (v == null || (v = v.toString()) == null) {
                v = "<null-value>";
            }
            Object v2 = v;
            map4.put(k, v2);
        }
        Map allPusherValues = destination$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)indexedHash, (String)"indexedHash");
        Intrinsics.checkNotNullExpressionValue((Object)contentHash, (String)"contentHash");
        return new IndexedFilePath(fileId, fileType, substitutedFileType2, fileSize, fileUrl, portableFilePath, allPusherValues, indexedHash, contentHash);
    }

    private final Map<String, Object> dumpFilePropertyPusherValues(VirtualFile file2, Project project2) {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        FilePropertyPusher.EP_NAME.forEachExtensionSafe(arg_0 -> IndexedFilePaths.dumpFilePropertyPusherValues$lambda$1((Function1)new Function1<FilePropertyPusher<?>, Unit>(file2, project2, map2){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;
            final /* synthetic */ HashMap<String, Object> $map;
            {
                this.$file = $file;
                this.$project = $project;
                this.$map = $map;
                super(1);
            }

            public final void invoke(FilePropertyPusher<?> pusher) {
                if (this.$file.isDirectory() && pusher.acceptsDirectory(this.$file, this.$project) || !this.$file.isDirectory() && pusher.acceptsFile(this.$file, this.$project)) {
                    Map map2 = this.$map;
                    Intrinsics.checkNotNullExpressionValue(pusher, (String)"pusher");
                    map2.put(IndexedFilePaths.access$getPusherName(IndexedFilePaths.INSTANCE, pusher), pusher.getImmediateValue(this.$project, this.$file));
                }
            }
        }, arg_0));
        return map2;
    }

    private final String getPusherName(FilePropertyPusher<?> $this$pusherName) {
        String string2 = $this$pusherName.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.name");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)string2, (CharSequence)"com."), (CharSequence)"intellij."), (CharSequence)"jetbrains."), (String)"util.", (String)"", (boolean)false, (int)4, null), (String)"impl.", (String)"", (boolean)false, (int)4, null);
    }

    private static final void dumpFilePropertyPusherValues$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$getPusherName(IndexedFilePaths $this, FilePropertyPusher $receiver) {
        return $this.getPusherName($receiver);
    }
}

