/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump.paths.providers;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.providers.PortableFilePathProvider;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/providers/JdkPortableFilePathProvider;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/providers/PortableFilePathProvider;", "()V", "getRelativePortableFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$RelativePath;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.lang.impl"})
public final class JdkPortableFilePathProvider
implements PortableFilePathProvider {
    @NotNull
    public static final JdkPortableFilePathProvider INSTANCE = new JdkPortableFilePathProvider();

    private JdkPortableFilePathProvider() {
    }

    @Override
    @Nullable
    public PortableFilePath.RelativePath getRelativePortableFilePath(@NotNull Project project2, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        OrderEntry orderEntry2 = (OrderEntry)ActionsKt.runReadAction((Function0)new Function0<OrderEntry>(virtualFile2, project2){
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ Project $project;
            {
                this.$virtualFile = $virtualFile;
                this.$project = $project;
                super(0);
            }

            @Nullable
            public final OrderEntry invoke() {
                return LibraryUtil.findLibraryEntry(this.$virtualFile, this.$project);
            }
        });
        if (!(orderEntry2 instanceof JdkOrderEntry)) {
            return null;
        }
        String jdkName = ((JdkOrderEntry)orderEntry2).getJdkName();
        if (jdkName == null) {
            return null;
        }
        Object[] objectArray = new OrderRootType[]{OrderRootType.CLASSES, OrderRootType.SOURCES};
        for (OrderRootType rootType : CollectionsKt.listOf((Object[])objectArray)) {
            VirtualFile[] jdkRoots;
            boolean inClassFiles = Intrinsics.areEqual((Object)rootType, (Object)OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)((JdkOrderEntry)orderEntry2).getRootFiles(rootType), (String)"orderEntry.getRootFiles(rootType)");
            int n = jdkRoots.length;
            for (int j = 0; j < n; ++j) {
                int rootIndex = j;
                VirtualFile rootFile = jdkRoots[j];
                String relativePath = VfsUtilCore.getRelativePath(virtualFile2, rootFile);
                if (relativePath == null) continue;
                return new PortableFilePath.RelativePath(new PortableFilePath.JdkRoot(jdkName, rootIndex, inClassFiles), relativePath);
            }
        }
        return null;
    }
}

