/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump.paths.resolvers;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.resolvers.LibraryRootPortableFilePathResolver;
import com.intellij.util.indexing.diagnostic.dump.paths.resolvers.PortableFilePathResolver;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/resolvers/LibraryRootPortableFilePathResolver;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/resolvers/PortableFilePathResolver;", "()V", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "portableFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "findInLibraryTable", "libraryTable", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$LibraryRoot;", "intellij.platform.lang.impl"})
public final class LibraryRootPortableFilePathResolver
implements PortableFilePathResolver {
    @NotNull
    public static final LibraryRootPortableFilePathResolver INSTANCE = new LibraryRootPortableFilePathResolver();

    private LibraryRootPortableFilePathResolver() {
    }

    @Override
    @Nullable
    public VirtualFile findFileByPath(@NotNull Project project2, @NotNull PortableFilePath portableFilePath) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)portableFilePath, (String)"portableFilePath");
        if (portableFilePath instanceof PortableFilePath.LibraryRoot) {
            return (VirtualFile)ActionsKt.runReadAction((Function0)new Function0<VirtualFile>(portableFilePath, project2){
                final /* synthetic */ PortableFilePath $portableFilePath;
                final /* synthetic */ Project $project;
                {
                    this.$portableFilePath = $portableFilePath;
                    this.$project = $project;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Nullable
                public final VirtualFile invoke() {
                    VirtualFile virtualFile2;
                    switch (findFileByPath.WhenMappings.$EnumSwitchMapping$0[((PortableFilePath.LibraryRoot)this.$portableFilePath).getLibraryType().ordinal()]) {
                        case 1: {
                            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable();
                            Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getInstance().libraryTable");
                            virtualFile2 = LibraryRootPortableFilePathResolver.access$findInLibraryTable(LibraryRootPortableFilePathResolver.INSTANCE, libraryTable, (PortableFilePath.LibraryRoot)this.$portableFilePath);
                            break;
                        }
                        case 2: {
                            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.$project);
                            Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getInstance().getLibraryTable(project)");
                            virtualFile2 = LibraryRootPortableFilePathResolver.access$findInLibraryTable(LibraryRootPortableFilePathResolver.INSTANCE, libraryTable, (PortableFilePath.LibraryRoot)this.$portableFilePath);
                            break;
                        }
                        case 3: {
                            VirtualFile virtualFile3;
                            String string2 = ((PortableFilePath.LibraryRoot)this.$portableFilePath).getModuleName();
                            Intrinsics.checkNotNull((Object)string2);
                            String moduleName = string2;
                            Module module2 = ModuleManager.Companion.getInstance(this.$project).findModuleByName(moduleName);
                            if (module2 == null) {
                                return null;
                            }
                            Module module3 = module2;
                            ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance(module3).getModifiableModel();
                            Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"getInstance(module).modifiableModel");
                            ModifiableRootModel rootModel = modifiableRootModel;
                            try {
                                LibraryTable libraryTable = rootModel.getModuleLibraryTable();
                                Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"rootModel.moduleLibraryTable");
                                virtualFile3 = LibraryRootPortableFilePathResolver.access$findInLibraryTable(LibraryRootPortableFilePathResolver.INSTANCE, libraryTable, (PortableFilePath.LibraryRoot)this.$portableFilePath);
                            }
                            finally {
                                rootModel.dispose();
                            }
                            virtualFile2 = virtualFile3;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return virtualFile2;
                }
            });
        }
        return null;
    }

    private final VirtualFile findInLibraryTable(LibraryTable libraryTable, PortableFilePath.LibraryRoot portableFilePath) {
        Library library = libraryTable.getLibraryByName(portableFilePath.getLibraryName());
        if (library == null) {
            return null;
        }
        Library library2 = library;
        OrderRootType rootType = portableFilePath.getInClassFiles() ? OrderRootType.CLASSES : OrderRootType.SOURCES;
        Object[] objectArray = library2.getRootProvider().getFiles(rootType);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"library.rootProvider.getFiles(rootType)");
        Object[] roots2 = objectArray;
        return (VirtualFile)ArraysKt.getOrNull((Object[])roots2, (int)portableFilePath.getLibraryRootIndex());
    }

    public static final /* synthetic */ VirtualFile access$findInLibraryTable(LibraryRootPortableFilePathResolver $this, LibraryTable libraryTable, PortableFilePath.LibraryRoot portableFilePath) {
        return $this.findInLibraryTable(libraryTable, portableFilePath);
    }
}

