/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.events;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiManager;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexUpToDateCheckIn;
import com.intellij.util.indexing.IndexingFlag;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.RegisteredIndexes;
import com.intellij.util.indexing.events.DeletedVirtualFileStub;
import com.intellij.util.indexing.events.IndexedFilesListener;
import com.intellij.util.indexing.events.VfsEventsMerger;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Phaser;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class ChangedFilesCollector
extends IndexedFilesListener {
    private static final Logger LOG = Logger.getInstance(ChangedFilesCollector.class);
    public static final boolean CLEAR_NON_INDEXABLE_FILE_DATA = SystemProperties.getBooleanProperty("idea.indexes.clear.non.indexable.file.data", true);
    private final IntObjectMap<VirtualFile> myFilesToUpdate = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
    private final AtomicInteger myProcessedEventIndex = new AtomicInteger();
    private final Phaser myWorkersFinishedSync = new Phaser(){

        @Override
        protected boolean onAdvance(int phase, int registeredParties) {
            return false;
        }
    };
    private final Executor myVfsEventsExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor("FileBasedIndex Vfs Event Processor");
    private final AtomicInteger myScheduledVfsEventsWorkers = new AtomicInteger();
    private final FileBasedIndexImpl myFileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();

    @Override
    protected void iterateIndexableFiles(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator2) {
        if (file2 == null) {
            ChangedFilesCollector.$$$reportNull$$$0(0);
        }
        if (iterator2 == null) {
            ChangedFilesCollector.$$$reportNull$$$0(1);
        }
        if (this.myFileBasedIndex.belongsToIndexableFiles(file2)) {
            VfsUtilCore.visitChildrenRecursively(file2, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                @Override
                public boolean visitFile(@NotNull VirtualFile file11) {
                    if (file11 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!ChangedFilesCollector.this.myFileBasedIndex.belongsToIndexableFiles(file11)) {
                        return false;
                    }
                    iterator2.processFile(file11);
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file11", "com/intellij/util/indexing/events/ChangedFilesCollector$2", "visitFile"));
                }
            });
        }
    }

    public void scheduleForUpdate(@NotNull VirtualFile file2) {
        Set<Project> projects;
        if (file2 == null) {
            ChangedFilesCollector.$$$reportNull$$$0(2);
        }
        int fileId = FileBasedIndex.getFileId((VirtualFile)file2);
        if (!(file2 instanceof DeletedVirtualFileStub) && (projects = this.myFileBasedIndex.getContainingProjects(file2)).isEmpty()) {
            this.removeNonIndexableFileData(file2, fileId);
            return;
        }
        VfsEventsMerger.tryLog((String)"ADD_TO_UPDATE", (VirtualFile)file2);
        this.myFilesToUpdate.put(fileId, file2);
    }

    public void removeScheduledFileFromUpdate(VirtualFile file2) {
        int fileId = FileBasedIndex.getFileId((VirtualFile)file2);
        VirtualFile alreadyScheduledFile = this.myFilesToUpdate.get(fileId);
        if (!(alreadyScheduledFile instanceof DeletedVirtualFileStub)) {
            VfsEventsMerger.tryLog((String)"PULL_OUT_FROM_UPDATE", (VirtualFile)file2);
            this.myFilesToUpdate.remove(fileId);
        }
    }

    public void removeFileIdFromFilesScheduledForUpdate(int fileId) {
        this.myFilesToUpdate.remove(fileId);
    }

    public boolean containsFileId(int fileId) {
        return this.myFilesToUpdate.containsKey(fileId);
    }

    public Iterator<@NotNull VirtualFile> getFilesToUpdate() {
        return this.myFilesToUpdate.values().iterator();
    }

    public Collection<VirtualFile> getAllFilesToUpdate() {
        this.ensureUpToDate();
        return this.myFilesToUpdate.isEmpty() ? Collections.emptyList() : Collections.unmodifiableCollection(this.myFilesToUpdate.values());
    }

    public Collection<VirtualFile> getAllPossibleFilesToUpdate() {
        ReadAction.run(() -> this.processFilesInReadAction(info2 -> {
            this.myFilesToUpdate.put(info2.getFileId(), (VirtualFile)(info2.isFileRemoved() ? new DeletedVirtualFileStub((VirtualFileWithId)((Object)info2.getFile())) : info2.getFile()));
            return true;
        }));
        return new ArrayList<VirtualFile>(this.myFilesToUpdate.values());
    }

    public void clearFilesToUpdate() {
        this.myFilesToUpdate.clear();
    }

    @Override
    @NotNull
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            ChangedFilesCollector.$$$reportNull$$$0(3);
        }
        final boolean shouldCleanup = ContainerUtil.exists(events, ChangedFilesCollector::memoryStorageCleaningNeeded);
        final AsyncFileListener.ChangeApplier superApplier = super.prepareChange(events);
        return new AsyncFileListener.ChangeApplier(){

            @Override
            public void beforeVfsChange() {
                if (shouldCleanup) {
                    ChangedFilesCollector.this.myFileBasedIndex.cleanupMemoryStorage(false);
                }
                superApplier.beforeVfsChange();
            }

            @Override
            public void afterVfsChange() {
                superApplier.afterVfsChange();
                RegisteredIndexes registeredIndexes = ChangedFilesCollector.this.myFileBasedIndex.getRegisteredIndexes();
                if (registeredIndexes != null && registeredIndexes.isInitialized()) {
                    ChangedFilesCollector.this.ensureUpToDateAsync();
                }
            }
        };
    }

    private void removeNonIndexableFileData(@NotNull VirtualFile file2, int fileId) {
        if (file2 == null) {
            ChangedFilesCollector.$$$reportNull$$$0(4);
        }
        if (CLEAR_NON_INDEXABLE_FILE_DATA) {
            List<ID<?, ?>> extensions2 = this.getIndexedContentDependentExtensions(fileId);
            if (!extensions2.isEmpty()) {
                this.myFileBasedIndex.removeDataFromIndicesForFile(fileId, file2, "non_indexable_file");
            }
            IndexingFlag.cleanProcessingFlag(file2);
        } else if (ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.checkNotIndexedByContentBasedIndexes(file2, fileId);
        }
    }

    private static boolean memoryStorageCleaningNeeded(@NotNull VFileEvent event) {
        Object requestor;
        if (event == null) {
            ChangedFilesCollector.$$$reportNull$$$0(5);
        }
        return (requestor = event.getRequestor()) instanceof FileDocumentManager || requestor instanceof PsiManager || requestor == LocalHistory.VFS_EVENT_REQUESTOR;
    }

    public boolean isScheduledForUpdate(VirtualFile file2) {
        return this.myFilesToUpdate.containsKey(FileBasedIndex.getFileId((VirtualFile)file2));
    }

    public void ensureUpToDate() {
        if (!IndexUpToDateCheckIn.isUpToDateCheckEnabled()) {
            return;
        }
        this.myFileBasedIndex.waitUntilIndicesAreInitialized();
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            this.processFilesToUpdateInReadAction();
        } else {
            this.processFilesInReadActionWithYieldingToWriteAction();
        }
    }

    public void ensureUpToDateAsync() {
        if (this.getEventMerger().getApproximateChangesCount() >= 20 && this.myScheduledVfsEventsWorkers.compareAndSet(0, 1)) {
            this.myVfsEventsExecutor.execute(() -> {
                try {
                    this.processFilesInReadActionWithYieldingToWriteAction();
                    if (Registry.is("try.starting.dumb.mode.where.many.files.changed")) {
                        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
                            try {
                                FileBasedIndexProjectHandler.scheduleReindexingInDumbMode(project2);
                            }
                            catch (ProcessCanceledException | AlreadyDisposedException runtimeException) {
                            }
                            catch (Exception e) {
                                LOG.error(e);
                            }
                        }
                    }
                }
                finally {
                    this.myScheduledVfsEventsWorkers.decrementAndGet();
                }
            });
        }
    }

    public void processFilesToUpdateInReadAction() {
        this.processFilesInReadAction(new VfsEventsMerger.VfsEventProcessor(){
            private final StubIndexEx.FileUpdateProcessor perFileElementTypeUpdateProcessor = ((StubIndexImpl)StubIndex.getInstance()).getPerFileElementTypeModificationTrackerUpdateProcessor();

            public boolean process(// Could not load outer class - annotation placement on inner may be incorrect
            @NotNull VfsEventsMerger.ChangeInfo info2) {
                if (info2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                int fileId = info2.getFileId();
                VirtualFile file2 = info2.getFile();
                if (info2.isTransientStateChanged()) {
                    ChangedFilesCollector.this.myFileBasedIndex.doTransientStateChangeForFile(fileId, file2);
                }
                if (info2.isContentChanged()) {
                    ChangedFilesCollector.this.myFileBasedIndex.scheduleFileForIndexing(fileId, file2, true);
                }
                if (info2.isFileRemoved()) {
                    ChangedFilesCollector.this.myFileBasedIndex.doInvalidateIndicesForFile(fileId, file2);
                }
                if (info2.isFileAdded()) {
                    ChangedFilesCollector.this.myFileBasedIndex.scheduleFileForIndexing(fileId, file2, false);
                }
                if (StubIndexImpl.PER_FILE_ELEMENT_TYPE_STUB_CHANGE_TRACKING_SOURCE == StubIndexImpl.PerFileElementTypeStubChangeTrackingSource.ChangedFilesCollector) {
                    this.perFileElementTypeUpdateProcessor.processUpdate(file2);
                }
                return true;
            }

            public void endBatch() {
                if (StubIndexImpl.PER_FILE_ELEMENT_TYPE_STUB_CHANGE_TRACKING_SOURCE == StubIndexImpl.PerFileElementTypeStubChangeTrackingSource.ChangedFilesCollector) {
                    this.perFileElementTypeUpdateProcessor.endUpdatesBatch();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/util/indexing/events/ChangedFilesCollector$4", "process"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFilesInReadAction(final @NotNull VfsEventsMerger.VfsEventProcessor processor) {
        if (processor == null) {
            ChangedFilesCollector.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int publishedEventIndex = this.getEventMerger().getPublishedEventIndex();
        int processedEventIndex = this.myProcessedEventIndex.get();
        if (processedEventIndex == publishedEventIndex) {
            return;
        }
        this.myWorkersFinishedSync.register();
        int phase = this.myWorkersFinishedSync.getPhase();
        try {
            this.myFileBasedIndex.waitUntilIndicesAreInitialized();
            this.getEventMerger().processChanges(new VfsEventsMerger.VfsEventProcessor(){

                public boolean process(// Could not load outer class - annotation placement on inner may be incorrect
                @NotNull VfsEventsMerger.ChangeInfo changeInfo) {
                    if (changeInfo == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return ConcurrencyUtil.withLock(ChangedFilesCollector.this.myFileBasedIndex.myWriteLock, () -> {
                        try {
                            ProgressManager.getInstance().executeNonCancelableSection(() -> processor.process(changeInfo));
                        }
                        finally {
                            IndexingStamp.flushCache(changeInfo.getFileId());
                        }
                        return true;
                    });
                }

                public void endBatch() {
                    ConcurrencyUtil.withLock(ChangedFilesCollector.this.myFileBasedIndex.myWriteLock, () -> processor.endBatch());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeInfo", "com/intellij/util/indexing/events/ChangedFilesCollector$5", "process"));
                }
            });
        }
        finally {
            this.myWorkersFinishedSync.arriveAndDeregister();
        }
        try {
            this.myWorkersFinishedSync.awaitAdvance(phase);
        }
        catch (RejectedExecutionException e) {
            LOG.warn(e);
            throw new ProcessCanceledException(e);
        }
        if (this.getEventMerger().getPublishedEventIndex() == publishedEventIndex) {
            this.myProcessedEventIndex.compareAndSet(processedEventIndex, publishedEventIndex);
        }
    }

    private void processFilesInReadActionWithYieldingToWriteAction() {
        while (this.getEventMerger().hasChanges()) {
            ReadAction.nonBlocking(() -> this.processFilesToUpdateInReadAction()).executeSynchronously();
        }
    }

    private void checkNotIndexedByContentBasedIndexes(@NotNull VirtualFile file2, int fileId) {
        List<ID<?, ?>> contentDependentIndexes;
        if (file2 == null) {
            ChangedFilesCollector.$$$reportNull$$$0(7);
        }
        if (!(contentDependentIndexes = this.getIndexedContentDependentExtensions(fileId)).isEmpty()) {
            LOG.error("indexes " + contentDependentIndexes + " will not be updated for file = " + file2 + ", id = " + fileId);
        }
    }

    @NotNull
    private List<ID<?, ?>> getIndexedContentDependentExtensions(int fileId) {
        List<ID<?, ?>> contentDependentIndexes;
        List<ID<?, ?>> indexedStates = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        RegisteredIndexes registeredIndexes = this.myFileBasedIndex.getRegisteredIndexes();
        if (registeredIndexes == null) {
            Set allContentDependentIndexes = FileBasedIndexExtension.EXTENSION_POINT_NAME.getExtensionList().stream().filter(ex -> ex.dependsOnFileContent()).map(ex -> ex.getName()).collect(Collectors.toSet());
            contentDependentIndexes = ContainerUtil.filter(indexedStates, id -> !allContentDependentIndexes.contains(id));
        } else {
            contentDependentIndexes = ContainerUtil.filter(indexedStates, id -> registeredIndexes.isContentDependentIndex((ID<?, ?>)id));
        }
        List<ID<?, ?>> list2 = contentDependentIndexes;
        if (list2 == null) {
            ChangedFilesCollector.$$$reportNull$$$0(8);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public void waitForVfsEventsExecuted(long timeout, @NotNull TimeUnit timeUnit) throws Exception {
        void unit;
        if (timeUnit == null) {
            ChangedFilesCollector.$$$reportNull$$$0(9);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ((BoundedTaskExecutor)this.myVfsEventsExecutor).waitAllTasksExecuted(timeout, (TimeUnit)unit);
            return;
        }
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        while (System.nanoTime() < deadline) {
            try {
                ((BoundedTaskExecutor)this.myVfsEventsExecutor).waitAllTasksExecuted(100L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException e) {
                UIUtil.dispatchAllInvocationEvents();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/events/ChangedFilesCollector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/events/ChangedFilesCollector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedContentDependentExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "iterateIndexableFiles";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scheduleForUpdate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareChange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeNonIndexableFileData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "memoryStorageCleaningNeeded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processFilesInReadAction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkNotIndexedByContentBasedIndexes";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "waitForVfsEventsExecuted";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8 -> new IllegalStateException(string2);
        };
    }
}

