/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.events;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexingFlag;
import com.intellij.util.indexing.events.VfsEventsMerger;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class IndexedFilesListener
implements AsyncFileListener {
    @NotNull
    private final VfsEventsMerger myEventMerger = new VfsEventsMerger();

    @NotNull
    public VfsEventsMerger getEventMerger() {
        VfsEventsMerger vfsEventsMerger2 = this.myEventMerger;
        if (vfsEventsMerger2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(0);
        }
        return vfsEventsMerger2;
    }

    public void scheduleForIndexingRecursively(@NotNull VirtualFile file2, boolean onlyContentDependent) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(1);
        }
        IndexingFlag.cleanProcessedFlagRecursively(file2);
        if (file2.isDirectory()) {
            ContentIterator iterator2 = fileOrDir -> {
                this.myEventMerger.recordFileEvent(fileOrDir, onlyContentDependent);
                return true;
            };
            this.iterateIndexableFiles(file2, iterator2);
        } else {
            this.myEventMerger.recordFileEvent(file2, onlyContentDependent);
        }
    }

    protected abstract void iterateIndexableFiles(@NotNull VirtualFile var1, @NotNull ContentIterator var2);

    private static void collectFilesRecursively(@NotNull VirtualFile file2, final @NotNull Int2ObjectMap<VirtualFile> id2File) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(2);
        }
        if (id2File == null) {
            IndexedFilesListener.$$$reportNull$$$0(3);
        }
        VfsUtilCore.visitChildrenRecursively(file2, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (file2 instanceof VirtualFileWithId) {
                    id2File.put(((VirtualFileWithId)((Object)file2)).getId(), file2);
                }
                return !file2.isDirectory() || FileBasedIndexImpl.isMock(file2) || ManagingFS.getInstance().wereChildrenAccessed(file2);
            }

            @Override
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return file2 instanceof NewVirtualFile ? ((NewVirtualFile)file2).iterInDbChildren() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/util/indexing/events/IndexedFilesListener$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildrenIterable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    @NotNull
    public AsyncFileListener.ChangeApplier prepareChange(final @NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            IndexedFilesListener.$$$reportNull$$$0(4);
        }
        final Int2ObjectOpenHashMap<VirtualFile> deletedFiles = new Int2ObjectOpenHashMap<VirtualFile>();
        for (VFileEvent vFileEvent : events) {
            if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
            IndexedFilesListener.collectFilesRecursively(((VFileDeleteEvent)vFileEvent).getFile(), deletedFiles);
        }
        return new AsyncFileListener.ChangeApplier(){

            @Override
            public void beforeVfsChange() {
                for (VirtualFile file2 : deletedFiles.values()) {
                    IndexedFilesListener.this.myEventMerger.recordFileRemovedEvent(file2);
                }
            }

            @Override
            public void afterVfsChange() {
                IndexedFilesListener.this.processAfterEvents(events);
            }
        };
    }

    private void processAfterEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            IndexedFilesListener.$$$reportNull$$$0(5);
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile fileToIndex = null;
            boolean onlyContentDependent = true;
            if (vFileEvent instanceof VFileContentChangeEvent) {
                fileToIndex = vFileEvent.getFile();
            } else if (vFileEvent instanceof VFileCopyEvent) {
                VFileCopyEvent ce = (VFileCopyEvent)vFileEvent;
                VirtualFile copy2 = ce.getNewParent().findChild(ce.getNewChildName());
                if (copy2 != null) {
                    fileToIndex = copy2;
                    onlyContentDependent = false;
                }
            } else if (vFileEvent instanceof VFileCreateEvent) {
                VirtualFile newChild = vFileEvent.getFile();
                if (newChild != null) {
                    fileToIndex = newChild;
                    onlyContentDependent = false;
                }
            } else if (vFileEvent instanceof VFileMoveEvent) {
                fileToIndex = vFileEvent.getFile();
                onlyContentDependent = false;
            } else if (vFileEvent instanceof VFilePropertyChangeEvent) {
                VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)vFileEvent;
                String propertyName = pce.getPropertyName();
                if (propertyName.equals("name")) {
                    fileToIndex = pce.getFile();
                    onlyContentDependent = false;
                } else if (propertyName.equals("encoding")) {
                    fileToIndex = pce.getFile();
                }
            }
            if (fileToIndex == null) continue;
            this.scheduleForIndexingRecursively(fileToIndex, onlyContentDependent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/events/IndexedFilesListener";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id2File";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventMerger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/events/IndexedFilesListener";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "scheduleForIndexingRecursively";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectFilesRecursively";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareChange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processAfterEvents";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string2);
        };
    }
}

