/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.util.Computable;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.FileId2ValueMapping;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTrackingValueContainer<Value>
extends UpdatableValueContainer<Value> {
    protected ValueContainerImpl<Value> myAdded;
    protected IntSet myInvalidated;
    private volatile ValueContainerImpl<Value> myMergedSnapshot;
    @Nullable
    private final Computable<? extends ValueContainer<Value>> myInitializer;

    public ChangeTrackingValueContainer(@Nullable Computable<? extends ValueContainer<Value>> initializer2) {
        this.myInitializer = initializer2;
    }

    @Override
    public void addValue(int inputId, Value value) {
        ValueContainerImpl<Value> mergedSnapshot = this.myMergedSnapshot;
        if (mergedSnapshot != null) {
            mergedSnapshot.addValue(inputId, value);
        }
        if (this.myAdded == null) {
            this.myAdded = new ValueContainerImpl();
        }
        this.myAdded.addValue(inputId, value);
    }

    @Override
    public boolean removeAssociatedValue(int inputId) {
        ValueContainerImpl<Value> mergedSnapshot = this.myMergedSnapshot;
        if (mergedSnapshot != null) {
            mergedSnapshot.removeAssociatedValue(inputId);
        }
        if (this.removeFromAdded(inputId)) {
            return true;
        }
        if (this.myInvalidated == null) {
            this.myInvalidated = new IntOpenHashSet(1);
        }
        this.myInvalidated.add(inputId);
        return true;
    }

    protected boolean removeFromAdded(int inputId) {
        return this.myAdded != null && this.myAdded.removeAssociatedValue(inputId);
    }

    @Override
    public int size() {
        return this.getMergedData().size();
    }

    @Override
    @NotNull
    public ValueContainer.ValueIterator<Value> getValueIterator() {
        ValueContainer.ValueIterator valueIterator = this.getMergedData().getValueIterator();
        if (valueIterator == null) {
            ChangeTrackingValueContainer.$$$reportNull$$$0(0);
        }
        return valueIterator;
    }

    public void dropMergedData() {
        this.myMergedSnapshot = null;
    }

    private ValueContainerImpl<Value> getMergedData() {
        ValueContainerImpl<Value> mergedSnapshot = this.myMergedSnapshot;
        if (mergedSnapshot != null) {
            return mergedSnapshot;
        }
        ValueContainer<Value> fromDisk = this.myInitializer.compute();
        mergedSnapshot = this.myMergedSnapshot;
        if (mergedSnapshot != null) {
            return mergedSnapshot;
        }
        Object newMerged = fromDisk instanceof ValueContainerImpl ? ((ValueContainerImpl)fromDisk).clone() : ((ChangeTrackingValueContainer)fromDisk).getMergedData().clone();
        FileId2ValueMapping fileId2ValueMapping = (this.myAdded != null || this.myInvalidated != null) && (((ValueContainerImpl)newMerged).size() > 20 || this.myAdded != null && this.myAdded.size() > 20) ? new FileId2ValueMapping(newMerged) : null;
        if (this.myInvalidated != null) {
            this.myInvalidated.forEach(arg_0 -> ChangeTrackingValueContainer.lambda$getMergedData$0(fileId2ValueMapping, (ValueContainerImpl)newMerged, arg_0));
        }
        if (this.myAdded != null) {
            this.myAdded.forEach((arg_0, arg_1) -> ChangeTrackingValueContainer.lambda$getMergedData$1(fileId2ValueMapping, (ValueContainerImpl)newMerged, arg_0, arg_1));
        }
        this.setNeedsCompacting(((UpdatableValueContainer)fromDisk).needsCompacting());
        this.myMergedSnapshot = newMerged;
        return newMerged;
    }

    public boolean isDirty() {
        return this.myAdded != null && this.myAdded.size() > 0 || this.myInvalidated != null && !this.myInvalidated.isEmpty() || this.needsCompacting();
    }

    boolean containsOnlyInvalidatedChange() {
        return this.myInvalidated != null && !this.myInvalidated.isEmpty() && (this.myAdded == null || this.myAdded.size() == 0);
    }

    boolean containsCachedMergedData() {
        return this.myMergedSnapshot != null;
    }

    @Override
    public void saveTo(DataOutput out, DataExternalizer<? super Value> externalizer) throws IOException {
        if (this.needsCompacting()) {
            this.getMergedData().saveTo(out, externalizer);
        } else {
            ValueContainerImpl<Value> toAppend;
            IntSet set2 = this.myInvalidated;
            if (set2 != null && set2.size() > 0) {
                for (int inputId : this.myInvalidated.toIntArray()) {
                    DataInputOutputUtil.writeINT(out, -inputId);
                }
            }
            if ((toAppend = this.myAdded) != null && ((ValueContainer)toAppend).size() > 0) {
                ((UpdatableValueContainer)toAppend).saveTo(out, externalizer);
            }
        }
    }

    private static /* synthetic */ boolean lambda$getMergedData$1(FileId2ValueMapping fileId2ValueMapping, ValueContainerImpl newMerged, int inputId, Object value) {
        if (fileId2ValueMapping != null) {
            fileId2ValueMapping.removeFileId(inputId);
            fileId2ValueMapping.associateFileIdToValue(inputId, value);
        } else {
            newMerged.removeAssociatedValue(inputId);
            newMerged.addValue(inputId, value);
        }
        return true;
    }

    private static /* synthetic */ void lambda$getMergedData$0(FileId2ValueMapping fileId2ValueMapping, ValueContainerImpl newMerged, int inputId) {
        if (fileId2ValueMapping != null) {
            fileId2ValueMapping.removeFileId(inputId);
        } else {
            newMerged.removeAssociatedValue(inputId);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ChangeTrackingValueContainer", "getValueIterator"));
    }
}

