/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.containers.SLRUCache;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.MapIndexStorageCache;
import com.intellij.util.indexing.impl.MapIndexStorageSlruCache;
import com.intellij.util.io.IOCancellationCallbackHolder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000K\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u000f\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003BO\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\u00020\u00182\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u001bH\u0016J\u001b\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001f\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00062\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eR\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/util/indexing/impl/MapIndexStorageSlruCache;", "Key", "Value", "Lcom/intellij/util/indexing/impl/MapIndexStorageCache;", "valueReader", "Ljava/util/function/Function;", "Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "evictionListener", "Ljava/util/function/BiConsumer;", "hashingStrategy", "Lcom/intellij/util/containers/hash/EqualityPolicy;", "cacheSize", "", "(Ljava/util/function/Function;Ljava/util/function/BiConsumer;Lcom/intellij/util/containers/hash/EqualityPolicy;I)V", "cache", "com/intellij/util/indexing/impl/MapIndexStorageSlruCache$cache$1", "Lcom/intellij/util/indexing/impl/MapIndexStorageSlruCache$cache$1;", "cacheAccessLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getEvictionListener", "()Ljava/util/function/BiConsumer;", "getValueReader", "()Ljava/util/function/Function;", "invalidateAll", "", "processCachedValues", "processor", "Ljava/util/function/Consumer;", "read", "key", "(Ljava/lang/Object;)Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "readIfCached", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nMapIndexStorageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapIndexStorageCache.kt\ncom/intellij/util/indexing/impl/MapIndexStorageSlruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
final class MapIndexStorageSlruCache<Key, Value>
implements MapIndexStorageCache<Key, Value> {
    @NotNull
    private final Function<Key, ChangeTrackingValueContainer<Value>> valueReader;
    @NotNull
    private final BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictionListener;
    @NotNull
    private final cache.1 cache;
    @NotNull
    private final ReentrantLock cacheAccessLock;

    public MapIndexStorageSlruCache(@NotNull Function<Key, ChangeTrackingValueContainer<Value>> valueReader, @NotNull BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictionListener, @NotNull EqualityPolicy<Key> hashingStrategy, int cacheSize) {
        Intrinsics.checkNotNullParameter(valueReader, (String)"valueReader");
        Intrinsics.checkNotNullParameter(evictionListener, (String)"evictionListener");
        Intrinsics.checkNotNullParameter(hashingStrategy, (String)"hashingStrategy");
        this.valueReader = valueReader;
        this.evictionListener = evictionListener;
        int n = (int)Math.ceil((double)cacheSize * 0.25);
        this.cache = new SLRUCache<Key, ChangeTrackingValueContainer<Value>>(cacheSize, hashingStrategy, this, n){
            final /* synthetic */ MapIndexStorageSlruCache<Key, Value> this$0;
            {
                this.this$0 = $receiver;
                super($cacheSize, $super_call_param$1, $hashingStrategy);
            }

            @NotNull
            public ChangeTrackingValueContainer<Value> createValue(Key key) {
                ChangeTrackingValueContainer<Value> changeTrackingValueContainer = this.this$0.getValueReader().apply(key);
                Intrinsics.checkNotNullExpressionValue(changeTrackingValueContainer, (String)"valueReader.apply(key)");
                return changeTrackingValueContainer;
            }

            protected void onDropFromCache(Key key, @NotNull ChangeTrackingValueContainer<Value> valueContainer) {
                Intrinsics.checkNotNullParameter(valueContainer, (String)"valueContainer");
                boolean bl = MapIndexStorageSlruCache.access$getCacheAccessLock$p(this.this$0).isHeldByCurrentThread();
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                this.this$0.getEvictionListener().accept(key, valueContainer);
            }
        };
        this.cacheAccessLock = new ReentrantLock();
    }

    @NotNull
    public final Function<Key, ChangeTrackingValueContainer<Value>> getValueReader() {
        return this.valueReader;
    }

    @NotNull
    public final BiConsumer<Key, ChangeTrackingValueContainer<Value>> getEvictionListener() {
        return this.evictionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ChangeTrackingValueContainer<Value> read(Key key) {
        ChangeTrackingValueContainer changeTrackingValueContainer;
        Lock lock = this.cacheAccessLock;
        lock.lock();
        try {
            boolean bl = false;
            ChangeTrackingValueContainer changeTrackingValueContainer2 = (ChangeTrackingValueContainer)this.cache.get(key);
            changeTrackingValueContainer = changeTrackingValueContainer2;
        }
        finally {
            lock.unlock();
        }
        Intrinsics.checkNotNullExpressionValue((Object)changeTrackingValueContainer, (String)"cacheAccessLock.withLock { cache.get(key) }");
        return changeTrackingValueContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ChangeTrackingValueContainer<Value> readIfCached(Key key) {
        ChangeTrackingValueContainer changeTrackingValueContainer;
        Lock lock = this.cacheAccessLock;
        lock.lock();
        try {
            boolean bl = false;
            changeTrackingValueContainer = (ChangeTrackingValueContainer)this.cache.getIfCached(key);
        }
        finally {
            lock.unlock();
        }
        return changeTrackingValueContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processCachedValues(@NotNull Consumer<ChangeTrackingValueContainer<Value>> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Lock lock = this.cacheAccessLock;
        lock.lock();
        try {
            boolean bl = false;
            for (Map.Entry entry : this.cache.entrySet()) {
                ChangeTrackingValueContainer valueContainer;
                Intrinsics.checkNotNullExpressionValue(entry, (String)"cache.entrySet()");
                ChangeTrackingValueContainer changeTrackingValueContainer = valueContainer = (ChangeTrackingValueContainer)entry.getValue();
                Intrinsics.checkNotNull((Object)changeTrackingValueContainer);
                processor.accept(changeTrackingValueContainer);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAll() {
        while (!this.cacheAccessLock.tryLock(10L, TimeUnit.MILLISECONDS)) {
            IOCancellationCallbackHolder.checkCancelled();
        }
        try {
            this.cache.clear();
        }
        finally {
            this.cacheAccessLock.unlock();
        }
    }

    public static final /* synthetic */ ReentrantLock access$getCacheAccessLock$p(MapIndexStorageSlruCache $this) {
        return $this.cacheAccessLock;
    }
}

