/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.containers.ChangeBufferingList;
import com.intellij.util.indexing.containers.IntIdsIterator;
import com.intellij.util.indexing.impl.FileId2ValueMapping;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.InvertedIndexValueIterator;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.indexing.impl.ValueContainerInputRemapping;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ValueContainerImpl<Value>
extends UpdatableValueContainer<Value>
implements Cloneable {
    static final Logger LOG = Logger.getInstance(ValueContainerImpl.class);
    private static final boolean DO_EXPENSIVE_CHECKS = (IndexDebugProperties.IS_UNIT_TEST_MODE || IndexDebugProperties.EXTRA_SANITY_CHECKS) && !IndexDebugProperties.IS_IN_STRESS_TESTS;
    private Object myInputIdMapping;
    private Object myInputIdMappingValue;
    private Int2ObjectMap<Object> myPresentInputIds;
    private List<UpdateOp> myUpdateOps;
    public static final IntIdsIterator EMPTY_ITERATOR = new IntIdsIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int next() {
            return 0;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean hasAscendingOrder() {
            return true;
        }

        @Override
        public IntIdsIterator createCopyInInitialState() {
            return this;
        }
    };
    static final int NUMBER_OF_VALUES_THRESHOLD = 20;

    public ValueContainerImpl() {
        this(DO_EXPENSIVE_CHECKS);
    }

    public ValueContainerImpl(boolean doExpensiveChecks) {
        this.myPresentInputIds = doExpensiveChecks ? new Int2ObjectOpenHashMap() : null;
        this.myUpdateOps = doExpensiveChecks ? new SmartList() : null;
    }

    @Override
    public void addValue(int inputId, Value value) {
        Object fileSetObject = this.getFileSetObject(value);
        this.ensureInputIdIsntAssociatedWithAnotherValue(inputId, value, false);
        if (fileSetObject == null) {
            this.attachFileSetForNewValue(value, inputId);
        } else if (fileSetObject instanceof Integer) {
            int existingValue = (Integer)fileSetObject;
            if (existingValue != inputId) {
                ChangeBufferingList list2 = new ChangeBufferingList();
                list2.add(existingValue);
                list2.add(inputId);
                this.resetFileSetForValue(value, list2);
            }
        } else {
            ((ChangeBufferingList)fileSetObject).add(inputId);
        }
    }

    private void ensureInputIdIsntAssociatedWithAnotherValue(int inputId, Value value, boolean isDirect) {
        if (this.myPresentInputIds != null) {
            Value normalizedValue = ValueContainerImpl.wrapValue(value);
            Value previousValue = this.myPresentInputIds.put(inputId, (Object)normalizedValue);
            this.myUpdateOps.add(new UpdateOp(isDirect ? UpdateOp.Type.ADD_DIRECT : UpdateOp.Type.ADD, inputId, normalizedValue));
            if (previousValue != null && !previousValue.equals(normalizedValue)) {
                LOG.error("Can't add value '" + normalizedValue + "'; input id " + inputId + " is already present in:\n" + this.getDebugMessage());
            }
        }
    }

    private void ensureInputIdAssociatedWithValue(int inputId, Value value) {
        if (this.myPresentInputIds != null) {
            Value normalizedValue = ValueContainerImpl.wrapValue(value);
            Object previousValue = this.myPresentInputIds.remove(inputId);
            this.myUpdateOps.add(new UpdateOp(UpdateOp.Type.REMOVE, inputId, normalizedValue));
            if (previousValue != null && !previousValue.equals(normalizedValue)) {
                LOG.error("Can't remove value '" + normalizedValue + "'; input id " + inputId + " is not present for the specified value in:\n" + this.getDebugMessage());
            }
        }
    }

    @Nullable
    private ValueToInputMap<Value> asMapping() {
        return this.myInputIdMapping instanceof ValueToInputMap ? (ValueToInputMap)this.myInputIdMapping : null;
    }

    private Value asValue() {
        return (Value)this.myInputIdMapping;
    }

    private void resetFileSetForValue(Value value, @NotNull Object fileSet) {
        if (fileSet == null) {
            ValueContainerImpl.$$$reportNull$$$0(0);
        }
        value = ValueContainerImpl.wrapValue(value);
        ValueToInputMap<Value> map2 = this.asMapping();
        if (map2 == null) {
            this.myInputIdMappingValue = fileSet;
        } else {
            map2.put(value, fileSet);
        }
    }

    @Override
    public int size() {
        return this.myInputIdMapping != null ? (this.myInputIdMapping instanceof ValueToInputMap ? ((ValueToInputMap)this.myInputIdMapping).size() : 1) : 0;
    }

    @Override
    public boolean removeAssociatedValue(int inputId) {
        ValueContainer.ValueIterator valueIterator = this.getValueIterator();
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            if (!valueIterator.getValueAssociationPredicate().test(inputId)) continue;
            this.removeValue(inputId, valueIterator.getFileSetObject(), value);
            return true;
        }
        return false;
    }

    @NotNull
    String getDebugMessage() {
        String string2 = "Actual value container = \n" + this + (this.myPresentInputIds == null ? "" : "\nExpected value container = " + this.myPresentInputIds) + (this.myUpdateOps == null ? "" : "\nUpdate operations = " + this.myUpdateOps);
        if (string2 == null) {
            ValueContainerImpl.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.forEach((id, value) -> {
            sb.append(id).append(" <-> '").append(value).append("'\n");
            return true;
        });
        return sb.toString();
    }

    void removeValue(int inputId, Value value) {
        this.removeValue(inputId, this.getFileSetObject(value), value);
    }

    private void removeValue(int inputId, Object fileSet, Value value) {
        this.ensureInputIdAssociatedWithValue(inputId, value);
        if (fileSet == null) {
            return;
        }
        if (fileSet instanceof ChangeBufferingList) {
            ChangeBufferingList changesList = (ChangeBufferingList)fileSet;
            changesList.remove(inputId);
            if (!changesList.isEmpty()) {
                return;
            }
        } else if (fileSet instanceof Integer && (Integer)fileSet != inputId) {
            return;
        }
        value = ValueContainerImpl.wrapValue(value);
        ValueToInputMap<Value> mapping = this.asMapping();
        if (mapping == null) {
            this.myInputIdMapping = null;
            this.myInputIdMappingValue = null;
        } else {
            mapping.remove(value);
            if (mapping.size() == 1) {
                Map.Entry entry = mapping.entrySet().iterator().next();
                this.myInputIdMapping = entry.getKey();
                this.myInputIdMappingValue = entry.getValue();
            }
        }
    }

    @NotNull
    static <Value> Value wrapValue(Value value) {
        Object object = value == null ? ObjectUtils.NULL : value;
        if (object == null) {
            ValueContainerImpl.$$$reportNull$$$0(2);
        }
        return (Value)object;
    }

    static <Value> Value unwrap(Value value) {
        return value == ObjectUtils.NULL ? null : (Value)value;
    }

    @Override
    @NotNull
    public InvertedIndexValueIterator<Value> getValueIterator() {
        if (this.myInputIdMapping == null) {
            EmptyValueIterator emptyValueIterator = EmptyValueIterator.INSTANCE;
            if (emptyValueIterator == null) {
                ValueContainerImpl.$$$reportNull$$$0(3);
            }
            return emptyValueIterator;
        }
        final Map<Value, Object> mapping = ObjectUtils.notNull(this.asMapping(), Collections.singletonMap(ValueContainerImpl.wrapValue(this.asValue()), this.myInputIdMappingValue));
        return new InvertedIndexValueIterator<Value>(){
            private Value current;
            private Object currentValue;
            private final Iterator<Map.Entry<Value, Object>> iterator;
            {
                this.iterator = mapping.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Value next() {
                Map.Entry entry = this.iterator.next();
                Object next2 = this.current = entry.getKey();
                this.currentValue = entry.getValue();
                return ValueContainerImpl.unwrap(next2);
            }

            @Override
            @NotNull
            public ValueContainer.IntIterator getInputIdsIterator() {
                ValueContainer.IntIterator intIterator = ValueContainerImpl.getIntIteratorOutOfFileSetObject(this.getFileSetObject());
                if (intIterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return intIterator;
            }

            @Override
            @NotNull
            public IntPredicate getValueAssociationPredicate() {
                IntPredicate intPredicate = ValueContainerImpl.getPredicateOutOfFileSetObject(this.getFileSetObject());
                if (intPredicate == null) {
                    1.$$$reportNull$$$0(1);
                }
                return intPredicate;
            }

            @Override
            public Object getFileSetObject() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                return this.currentValue;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/indexing/impl/ValueContainerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInputIdsIterator";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueAssociationPredicate";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    private static IntPredicate getPredicateOutOfFileSetObject(@Nullable Object input) {
        if (input == null) {
            IntPredicate intPredicate = __ -> false;
            if (intPredicate == null) {
                ValueContainerImpl.$$$reportNull$$$0(4);
            }
            return intPredicate;
        }
        if (input instanceof Integer) {
            int singleId = (Integer)input;
            IntPredicate intPredicate = id -> id == singleId;
            if (intPredicate == null) {
                ValueContainerImpl.$$$reportNull$$$0(5);
            }
            return intPredicate;
        }
        IntPredicate intPredicate = ((ChangeBufferingList)input).intPredicate();
        if (intPredicate == null) {
            ValueContainerImpl.$$$reportNull$$$0(6);
        }
        return intPredicate;
    }

    @NotNull
    private static ValueContainer.IntIterator getIntIteratorOutOfFileSetObject(@Nullable Object input) {
        if (input == null) {
            IntIdsIterator intIdsIterator = EMPTY_ITERATOR;
            if (intIdsIterator == null) {
                ValueContainerImpl.$$$reportNull$$$0(7);
            }
            return intIdsIterator;
        }
        if (input instanceof Integer) {
            return new SingleValueIterator((Integer)input);
        }
        IntIdsIterator intIdsIterator = ((ChangeBufferingList)input).intIterator();
        if (intIdsIterator == null) {
            ValueContainerImpl.$$$reportNull$$$0(8);
        }
        return intIdsIterator;
    }

    private Object getFileSetObject(Value value) {
        if (this.myInputIdMapping == null) {
            return null;
        }
        if (this.myInputIdMapping == (value = ValueContainerImpl.wrapValue(value)) || this.myInputIdMapping.equals(value)) {
            return this.myInputIdMappingValue;
        }
        ValueToInputMap<Value> mapping = this.asMapping();
        return mapping == null ? null : mapping.get(value);
    }

    public ValueContainerImpl<Value> clone() {
        try {
            ValueContainerImpl clone = (ValueContainerImpl)super.clone();
            ValueToInputMap<Value> mapping = this.asMapping();
            if (mapping != null) {
                Object2ObjectOpenHashMap cloned = mapping.clone();
                cloned.forEach((arg_0, arg_1) -> ValueContainerImpl.lambda$clone$3((ValueToInputMap)cloned, arg_0, arg_1));
                clone.myInputIdMapping = cloned;
            } else if (this.myInputIdMappingValue instanceof ChangeBufferingList) {
                clone.myInputIdMappingValue = ((ChangeBufferingList)this.myInputIdMappingValue).clone();
            }
            clone.myPresentInputIds = this.myPresentInputIds != null ? new Int2ObjectOpenHashMap<Object>(this.myPresentInputIds) : null;
            clone.myUpdateOps = this.myUpdateOps != null ? new SmartList<UpdateOp>((Collection<UpdateOp>)this.myUpdateOps) : null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private ChangeBufferingList ensureFileSetCapacityForValue(Value value, int count2) {
        if (count2 <= 1) {
            return null;
        }
        Object fileSetObject = this.getFileSetObject(value);
        if (fileSetObject != null) {
            if (fileSetObject instanceof Integer) {
                ChangeBufferingList list2 = new ChangeBufferingList(count2 + 1);
                list2.add((Integer)fileSetObject);
                this.resetFileSetForValue(value, list2);
                return list2;
            }
            if (fileSetObject instanceof ChangeBufferingList) {
                ChangeBufferingList list3 = (ChangeBufferingList)fileSetObject;
                list3.ensureCapacity(count2);
                return list3;
            }
            return null;
        }
        ChangeBufferingList fileSet = new ChangeBufferingList(count2);
        this.attachFileSetForNewValue(value, fileSet);
        return fileSet;
    }

    private void attachFileSetForNewValue(Value value, Object fileSet) {
        value = ValueContainerImpl.wrapValue(value);
        if (this.myInputIdMapping != null) {
            ValueToInputMap<Value> mapping = this.asMapping();
            if (mapping == null) {
                Value oldMapping = this.asValue();
                mapping = new ValueToInputMap(2);
                this.myInputIdMapping = mapping;
                mapping.put(oldMapping, this.myInputIdMappingValue);
                this.myInputIdMappingValue = null;
            }
            mapping.put(value, fileSet);
        } else {
            this.myInputIdMapping = value;
            this.myInputIdMappingValue = fileSet;
        }
    }

    @Override
    public void saveTo(@NotNull DataOutput out, @NotNull DataExternalizer<? super Value> externalizer) throws IOException {
        if (out == null) {
            ValueContainerImpl.$$$reportNull$$$0(9);
        }
        if (externalizer == null) {
            ValueContainerImpl.$$$reportNull$$$0(10);
        }
        DataInputOutputUtil.writeINT(out, this.size());
        ValueContainer.ValueIterator valueIterator = this.getValueIterator();
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            externalizer.save(out, value);
            Object fileSetObject = valueIterator.getFileSetObject();
            ValueContainerImpl.storeFileSet(out, fileSetObject);
        }
    }

    public static void storeFileSet(@NotNull DataOutput out, @NotNull Object fileSetObject) throws IOException {
        if (out == null) {
            ValueContainerImpl.$$$reportNull$$$0(11);
        }
        if (fileSetObject == null) {
            ValueContainerImpl.$$$reportNull$$$0(12);
        }
        if (fileSetObject instanceof Integer) {
            int singleFileId = (Integer)fileSetObject;
            ValueContainerImpl.checkFileIdSanity(singleFileId);
            DataInputOutputUtil.writeINT(out, singleFileId);
        } else {
            ChangeBufferingList originalInput = (ChangeBufferingList)fileSetObject;
            IntIdsIterator intIterator = originalInput.sortedIntIterator();
            if (IndexDebugProperties.DEBUG) {
                LOG.assertTrue(intIterator.hasAscendingOrder());
            }
            if (intIterator.size() == 1) {
                int singleFileId = intIterator.next();
                ValueContainerImpl.checkFileIdSanity(singleFileId);
                DataInputOutputUtil.writeINT(out, singleFileId);
            } else {
                DataInputOutputUtil.writeINT(out, -intIterator.size());
                int prev = 0;
                while (intIterator.hasNext()) {
                    int fileId = intIterator.next();
                    DataInputOutputUtil.writeINT(out, fileId - prev);
                    prev = fileId;
                }
            }
        }
    }

    public void readFrom(@NotNull DataInputStream stream, @NotNull DataExternalizer<? extends Value> externalizer, @NotNull ValueContainerInputRemapping remapping) throws IOException {
        if (stream == null) {
            ValueContainerImpl.$$$reportNull$$$0(13);
        }
        if (externalizer == null) {
            ValueContainerImpl.$$$reportNull$$$0(14);
        }
        if (remapping == null) {
            ValueContainerImpl.$$$reportNull$$$0(15);
        }
        FileId2ValueMapping mapping = null;
        while (stream.available() > 0) {
            int valueCount = DataInputOutputUtil.readINT(stream);
            if (valueCount < 0) {
                @NotNull Object inputIds = remapping.remap(-valueCount);
                if (mapping == null && this.size() > 20) {
                    mapping = new FileId2ValueMapping(this);
                }
                boolean doCompact = false;
                if (inputIds instanceof int[]) {
                    for (int inputId : (int[])inputIds) {
                        doCompact = this.removeValue(mapping, inputId);
                    }
                } else {
                    int inputId = (Integer)inputIds;
                    doCompact = this.removeValue(mapping, inputId);
                }
                if (!doCompact) continue;
                this.setNeedsCompacting(true);
                continue;
            }
            for (int valueIdx = 0; valueIdx < valueCount; ++valueIdx) {
                Value value = externalizer.read(stream);
                int idCountOrSingleValue = DataInputOutputUtil.readINT(stream);
                if (idCountOrSingleValue > 0) {
                    @NotNull Object inputIds = remapping.remap(idCountOrSingleValue);
                    if (inputIds instanceof int[]) {
                        int inputId;
                        int[] nArray = (int[])inputIds;
                        inputId = nArray.length;
                        for (int j = 0; j < inputId; ++j) {
                            int inputId2 = nArray[j];
                            this.associateValue(mapping, value, inputId2);
                        }
                        continue;
                    }
                    int inputId = (Integer)inputIds;
                    this.associateValue(mapping, value, inputId);
                    continue;
                }
                idCountOrSingleValue = -idCountOrSingleValue;
                ChangeBufferingList changeBufferingList = this.ensureFileSetCapacityForValue(value, idCountOrSingleValue);
                int prev = 0;
                for (int i2 = 0; i2 < idCountOrSingleValue; ++i2) {
                    int id = DataInputOutputUtil.readINT(stream);
                    @NotNull Object inputIds = remapping.remap(prev + id);
                    if (inputIds instanceof int[]) {
                        for (int inputId : (int[])inputIds) {
                            this.associateValueOptimizely(mapping, value, changeBufferingList, inputId);
                        }
                    } else {
                        int inputId = (Integer)inputIds;
                        this.associateValueOptimizely(mapping, value, changeBufferingList, inputId);
                    }
                    prev += id;
                }
            }
        }
    }

    private boolean removeValue(FileId2ValueMapping<Value> mapping, int inputId) {
        if (mapping != null) {
            return mapping.removeFileId(inputId);
        }
        this.removeAssociatedValue(inputId);
        return true;
    }

    private void associateValue(FileId2ValueMapping<Value> mapping, Value value, int inputId) {
        if (mapping != null) {
            mapping.associateFileIdToValue(inputId, value);
        } else {
            this.addValue(inputId, value);
        }
    }

    private void associateValueOptimizely(FileId2ValueMapping<Value> mapping, Value value, ChangeBufferingList changeBufferingList, int inputId) {
        if (changeBufferingList != null) {
            this.ensureInputIdIsntAssociatedWithAnotherValue(inputId, value, true);
            changeBufferingList.add(inputId);
            if (mapping != null) {
                mapping.associateFileIdToValueSkippingContainer(inputId, value);
            }
        } else if (mapping != null) {
            mapping.associateFileIdToValue(inputId, value);
        } else {
            this.addValue(inputId, value);
        }
    }

    private static void checkFileIdSanity(int singleFileId) {
        if (singleFileId <= 0) {
            throw new IllegalStateException("fileId(=" + singleFileId + ") must be >0");
        }
    }

    private static /* synthetic */ void lambda$clone$3(ValueToInputMap cloned, Object key, Object val) {
        if (val instanceof ChangeBufferingList) {
            cloned.put(key, ((ChangeBufferingList)val).clone());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/ValueContainerImpl";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSetObject";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/ValueContainerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueIterator";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredicateOutOfFileSetObject";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntIteratorOutOfFileSetObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetFileSetForValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveTo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "storeFileSet";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readFrom";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UpdateOp {
        private final Type myType;
        private final int myInputId;
        private final Object myValue;

        private UpdateOp(Type type, int id, Object value) {
            this.myType = type;
            this.myInputId = id;
            this.myValue = value;
        }

        public String toString() {
            return "(" + (Object)((Object)this.myType) + ", " + this.myInputId + ", " + this.myValue + ")";
        }

        private static enum Type {
            ADD,
            ADD_DIRECT,
            REMOVE;

        }
    }

    private static final class ValueToInputMap<Value>
    extends Object2ObjectOpenHashMap<Value, Object> {
        ValueToInputMap(int size) {
            super(size);
        }

        @Override
        public ValueToInputMap<Value> clone() {
            return (ValueToInputMap)super.clone();
        }
    }

    private static class EmptyValueIterator<Value>
    implements InvertedIndexValueIterator<Value> {
        private static final EmptyValueIterator<Object> INSTANCE = new EmptyValueIterator();

        private EmptyValueIterator() {
        }

        @Override
        @NotNull
        public ValueContainer.IntIterator getInputIdsIterator() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public IntPredicate getValueAssociationPredicate() {
            throw new IllegalStateException();
        }

        @Override
        public Object getFileSetObject() {
            throw new IllegalStateException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Value next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static final class SingleValueIterator
    implements IntIdsIterator {
        private final int myValue;
        private boolean myValueRead;

        private SingleValueIterator(int value) {
            this.myValue = value;
        }

        @Override
        public boolean hasNext() {
            return !this.myValueRead;
        }

        @Override
        public int next() {
            this.myValueRead = true;
            return this.myValue;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean hasAscendingOrder() {
            return true;
        }

        @Override
        public IntIdsIterator createCopyInInitialState() {
            return new SingleValueIterator(this.myValue);
        }
    }
}

