/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.InputMapExternalizer;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.EmptyForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.IntMapForwardIndex;
import com.intellij.util.indexing.impl.forward.MapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.indexing.impl.forward.SingleEntryIndexForwardIndexAccessor;
import com.intellij.util.indexing.impl.storage.FileBasedIndexLayoutSettings;
import com.intellij.util.indexing.impl.storage.InMemoryStorageLayout;
import com.intellij.util.indexing.impl.storage.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.snapshot.HashIdForwardIndexAccessor;
import com.intellij.util.indexing.snapshot.SnapshotInputMappings;
import com.intellij.util.indexing.storage.FileBasedIndexLayoutProvider;
import com.intellij.util.indexing.storage.FileBasedIndexLayoutProviderBean;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003+,-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00190\u0017\"\u0004\b\u0000\u0010\u0018\"\u0004\b\u0001\u0010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00190\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001bH\u0002J<\u0010 \u001a\u0012\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H#\u0012\u0002\b\u00030!\"\u0004\b\u0000\u0010\"\"\u0004\b\u0001\u0010#2\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H#\u0012\u0002\b\u00030%H\u0003J<\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H#0'\"\u0004\b\u0000\u0010\"\"\u0004\b\u0001\u0010#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H#0\u001b2\u0006\u0010(\u001a\u00020)H\u0007J\b\u0010*\u001a\u00020\u001dH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0002\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006."}, d2={"Lcom/intellij/util/indexing/impl/storage/DefaultIndexStorageLayout;", "", "()V", "availableLayouts", "", "Lcom/intellij/util/indexing/storage/FileBasedIndexLayoutProviderBean;", "getAvailableLayouts", "()Ljava/util/List;", "forcedLayout", "", "forcedLayoutEP", "getForcedLayoutEP", "()Lcom/intellij/util/indexing/storage/FileBasedIndexLayoutProviderBean;", "indexLayout", "getIndexLayout", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "usedLayoutId", "getUsedLayoutId$annotations", "getUsedLayoutId", "()Ljava/lang/String;", "createIndexStorage", "Lcom/intellij/util/indexing/VfsAwareIndexStorage;", "K", "V", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "storageLockContext", "Lcom/intellij/util/io/StorageLockContext;", "deleteIndexDirectory", "", "getForwardIndexAccessor", "Lcom/intellij/util/indexing/impl/forward/AbstractMapForwardIndexAccessor;", "Key", "Value", "indexExtension", "Lcom/intellij/util/indexing/IndexExtension;", "getLayout", "Lcom/intellij/util/indexing/storage/VfsAwareIndexStorageLayout;", "contentHashEnumeratorReopen", "", "newStorageLockContext", "DefaultStorageLayout", "SingleEntryStorageLayout", "SnapshotMappingsStorageLayout", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nDefaultIndexStorageLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultIndexStorageLayout.kt\ncom/intellij/util/indexing/impl/storage/DefaultIndexStorageLayout\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,192:1\n766#2:193\n857#2,2:194\n1#3:196\n10#4:197\n*S KotlinDebug\n*F\n+ 1 DefaultIndexStorageLayout.kt\ncom/intellij/util/indexing/impl/storage/DefaultIndexStorageLayout\n*L\n48#1:193\n48#1:194,2\n19#1:197\n*E\n"})
public final class DefaultIndexStorageLayout {
    @NotNull
    public static final DefaultIndexStorageLayout INSTANCE = new DefaultIndexStorageLayout();
    @NotNull
    private static final Logger log;
    @Nullable
    private static final String forcedLayout;

    private DefaultIndexStorageLayout() {
    }

    @JvmStatic
    @NotNull
    public static final <Key, Value> VfsAwareIndexStorageLayout<Key, Value> getLayout(@NotNull FileBasedIndexExtension<Key, Value> indexExtension, boolean contentHashEnumeratorReopen) throws IOException {
        Intrinsics.checkNotNullParameter(indexExtension, (String)"indexExtension");
        FileBasedIndexLayoutProviderBean layoutEP = INSTANCE.getIndexLayout();
        if (layoutEP != null) {
            log.info("Layout '" + layoutEP.id + "' will be used to for '" + indexExtension.getName() + "' index");
            VfsAwareIndexStorageLayout vfsAwareIndexStorageLayout = layoutEP.getLayoutProvider().getLayout(indexExtension);
            Intrinsics.checkNotNullExpressionValue((Object)vfsAwareIndexStorageLayout, (String)"layoutEP.layoutProvider.getLayout(indexExtension)");
            return vfsAwareIndexStorageLayout;
        }
        if (FileBasedIndex.USE_IN_MEMORY_INDEX) {
            return new InMemoryStorageLayout<Key, Value>(indexExtension);
        }
        if (indexExtension instanceof SingleEntryFileBasedIndexExtension) {
            return new SingleEntryStorageLayout<Key, Value>(indexExtension);
        }
        return VfsAwareMapReduceIndex.hasSnapshotMapping((IndexExtension)indexExtension) ? (VfsAwareIndexStorageLayout)new SnapshotMappingsStorageLayout<Key, Value>(indexExtension, contentHashEnumeratorReopen) : (VfsAwareIndexStorageLayout)new DefaultStorageLayout<Key, Value>(indexExtension);
    }

    @Nullable
    public static final String getUsedLayoutId() {
        FileBasedIndexLayoutProviderBean fileBasedIndexLayoutProviderBean = INSTANCE.getIndexLayout();
        return fileBasedIndexLayoutProviderBean != null ? fileBasedIndexLayoutProviderBean.id : null;
    }

    @JvmStatic
    public static /* synthetic */ void getUsedLayoutId$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FileBasedIndexLayoutProviderBean> getAvailableLayouts() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = FileBasedIndexLayoutProvider.STORAGE_LAYOUT_EP_NAME.getExtensionList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileBasedIndexLayoutProviderBean it = (FileBasedIndexLayoutProviderBean)element$iv$iv;
            boolean bl = false;
            if (!it.getLayoutProvider().isSupported()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final FileBasedIndexLayoutProviderBean getIndexLayout() {
        FileBasedIndexLayoutProviderBean fileBasedIndexLayoutProviderBean = this.getForcedLayoutEP();
        if (fileBasedIndexLayoutProviderBean == null) {
            fileBasedIndexLayoutProviderBean = FileBasedIndexLayoutSettings.INSTANCE.getUsedLayout();
        }
        return fileBasedIndexLayoutProviderBean;
    }

    private final FileBasedIndexLayoutProviderBean getForcedLayoutEP() {
        Object v1;
        String layout;
        block3: {
            String string2 = forcedLayout;
            if (string2 == null) {
                return null;
            }
            layout = string2;
            Iterable iterable = this.getAvailableLayouts();
            for (Object t : iterable) {
                FileBasedIndexLayoutProviderBean it = (FileBasedIndexLayoutProviderBean)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.id, (Object)layout)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        FileBasedIndexLayoutProviderBean fileBasedIndexLayoutProviderBean = v1;
        if (fileBasedIndexLayoutProviderBean == null) {
            throw new IllegalStateException("Can't find index storage layout for id = " + layout);
        }
        return fileBasedIndexLayoutProviderBean;
    }

    @ApiStatus.Internal
    private final <Key, Value> AbstractMapForwardIndexAccessor<Key, Value, ?> getForwardIndexAccessor(IndexExtension<Key, Value, ?> indexExtension) {
        return !(indexExtension instanceof SingleEntryFileBasedIndexExtension) || FileBasedIndex.USE_IN_MEMORY_INDEX ? (AbstractMapForwardIndexAccessor)new MapForwardIndexAccessor((DataExternalizer)new InputMapExternalizer(indexExtension)) : (AbstractMapForwardIndexAccessor)new SingleEntryIndexForwardIndexAccessor(indexExtension);
    }

    @NotNull
    public final <K, V> VfsAwareIndexStorage<K, V> createIndexStorage(@NotNull FileBasedIndexExtension<K, V> extension2, @NotNull StorageLockContext storageLockContext) throws IOException {
        Intrinsics.checkNotNullParameter(extension2, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)storageLockContext, (String)"storageLockContext");
        Path path2 = IndexInfrastructure.getStorageFile((ID)extension2.getName());
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getStorageFile(extension.name)");
        Path storageFile = path2;
        KeyDescriptor keyDescriptor = extension2.getKeyDescriptor();
        DataExternalizer dataExternalizer = extension2.getValueExternalizer();
        int n = extension2.getCacheSize();
        boolean bl = extension2.keyIsUniqueForIndexedFile();
        boolean bl2 = extension2.traceKeyHashToVirtualFileMapping();
        boolean bl3 = extension2.enableWal();
        return new VfsAwareMapIndexStorage<K, V>(storageFile, storageLockContext, keyDescriptor, dataExternalizer, n, bl, bl2, bl3){
            final /* synthetic */ StorageLockContext $storageLockContext;
            {
                this.$storageLockContext = $storageLockContext;
                super($storageFile, $super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void initMapAndCache() {
                boolean bl;
                boolean bl2 = bl = PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.get() == null;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.set(this.$storageLockContext);
                try {
                    super.initMapAndCache();
                }
                finally {
                    PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.remove();
                }
            }
        };
    }

    private final void deleteIndexDirectory(FileBasedIndexExtension<?, ?> extension2) {
        FileUtil.deleteWithRenaming(IndexInfrastructure.getIndexRootDir((ID)extension2.getName()).toFile());
    }

    private final StorageLockContext newStorageLockContext() {
        return new StorageLockContext(false, true);
    }

    public static final /* synthetic */ AbstractMapForwardIndexAccessor access$getForwardIndexAccessor(DefaultIndexStorageLayout $this, IndexExtension indexExtension) {
        return $this.getForwardIndexAccessor(indexExtension);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DefaultIndexStorageLayout.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        log = logger;
        forcedLayout = System.getProperty("idea.index.storage.forced.layout");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u001b\b\u0000\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/indexing/impl/storage/DefaultIndexStorageLayout$SingleEntryStorageLayout;", "K", "V", "Lcom/intellij/util/indexing/storage/VfsAwareIndexStorageLayout;", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "(Lcom/intellij/util/indexing/FileBasedIndexExtension;)V", "storageLockContext", "Lcom/intellij/util/io/StorageLockContext;", "clearIndexData", "", "getForwardIndexAccessor", "Lcom/intellij/util/indexing/impl/forward/ForwardIndexAccessor;", "openForwardIndex", "Lcom/intellij/util/indexing/impl/forward/ForwardIndex;", "openIndexStorage", "Lcom/intellij/util/indexing/impl/IndexStorage;", "intellij.platform.lang.impl"})
    public static final class SingleEntryStorageLayout<K, V>
    implements VfsAwareIndexStorageLayout<K, V> {
        @NotNull
        private final FileBasedIndexExtension<K, V> extension;
        @NotNull
        private final StorageLockContext storageLockContext;

        public SingleEntryStorageLayout(@NotNull FileBasedIndexExtension<K, V> extension2) {
            Intrinsics.checkNotNullParameter(extension2, (String)"extension");
            this.extension = extension2;
            this.storageLockContext = INSTANCE.newStorageLockContext();
        }

        @NotNull
        public IndexStorage<K, V> openIndexStorage() throws IOException {
            return (IndexStorage)INSTANCE.createIndexStorage(this.extension, this.storageLockContext);
        }

        @NotNull
        public ForwardIndex openForwardIndex() {
            return new EmptyForwardIndex();
        }

        @NotNull
        public ForwardIndexAccessor<K, V> getForwardIndexAccessor() {
            FileBasedIndexExtension<K, V> fileBasedIndexExtension = this.extension;
            Intrinsics.checkNotNull(fileBasedIndexExtension, (String)"null cannot be cast to non-null type com.intellij.util.indexing.IndexExtension<kotlin.Int, V of com.intellij.util.indexing.impl.storage.DefaultIndexStorageLayout.SingleEntryStorageLayout, *>");
            return (ForwardIndexAccessor)new SingleEntryIndexForwardIndexAccessor((IndexExtension)fileBasedIndexExtension);
        }

        public void clearIndexData() {
            INSTANCE.deleteIndexDirectory(this.extension);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B#\b\u0000\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nH\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001aH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/util/indexing/impl/storage/DefaultIndexStorageLayout$SnapshotMappingsStorageLayout;", "K", "V", "Lcom/intellij/util/indexing/storage/VfsAwareIndexStorageLayout;", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "contentHashEnumeratorReopen", "", "(Lcom/intellij/util/indexing/FileBasedIndexExtension;Z)V", "mySnapshotInputMappings", "Lcom/intellij/util/indexing/snapshot/SnapshotInputMappings;", "getMySnapshotInputMappings", "()Lcom/intellij/util/indexing/snapshot/SnapshotInputMappings;", "mySnapshotInputMappings$delegate", "Lkotlin/Lazy;", "storageLockContext", "Lcom/intellij/util/io/StorageLockContext;", "clearIndexData", "", "createOrClearSnapshotInputMappings", "deleteIndexData", "getForwardIndexAccessor", "Lcom/intellij/util/indexing/impl/forward/ForwardIndexAccessor;", "openForwardIndex", "Lcom/intellij/util/indexing/impl/forward/ForwardIndex;", "openIndexStorage", "Lcom/intellij/util/indexing/impl/IndexStorage;", "intellij.platform.lang.impl"})
    public static final class SnapshotMappingsStorageLayout<K, V>
    implements VfsAwareIndexStorageLayout<K, V> {
        @NotNull
        private final FileBasedIndexExtension<K, V> extension;
        @NotNull
        private final StorageLockContext storageLockContext;
        @NotNull
        private final Lazy mySnapshotInputMappings$delegate;

        public SnapshotMappingsStorageLayout(@NotNull FileBasedIndexExtension<K, V> extension2, boolean contentHashEnumeratorReopen) {
            Intrinsics.checkNotNullParameter(extension2, (String)"extension");
            this.extension = extension2;
            this.storageLockContext = INSTANCE.newStorageLockContext();
            this.mySnapshotInputMappings$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)new Function0<SnapshotInputMappings<K, V>>(this){
                final /* synthetic */ SnapshotMappingsStorageLayout<K, V> this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final SnapshotInputMappings<K, V> invoke() {
                    return new SnapshotInputMappings<Key, Value>((IndexExtension)SnapshotMappingsStorageLayout.access$getExtension$p(this.this$0), DefaultIndexStorageLayout.access$getForwardIndexAccessor(DefaultIndexStorageLayout.INSTANCE, (IndexExtension)SnapshotMappingsStorageLayout.access$getExtension$p(this.this$0)));
                }
            });
            if (!contentHashEnumeratorReopen) {
                this.deleteIndexData();
            }
        }

        private final SnapshotInputMappings<K, V> getMySnapshotInputMappings() {
            Lazy lazy = this.mySnapshotInputMappings$delegate;
            return (SnapshotInputMappings)lazy.getValue();
        }

        private final void deleteIndexData() {
            INSTANCE.deleteIndexDirectory(this.extension);
            FileUtil.deleteWithRenaming(IndexInfrastructure.getPersistentIndexRootDir((ID)this.extension.getName()).toFile());
        }

        @NotNull
        public SnapshotInputMappings<K, V> createOrClearSnapshotInputMappings() throws IOException {
            return this.getMySnapshotInputMappings();
        }

        @NotNull
        public IndexStorage<K, V> openIndexStorage() throws IOException {
            this.getMySnapshotInputMappings();
            return (IndexStorage)INSTANCE.createIndexStorage(this.extension, this.storageLockContext);
        }

        @NotNull
        public ForwardIndex openForwardIndex() throws IOException {
            Path storageFile = this.getMySnapshotInputMappings().getInputIndexStorageFile();
            return new IntMapForwardIndex(storageFile, true);
        }

        @NotNull
        public ForwardIndexAccessor<K, V> getForwardIndexAccessor() throws IOException {
            HashIdForwardIndexAccessor<K, V, FileContent> hashIdForwardIndexAccessor = this.getMySnapshotInputMappings().getForwardIndexAccessor();
            Intrinsics.checkNotNullExpressionValue(hashIdForwardIndexAccessor, (String)"mySnapshotInputMappings.forwardIndexAccessor");
            return hashIdForwardIndexAccessor;
        }

        public void clearIndexData() {
            this.deleteIndexData();
        }

        public static final /* synthetic */ FileBasedIndexExtension access$getExtension$p(SnapshotMappingsStorageLayout $this) {
            return $this.extension;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/indexing/impl/storage/DefaultIndexStorageLayout$DefaultStorageLayout;", "K", "V", "Lcom/intellij/util/indexing/storage/VfsAwareIndexStorageLayout;", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "(Lcom/intellij/util/indexing/FileBasedIndexExtension;)V", "storageLockContext", "Lcom/intellij/util/io/StorageLockContext;", "clearIndexData", "", "getForwardIndexAccessor", "Lcom/intellij/util/indexing/impl/forward/ForwardIndexAccessor;", "openForwardIndex", "Lcom/intellij/util/indexing/impl/forward/ForwardIndex;", "openIndexStorage", "Lcom/intellij/util/indexing/impl/IndexStorage;", "intellij.platform.lang.impl"})
    public static final class DefaultStorageLayout<K, V>
    implements VfsAwareIndexStorageLayout<K, V> {
        @NotNull
        private final FileBasedIndexExtension<K, V> extension;
        @NotNull
        private final StorageLockContext storageLockContext;

        public DefaultStorageLayout(@NotNull FileBasedIndexExtension<K, V> extension2) {
            Intrinsics.checkNotNullParameter(extension2, (String)"extension");
            this.extension = extension2;
            this.storageLockContext = INSTANCE.newStorageLockContext();
        }

        @NotNull
        public IndexStorage<K, V> openIndexStorage() throws IOException {
            return (IndexStorage)INSTANCE.createIndexStorage(this.extension, this.storageLockContext);
        }

        @NotNull
        public ForwardIndex openForwardIndex() throws IOException {
            Path path2 = IndexInfrastructure.getInputIndexStorageFile((ID)this.extension.getName());
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getInputIndexStorageFile(extension.name)");
            Path indexStorageFile = path2;
            return new PersistentMapBasedForwardIndex(indexStorageFile, false, false, this.storageLockContext);
        }

        @NotNull
        public ForwardIndexAccessor<K, V> getForwardIndexAccessor() {
            return new MapForwardIndexAccessor((DataExternalizer)new InputMapExternalizer((IndexExtension)this.extension));
        }

        public void clearIndexData() {
            log.info("Clearing storage data for: " + this.extension);
            INSTANCE.deleteIndexDirectory(this.extension);
        }
    }
}

