/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.impl.storage.DefaultIndexStorageLayout;
import com.intellij.util.indexing.storage.FileBasedIndexLayoutProviderBean;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.PathKt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u0004\u0018\u00010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005R\u0018\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/indexing/impl/storage/FileBasedIndexLayoutSettings;", "", "()V", "currentLayout", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/util/indexing/storage/FileBasedIndexLayoutProviderBean;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getUsedLayout", "indexLayoutSettingFile", "Ljava/nio/file/Path;", "loadUsedLayout", "", "resetUsedLayout", "", "saveCurrentLayout", "setUsedLayout", "bean", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nFileBasedIndexLayoutSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileBasedIndexLayoutSettings.kt\ncom/intellij/util/indexing/impl/storage/FileBasedIndexLayoutSettings\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,97:1\n10#2:98\n*S KotlinDebug\n*F\n+ 1 FileBasedIndexLayoutSettings.kt\ncom/intellij/util/indexing/impl/storage/FileBasedIndexLayoutSettings\n*L\n21#1:98\n*E\n"})
public final class FileBasedIndexLayoutSettings {
    @NotNull
    public static final FileBasedIndexLayoutSettings INSTANCE = new FileBasedIndexLayoutSettings();
    @NotNull
    private static final Logger log;
    @Nullable
    private static Ref<FileBasedIndexLayoutProviderBean> currentLayout;

    private FileBasedIndexLayoutSettings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setUsedLayout(@Nullable FileBasedIndexLayoutProviderBean bean) {
        try {
            Files.createDirectories(this.indexLayoutSettingFile().getParent(), new FileAttribute[0]);
            if (bean == null) {
                FileUtil.delete(this.indexLayoutSettingFile());
                return;
            }
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(this.indexLayoutSettingFile(), Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(this, *options)");
            Closeable closeable = outputStream;
            int n = 8192;
            closeable = new DataOutputStream(closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n));
            Throwable throwable = null;
            try {
                DataOutputStream it = (DataOutputStream)closeable;
                boolean bl = false;
                EnumeratorStringDescriptor.INSTANCE.save((DataOutput)it, bean.id);
                DataInputOutputUtil.writeINT(it, bean.version);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            log.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean loadUsedLayout() {
        if (!Files.exists(this.indexLayoutSettingFile(), new LinkOption[0])) {
            currentLayout = Ref.create();
            return false;
        }
        String id = null;
        int version = 0;
        Iterator<FileBasedIndexLayoutProviderBean> iterator2 = PathKt.inputStream(this.indexLayoutSettingFile());
        int n = 8192;
        iterator2 = new DataInputStream(iterator2 instanceof BufferedInputStream ? (BufferedInputStream)((Object)iterator2) : new BufferedInputStream((InputStream)((Object)iterator2), n));
        Throwable throwable = null;
        try {
            DataInputStream it = (DataInputStream)((Object)iterator2);
            boolean bl = false;
            String string2 = EnumeratorStringDescriptor.INSTANCE.read(it);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"INSTANCE.read(it)");
            id = string2;
            version = DataInputOutputUtil.readINT(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)((Object)iterator2), (Throwable)throwable);
        }
        for (FileBasedIndexLayoutProviderBean bean : DefaultIndexStorageLayout.INSTANCE.getAvailableLayouts()) {
            if (!Intrinsics.areEqual((Object)bean.id, (Object)id) || bean.version != version) continue;
            currentLayout = Ref.create(bean);
            return false;
        }
        for (FileBasedIndexLayoutProviderBean bean : DefaultIndexStorageLayout.INSTANCE.getAvailableLayouts()) {
            if (!Intrinsics.areEqual((Object)bean.id, (Object)id)) continue;
            this.setUsedLayout(bean);
            currentLayout = Ref.create(bean);
            return true;
        }
        this.setUsedLayout(null);
        return true;
    }

    public final synchronized void saveCurrentLayout() {
        this.setUsedLayout(this.getUsedLayout());
    }

    @Nullable
    public final synchronized FileBasedIndexLayoutProviderBean getUsedLayout() {
        Ref<FileBasedIndexLayoutProviderBean> ref = currentLayout;
        if (ref == null) {
            throw new IllegalStateException("File-based index layout settings not loaded yet");
        }
        Ref<FileBasedIndexLayoutProviderBean> layout = ref;
        return layout.get();
    }

    public final synchronized void resetUsedLayout() {
        currentLayout = null;
    }

    private final Path indexLayoutSettingFile() {
        Path path2 = PathManager.getIndexRoot().resolve("indices.layout");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getIndexRoot().resolve(\"indices.layout\")");
        return path2;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FileBasedIndexLayoutSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        log = logger;
    }
}

