/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.storage.AbstractIntLog;
import com.intellij.util.indexing.impl.storage.IntLog;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.keyStorage.AppendableObjectStorage;
import com.intellij.util.io.keyStorage.AppendableStorageBackedByResizableMappedFile;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.BitSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0002,-B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0002J\b\u0010\u001a\u001a\u00020\u0003H\u0002J\b\u0010\u001b\u001a\u00020\u0005H\u0007J\u0016\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u000f0\u000f0\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0011H\u0002J\b\u0010$\u001a\u00020%H\u0016J)\u0010&\u001a\u0002H'\"\u0004\b\u0000\u0010'2\u0006\u0010(\u001a\u00020\u00052\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0*H\u0002\u00a2\u0006\u0002\u0010+R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/util/indexing/impl/storage/IntLog;", "Lcom/intellij/util/indexing/impl/storage/AbstractIntLog;", "baseStorageFile", "Ljava/nio/file/Path;", "compact", "", "storageLockContext", "Lcom/intellij/util/io/StorageLockContext;", "(Ljava/nio/file/Path;ZLcom/intellij/util/io/StorageLockContext;)V", "modificationStamp", "", "getModificationStamp", "()J", "myKeyHashToVirtualFileMapping", "Lcom/intellij/util/io/keyStorage/AppendableObjectStorage;", "", "addData", "", "data", "", "inputId", "clear", "close", "doForce", "flush", "getCompactionMarker", "getDataFile", "isRequiresCompaction", "openLog", "Lcom/intellij/util/io/keyStorage/AppendableStorageBackedByResizableMappedFile;", "kotlin.jvm.PlatformType", "performCompaction", "processEntries", "processor", "Lcom/intellij/util/indexing/impl/storage/AbstractIntLog$IntLogEntryProcessor;", "setRequiresCompaction", "toString", "", "withLock", "T", "read", "operation", "Lkotlin/Function0;", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "IntPairInArrayKeyDescriptor", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nIntLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntLog.kt\ncom/intellij/util/indexing/impl/storage/IntLog\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,311:1\n10#2:312\n*S KotlinDebug\n*F\n+ 1 IntLog.kt\ncom/intellij/util/indexing/impl/storage/IntLog\n*L\n43#1:312\n*E\n"})
public final class IntLog
implements AbstractIntLog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path baseStorageFile;
    @Nullable
    private final StorageLockContext storageLockContext;
    @NotNull
    private volatile AppendableObjectStorage<int[]> myKeyHashToVirtualFileMapping;
    private final long modificationStamp;
    @NotNull
    private static final Logger LOG;

    public IntLog(@NotNull Path baseStorageFile, boolean compact, @Nullable StorageLockContext storageLockContext) throws IOException {
        Intrinsics.checkNotNullParameter((Object)baseStorageFile, (String)"baseStorageFile");
        this.baseStorageFile = baseStorageFile;
        this.storageLockContext = storageLockContext;
        if (compact && this.isRequiresCompaction()) {
            this.performCompaction();
        }
        this.myKeyHashToVirtualFileMapping = this.openLog();
        this.modificationStamp = this.myKeyHashToVirtualFileMapping.getCurrentLength();
    }

    public /* synthetic */ IntLog(Path path2, boolean bl, StorageLockContext storageLockContext, int n, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n & 4) != 0) {
            storageLockContext = null;
        }
        this(path2, bl, storageLockContext);
    }

    @Override
    public boolean processEntries(@NotNull AbstractIntLog.IntLogEntryProcessor processor) throws StorageException {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        try {
            long l = System.currentTimeMillis();
            this.doForce();
            BitSet uniqueInputs = new BitSet();
            Ref.IntRef uselessRecords = new Ref.IntRef();
            Ref.IntRef usefulRecords = new Ref.IntRef();
            boolean isReadAction = ApplicationManager.getApplication().isReadAccessAllowed();
            if (isReadAction) {
                ProgressManager.checkCanceled();
            }
            this.withLock(true, (Function0)new Function0<Boolean>(this, isReadAction, processor, uniqueInputs, uselessRecords, usefulRecords){
                final /* synthetic */ IntLog this$0;
                final /* synthetic */ boolean $isReadAction;
                final /* synthetic */ AbstractIntLog.IntLogEntryProcessor $processor;
                final /* synthetic */ BitSet $uniqueInputs;
                final /* synthetic */ Ref.IntRef $uselessRecords;
                final /* synthetic */ Ref.IntRef $usefulRecords;
                {
                    this.this$0 = $receiver;
                    this.$isReadAction = $isReadAction;
                    this.$processor = $processor;
                    this.$uniqueInputs = $uniqueInputs;
                    this.$uselessRecords = $uselessRecords;
                    this.$usefulRecords = $usefulRecords;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    if (!IntLog.access$getMyKeyHashToVirtualFileMapping$p(this.this$0).processAll((arg_0, arg_1) -> processEntries.1.invoke$lambda$0((Function2)new Function2<Integer, int[], Boolean>(this.$isReadAction, this.$processor, this.$uniqueInputs, this.$uselessRecords, this.$usefulRecords){
                        final /* synthetic */ boolean $isReadAction;
                        final /* synthetic */ AbstractIntLog.IntLogEntryProcessor $processor;
                        final /* synthetic */ BitSet $uniqueInputs;
                        final /* synthetic */ Ref.IntRef $uselessRecords;
                        final /* synthetic */ Ref.IntRef $usefulRecords;
                        {
                            this.$isReadAction = $isReadAction;
                            this.$processor = $processor;
                            this.$uniqueInputs = $uniqueInputs;
                            this.$uselessRecords = $uselessRecords;
                            this.$usefulRecords = $usefulRecords;
                            super(2);
                        }

                        @NotNull
                        public final Boolean invoke(int n, int[] key) {
                            int inputId;
                            int data2;
                            if (this.$isReadAction) {
                                ProgressManager.checkCanceled();
                            }
                            if (!this.$processor.process(data2 = key[0], inputId = key[1])) {
                                return false;
                            }
                            boolean isPresent = this.$uniqueInputs.get(inputId);
                            if (isPresent) {
                                int n2 = this.$uselessRecords.element;
                                this.$uselessRecords.element = n2 + 1;
                            } else {
                                this.$uniqueInputs.set(inputId);
                                int n3 = this.$usefulRecords.element;
                                this.$usefulRecords.element = n3 + 1;
                            }
                            return true;
                        }
                    }, arg_0, arg_1))) {
                        return false;
                    }
                    return true;
                }

                private static final boolean invoke$lambda$0(Function2 $tmp0, int p0, Object p1) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Boolean)$tmp0.invoke((Object)p0, p1);
                }
            });
            if (uselessRecords.element >= usefulRecords.element) {
                this.setRequiresCompaction();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scanned IntLog of " + this.baseStorageFile + " for " + (System.currentTimeMillis() - l));
            }
            return true;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void clear() {
        try {
            this.close();
        }
        catch (Exception e) {
            LOG.error(e);
        }
        IOUtil.deleteAllFilesStartingWith(this.baseStorageFile);
        this.myKeyHashToVirtualFileMapping = this.openLog();
    }

    private final AppendableStorageBackedByResizableMappedFile<int[]> openLog() {
        return new AppendableStorageBackedByResizableMappedFile<int[]>(this.getDataFile(), 4096, this.storageLockContext, 0x100000, true, IntPairInArrayKeyDescriptor.INSTANCE);
    }

    @Override
    public void addData(int data2, int inputId) throws StorageException {
        if (inputId == 0) {
            return;
        }
        try {
            this.withLock(false, (Function0)new Function0<Integer>(this, data2, inputId){
                final /* synthetic */ IntLog this$0;
                final /* synthetic */ int $data;
                final /* synthetic */ int $inputId;
                {
                    this.this$0 = $receiver;
                    this.$data = $data;
                    this.$inputId = $inputId;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    int[] nArray = new int[]{this.$data, this.$inputId};
                    return IntLog.access$getMyKeyHashToVirtualFileMapping$p(this.this$0).append(nArray);
                }
            });
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.myKeyHashToVirtualFileMapping.isDirty()) {
            this.doForce();
        }
    }

    @Override
    public void close() throws IOException {
        this.withLock(false, (Function0)new Function0<Unit>(this){
            final /* synthetic */ IntLog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                IntLog.access$getMyKeyHashToVirtualFileMapping$p(this.this$0).close();
            }
        });
    }

    private final void doForce() throws IOException {
        this.withLock(false, (Function0)new Function0<Unit>(this){
            final /* synthetic */ IntLog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                IntLog.access$getMyKeyHashToVirtualFileMapping$p(this.this$0).force();
            }
        });
    }

    @Override
    public long getModificationStamp() {
        return this.modificationStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withLock(boolean read, Function0<? extends T> operation) {
        if (read) {
            this.myKeyHashToVirtualFileMapping.lockRead();
        } else {
            this.myKeyHashToVirtualFileMapping.lockWrite();
        }
        try {
            Object object = operation.invoke();
            return (T)object;
        }
        finally {
            if (read) {
                this.myKeyHashToVirtualFileMapping.unlockRead();
            } else {
                this.myKeyHashToVirtualFileMapping.unlockWrite();
            }
        }
    }

    private final void setRequiresCompaction() {
        Path marker = this.getCompactionMarker();
        if (Files.exists(marker, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(marker.getParent(), new FileAttribute[0]);
            Files.createFile(marker, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @VisibleForTesting
    public final boolean isRequiresCompaction() {
        return Files.exists(this.getCompactionMarker(), new LinkOption[0]);
    }

    private final Path getCompactionMarker() {
        Path dataFile = this.getDataFile();
        Path path2 = dataFile.resolveSibling(dataFile.getFileName() + ".require.compaction");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"dataFile.resolveSibling(\u2026 + \".require.compaction\")");
        return path2;
    }

    private final Path getDataFile() {
        Path path2 = this.baseStorageFile.resolveSibling(this.baseStorageFile.getFileName() + ".project");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"baseStorageFile.resolveS\u2026.toString() + \".project\")");
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performCompaction() throws IOException {
        try {
            Int2ObjectMap data2 = new Int2ObjectOpenHashMap();
            Int2IntOpenHashMap forwardData = new Int2IntOpenHashMap();
            Path oldDataFile = this.getDataFile();
            AppendableStorageBackedByResizableMappedFile<Object> oldMapping = new AppendableStorageBackedByResizableMappedFile<Object>(oldDataFile, 0, this.storageLockContext, 0x100000, true, IntPairInArrayKeyDescriptor.INSTANCE);
            oldMapping.lockRead();
            try {
                oldMapping.processAll((arg_0, arg_1) -> IntLog.performCompaction$lambda$0((Function2)new Function2<Integer, int[], Boolean>(forwardData, (Int2ObjectMap<IntSet>)data2){
                    final /* synthetic */ Int2IntOpenHashMap $forwardData;
                    final /* synthetic */ Int2ObjectMap<IntSet> $data;
                    {
                        this.$forwardData = $forwardData;
                        this.$data = $data;
                        super(2);
                    }

                    @NotNull
                    public final Boolean invoke(int n, @NotNull int[] key) {
                        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                        int inputId = key[1];
                        int dataKey = key[0];
                        int absInputId = Math.abs(inputId);
                        if (dataKey == 0) {
                            IntSet associatedInputIds;
                            int currentKeyHash = this.$forwardData.get(inputId);
                            IntSet intSet = associatedInputIds = (IntSet)this.$data.get(currentKeyHash);
                            if (intSet != null) {
                                intSet.remove(absInputId);
                            }
                        } else if (inputId > 0) {
                            this.$data.computeIfAbsent(dataKey, performCompaction.1::invoke$lambda$0).add(absInputId);
                            Integer n2 = absInputId;
                            Integer n3 = dataKey;
                            ((Map)this.$forwardData).put(n2, n3);
                        } else {
                            IntSet associatedInputIds;
                            IntSet intSet = associatedInputIds = (IntSet)this.$data.get(dataKey);
                            if (intSet != null) {
                                intSet.remove(absInputId);
                            }
                            this.$forwardData.remove(absInputId);
                        }
                        return true;
                    }

                    private static final IntSet invoke$lambda$0(int it) {
                        return new IntOpenHashSet();
                    }
                }, arg_0, arg_1));
                oldMapping.close();
            }
            finally {
                oldMapping.unlockRead();
            }
            String dataFileName = ((Object)oldDataFile.getFileName()).toString();
            String newDataFileName = "new." + dataFileName;
            Path newDataFile = oldDataFile.resolveSibling(newDataFileName);
            AppendableStorageBackedByResizableMappedFile<int[]> newMapping = new AppendableStorageBackedByResizableMappedFile<int[]>(newDataFile, 64 * data2.size(), this.storageLockContext, 0x100000, true, IntPairInArrayKeyDescriptor.INSTANCE);
            newMapping.lockWrite();
            try {
                for (Int2ObjectMap.Entry throwable : data2.int2ObjectEntrySet()) {
                    IntIterator inputIdIterator;
                    int keyHash = throwable.getIntKey();
                    Intrinsics.checkNotNullExpressionValue((Object)((IntSet)throwable.getValue()).iterator(), (String)"entry.value.iterator()");
                    while (inputIdIterator.hasNext()) {
                        int inputId = inputIdIterator.nextInt();
                        int[] nArray = new int[]{keyHash, inputId};
                        newMapping.append(nArray);
                    }
                }
                newMapping.close();
            }
            finally {
                newMapping.unlockWrite();
            }
            IOUtil.deleteAllFilesStartingWith(oldDataFile);
            Closeable closeable = Files.newDirectoryStream(newDataFile.getParent());
            Throwable throwable = null;
            try {
                DirectoryStream paths2 = (DirectoryStream)closeable;
                boolean bl = false;
                for (Path path2 : paths2) {
                    String name = ((Object)path2.getFileName()).toString();
                    if (!StringsKt.startsWith$default((String)name, (String)newDataFileName, (boolean)false, (int)2, null)) continue;
                    File file2 = path2.toFile();
                    String string2 = name.substring(newDataFileName.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    FileUtil.rename(file2, dataFileName + string2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, throwable);
            }
            try {
                Files.delete(this.getCompactionMarker());
            }
            catch (IOException iOException) {}
        }
        catch (ProcessCanceledException e) {
            LOG.error(e);
            throw e;
        }
    }

    @NotNull
    public String toString() {
        return "super.toString()";
    }

    private static final boolean performCompaction$lambda$0(Function2 $tmp0, int p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke((Object)p0, p1);
    }

    public static final /* synthetic */ AppendableObjectStorage access$getMyKeyHashToVirtualFileMapping$p(IntLog $this) {
        return $this.myKeyHashToVirtualFileMapping;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IntLog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/util/indexing/impl/storage/IntLog$IntPairInArrayKeyDescriptor;", "Lcom/intellij/util/io/DataExternalizer;", "", "()V", "read", "in", "Ljava/io/DataInput;", "save", "", "out", "Ljava/io/DataOutput;", "value", "intellij.platform.lang.impl"})
    private static final class IntPairInArrayKeyDescriptor
    implements DataExternalizer<int[]> {
        @NotNull
        public static final IntPairInArrayKeyDescriptor INSTANCE = new IntPairInArrayKeyDescriptor();

        private IntPairInArrayKeyDescriptor() {
        }

        @Override
        public void save(@NotNull DataOutput out, @NotNull int[] value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            DataInputOutputUtil.writeINT(out, value[0]);
            DataInputOutputUtil.writeINT(out, value[1]);
        }

        @Override
        @NotNull
        public int[] read(@NotNull DataInput in) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            int[] nArray = new int[]{DataInputOutputUtil.readINT(in), DataInputOutputUtil.readINT(in)};
            return nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/indexing/impl/storage/IntLog$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

