/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.storage.TransientChangesIndexStorage;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.storage.SnapshotInputMappingIndex;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TransientFileContentIndex<Key, Value, FileCachedData extends VfsAwareMapReduceIndex.IndexerIdHolder>
extends VfsAwareMapReduceIndex<Key, Value, FileCachedData> {
    private static final Logger LOG = Logger.getInstance(TransientFileContentIndex.class);
    private final AtomicBoolean myInMemoryMode;
    private final ConcurrentIntObjectMap<Map<Key, Value>> myInMemoryKeysAndValues;

    public TransientFileContentIndex(final @NotNull FileBasedIndexExtension<Key, Value> extension2, final @NotNull VfsAwareIndexStorageLayout<Key, Value> indexStorageLayout) throws IOException {
        if (extension2 == null) {
            TransientFileContentIndex.$$$reportNull$$$0(0);
        }
        if (indexStorageLayout == null) {
            TransientFileContentIndex.$$$reportNull$$$0(1);
        }
        super(extension2, new VfsAwareIndexStorageLayout<Key, Value>(){

            @NotNull
            public IndexStorage<Key, Value> openIndexStorage() throws IOException {
                return new TransientChangesIndexStorage(indexStorageLayout.openIndexStorage(), extension2);
            }

            @Nullable
            public SnapshotInputMappingIndex<Key, Value, FileContent> createOrClearSnapshotInputMappings() throws IOException {
                return indexStorageLayout.createOrClearSnapshotInputMappings();
            }

            public void clearIndexData() {
                indexStorageLayout.clearIndexData();
            }

            @Nullable
            public ForwardIndex openForwardIndex() throws IOException {
                return indexStorageLayout.openForwardIndex();
            }

            @Nullable
            public ForwardIndexAccessor<Key, Value> getForwardIndexAccessor() throws IOException {
                return indexStorageLayout.getForwardIndexAccessor();
            }
        });
        this.myInMemoryMode = new AtomicBoolean();
        this.myInMemoryKeysAndValues = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        this.installMemoryModeListener();
    }

    @NotNull
    protected InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId) throws IOException {
        Map keysAndValues;
        if (this.myInMemoryMode.get() && (keysAndValues = (Map)this.myInMemoryKeysAndValues.get(inputId)) != null) {
            InputDataDiffBuilder inputDataDiffBuilder = this.getKeysDiffBuilder(inputId, keysAndValues);
            if (inputDataDiffBuilder == null) {
                TransientFileContentIndex.$$$reportNull$$$0(2);
            }
            return inputDataDiffBuilder;
        }
        InputDataDiffBuilder inputDataDiffBuilder = super.getKeysDiffBuilder(inputId);
        if (inputDataDiffBuilder == null) {
            TransientFileContentIndex.$$$reportNull$$$0(3);
        }
        return inputDataDiffBuilder;
    }

    protected void updateForwardIndex(int inputId, @NotNull InputData<Key, Value> data2) throws IOException {
        if (data2 == null) {
            TransientFileContentIndex.$$$reportNull$$$0(4);
        }
        if (this.myInMemoryMode.get()) {
            this.myInMemoryKeysAndValues.put(inputId, data2.getKeyValues());
        } else {
            super.updateForwardIndex(inputId, data2);
        }
    }

    @Nullable
    protected Map<Key, Value> getNullableIndexedData(int fileId) throws IOException, StorageException {
        Map map2;
        if (this.myInMemoryMode.get() && (map2 = (Map)this.myInMemoryKeysAndValues.get(fileId)) != null) {
            return map2;
        }
        return super.getNullableIndexedData(fileId);
    }

    private void installMemoryModeListener() {
        IndexStorage storage = this.getStorage();
        if (storage instanceof TransientChangesIndexStorage) {
            ((TransientChangesIndexStorage)storage).addBufferingStateListener(new TransientChangesIndexStorage.BufferingStateListener(){

                public void bufferingStateChanged(boolean newState) {
                    TransientFileContentIndex.this.myInMemoryMode.set(newState);
                }

                public void memoryStorageCleared() {
                    TransientFileContentIndex.this.myInMemoryKeysAndValues.clear();
                }
            });
        }
    }

    public void setBufferingEnabled(boolean enabled) {
        ((TransientChangesIndexStorage)this.getStorage()).setBufferingEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransientDataForFile(int inputId) {
        if (IndexDebugProperties.DEBUG) {
            LOG.assertTrue(ProgressManager.getInstance().isInNonCancelableSection());
        }
        this.getLock().writeLock().lock();
        try {
            Map keyValueMap = (Map)this.myInMemoryKeysAndValues.remove(inputId);
            if (keyValueMap == null) {
                return;
            }
            try {
                this.removeTransientDataForInMemoryKeys(inputId, keyValueMap);
                InputDataDiffBuilder<Key, Value> builder2 = this.getKeysDiffBuilder(inputId);
                this.removeTransientDataForKeys(inputId, builder2);
            }
            catch (IOException throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    protected void removeTransientDataForInMemoryKeys(int inputId, @NotNull Map<Key, Value> map2) throws IOException {
        if (map2 == null) {
            TransientFileContentIndex.$$$reportNull$$$0(5);
        }
        this.removeTransientDataForKeys(inputId, this.getKeysDiffBuilder(inputId, map2));
    }

    public void removeTransientDataForKeys(int inputId, @NotNull InputDataDiffBuilder<Key, Value> diffBuilder) {
        if (diffBuilder == null) {
            TransientFileContentIndex.$$$reportNull$$$0(6);
        }
        TransientChangesIndexStorage memoryIndexStorage = (TransientChangesIndexStorage)this.getStorage();
        boolean modified = false;
        for (Object key : ((DirectInputDataDiffBuilder)diffBuilder).getKeys()) {
            if (!memoryIndexStorage.clearMemoryMapForId(key, inputId) || modified) continue;
            modified = true;
        }
        if (modified) {
            this.incrementModificationStamp();
        }
    }

    public void cleanupMemoryStorage() {
        TransientChangesIndexStorage memStorage = (TransientChangesIndexStorage)this.getStorage();
        if (memStorage.clearMemoryMap()) {
            this.incrementModificationStamp();
        }
        memStorage.fireMemoryStorageCleared();
    }

    @TestOnly
    public void cleanupForNextTest() {
        IndexStorage memStorage = this.getStorage();
        ConcurrencyUtil.withLock(this.getLock().readLock(), () -> memStorage.clearCaches());
    }

    public static <Key, Value> TransientFileContentIndex<Key, Value, VfsAwareMapReduceIndex.IndexerIdHolder> createIndex(@NotNull FileBasedIndexExtension<Key, Value> extension2, @NotNull VfsAwareIndexStorageLayout<Key, Value> indexStorageLayout) throws IOException {
        if (extension2 == null) {
            TransientFileContentIndex.$$$reportNull$$$0(7);
        }
        if (indexStorageLayout == null) {
            TransientFileContentIndex.$$$reportNull$$$0(8);
        }
        return new TransientFileContentIndex(extension2, indexStorageLayout);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexStorageLayout";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/storage/TransientFileContentIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/storage/TransientFileContentIndex";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysDiffBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateForwardIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForInMemoryKeys";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForKeys";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createIndex";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

