/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.projectFilter;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.UnindexedFilesScanner;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.projectFilter.FileAddStatus;
import com.intellij.util.indexing.projectFilter.IncrementalProjectIndexableFilesFilter;
import com.intellij.util.indexing.projectFilter.IncrementalProjectIndexableFilesFilterHolder;
import com.intellij.util.indexing.projectFilter.ProjectIndexableFilesFilterHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\r0\fH\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d\u00b2\u0006\u0010\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u008a\u0084\u0002"}, d2={"Lcom/intellij/util/indexing/projectFilter/IncrementalProjectIndexableFilesFilterHolder;", "Lcom/intellij/util/indexing/projectFilter/ProjectIndexableFilesFilterHolder;", "()V", "myProjectFilters", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/util/indexing/projectFilter/IncrementalProjectIndexableFilesFilter;", "addFileId", "Lcom/intellij/util/indexing/projectFilter/FileAddStatus;", "fileId", "", "projects", "Lkotlin/Function0;", "", "project", "entireProjectUpdateFinished", "", "entireProjectUpdateStarted", "findProjectForFile", "getFilter", "kotlin.jvm.PlatformType", "getProjectIndexableFiles", "Lcom/intellij/util/indexing/IdFilter;", "removeFile", "runHealthCheck", "", "Lcom/intellij/util/indexing/projectFilter/IncrementalProjectIndexableFilesFilterHolder$HealthCheckError;", "filter", "HealthCheckError", "intellij.platform.lang.impl", "matchedProjects"})
@SourceDebugExtension(value={"SMAP\nProjectIndexableFilesFilterHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectIndexableFilesFilterHolder.kt\ncom/intellij/util/indexing/projectFilter/IncrementalProjectIndexableFilesFilterHolder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n125#2:166\n152#2,3:167\n1726#3,3:170\n1747#3,3:173\n1549#3:176\n1620#3,3:177\n*S KotlinDebug\n*F\n+ 1 ProjectIndexableFilesFilterHolder.kt\ncom/intellij/util/indexing/projectFilter/IncrementalProjectIndexableFilesFilterHolder\n*L\n81#1:166\n81#1:167,3\n87#1:170,3\n88#1:173,3\n126#1:176\n126#1:177,3\n*E\n"})
public final class IncrementalProjectIndexableFilesFilterHolder
extends ProjectIndexableFilesFilterHolder {
    @NotNull
    private final ConcurrentMap<Project, IncrementalProjectIndexableFilesFilter> myProjectFilters = new ConcurrentHashMap();

    public IncrementalProjectIndexableFilesFilterHolder() {
        super(null);
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectCloseListener.TOPIC, new ProjectCloseListener(){

            @Override
            public void projectClosed(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                myProjectFilters.remove(project2);
            }
        });
    }

    @Override
    @Nullable
    public IdFilter getProjectIndexableFiles(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!UnindexedFilesScanner.isProjectContentFullyScanned(project2) || UnindexedFilesUpdater.isIndexUpdateInProgress(project2)) {
            return null;
        }
        return this.getFilter(project2);
    }

    @Override
    public void entireProjectUpdateStarted(@NotNull Project project2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            boolean bl = UnindexedFilesUpdater.isIndexUpdateInProgress(project2);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            IncrementalProjectIndexableFilesFilter incrementalProjectIndexableFilesFilter = this.getFilter(project2);
            if (incrementalProjectIndexableFilesFilter == null) break block1;
            incrementalProjectIndexableFilesFilter.memoizeAndResetFileIds();
        }
    }

    @Override
    public void entireProjectUpdateFinished(@NotNull Project project2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            boolean bl = UnindexedFilesUpdater.isIndexUpdateInProgress(project2);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            IncrementalProjectIndexableFilesFilter incrementalProjectIndexableFilesFilter = this.getFilter(project2);
            if (incrementalProjectIndexableFilesFilter == null) break block1;
            incrementalProjectIndexableFilesFilter.resetPreviousFileIds();
        }
    }

    private final IncrementalProjectIndexableFilesFilter getFilter(Project project2) {
        return this.myProjectFilters.computeIfAbsent(project2, arg_0 -> IncrementalProjectIndexableFilesFilterHolder.getFilter$lambda$0(getFilter.1.INSTANCE, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FileAddStatus addFileId(int fileId, @NotNull Function0<? extends Set<? extends Project>> projects) {
        boolean bl;
        block10: {
            boolean bl2;
            List statuses2;
            block9: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(projects, (String)"projects");
                Lazy matchedProjects$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Set<? extends Project>>(projects){
                    final /* synthetic */ Function0<Set<Project>> $projects;
                    {
                        this.$projects = $projects;
                        super(0);
                    }

                    @NotNull
                    public final Set<Project> invoke() {
                        return (Set)this.$projects.invoke();
                    }
                }));
                Map $this$map$iv = this.myProjectFilters;
                boolean $i$f$map = false;
                Iterator iterator2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator3.next();
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    Project p = (Project)entry.getKey();
                    IncrementalProjectIndexableFilesFilter filter2 = (IncrementalProjectIndexableFilesFilter)((Object)entry.getValue());
                    collection.add(filter2.ensureFileIdPresent(fileId, (Function0<Boolean>)((Function0)new Function0<Boolean>(p, (Lazy<? extends Set<? extends Project>>)matchedProjects$delegate){
                        final /* synthetic */ Project $p;
                        final /* synthetic */ Lazy<Set<Project>> $matchedProjects$delegate;
                        {
                            this.$p = $p;
                            this.$matchedProjects$delegate = $matchedProjects$delegate;
                            super(0);
                        }

                        @NotNull
                        public final Boolean invoke() {
                            return IncrementalProjectIndexableFilesFilterHolder.access$addFileId$lambda$1(this.$matchedProjects$delegate).contains(this.$p);
                        }
                    })));
                }
                statuses2 = (List)destination$iv$iv;
                Iterable $this$all$iv = statuses2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        FileAddStatus it = (FileAddStatus)((Object)element$iv);
                        boolean bl4 = false;
                        if (it == FileAddStatus.SKIPPED) continue;
                        bl2 = false;
                        break block9;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return FileAddStatus.SKIPPED;
            }
            Iterable $this$any$iv = statuses2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FileAddStatus it = (FileAddStatus)((Object)element$iv);
                    boolean bl5 = false;
                    if (!(it == FileAddStatus.ADDED)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return FileAddStatus.ADDED;
        }
        return FileAddStatus.PRESENT;
    }

    @Override
    @NotNull
    public FileAddStatus addFileId(int fileId, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object object = (IncrementalProjectIndexableFilesFilter)((Object)this.myProjectFilters.get(project2));
        if (object == null || (object = object.ensureFileIdPresent(fileId, (Function0<Boolean>)((Function0)addFileId.3.INSTANCE))) == null) {
            object = FileAddStatus.SKIPPED;
        }
        return object;
    }

    @Override
    public void removeFile(int fileId) {
        for (IncrementalProjectIndexableFilesFilter filter2 : this.myProjectFilters.values()) {
            filter2.removeFileId(fileId);
        }
    }

    @Override
    @Nullable
    public Project findProjectForFile(int fileId) {
        for (Map.Entry entry : ((Map)this.myProjectFilters).entrySet()) {
            Project project2 = (Project)entry.getKey();
            IncrementalProjectIndexableFilesFilter filter2 = (IncrementalProjectIndexableFilesFilter)((Object)entry.getValue());
            if (!filter2.containsFileId(fileId)) continue;
            return project2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void runHealthCheck() {
        try {
            for (Map.Entry entry : ((Map)this.myProjectFilters).entrySet()) {
                String message;
                void $this$mapTo$iv$iv;
                Project project2 = (Project)entry.getKey();
                IncrementalProjectIndexableFilesFilter filter2 = (IncrementalProjectIndexableFilesFilter)((Object)entry.getValue());
                Ref.ObjectRef errors = new Ref.ObjectRef();
                ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> IncrementalProjectIndexableFilesFilterHolder.runHealthCheck$lambda$5(project2, errors, this, filter2));
                Collection collection = (Collection)errors.element;
                if (collection == null || collection.isEmpty()) continue;
                Object object = errors.element;
                Intrinsics.checkNotNull((Object)object);
                for (HealthCheckError error2 : (List)object) {
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)filter2), (String)"filter");
                    error2.fix(filter2);
                }
                Object object2 = errors.element;
                Intrinsics.checkNotNull((Object)object2);
                Iterable $this$map$iv = (Iterable)object2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    HealthCheckError healthCheckError = (HealthCheckError)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(ReadAction.nonBlocking(() -> IncrementalProjectIndexableFilesFilterHolder.runHealthCheck$lambda$7$lambda$6((HealthCheckError)it)));
                }
                Intrinsics.checkNotNullExpressionValue((Object)StringUtil.first(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), 300, true), (String)"first(errors!!.map { Rea\u2026                    true)");
                FileBasedIndexImpl.LOG.error("Project indexable filter health check errors: " + message);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (Exception e) {
            FileBasedIndexImpl.LOG.error(e);
        }
    }

    private final List<HealthCheckError> runHealthCheck(Project project2, IncrementalProjectIndexableFilesFilter filter2) {
        List errors = new ArrayList();
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        FileBasedIndexImpl index2 = (FileBasedIndexImpl)fileBasedIndex;
        index2.iterateIndexableFiles(arg_0 -> IncrementalProjectIndexableFilesFilterHolder.runHealthCheck$lambda$8(filter2, arg_0), project2, ProgressManager.getInstance().getProgressIndicator());
        return errors;
    }

    private static final IncrementalProjectIndexableFilesFilter getFilter$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (IncrementalProjectIndexableFilesFilter)((Object)$tmp0.invoke(p0));
    }

    private static final Set<Project> addFileId$lambda$1(Lazy<? extends Set<? extends Project>> $matchedProjects$delegate) {
        Lazy<? extends Set<? extends Project>> lazy = $matchedProjects$delegate;
        return (Set)lazy.getValue();
    }

    private static final void runHealthCheck$lambda$5(Project $project, Ref.ObjectRef $errors, IncrementalProjectIndexableFilesFilterHolder this$0, IncrementalProjectIndexableFilesFilter $filter) {
        Intrinsics.checkNotNullParameter((Object)$errors, (String)"$errors");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (DumbService.isDumb($project)) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)$project, (String)"project");
        Intrinsics.checkNotNullExpressionValue((Object)((Object)$filter), (String)"filter");
        $errors.element = this$0.runHealthCheck($project, $filter);
    }

    private static final String runHealthCheck$lambda$7$lambda$6(HealthCheckError $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return $it.getPresentableText();
    }

    private static final boolean runHealthCheck$lambda$8(IncrementalProjectIndexableFilesFilter $filter, VirtualFile it) {
        int fileId;
        Intrinsics.checkNotNullParameter((Object)((Object)$filter), (String)"$filter");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof VirtualFileWithId && !$filter.containsFileId(fileId = ((VirtualFileWithId)((Object)it)).getId())) {
            $filter.ensureFileIdPresent(fileId, (Function0<Boolean>)((Function0)runHealthCheck.2.1.INSTANCE));
        }
        return true;
    }

    public static final /* synthetic */ Set access$addFileId$lambda$1(Lazy $matchedProjects$delegate) {
        return IncrementalProjectIndexableFilesFilterHolder.addFileId$lambda$1((Lazy<? extends Set<? extends Project>>)$matchedProjects$delegate);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/indexing/projectFilter/IncrementalProjectIndexableFilesFilterHolder$HealthCheckError;", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "presentableText", "", "getPresentableText", "()Ljava/lang/String;", "fix", "", "filter", "Lcom/intellij/util/indexing/projectFilter/IncrementalProjectIndexableFilesFilter;", "intellij.platform.lang.impl"})
    private static final class HealthCheckError {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile virtualFile;

        public HealthCheckError(@NotNull Project project2, @NotNull VirtualFile virtualFile2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            this.project = project2;
            this.virtualFile = virtualFile2;
        }

        @NotNull
        public final String getPresentableText() {
            return "file " + this.virtualFile.getPath() + " not found in " + this.project.getName();
        }

        public final void fix(@NotNull IncrementalProjectIndexableFilesFilter filter2) {
            Intrinsics.checkNotNullParameter((Object)((Object)filter2), (String)"filter");
            VirtualFile virtualFile2 = this.virtualFile;
            Intrinsics.checkNotNull((Object)virtualFile2, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFileWithId");
            filter2.ensureFileIdPresent(((VirtualFileWithId)((Object)virtualFile2)).getId(), (Function0<Boolean>)((Function0)fix.1.INSTANCE));
        }
    }
}

